/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.geocoding;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.service.geocoding.GeocoderAddressComponent;
import com.dlsc.gmapsfx.service.geocoding.GeocoderAddressComponentType;
import com.dlsc.gmapsfx.service.geocoding.GeocoderGeometry;
import com.dlsc.gmapsfx.service.geocoding.GeocoderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class GeocodingResult
extends JavascriptObject {
    public GeocodingResult() {
        super("google.maps.GeocoderResult");
    }

    public GeocodingResult(JSObject jsObject) {
        super("google.maps.GeocoderResult", jsObject);
    }

    public String getFormattedAddress() {
        return this.getJSObject().getMember("formatted_address").toString();
    }

    public String getPlaceId() {
        return this.getJSObject().getMember("place_id").toString();
    }

    public Boolean isPartialMatch() {
        Boolean result = null;
        String text = this.getJSObject().getMember("partial_match").toString();
        try {
            result = Boolean.parseBoolean(text);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", e);
        }
        return result;
    }

    public List<String> getPostcodeLocalities() {
        ArrayList<String> result = new ArrayList<String>();
        List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.jsObject.getMember("postcode_localities"));
        for (JSObject jsLocality : jsLocalities) {
            String text = jsLocality.toString();
            if (text == null || text.isEmpty() || text.equals("undefined")) continue;
            result.add(text);
        }
        return result;
    }

    public List<GeocoderAddressComponent> getAddressComponents() {
        ArrayList<GeocoderAddressComponent> components = new ArrayList<GeocoderAddressComponent>();
        JSObject componentArray = (JSObject)this.getJSObject().getMember("address_components");
        List<JSObject> jsObjectsFromArray = GeocoderUtils.getJSObjectsFromArray(componentArray);
        for (JSObject obj : jsObjectsFromArray) {
            components.add(new GeocoderAddressComponent(obj));
        }
        return components;
    }

    public List<GeocoderAddressComponentType> getTypes() {
        JSObject jsTypes = (JSObject)this.getJSObject().getMember("types");
        return GeocoderUtils.convertJSObjectToListOfEnum(jsTypes, GeocoderAddressComponentType.class);
    }

    public GeocoderGeometry getGeometry() {
        try {
            JSObject geometry = (JSObject)this.getJSObject().getMember("geometry");
            return new GeocoderGeometry(geometry);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", e);
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\t Types: ").append(this.getTypes()).append("\n");
        builder.append("\t Formatted Address: ").append(this.getFormattedAddress()).append("\n");
        builder.append("\t Address Components: ").append(this.getAddressComponents()).append("\n");
        builder.append("\t Partial Match: ").append(this.isPartialMatch()).append("\n");
        builder.append("\t Place Id: ").append(this.getPlaceId()).append("\n");
        builder.append("\t Geometry: ").append(this.getGeometry()).append("\n");
        return builder.toString();
    }
}

