/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.util;

import jakarta.xml.bind.DatatypeConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;

public class MarkerImageFactory {
    public static String createMarkerImage(String uri, String type) {
        Logger.getLogger(MarkerImageFactory.class.getName()).log(Level.FINEST, "createMarkerImage using: {0}", uri);
        String dataURI = null;
        if (uri.startsWith("file:")) {
            return MarkerImageFactory.createMarkerImageFromFile(uri, type);
        }
        URL myURL = MarkerImageFactory.class.getResource(uri);
        if (myURL != null) {
            String myURI = myURL.toExternalForm();
            Image img = new Image(myURI);
            String imageMimeType = "image/" + type;
            try {
                dataURI = "data:" + imageMimeType + ";base64,(" + DatatypeConverter.printBase64Binary((byte[])MarkerImageFactory.getImageBytes(SwingFXUtils.fromFXImage((Image)img, null), type)) + ")";
            }
            catch (IOException ioe) {
                Logger.getLogger(MarkerImageFactory.class.getName()).log(Level.WARNING, "Cannot create marker image", ioe);
                dataURI = null;
            }
        }
        return dataURI;
    }

    private static String createMarkerImageFromFile(String uri, String type) {
        try {
            String dataURI = null;
            URL myURL = URI.create(uri).toURL();
            if (myURL != null) {
                String myURLext = myURL.toExternalForm();
                Image img = new Image(myURLext);
                String imageMimeType = "image/" + type;
                try {
                    dataURI = "data:" + imageMimeType + ";base64," + DatatypeConverter.printBase64Binary((byte[])MarkerImageFactory.getImageBytes(SwingFXUtils.fromFXImage((Image)img, null), type));
                }
                catch (IOException ioe) {
                    Logger.getLogger(MarkerImageFactory.class.getName()).log(Level.WARNING, "Cannot create marker image", ioe);
                    dataURI = null;
                }
            }
            return dataURI;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(MarkerImageFactory.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private static byte[] getImageBytes(BufferedImage image, String type) throws IOException {
        byte[] imageBytes;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, type, bos);
            imageBytes = bos.toByteArray();
        }
        return imageBytes;
    }
}

