/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx;

import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.SegmentCell;
import com.dlsc.pickerfx.skins.DurationPickerSkin;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class DurationPicker
extends Picker<Duration> {
    private final ObjectProperty<Duration> minimumDuration = new SimpleObjectProperty((Object)this, "earliestTime", (Object)Duration.ZERO);
    private final ObjectProperty<Duration> maximumDuration = new SimpleObjectProperty((Object)this, "maximumDuration", (Object)Duration.ofDays(99L));
    private final ListProperty<ChronoUnit> fields = new SimpleListProperty((Object)this, "fields", FXCollections.observableArrayList());
    private final ObjectProperty<Map<ChronoUnit, Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>>> cellFactories = new SimpleObjectProperty((Object)this, "cellFactories", new HashMap());

    public DurationPicker() {
        this.getStyleClass().add((Object)"duration-picker");
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("duration-picker.css").toExternalForm());
        this.setValue(Duration.ZERO);
        this.getFields().setAll((Object[])new ChronoUnit[]{ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS});
        for (ChronoUnit unit : ChronoUnit.values()) {
            this.getCellFactories().put(unit, (Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>)((Callback)segment -> new SegmentCell()));
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new DurationPickerSkin(this);
    }

    public final Duration getMinimumDuration() {
        return (Duration)this.minimumDuration.get();
    }

    public final ObjectProperty<Duration> minimumDurationProperty() {
        return this.minimumDuration;
    }

    public final void setMinimumDuration(Duration minimumDuration) {
        this.minimumDuration.set((Object)minimumDuration);
    }

    public final Duration getMaximumDuration() {
        return (Duration)this.maximumDuration.get();
    }

    public final ObjectProperty<Duration> maximumDurationProperty() {
        return this.maximumDuration;
    }

    public final void setMaximumDuration(Duration maximumDuration) {
        this.maximumDuration.set((Object)maximumDuration);
    }

    public final ObservableList<ChronoUnit> getFields() {
        return (ObservableList)this.fields.get();
    }

    public final ListProperty<ChronoUnit> fieldsProperty() {
        return this.fields;
    }

    public void setFields(ObservableList<ChronoUnit> fields) {
        this.fields.set(fields);
    }

    public Map<ChronoUnit, Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>> getCellFactories() {
        return (Map)this.cellFactories.get();
    }

    public ObjectProperty<Map<ChronoUnit, Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>>> cellFactoriesProperty() {
        return this.cellFactories;
    }

    public void setCellFactories(Map<ChronoUnit, Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>> cellFactories) {
        this.cellFactories.set(cellFactories);
    }
}

