/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.DateFormat;
import com.dlsc.pickerfx.LocalDatePicker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.skins.PickerSkinBase;
import java.time.LocalDate;
import java.time.Month;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class LocalDatePickerSkin
extends PickerSkinBase<LocalDatePicker> {
    private final Segment<LocalDate, Integer> daySegment;
    private final Segment<LocalDate, Month> monthSegment;
    private final Segment<LocalDate, Integer> yearSegment;
    private boolean updatingValue;

    public LocalDatePickerSkin(LocalDatePicker picker) {
        super(picker);
        InvalidationListener updateValueListener = it -> this.updateValue();
        this.daySegment = new Segment<LocalDate, Integer>(picker, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31);
        this.daySegment.getStyleClass().add((Object)"day");
        this.daySegment.valueProperty().addListener(updateValueListener);
        this.daySegment.cellFactoryProperty().bind(picker.dayCellFactoryProperty());
        this.monthSegment = new Segment(picker);
        this.monthSegment.getItems().setAll((Object[])Month.values());
        this.monthSegment.getStyleClass().add((Object)"month");
        this.monthSegment.valueProperty().addListener(updateValueListener);
        this.monthSegment.cellFactoryProperty().bind(picker.monthCellFactoryProperty());
        this.yearSegment = new Segment(picker);
        this.yearSegment.getStyleClass().add((Object)"year");
        this.yearSegment.valueProperty().addListener(updateValueListener);
        this.yearSegment.cellFactoryProperty().bind(picker.yearCellFactoryProperty());
        int i = LocalDate.now().getYear() - 10;
        while (i <= LocalDate.now().getYear() + 10) {
            this.yearSegment.getItems().add((Object)i++);
        }
        HBox.setHgrow(this.daySegment, (Priority)Priority.ALWAYS);
        HBox.setHgrow(this.monthSegment, (Priority)Priority.ALWAYS);
        HBox.setHgrow(this.yearSegment, (Priority)Priority.ALWAYS);
        picker.valueProperty().addListener(obs -> this.updateSegmentValues());
        this.updateSegmentValues();
        picker.dateFormatProperty().addListener(obs -> this.updateSkin());
        this.updateSkin();
    }

    private void updateSkin() {
        this.clear();
        if (((LocalDatePicker)this.getSkinnable()).getDateFormat() == DateFormat.STANDARD) {
            this.add(this.daySegment);
            this.add((Node)new PickerSkinBase.SegmentSeparator());
            this.add(this.monthSegment);
            this.add((Node)new PickerSkinBase.SegmentSeparator());
            this.add(this.yearSegment);
        } else {
            this.add(this.monthSegment);
            this.add((Node)new PickerSkinBase.SegmentSeparator());
            this.add(this.daySegment);
            this.add((Node)new PickerSkinBase.SegmentSeparator());
            this.add(this.yearSegment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        Integer day = this.daySegment.getValue();
        Month month = this.monthSegment.getValue();
        Integer year = this.yearSegment.getValue();
        if (day != null && month != null && year != null) {
            try {
                this.updatingValue = true;
                ((LocalDatePicker)this.getSkinnable()).setValue(LocalDate.of((int)year, month, (int)day));
                ((LocalDatePicker)this.getSkinnable()).getProperties().put((Object)"invalid", (Object)false);
            }
            catch (Exception e) {
                ((LocalDatePicker)this.getSkinnable()).setValue(null);
                ((LocalDatePicker)this.getSkinnable()).getProperties().put((Object)"invalid", (Object)true);
            }
            finally {
                this.updatingValue = false;
            }
        }
    }

    private void updateSegmentValues() {
        LocalDate value;
        if (!this.updatingValue && (value = (LocalDate)((LocalDatePicker)this.getSkinnable()).getValue()) != null) {
            this.daySegment.setValue(value.getDayOfMonth());
            this.monthSegment.setValue(value.getMonth());
            this.yearSegment.setValue(value.getYear());
        }
    }
}

