/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.wms.eox;

import java.util.TreeMap;
import org.mapton.api.MWmsGenerator;

public class GenerateStyles
extends MWmsGenerator {
    public static void main(String[] args) {
        new GenerateStyles();
    }

    public GenerateStyles() {
        this.initEoxEarthByDay(true);
        this.initEoxEarthByNight(true);
        this.initEoxHydro(true);
        this.initEoxOsm(true);
        this.initEoxSentinel2(true);
        this.initEoxSentinel2Streets(true);
        this.initEoxTerrain(true);
        this.initEoxTerrainLight(true);
        System.out.println(this.getStyleJson());
    }

    private void initEoxEarthByDay(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Earth by day");
        names.put("sv", "Jorden p\u00e5 dagen");
        TreeMap descriptions = new TreeMap();
        this.mStyles.add(this.createStyle(this.mCategoriesEarth, names, descriptions, "EOX & ESA", enabled, "at.eox.bluemarble", new String[]{"at.eox.bluemarble"}));
    }

    private void initEoxEarthByNight(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Earth by night");
        names.put("sv", "Jorden p\u00e5 natten");
        TreeMap descriptions = new TreeMap();
        this.mStyles.add(this.createStyle(this.mCategoriesEarth, names, descriptions, "EOX & ESA", enabled, "at.eox.blackmarble", new String[]{"at.eox.blackmarble"}));
    }

    private void initEoxHydro(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Coastline & Hydrography");
        names.put("sv", "Kustlinje & hydrografi");
        TreeMap descriptions = new TreeMap();
        this.mStyles.add(this.createStyle(this.mCategoriesEarth, names, descriptions, "EOX", enabled, "at.eox.coasthydro", new String[]{"at.eox.coastline", "at.eox.hydrography"}));
    }

    private void initEoxOsm(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "OpenStreetMap");
        TreeMap<String, String> descriptions = new TreeMap<String, String>();
        descriptions.put("", "A global road map created by the\nOpenStreetMap (OSM) projekt.");
        descriptions.put("sv", "En global v\u00e4gkarta skapad av\nprojektet OpenStreetMap (OSM).");
        this.mStyles.add(this.createStyle(null, names, descriptions, "EOX", enabled, "at.eox.osm", new String[]{"at.eox.osm"}));
    }

    private void initEoxSentinel2(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Satellite");
        names.put("sv", "Satellit");
        TreeMap<String, String> descriptions = new TreeMap<String, String>();
        descriptions.put("", "World wide satellite imagery\nfrom ESA & EOX.");
        descriptions.put("sv", "V\u00e4rldst\u00e4ckande satellitbild\nfr\u00e5n ESA & EOX.");
        this.mStyles.add(this.createStyle(null, names, descriptions, "EOX & ESA", enabled, "at.eox.s2cloudless", new String[]{"at.eox.s2cloudless"}));
    }

    private void initEoxSentinel2Streets(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Satellite & Street");
        names.put("sv", "Satellit & v\u00e4g");
        TreeMap descriptions = new TreeMap();
        this.mStyles.add(this.createStyle(this.mCategoriesEarth, names, descriptions, "EOX & ESA", enabled, "at.eox.streets", new String[]{"at.eox.streets", "at.eox.s2cloudless"}));
    }

    private void initEoxTerrain(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Terrain");
        names.put("sv", "Terr\u00e4ng");
        TreeMap descriptions = new TreeMap();
        this.mStyles.add(this.createStyle(this.mCategoriesEarth, names, descriptions, "EOX & ESA", enabled, "at.eox.terrain", new String[]{"at.eox.terrain"}));
    }

    private void initEoxTerrainLight(boolean enabled) {
        TreeMap<String, String> names = new TreeMap<String, String>();
        names.put("", "Terrain (light)");
        names.put("sv", "Terr\u00e4ng (ljus)");
        TreeMap descriptions = new TreeMap();
        this.mStyles.add(this.createStyle(this.mCategoriesEarth, names, descriptions, "EOX & ESA", enabled, "at.eox.terrain-light", new String[]{"at.eox.terrain-light"}));
    }
}

