/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.gmapsfx;

import com.dlsc.gmapsfx.javascript.object.LatLong;
import com.dlsc.gmapsfx.javascript.object.Marker;
import com.dlsc.gmapsfx.javascript.object.MarkerOptions;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.gmapsfx.GMapsFXMapEngine;

public class BookmarkPlotter {
    private final MBookmarkManager mBookmarkManager = MBookmarkManager.getInstance();
    private final GMapsFXMapEngine mEngine;

    public BookmarkPlotter(GMapsFXMapEngine engine) {
        this.mEngine = engine;
        this.mBookmarkManager.getItems().addListener(c -> this.updatePlacemarks());
        this.updatePlacemarks();
    }

    private void updatePlacemarks() {
        this.mEngine.getMap().clearMarkers();
        for (MBookmark bookmark : this.mBookmarkManager.getItems()) {
            if (!bookmark.isDisplayMarker().booleanValue()) continue;
            LatLong latLong = new LatLong(bookmark.getLatitude().doubleValue(), bookmark.getLongitude().doubleValue());
            MarkerOptions markerOptions = new MarkerOptions();
            markerOptions.position(latLong);
            markerOptions.title(bookmark.getName());
            Marker marker = new Marker(markerOptions);
            this.mEngine.getMap().addMarker(marker);
        }
    }
}

