/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.gmapsfx;

import com.dlsc.gmapsfx.GoogleMapView;
import com.dlsc.gmapsfx.javascript.event.UIEventType;
import com.dlsc.gmapsfx.javascript.object.GoogleMap;
import com.dlsc.gmapsfx.javascript.object.InfoWindow;
import com.dlsc.gmapsfx.javascript.object.LatLong;
import com.dlsc.gmapsfx.javascript.object.LatLongBounds;
import com.dlsc.gmapsfx.javascript.object.MapOptions;
import com.dlsc.gmapsfx.javascript.object.MapTypeIdEnum;
import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.Locale;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javax.swing.JComponent;
import org.mapton.api.MAttribution;
import org.mapton.api.MDocumentInfo;
import org.mapton.api.MEngine;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.Mapton;
import org.mapton.gmapsfx.BookmarkPlotter;
import org.mapton.gmapsfx.ModuleOptions;
import org.mapton.gmapsfx.StyleView;
import org.mapton.gmapsfx.api.MapStyle;
import org.mapton.google_maps.api.GoogleMaps;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.MathHelper;
import se.trixon.almond.util.fx.FxHelper;

public class GMapsFXMapEngine
extends MEngine {
    public static final String LOG_TAG = "GMapsFX";
    private BookmarkPlotter mBookmarkPlotter;
    private InfoWindow mInfoWindow;
    private GoogleMap mMap;
    private MapOptions mMapOptions;
    private GoogleMapView mMapView;
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private StyleView mStyleView = new StyleView();

    public void create(Runnable postCreateRunnable) {
        FxHelper.runLater(() -> {
            if (this.mMapView == null) {
                this.init();
                postCreateRunnable.run();
            } else {
                postCreateRunnable.run();
            }
        });
    }

    public void fitToBounds(MLatLonBox latLonBox) {
        this.mMap.fitBounds(new LatLongBounds(this.toLatLong(latLonBox.getSouthWest()), this.toLatLong(latLonBox.getNorthEast())));
    }

    public MLatLon getCenter() {
        return this.toLatLon(this.mMap.getCenter());
    }

    public GoogleMap getMap() {
        return this.mMap;
    }

    public JComponent getMapComponent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Node getMapNode() {
        this.updateToolbarDocumentInfo();
        return this.mMapView;
    }

    public String getName() {
        return "Google Maps";
    }

    public Node getStyleView() {
        return this.mStyleView;
    }

    public double getZoom() {
        return this.toGlobalZoom();
    }

    public boolean isSwing() {
        return false;
    }

    public void onWhatsHere(String s) {
        this.mInfoWindow.setContent(s);
        this.mInfoWindow.setPosition(this.toLatLong(this.getLatLonMouse()));
        this.mInfoWindow.open(this.mMap);
    }

    public void panTo(MLatLon latLon) {
        this.mMap.panTo(this.toLatLong(latLon));
    }

    public void panTo(MLatLon latLong, double zoom) {
        this.mMap.setZoom(MathHelper.round((double)this.toLocalZoom(zoom)));
        this.panTo(latLong);
    }

    private void init() {
        this.mMapView = new GoogleMapView(Locale.getDefault().getLanguage(), GoogleMaps.getKey());
        this.mMapView.addMapInitializedListener(() -> {
            this.mInfoWindow = new InfoWindow();
            this.mMapOptions = new MapOptions().zoom(5.0).mapType(MapTypeIdEnum.ROADMAP).rotateControl(true).clickableIcons(false).streetViewControl(false).mapTypeControl(false).fullscreenControl(false).scaleControl(true).styleString(MapStyle.getStyle(this.mOptions.get("map_style", new String[]{"Retro"}))).zoomControl(false);
            this.initMap();
            this.initialized();
            this.initListeners();
            this.setImageRenderer(() -> {
                WritableImage image = this.mMapView.snapshot(new SnapshotParameters(), null);
                return SwingFXUtils.fromFXImage((Image)image, null);
            });
            this.mBookmarkPlotter = new BookmarkPlotter(this);
            Mapton.getLog().i(LOG_TAG, "Loaded and ready");
        });
    }

    private void initListeners() {
        this.mOptions.getPreferences().addPreferenceChangeListener(evt -> Platform.runLater(() -> {
            switch (evt.getKey()) {
                case "map_style": {
                    MLatLon old = this.getCenter();
                    this.initMap();
                    FxHelper.runLaterDelayed((long)100L, () -> this.panTo(old));
                    break;
                }
                case "map_type": {
                    this.mMap.setMapType(this.mOptions.getMapType());
                    this.updateToolbarDocumentInfo();
                    break;
                }
            }
        }));
        this.mMap.zoomProperty().addListener((ov, t, t1) -> Mapton.getInstance().zoomProperty().set(this.toGlobalZoom()));
        this.mMapView.setOnContextMenuRequested(e -> this.displayContextMenu(new Point((int)e.getScreenX(), (int)e.getScreenY())));
    }

    private void initMap() {
        Mapton.getLog().v(LOG_TAG, "Initializing map...");
        this.mMapOptions.styleString(MapStyle.getStyle(this.mOptions.get("map_style", new String[]{"Retro"})));
        this.mMap = this.mMapView.createMap(this.mMapOptions);
        this.mMap.setMapType(this.mOptions.getMapType());
        this.mMap.addMouseEventHandler(UIEventType.mousemove, event -> this.setStatusMousePositionData(this.toLatLon(event.getLatLong()), null, null));
        Mapton.getLog().v(LOG_TAG, "Map initialized");
    }

    private double toGlobalZoom() {
        double steps = 22.0;
        int zoom = this.mMap.getZoom();
        return (double)zoom / 22.0;
    }

    private MLatLon toLatLon(LatLong latLong) {
        return new MLatLon(latLong.getLatitude(), latLong.getLongitude());
    }

    private LatLong toLatLong(MLatLon latLon) {
        return new LatLong(latLon.getLatitude(), latLon.getLongitude());
    }

    private double toLocalZoom(double globalZoom) {
        return globalZoom * 22.0;
    }

    private void updateToolbarDocumentInfo() {
        String name = "";
        switch (this.mOptions.getMapType().toString()) {
            case "ROADMAP": {
                name = Dict.MAP_TYPE_ROADMAP.toString();
                break;
            }
            case "SATELLITE": {
                name = Dict.MAP_TYPE_SATELLITE.toString();
                break;
            }
            case "HYBRID": {
                name = Dict.MAP_TYPE_HYBRID.toString();
                break;
            }
            case "TERRAIN": {
                name = Dict.MAP_TYPE_TERRAIN.toString();
            }
        }
        LinkedHashMap<String, MAttribution> attributions = new LinkedHashMap<String, MAttribution>();
        MAttribution attribution = new MAttribution();
        attribution.setProviderName("Google");
        attribution.setProviderUrl("https://www.google.com/maps");
        attribution.setLicenseName("GOOGLE TERMS OF SERVICE");
        attribution.setLicenseUrl("https://www.google.com/help/terms_maps/");
        attributions.put("com.google.maps", attribution);
        MDocumentInfo documentInfo = new MDocumentInfo(name, attributions);
        Mapton.getGlobalState().put("map.document.info", (Object)documentInfo);
    }
}

