/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.gmapsfx;

import com.dlsc.gmapsfx.javascript.object.MapTypeIdEnum;
import java.util.ArrayList;
import java.util.Collections;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.mapton.gmapsfx.ModuleOptions;
import org.mapton.gmapsfx.api.MapStyle;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;

public class StyleView
extends HBox {
    private final ModuleOptions mOptions = ModuleOptions.getInstance();
    private final VBox mTypeBox = new VBox(16.0);
    private final VBox mStyleBox = new VBox(16.0);

    public StyleView() {
        this.setSpacing(16.0);
        this.setPadding(new Insets(8.0, 16.0, 16.0, 16.0));
        this.mTypeBox.setPrefWidth(200.0);
        this.mStyleBox.setPrefWidth(200.0);
        Lookup.getDefault().lookupResult(MapStyle.class).addLookupListener(ev -> this.initStyle());
        this.initType();
        this.initStyle();
        this.getChildren().addAll((Object[])new Node[]{this.mTypeBox, new Separator(Orientation.VERTICAL), this.mStyleBox});
    }

    private void initStyle() {
        Platform.runLater(() -> {
            ToggleGroup group = new ToggleGroup();
            this.mStyleBox.getChildren().clear();
            ArrayList styles = new ArrayList(Lookup.getDefault().lookupAll(MapStyle.class));
            Collections.sort(styles, (o1, o2) -> o1.getName().compareTo(o2.getName()));
            for (MapStyle mapStyle : styles) {
                ToggleButton button = new ToggleButton(mapStyle.getName());
                button.prefWidthProperty().bind((ObservableValue)this.widthProperty());
                button.setToggleGroup(group);
                button.setOnAction(event -> {
                    MapTypeIdEnum type = this.mOptions.getMapType();
                    this.mOptions.put("map_style", mapStyle.getName());
                    if (MapTypeIdEnum.ROADMAP != type) {
                        this.mOptions.setMapType(MapTypeIdEnum.ROADMAP);
                        this.mOptions.setMapType(type);
                    }
                });
                this.mStyleBox.getChildren().add((Object)button);
            }
        });
    }

    private void initType() {
        ToggleButton hybridToggleButton = new ToggleButton(Dict.MAP_TYPE_HYBRID.toString());
        ToggleButton terrainToggleButton = new ToggleButton(Dict.MAP_TYPE_TERRAIN.toString());
        ToggleButton roadmapToggleButton = new ToggleButton(Dict.MAP_TYPE_ROADMAP.toString());
        ToggleButton satelliteToggleButton = new ToggleButton(Dict.MAP_TYPE_SATELLITE.toString());
        hybridToggleButton.setOnAction(event -> this.mOptions.setMapType(MapTypeIdEnum.HYBRID));
        terrainToggleButton.setOnAction(event -> this.mOptions.setMapType(MapTypeIdEnum.TERRAIN));
        roadmapToggleButton.setOnAction(event -> this.mOptions.setMapType(MapTypeIdEnum.ROADMAP));
        satelliteToggleButton.setOnAction(event -> this.mOptions.setMapType(MapTypeIdEnum.SATELLITE));
        this.mTypeBox.getChildren().addAll((Object[])new Node[]{roadmapToggleButton, satelliteToggleButton, hybridToggleButton, terrainToggleButton});
        ToggleGroup group = new ToggleGroup();
        this.mTypeBox.getChildren().forEach(node -> {
            ToggleButton button = (ToggleButton)node;
            button.prefWidthProperty().bind((ObservableValue)this.widthProperty());
            button.setToggleGroup(group);
        });
    }
}

