/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.gmapsfx.api;

import java.io.IOException;
import java.io.InputStream;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.io.IOUtils;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import se.trixon.almond.util.SystemHelper;

public abstract class MapStyle {
    private final StringProperty mName = new SimpleStringProperty();
    private final StringProperty mStyle = new SimpleStringProperty();

    public static String getStyle(String name) {
        String style = "";
        for (MapStyle mapStyle : Lookup.getDefault().lookupAll(MapStyle.class)) {
            if (!mapStyle.getName().equalsIgnoreCase(name)) continue;
            style = mapStyle.getStyle();
        }
        return style;
    }

    public MapStyle(String name, String resourceName) {
        this.setName(name);
        this.setStyle(this.loadFromResource(resourceName));
    }

    public final String getName() {
        return (String)this.mName.get();
    }

    public final String getStyle() {
        return (String)this.mStyle.get();
    }

    public final StringProperty nameProperty() {
        return this.mName;
    }

    public final void setName(String value) {
        this.mName.set((Object)value);
    }

    public final void setStyle(String value) {
        this.mStyle.set((Object)value);
    }

    public StringProperty styleProperty() {
        return this.mStyle;
    }

    private String loadFromResource(String filename) {
        InputStream inputStream = this.getClass().getResourceAsStream("/" + SystemHelper.getPackageAsPath(this.getClass()) + filename);
        try {
            return IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }
}

