/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

public class MathBase {
    public static final double SQRT_2 = 1.4142135623730951;
    public static final double PI = Math.PI;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final double DEG_TO_RAD = Math.PI / 180;
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double TWO_PI = Math.PI * 2;
    public static final double INV_PI = 0.3183098861837907;
    public static final double E = Math.E;
    public static final double LOG_E = 0.4342944819032518;
    public static final double LOG_2 = 0.201029996;
    public static final double LN_10 = 2.302585092994046;
    public static final double EULER_GAMMA = 0.5772156649015329;
    public static final double C = 2.99792458E8;
    public static final double C_UNCERTAINTY = 0.0;
    public static final double C_CGS = 2.99792458E10;
    public static final double G = 6.673E-11;
    public static final double G_UNCERTAINTY = 1.0E-13;
    public static final double G_CGS = 6.673E-14;
    public static final double GHBAR_C = 6.707E-39;
    public static final double GHBAR_C_UNCERTAINTY = 1.0E-41;
    public static final double GN = 9.80665;
    public static final double GN_UNCERTAINTY = 0.0;
    public static final double QE = 1.602176462E-19;
    public static final double QE_UNCERTAINTY = 6.3E-27;
    public static final double H = 6.62606876E-34;
    public static final double H_BAR = 1.054571596E-34;
    public static final double H_BAR_UNCERTAINTY = 8.2E-42;
    public static final double H_BAR_CGS = 1.054571596E-27;
    public static final double HC = 1.9864454404374119E-25;
    public static final double K = 1.3806503E-23;
    public static final double K_UNCERTAINTY = 2.4E-29;
    public static final double K_CGS = 1.3806503E-16;
    public static final double SIGMA = 5.6704E-8;
    public static final double SIGMA_UNCERTAINTY = 4.0E-13;
    public static final double N_A = 6.02214199E23;
    public static final double N_A_UNCERTAINTY = 4.7E16;
    public static final double R = 8.314472145136097;
    public static final double H_UNCERTAINTY = 5.2E-41;
    public static final double H_CGS = 6.62606876E-27;
    public static final double HC_CGS = 1.986445440437412E-16;
    public static final double MW_AIR = 28.9644;
    public static final double RG_AIR = 287.0583248793725;
    public static final double R_UNCERTAINTY = 1.5102046417E-5;

    public static double log(double x) {
        return Math.log(x);
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static double aCosH(double arg0) {
        if (arg0 == 0.0) {
            return 0.0;
        }
        double ax = Math.abs(arg0);
        return Math.log(arg0 + ax * Math.sqrt(1.0 - 1.0 / (ax * ax)));
    }

    public static double aSinH(double arg0) {
        if (arg0 == 0.0) {
            return 0.0;
        }
        double ax = Math.abs(arg0);
        return Math.log(arg0 + ax * Math.sqrt(1.0 + 1.0 / (ax * ax)));
    }

    public static double aTanH(double arg0) {
        return Math.log((1.0 + arg0) / (1.0 - arg0)) / 2.0;
    }

    public static double hypot(double x, double y) {
        return Math.hypot(x, y);
    }

    public static double abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    public static float abs(float d) {
        return d >= 0.0f ? d : -d;
    }

    public static int abs(int d) {
        return d >= 0 ? d : -d;
    }

    public static long abs(long d) {
        return d >= 0L ? d : -d;
    }

    public static short abs(short d) {
        return d >= 0 ? d : (short)(-d);
    }

    public static double aCos(double arg0) {
        return Math.acos(arg0);
    }

    public static double aSin(double arg0) {
        return Math.asin(arg0);
    }

    public static double aTan(double arg0) {
        return Math.atan(arg0);
    }

    public static double aTan2(double y, double x) {
        if (x != 0.0) {
            return Math.atan2(y, x);
        }
        if (y == 0.0) {
            return 0.0;
        }
        if (y > 0.0) {
            return 1.5707963267948966;
        }
        return -1.5707963267948966;
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static int ceilNInt(double x) {
        return MathBase.nInt(Math.ceil(x));
    }

    public static double cos(double arg0) {
        return Math.cos(arg0);
    }

    public static double cosH(double arg0) {
        return Math.cosh(arg0);
    }

    public static boolean even(long a) {
        return (a & 1L) == 0L;
    }

    public static double exp(double x) {
        return Math.exp(x);
    }

    public static boolean finite(double x) {
        return !Double.isInfinite(x) && !Double.isNaN(x);
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static int floorNint(double x) {
        return MathBase.nInt(Math.floor(x));
    }

    public static boolean isNaN(double x) {
        return Double.isNaN(x);
    }

    public static double ldExp(double x, int exp) {
        return x * Math.pow(2.0, exp);
    }

    public static double log2(double x) {
        return Math.log(x) / 0.201029996;
    }

    public static double max(double a, double b) {
        return a >= b ? a : b;
    }

    public static float max(float a, float b) {
        return a >= b ? a : b;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    public static short max(short a, short b) {
        return a >= b ? a : b;
    }

    public static double min(double a, double b) {
        return a <= b ? a : b;
    }

    public static float min(float a, float b) {
        return a <= b ? a : b;
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    public static short min(short a, short b) {
        return a <= b ? a : b;
    }

    public static long nextPrime(long x) {
        if (x <= 2L) {
            return 2L;
        }
        if (x == 3L) {
            return 3L;
        }
        long val = x % 2L == 0L ? x + 1L : x;
        long sqr = (long)Math.sqrt(val) + 1L;
        while (true) {
            long n;
            for (n = 3L; n <= sqr && val % n != 0L; n += 2L) {
            }
            if (n > sqr) {
                return val;
            }
            val += 2L;
        }
    }

    public static int nInt(double x) {
        int i;
        if (x >= 0.0) {
            i = (int)(x + 0.5);
            if (x + 0.5 == (double)i && (i & 1) > 0) {
                --i;
            }
        } else {
            i = (int)(x - 0.5);
            if (x - 0.5 == (double)i && (i & 1) > 0) {
                ++i;
            }
        }
        return i;
    }

    public static int nInt(float x) {
        int i;
        if (x >= 0.0f) {
            i = (int)(x + 0.5f);
            if (x + 0.5f == (float)i && (i & 1) > 0) {
                --i;
            }
        } else {
            i = (int)((double)x - 0.5);
            if (x - 0.5f == (float)i && (i & 1) > 0) {
                ++i;
            }
        }
        return i;
    }

    public static boolean odd(long a) {
        return (a & 1L) != 0L;
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static double range(double lb, double ub, double x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static int range(int lb, int ub, int x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static long range(long lb, long ub, long x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static short range(short lb, short ub, short x) {
        return x < lb ? lb : (x > ub ? ub : x);
    }

    public static double sign(double a, double b) {
        return b >= 0.0 ? MathBase.abs(a) : -MathBase.abs(a);
    }

    public static double sin(double arg0) {
        return Math.sin(arg0);
    }

    public static double sinH(double arg0) {
        return Math.sinh(arg0);
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double tan(double arg0) {
        return Math.tan(arg0);
    }

    public static double tanH(double arg0) {
        return Math.tanh(arg0);
    }
}

