/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.EventRateLimiter;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class MathDataSet
extends DoubleErrorDataSet {
    private static final long serialVersionUID = -4978160822533565009L;
    private static final long DEFAULT_UPDATE_LIMIT = 40L;
    private final transient EventListener eventListener;
    private final transient List<DataSet> sourceDataSets;
    private final transient DataSetFunction dataSetFunction;
    private final transient DataSetsFunction dataSetsFunction;
    private final transient DataSetValueFunction dataSetValueFunction;
    private final transient long minUpdatePeriod;
    private final transient EventRateLimiter.UpdateStrategy updateStrategy;
    private final transient String transformName;

    public MathDataSet(String transformName, DataSetFunction dataSetFunction, DataSet source) {
        this(transformName, dataSetFunction, null, null, 40L, EventRateLimiter.UpdateStrategy.INSTANTANEOUS_RATE, source);
    }

    public MathDataSet(String transformName, DataSetFunction dataSetFunction, long minUpdatePeriod, EventRateLimiter.UpdateStrategy updateStrategy, DataSet source) {
        this(transformName, dataSetFunction, null, null, minUpdatePeriod, updateStrategy, source);
    }

    public MathDataSet(String transformName, DataSetsFunction dataSetFunction, DataSet ... sources) {
        this(transformName, null, dataSetFunction, null, 40L, EventRateLimiter.UpdateStrategy.INSTANTANEOUS_RATE, sources);
    }

    public MathDataSet(String transformName, DataSetsFunction dataSetFunction, long minUpdatePeriod, EventRateLimiter.UpdateStrategy updateStrategy, DataSet ... sources) {
        this(transformName, null, dataSetFunction, null, minUpdatePeriod, updateStrategy, sources);
    }

    public MathDataSet(String transformName, DataSetValueFunction dataSetFunction, DataSet source) {
        this(transformName, null, null, dataSetFunction, 40L, EventRateLimiter.UpdateStrategy.INSTANTANEOUS_RATE, source);
    }

    public MathDataSet(String transformName, DataSetValueFunction dataSetFunction, long minUpdatePeriod, EventRateLimiter.UpdateStrategy updateStrategy, DataSet source) {
        this(transformName, null, null, dataSetFunction, minUpdatePeriod, updateStrategy, source);
    }

    protected MathDataSet(String transformName, DataSetFunction dataSetFunction, DataSetsFunction dataSetsFunction, DataSetValueFunction dataSetValueFunction, long minUpdatePeriod, EventRateLimiter.UpdateStrategy updateStrategy, DataSet ... sources) {
        super(MathDataSet.getCompositeDataSetName(transformName, sources));
        this.sourceDataSets = new ArrayList<DataSet>(Arrays.asList(sources));
        this.minUpdatePeriod = minUpdatePeriod;
        this.updateStrategy = updateStrategy == null ? EventRateLimiter.UpdateStrategy.INSTANTANEOUS_RATE : updateStrategy;
        this.dataSetFunction = dataSetFunction;
        this.dataSetsFunction = dataSetsFunction;
        this.dataSetValueFunction = dataSetValueFunction;
        this.transformName = transformName;
        if (dataSetFunction == null && dataSetsFunction == null && dataSetValueFunction == null) {
            throw new IllegalArgumentException("dataSetFunction, dataSetsFunction and dataSetValueFunction cannot all be null");
        }
        if (dataSetValueFunction != null && this.sourceDataSets.size() > 1) {
            throw new IllegalArgumentException("sources list may not be larger than one if the 'dataSetValueFunction' interface is used -> try to use 'DataSetFunction' instead");
        }
        this.eventListener = minUpdatePeriod > 0L ? new EventRateLimiter(this::handle, this.minUpdatePeriod, this.updateStrategy) : this::handle;
        this.registerListener();
        this.handle((UpdateEvent)new UpdatedDataEvent((EventSource)this, MathDataSet.class.getSimpleName() + " - initial constructor update"));
    }

    public final void deregisterListener() {
        this.sourceDataSets.forEach(srcDataSet -> srcDataSet.removeListener(this.eventListener));
    }

    public final List<DataSet> getSourceDataSets() {
        return this.sourceDataSets;
    }

    public final void registerListener() {
        this.sourceDataSets.forEach(srcDataSet -> srcDataSet.addListener(this.eventListener));
    }

    private void handleDataSetValueFunctionInterface() {
        double[] ySourceErrorNeg;
        double[] ySourceErrorPos;
        DataSet dataSet = this.sourceDataSets.get(0);
        int length = dataSet.getDataCount();
        double[] xSourceVector = dataSet.getValues(0);
        double[] ySourceVector = dataSet.getValues(1);
        if (dataSet instanceof DataSetError) {
            DataSetError dsError = (DataSetError)dataSet;
            ySourceErrorPos = dsError.getErrorsPositive(1);
            ySourceErrorNeg = dsError.getErrorsNegative(1);
        } else {
            ySourceErrorNeg = ySourceErrorPos = new double[length];
        }
        if (this.getCapacity() < length) {
            int amount = length - this.getCapacity();
            this.increaseCapacity(amount);
        }
        double[] xDestVector = this.getValues(0);
        double[] yDestVector = this.getValues(1);
        System.arraycopy(xSourceVector, 0, xDestVector, 0, length);
        this.dataSetValueFunction.transform(ySourceVector, yDestVector, length);
        this.set(xDestVector, yDestVector, ySourceErrorNeg, ySourceErrorPos, length, false);
    }

    protected void handle(UpdateEvent event) {
        boolean isKnownEvent;
        boolean bl = isKnownEvent = event instanceof AddedDataEvent || event instanceof RemovedDataEvent || event instanceof UpdatedDataEvent;
        if (event == null || !isKnownEvent) {
            return;
        }
        this.lock().writeLockGuard(() -> {
            if (this.dataSetFunction != null) {
                this.set(this.dataSetFunction.transform(this.sourceDataSets.get(0)));
            } else if (this.dataSetsFunction != null) {
                this.dataSetsFunction.transform(this.sourceDataSets, this);
            } else {
                if (this.sourceDataSets.isEmpty()) {
                    return;
                }
                this.handleDataSetValueFunctionInterface();
            }
            this.setName(MathDataSet.getCompositeDataSetName(this.transformName, this.sourceDataSets.toArray(new DataSet[0])));
        });
        this.fireInvalidated((UpdateEvent)new UpdatedDataEvent((EventSource)this, "propagated update from source " + this.getName()));
    }

    protected static String getCompositeDataSetName(String transformName, DataSet ... sources) {
        List<DataSet> dataSets = Arrays.asList(sources);
        String sanitizedFunctionName = transformName == null ? "" : transformName;
        return dataSets.stream().map(DataSet::getName).collect(Collectors.joining(",", sanitizedFunctionName + "(", ")"));
    }

    public static interface DataSetValueFunction {
        public void transform(double[] var1, double[] var2, int var3);
    }

    public static interface DataSetsFunction {
        public void transform(List<DataSet> var1, MathDataSet var2);
    }

    public static interface DataSetFunction {
        public DataSet transform(DataSet var1);
    }
}

