/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DefaultNumberFormatter;
import de.gsi.dataset.Formatter;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.utils.DoubleArrayCache;
import de.gsi.math.Math;
import java.util.Arrays;
import java.util.Objects;

public final class MultiDimDataSetMath {
    public static Formatter<Number> DEFAULT_FORMATTER = new DefaultNumberFormatter();

    private MultiDimDataSetMath() {
    }

    @SafeVarargs
    public static void computeIntegral(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, Formatter<Number> ... format) {
        MultiDimDataSetMath.computeMeanIntegral(source, output, dimIndex, xMin, xMax, false, format);
    }

    @SafeVarargs
    public static void computeMax(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, Formatter<Number> ... format) {
        MultiDimDataSetMath.computeMinMax(source, output, dimIndex, xMin, xMax, false, format);
    }

    @SafeVarargs
    public static void computeMean(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, Formatter<Number> ... format) {
        MultiDimDataSetMath.computeMeanIntegral(source, output, dimIndex, xMin, xMax, true, new Formatter[0]);
    }

    @SafeVarargs
    public static void computeMin(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, Formatter<Number> ... format) {
        MultiDimDataSetMath.computeMinMax(source, output, dimIndex, xMin, xMax, true, format);
    }

    @SafeVarargs
    public static void computeSlice(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, Formatter<Number> ... format) {
        double[] ret;
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility((DataSet)source);
        MultiDimDataSetMath.checkOutputDataSetCompatibility((DataSet)output);
        double[] xValues = output.getValues(0);
        double[] yValues = output.getValues(1);
        double[] yErrorNeg = output.getErrorsNegative(1);
        double[] yErrorPos = output.getErrorsPositive(1);
        int nsize = source.getShape(dimIndex);
        if (nsize == output.getDataCount()) {
            System.arraycopy(source.getGridValues(dimIndex), 0, xValues, 0, nsize);
            ret = MultiDimDataSetMath.getSliceArray(source, dimIndex, xMin, yValues);
            output.set(xValues, ret, yErrorNeg, yErrorPos, false);
        } else {
            ret = MultiDimDataSetMath.getSliceArray(source, dimIndex, xMin, yValues);
            output.set(Arrays.copyOf(source.getGridValues(dimIndex), nsize), ret, new double[nsize], new double[nsize], false);
        }
        String dataSetName = MultiDimDataSetMath.getFormatter(format).format("{0}({1})@{2} {3}", new Object[]{"slice", source.getName(), xMin, source.getAxisDescription(dimIndex).getUnit()});
        output.setName(dataSetName);
        output.getAxisDescription(0).set(source.getAxisDescription(dimIndex).getName(), new String[]{source.getAxisDescription(dimIndex).getUnit()});
        output.getAxisDescription(1).set(source.getAxisDescription(2).getName(), new String[]{source.getAxisDescription(2).getUnit()});
        output.getAxisDescriptions().forEach(AxisDescription::clear);
    }

    public static double[] getMeanIntegralArray(GridDataSet source, int dimIndex, double xMin, double xMax, double[] buffer, boolean isMean) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility((DataSet)source);
        double[] ret = MultiDimDataSetMath.getSanitizedBuffer(source, dimIndex, buffer);
        int minIndex = source.getGridIndex(dimIndex == 0 ? 1 : 0, xMin);
        int maxIndex = source.getGridIndex(dimIndex == 0 ? 1 : 0, xMax);
        int min = Math.min(minIndex, maxIndex);
        int max = Math.max(Math.max(minIndex, maxIndex), min + 1);
        int nDataCount = source.getShape(dimIndex);
        if (dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double integral = 0.0;
                int nSlices = 0;
                int i = min;
                while (i <= Math.min(max, nDataCount - 1)) {
                    integral += source.get(2, new int[]{i++, index});
                    ++nSlices;
                }
                ret[index] = isMean ? (nSlices == 0 ? Double.NaN : integral / (double)nSlices) : integral;
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double integral = 0.0;
                int nSlices = 0;
                int i = min;
                while (i <= Math.min(max, nDataCount - 1)) {
                    integral += source.get(2, new int[]{index, i++});
                    ++nSlices;
                }
                ret[index] = isMean ? (nSlices == 0 ? Double.NaN : integral / (double)nSlices) : integral;
            }
        }
        return ret;
    }

    public static double[] getMinMaxArray(GridDataSet source, int dimIndex, double xMin, double xMax, double[] buffer, boolean isMin) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility((DataSet)source);
        double[] ret = MultiDimDataSetMath.getSanitizedBuffer(source, dimIndex, buffer);
        int minIndex = source.getIndex(dimIndex == 0 ? 1 : 0, new double[]{xMin});
        int maxIndex = source.getIndex(dimIndex == 0 ? 1 : 0, new double[]{xMax});
        int min = Math.min(minIndex, maxIndex);
        int max = Math.max(Math.max(minIndex, maxIndex), min + 1);
        int nDataCount = source.getShape(dimIndex);
        if (dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double extreme = source.get(2, new int[]{min, index});
                for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                    double val = source.get(2, new int[]{i, index});
                    extreme = isMin ? Math.min(val, extreme) : Math.max(val, extreme);
                }
                ret[index] = extreme;
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double extreme = source.get(2, new int[]{index, min});
                for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                    double val = source.get(2, new int[]{index, i});
                    extreme = isMin ? Math.min(val, extreme) : Math.max(val, extreme);
                }
                ret[index] = extreme;
            }
        }
        return ret;
    }

    public static double[] getSliceArray(GridDataSet source, int dimIndex, double xMin, double[] buffer) {
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility((DataSet)source);
        double[] ret = MultiDimDataSetMath.getSanitizedBuffer(source, dimIndex, buffer);
        int minIndex = source.getGridIndex(dimIndex == 0 ? 1 : 0, xMin);
        int nDataCount = source.getShape(dimIndex);
        if (dimIndex == 1) {
            for (int index = 0; index < nDataCount; ++index) {
                double y;
                ret[index] = y = source.get(2, new int[]{minIndex, index});
            }
        } else {
            for (int index = 0; index < nDataCount; ++index) {
                double y;
                ret[index] = y = source.get(2, new int[]{index, minIndex});
            }
        }
        return ret;
    }

    private static void checkMultiDimDataSetCompatibility(DataSet source) {
        if (source == null || source.getDimension() <= 2) {
            throw new IllegalArgumentException("source is " + (String)(source == null ? "null" : " has insufficient dimension = " + source.getDimension()));
        }
    }

    private static void checkOutputDataSetCompatibility(DataSet ouput) {
        if (ouput == null || ouput.getDimension() != 2) {
            throw new IllegalArgumentException("output is " + (String)(ouput == null ? "null" : " has insufficient dimension = " + ouput.getDimension()));
        }
    }

    @SafeVarargs
    private static void computeMeanIntegral(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, boolean isMean, Formatter<Number> ... format) {
        double[] ret;
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility((DataSet)source);
        MultiDimDataSetMath.checkOutputDataSetCompatibility((DataSet)output);
        double[] xValues = output.getValues(0);
        double[] yValues = output.getValues(1);
        double[] yErrorNeg = output.getErrorsNegative(1);
        double[] yErrorPos = output.getErrorsPositive(1);
        int nsize = source.getShape(dimIndex);
        if (nsize == output.getDataCount()) {
            System.arraycopy(source.getValues(dimIndex), 0, xValues, 0, nsize);
            ret = MultiDimDataSetMath.getMeanIntegralArray(source, dimIndex, xMin, xMax, yValues, isMean);
            output.set(xValues, ret, yErrorNeg, yErrorPos, false);
        } else {
            ret = MultiDimDataSetMath.getMeanIntegralArray(source, dimIndex, xMin, xMax, yValues, isMean);
            output.set(Arrays.copyOf(source.getValues(dimIndex), nsize), ret, new double[nsize], new double[nsize], false);
        }
        String dataSetName = MultiDimDataSetMath.getFormatter(format).format("{0}({1})@{2}->{3} {4}", new Object[]{isMean ? "mean" : "int", source.getName(), xMin, xMax, source.getAxisDescription(dimIndex).getUnit()});
        output.setName(dataSetName);
        output.getAxisDescription(0).set(source.getAxisDescription(dimIndex).getName(), new String[]{source.getAxisDescription(dimIndex).getUnit()});
        output.getAxisDescription(1).set(source.getAxisDescription(2).getName(), new String[]{source.getAxisDescription(2).getUnit()});
        output.getAxisDescriptions().forEach(AxisDescription::clear);
    }

    @SafeVarargs
    private static void computeMinMax(GridDataSet source, DoubleErrorDataSet output, int dimIndex, double xMin, double xMax, boolean isMin, Formatter<Number> ... format) {
        double[] ret;
        MultiDimDataSetMath.checkMultiDimDataSetCompatibility((DataSet)source);
        MultiDimDataSetMath.checkOutputDataSetCompatibility((DataSet)output);
        double[] xValues = output.getValues(0);
        double[] yValues = output.getValues(1);
        double[] yErrorNeg = output.getErrorsNegative(1);
        double[] yErrorPos = output.getErrorsPositive(1);
        int nsize = source.getShape(dimIndex);
        if (nsize == output.getDataCount()) {
            System.arraycopy(source.getValues(dimIndex), 0, xValues, 0, nsize);
            ret = MultiDimDataSetMath.getMinMaxArray(source, dimIndex, xMin, xMax, yValues, isMin);
            output.set(xValues, ret, yErrorNeg, yErrorPos, false);
        } else {
            ret = MultiDimDataSetMath.getMinMaxArray(source, dimIndex, xMin, xMax, yValues, isMin);
            output.set(Arrays.copyOf(source.getValues(dimIndex), nsize), ret, new double[nsize], new double[nsize], false);
        }
        String dataSetName = MultiDimDataSetMath.getFormatter(format).format("{0}({1})@{2}->{3} {4}", new Object[]{isMin ? "min" : "max", source.getName(), xMin, xMax, source.getAxisDescription(dimIndex).getUnit()});
        output.setName(dataSetName);
        output.getAxisDescription(0).set(source.getAxisDescription(dimIndex).getName(), new String[]{source.getAxisDescription(dimIndex).getUnit()});
        output.getAxisDescription(1).set(source.getAxisDescription(2).getName(), new String[]{source.getAxisDescription(2).getUnit()});
        output.getAxisDescriptions().forEach(AxisDescription::clear);
    }

    private static double[] getSanitizedBuffer(GridDataSet source, int dimIndex, double[] buffer) {
        int size = source.getShape(dimIndex);
        boolean invalidBuffer = buffer == null || buffer.length < size;
        return invalidBuffer ? DoubleArrayCache.getInstance().getArrayExact(size) : buffer;
    }

    @SafeVarargs
    private static Formatter<Number> getFormatter(Formatter<Number> ... format) {
        return Objects.requireNonNull(format, "user-supplied format").length > 0 ? format[0] : DEFAULT_FORMATTER;
    }
}

