/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.math.Math;
import de.gsi.math.MathBase;

public class TRandom {
    protected static long fSeed;

    public TRandom(long seed) {
        this.SetSeed(seed);
    }

    public static int Binomial(int ntot, double prob) {
        if (prob < 0.0 || prob > 1.0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < ntot; ++i) {
            if (TRandom.Rndm() > prob) continue;
            ++n;
        }
        return n;
    }

    public static double BreitWigner(double mean, double gamma) {
        double rval = 2.0 * TRandom.Rndm() - 1.0;
        double displ = 0.5 * gamma * MathBase.tan(rval * 1.5707963267948966);
        return mean + displ;
    }

    public static void Circle(double[] val, double r) {
        double phi = TRandom.Uniform(0.0, java.lang.Math.PI * 2);
        val[0] = r * MathBase.cos(phi);
        val[1] = r * MathBase.sin(phi);
    }

    public static double Exp(double tau) {
        double x = TRandom.Uniform(1.0);
        return -tau * MathBase.log(x);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static double Gaus(double mean, double sigma) {
        double x;
        double z;
        double rn;
        double result;
        double kC1 = 1.448242853;
        double kC2 = 3.307147487;
        double kC3 = 1.46754004;
        double kD1 = 1.036467755;
        double kD2 = 5.295844968;
        double kD3 = 3.631288474;
        double kHm = 0.483941449;
        double kZm = 0.107981933;
        double kHp = 4.132731354;
        double kZp = 18.52161694;
        double kPhln = 0.4515827053;
        double kHm1 = 0.516058551;
        double kHp1 = 3.132731354;
        double kHzm = 0.375959516;
        double kHzmp = 0.591923442;
        double kAs = 0.8853395638;
        double kBs = 0.2452635696;
        double kCs = 0.2770276848;
        double kB = 0.5029324303;
        double kX0 = 0.4571828819;
        double kYm = 0.187308492;
        double kS = 0.7270572718;
        double kT = 0.03895759111;
        double y = TRandom.Rndm();
        if (y > 0.516058551) {
            result = 4.132731354 * y - 3.132731354;
            return mean + sigma * result;
        }
        if (y < 0.107981933) {
            double rn2 = 18.52161694 * y - 1.0;
            result = rn2 > 0.0 ? 1.0 + rn2 : -1.0 + rn2;
            return mean + sigma * result;
        }
        if (y < 0.483941449) {
            rn = TRandom.Rndm();
            double d = z = (rn = rn - 1.0 + rn) > 0.0 ? 2.0 - rn : -2.0 - rn;
            if ((1.448242853 - y) * (1.46754004 + MathBase.abs(z)) < 3.307147487) {
                result = z;
                return mean + sigma * result;
            }
            x = rn * rn;
            if ((y + 1.036467755) * (3.631288474 + x) < 5.295844968 || y + 0.375959516 < Math.exp(-(x + 0.4515827053) / 2.0)) {
                result = rn;
                return mean + sigma * result;
            }
            if (0.591923442 - y < Math.exp(-(z * z + 0.4515827053) / 2.0)) {
                result = z;
                return mean + sigma * result;
            }
        }
        do {
            if ((z = 0.4571828819 - 0.7270572718 * (x = TRandom.Rndm()) - (y = 0.187308492 * TRandom.Rndm())) > 0.0) {
                rn = 2.0 + y / x;
                continue;
            }
            x = 1.0 - x;
            y = 0.187308492 - y;
            rn = -(2.0 + y / x);
        } while (!((y - 0.8853395638 + x) * (0.2770276848 + x) + 0.2452635696 < 0.0) && (!(y < x + 0.03895759111) || !(rn * rn < 4.0 * (0.5029324303 - Math.log(x)))));
        result = rn;
        return mean + sigma * result;
    }

    public static long Integer(long imax) {
        long ui = (long)((double)imax * TRandom.Rndm());
        return ui;
    }

    public static double Landau(double mpv, double sigma) {
        double ranlan;
        double[] f = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, -2.244733, -2.204365, -2.168163, -2.135219, -2.104898, -2.07674, -2.050397, -2.025605, -2.00215, -1.979866, -1.958612, -1.938275, -1.91876, -1.899984, -1.881879, -1.864385, -1.847451, -1.83103, -1.815083, -1.799574, -1.784473, -1.769751, -1.755383, -1.741346, -1.72762, -1.714187, -1.701029, -1.68813, -1.675477, -1.663057, -1.650858, -1.638868, -1.627078, -1.615477, -1.604058, -1.592811, -1.581729, -1.570806, -1.560034, -1.549407, -1.538919, -1.528565, -1.518339, -1.508237, -1.498254, -1.488386, -1.478628, -1.468976, -1.459428, -1.449979, -1.440626, -1.431365, -1.422195, -1.413111, -1.404112, -1.395194, -1.386356, -1.377594, -1.368906, -1.360291, -1.351746, -1.343269, -1.334859, -1.326512, -1.318229, -1.310006, -1.301843, -1.293737, -1.285688, -1.277693, -1.269752, -1.261863, -1.254024, -1.246235, -1.238494, -1.2308, -1.223153, -1.21555, -1.20799, -1.200474, -1.192999, -1.185566, -1.178172, -1.170817, -1.1635, -1.15622, -1.148977, -1.14177, -1.134598, -1.127459, -1.120354, -1.113282, -1.106242, -1.099233, -1.092255, -1.085306, -1.078388, -1.071498, -1.064636, -1.057802, -1.050996, -1.044215, -1.037461, -1.030733, -1.024029, -1.01735, -1.010695, -1.004064, -0.997456, -0.990871, -0.984308, -0.977767, -0.971247, -0.964749, -0.958271, -0.951813, -0.945375, -0.938957, -0.932558, -0.926178, -0.919816, -0.913472, -0.907146, -0.900838, -0.894547, -0.888272, -0.882014, -0.875773, -0.869547, -0.863337, -0.857142, -0.850963, -0.844798, -0.838648, -0.832512, -0.82639, -0.820282, -0.814187, -0.808106, -0.802038, -0.795982, -0.78994, -0.783909, -0.777891, -0.771884, -0.765889, -0.759906, -0.753934, -0.747973, -0.742023, -0.736084, -0.730155, -0.724237, -0.718328, -0.712429, -0.706541, -0.700661, -0.694791, -0.688931, -0.683079, -0.677236, -0.671402, -0.665576, -0.659759, -0.65395, -0.648149, -0.642356, -0.63657, -0.630793, -0.625022, -0.619259, -0.613503, -0.607754, -0.602012, -0.596276, -0.590548, -0.584825, -0.579109, -0.573399, -0.567695, -0.561997, -0.556305, -0.550618, -0.544937, -0.539262, -0.533592, -0.527926, -0.522266, -0.516611, -0.510961, -0.505315, -0.499674, -0.494037, -0.488405, -0.482777, -0.477153, -0.471533, -0.465917, -0.460305, -0.454697, -0.449092, -0.443491, -0.437893, -0.432299, -0.426707, -0.421119, -0.415534, -0.409951, -0.404372, -0.398795, -0.393221, -0.387649, -0.38208, -0.376513, -0.370949, -0.365387, -0.359826, -0.354268, -0.348712, -0.343157, -0.337604, -0.332053, -0.326503, -0.320955, -0.315408, -0.309863, -0.304318, -0.298775, -0.293233, -0.287692, -0.282152, -0.276613, -0.271074, -0.265536, -0.259999, -0.254462, -0.248926, -0.243389, -0.237854, -0.232318, -0.226783, -0.221247, -0.215712, -0.210176, -0.204641, -0.199105, -0.193568, -0.188032, -0.182495, -0.176957, -0.171419, -0.16588, -0.160341, -0.1548, -0.149259, -0.143717, -0.138173, -0.132629, -0.127083, -0.121537, -0.115989, -0.110439, -0.104889, -0.099336, -0.093782, -0.088227, -0.08267, -0.077111, -0.07155, -0.065987, -0.060423, -0.054856, -0.049288, -0.043717, -0.038144, -0.032569, -0.026991, -0.021411, -0.015828, -0.010243, -0.004656, 9.34E-4, 0.006527, 0.012123, 0.017722, 0.023323, 0.028928, 0.034535, 0.040146, 0.045759, 0.051376, 0.056997, 0.06262, 0.068247, 0.073877, 0.079511, 0.085149, 0.09079, 0.096435, 0.102083, 0.107736, 0.113392, 0.119052, 0.124716, 0.130385, 0.136057, 0.141734, 0.147414, 0.1531, 0.158789, 0.164483, 0.170181, 0.175884, 0.181592, 0.187304, 0.193021, 0.198743, 0.204469, 0.210201, 0.215937, 0.221678, 0.227425, 0.233177, 0.238933, 0.244696, 0.250463, 0.256236, 0.262014, 0.267798, 0.273587, 0.279382, 0.285183, 0.290989, 0.296801, 0.302619, 0.308443, 0.314273, 0.320109, 0.325951, 0.331799, 0.337654, 0.343515, 0.349382, 0.355255, 0.361135, 0.367022, 0.372915, 0.378815, 0.384721, 0.390634, 0.396554, 0.402481, 0.408415, 0.414356, 0.420304, 0.42626, 0.432222, 0.438192, 0.444169, 0.450153, 0.456145, 0.462144, 0.468151, 0.474166, 0.480188, 0.486218, 0.492256, 0.498302, 0.504356, 0.510418, 0.516488, 0.522566, 0.528653, 0.534747, 0.54085, 0.546962, 0.553082, 0.55921, 0.565347, 0.571493, 0.577648, 0.583811, 0.589983, 0.596164, 0.602355, 0.608554, 0.614762, 0.62098, 0.627207, 0.633444, 0.639689, 0.645945, 0.65221, 0.658484, 0.664768, 0.671062, 0.677366, 0.68368, 0.690004, 0.696338, 0.702682, 0.709036, 0.7154, 0.721775, 0.72816, 0.734556, 0.740963, 0.747379, 0.753807, 0.760246, 0.766695, 0.773155, 0.779627, 0.786109, 0.792603, 0.799107, 0.805624, 0.812151, 0.81869, 0.825241, 0.831803, 0.838377, 0.844962, 0.85156, 0.85817, 0.864791, 0.871425, 0.878071, 0.884729, 0.891399, 0.898082, 0.904778, 0.911486, 0.918206, 0.92494, 0.931686, 0.938446, 0.945218, 0.952003, 0.958802, 0.965614, 0.972439, 0.979278, 0.98613, 0.992996, 0.999875, 1.006769, 1.013676, 1.020597, 1.027533, 1.034482, 1.041446, 1.048424, 1.055417, 1.062424, 1.069446, 1.076482, 1.083534, 1.0906, 1.097681, 1.104778, 1.111889, 1.119016, 1.126159, 1.133316, 1.14049, 1.147679, 1.154884, 1.162105, 1.169342, 1.176595, 1.183864, 1.191149, 1.198451, 1.20577, 1.213105, 1.220457, 1.227826, 1.235211, 1.242614, 1.250034, 1.257471, 1.264926, 1.272398, 1.279888, 1.287395, 1.294921, 1.302464, 1.310026, 1.317605, 1.325203, 1.332819, 1.340454, 1.348108, 1.35578, 1.363472, 1.371182, 1.378912, 1.38666, 1.394429, 1.402216, 1.410024, 1.417851, 1.425698, 1.433565, 1.441453, 1.44936, 1.457288, 1.465237, 1.473206, 1.481196, 1.489208, 1.49724, 1.505293, 1.513368, 1.521465, 1.529583, 1.537723, 1.545885, 1.554068, 1.562275, 1.570503, 1.578754, 1.587028, 1.595325, 1.603644, 1.611987, 1.620353, 1.628743, 1.637156, 1.645593, 1.654053, 1.662538, 1.671047, 1.679581, 1.688139, 1.696721, 1.705329, 1.713961, 1.722619, 1.731303, 1.740011, 1.748746, 1.757506, 1.766293, 1.775106, 1.783945, 1.79281, 1.801703, 1.810623, 1.819569, 1.828543, 1.837545, 1.846574, 1.855631, 1.864717, 1.87383, 1.882972, 1.892143, 1.901343, 1.910572, 1.91983, 1.929117, 1.938434, 1.947781, 1.957158, 1.966566, 1.976004, 1.985473, 1.994972, 2.004503, 2.014065, 2.023659, 2.033285, 2.042943, 2.052633, 2.062355, 2.07211, 2.081899, 2.09172, 2.101575, 2.111464, 2.121386, 2.131343, 2.141334, 2.15136, 2.161421, 2.171517, 2.181648, 2.191815, 2.202018, 2.212257, 2.222533, 2.232845, 2.243195, 2.253582, 2.264006, 2.274468, 2.284968, 2.295507, 2.306084, 2.316701, 2.327356, 2.338051, 2.348786, 2.359562, 2.370377, 2.381234, 2.392131, 2.40307, 2.414051, 2.425073, 2.436138, 2.447246, 2.458397, 2.469591, 2.480828, 2.49211, 2.503436, 2.514807, 2.526222, 2.537684, 2.54919, 2.560743, 2.572343, 2.583989, 2.595682, 2.607423, 2.619212, 2.63105, 2.642936, 2.654871, 2.666855, 2.67889, 2.690975, 2.70311, 2.715297, 2.727535, 2.739825, 2.752168, 2.764563, 2.777012, 2.789514, 2.80207, 2.814681, 2.827347, 2.840069, 2.852846, 2.86568, 2.87857, 2.891518, 2.904524, 2.917588, 2.930712, 2.943894, 2.957136, 2.970439, 2.983802, 2.997227, 3.010714, 3.024263, 3.037875, 3.051551, 3.06529, 3.079095, 3.092965, 3.1069, 3.120902, 3.134971, 3.149107, 3.163312, 3.177585, 3.191928, 3.20634, 3.220824, 3.235378, 3.250005, 3.264704, 3.279477, 3.294323, 3.309244, 3.32424, 3.339312, 3.354461, 3.369687, 3.384992, 3.400375, 3.415838, 3.431381, 3.447005, 3.462711, 3.4785, 3.494372, 3.510328, 3.52637, 3.542497, 3.558711, 3.575012, 3.591402, 3.607881, 3.62445, 3.641111, 3.657863, 3.674708, 3.691646, 3.70868, 3.725809, 3.743034, 3.760357, 3.777779, 3.7953, 3.812921, 3.830645, 3.84847, 3.8664, 3.884434, 3.902574, 3.920821, 3.939176, 3.95764, 3.976215, 3.994901, 4.013699, 4.032612, 4.051639, 4.070783, 4.090045, 4.109425, 4.128925, 4.148547, 4.168292, 4.18816, 4.208154, 4.228275, 4.248524, 4.268903, 4.289413, 4.310056, 4.330832, 4.351745, 4.372794, 4.393982, 4.41531, 4.436781, 4.458395, 4.480154, 4.50206, 4.524114, 4.546319, 4.568676, 4.591187, 4.613854, 4.636678, 4.659662, 4.682807, 4.706116, 4.72959, 4.753231, 4.777041, 4.801024, 4.825179, 4.849511, 4.87402, 4.89871, 4.923582, 4.948639, 4.973883, 4.999316, 5.024942, 5.050761, 5.076778, 5.102993, 5.129411, 5.156034, 5.182864, 5.209903, 5.237156, 5.264625, 5.292312, 5.32022, 5.348354, 5.376714, 5.405306, 5.434131, 5.463193, 5.492496, 5.522042, 5.551836, 5.58188, 5.612178, 5.642734, 5.673552, 5.704634, 5.735986, 5.76761, 5.799512, 5.831694, 5.864161, 5.896918, 5.929968, 5.963316, 5.996967, 6.030925, 6.065194, 6.09978, 6.134687, 6.169921, 6.205486, 6.241387, 6.27763, 6.31422, 6.351163, 6.388465, 6.42613, 6.464166, 6.502578, 6.541371, 6.580553, 6.62013, 6.660109, 6.700495, 6.741297, 6.78252, 6.824173, 6.866262, 6.908795, 6.95178, 6.995225, 7.039137, 7.083525, 7.128398, 7.173764, 7.219632, 7.266011, 7.31291, 7.360339, 7.408308, 7.456827, 7.505905, 7.555554, 7.605785, 7.656608, 7.708035, 7.760077, 7.812747, 7.866057, 7.920019, 7.974647, 8.029953, 8.085952, 8.142657, 8.200083, 8.258245, 8.317158, 8.376837, 8.4373, 8.498562, 8.560641, 8.623554, 8.687319, 8.751955, 8.817481, 8.883916, 8.951282, 9.0196, 9.088889, 9.159174, 9.230477, 9.302822, 9.376233, 9.450735, 9.526355, 9.603118, 9.681054, 9.760191, 9.840558, 9.922186, 10.005107, 10.089353, 10.174959, 10.261958, 10.350389, 10.440287, 10.531693, 10.624646, 10.719188, 10.815362, 10.913214, 11.012789, 11.114137, 11.217307, 11.322352, 11.429325, 11.538283, 11.649285, 11.76239, 11.877664, 11.99517, 12.114979, 12.237161, 12.361791, 12.488946, 12.618708, 12.751161, 12.886394, 13.024498, 13.16557, 13.309711, 13.457026, 13.607625, 13.761625, 13.919145, 14.080314, 14.245263, 14.414134, 14.587072, 14.764233, 14.945778, 15.131877, 15.322712, 15.51847, 15.719353, 15.92557, 16.137345, 16.354912, 16.57852, 16.808433, 17.044929, 17.288305, 17.538873, 17.796967, 18.062943, 18.337176, 18.620068, 18.912049, 19.213574, 19.525133, 19.847249, 20.18048, 20.525429, 20.882738, 21.253102, 21.637266, 22.036036, 22.450278, 22.880933, 23.329017, 23.795634, 24.281981, 24.789364, 25.319207, 25.873062, 26.452634, 27.059789, 27.696581, 28.365274, 29.06837, 29.808638, 30.589157, 31.413354, 32.28506, 33.208568, 34.188705, 35.23092, 36.341388, 37.527131, 38.796172, 40.157721, 41.622399, 43.202525, 44.912465, 46.769077, 48.792279, 51.005773, 53.437996, 56.123356, 59.103894};
        if (sigma <= 0.0) {
            return 0.0;
        }
        double x = TRandom.Rndm();
        double u = 1000.0 * x;
        int i = (int)u;
        u -= (double)i;
        if (i >= 70 && i < 800) {
            ranlan = f[i - 1] + u * (f[i] - f[i - 1]);
        } else if (i >= 7 && i <= 980) {
            ranlan = f[i - 1] + u * (f[i] - f[i - 1] - 0.25 * (1.0 - u) * (f[i + 1] - f[i] - f[i - 1] + f[i - 2]));
        } else if (i < 7) {
            double v = MathBase.log(x);
            u = 1.0 / v;
            ranlan = (0.9985895 + (34.5213058 + 17.0854528 * u) * u) / (1.0 + (34.1760202 + 4.01244582 * u) * u) * (-MathBase.log(-0.91893853 - v) - 1.0);
        } else {
            u = 1.0 - x;
            double v = u * u;
            ranlan = x <= 0.999 ? (1.00060006 + 263.991156 * u + 4373.20068 * v) / ((1.0 + 257.368075 * u + 3414.48018 * v) * u) : (1.00001538 + 6075.14119 * u + 734266.409 * v) / ((1.0 + 6065.11919 * u + 694021.044 * v) * u);
        }
        return mpv + sigma * ranlan;
    }

    public static int Poisson(double mean) {
        if (mean <= 0.0) {
            return 0;
        }
        if (mean < 25.0) {
            double expmean = MathBase.exp(-mean);
            double pir = 1.0;
            int n = -1;
            do {
                ++n;
            } while ((pir *= TRandom.Rndm()) > expmean);
            return n;
        }
        if (mean < 1.0E9) {
            double em;
            double pi = java.lang.Math.PI;
            double sq = MathBase.sqrt(2.0 * mean);
            double alxm = MathBase.log(mean);
            double g = mean * alxm - Math.lnGamma(mean + 1.0);
            while (true) {
                double y;
                if ((em = sq * (y = MathBase.tan(java.lang.Math.PI * TRandom.Rndm())) + mean) < 0.0) {
                    continue;
                }
                em = MathBase.floor(em);
                double t = 0.9 * (1.0 + y * y) * MathBase.exp(em * alxm - Math.lnGamma(em + 1.0) - g);
                if (!(TRandom.Rndm() > t)) break;
            }
            return (int)em;
        }
        int n = (int)(TRandom.Gaus(0.0, 1.0) * MathBase.sqrt(mean) + mean + 0.5);
        return n;
    }

    public static double PoissonD(double mean) {
        if (mean <= 0.0) {
            return 0.0;
        }
        if (mean < 25.0) {
            double expmean = MathBase.exp(-mean);
            double pir = 1.0;
            int n = -1;
            do {
                ++n;
            } while ((pir *= TRandom.Rndm()) > expmean);
            return n;
        }
        if (mean < 1.0E9) {
            double em;
            double pi = java.lang.Math.PI;
            double sq = MathBase.sqrt(2.0 * mean);
            double alxm = MathBase.log(mean);
            double g = mean * alxm - Math.lnGamma(mean + 1.0);
            while (true) {
                double y;
                if ((em = sq * (y = MathBase.tan(java.lang.Math.PI * TRandom.Rndm())) + mean) < 0.0) {
                    continue;
                }
                em = MathBase.floor(em);
                double t = 0.9 * (1.0 + y * y) * MathBase.exp(em * alxm - Math.lnGamma(em + 1.0) - g);
                if (!(TRandom.Rndm() > t)) break;
            }
            return em;
        }
        return TRandom.Gaus(0.0, 1.0) * MathBase.sqrt(mean) + mean + 0.5;
    }

    public static void Rannor(double[] val) {
        double y = TRandom.Rndm();
        double z = TRandom.Rndm();
        double x = z * (java.lang.Math.PI * 2);
        double r = MathBase.sqrt(-2.0 * MathBase.log(y));
        val[0] = r * MathBase.sin(x);
        val[1] = r * MathBase.cos(x);
    }

    public static void Rannor(float[] val) {
        double y = TRandom.Rndm();
        double z = TRandom.Rndm();
        double x = z * (java.lang.Math.PI * 2);
        double r = MathBase.sqrt(-2.0 * MathBase.log(y));
        val[0] = (float)(r * MathBase.sin(x));
        val[0] = (float)(r * MathBase.cos(x));
    }

    public static double Rndm() {
        double kCONS = 4.6566128730774E-10;
        if ((fSeed = 1103515245L * fSeed + 12345L & Integer.MAX_VALUE) > 0L) {
            return 4.6566128730774E-10 * (double)fSeed;
        }
        return TRandom.Rndm();
    }

    public void RndmArray(int n, float[] array) {
        double kCONS = 4.6566128730774E-10;
        int i = 0;
        while (i < n) {
            if ((fSeed = 1103515245L * fSeed + 12345L & Integer.MAX_VALUE) <= 0L) continue;
            array[i] = (float)(4.6566128730774E-10 * (double)fSeed);
            ++i;
        }
    }

    public void SetSeed(long seed) {
        fSeed = seed == 0L ? System.nanoTime() : seed;
    }

    public static void Sphere(double[] val, double r) {
        double a = 0.0;
        double b = 0.0;
        double r2 = 1.0;
        while (r2 > 0.25) {
            a = TRandom.Rndm() - 0.5;
            b = TRandom.Rndm() - 0.5;
            r2 = a * a + b * b;
        }
        val[2] = r * (-1.0 + 8.0 * r2);
        double scale = 8.0 * r * MathBase.sqrt(0.25 - r2);
        val[0] = a * scale;
        val[1] = b * scale;
    }

    public String toString() {
        return "TRandom(" + fSeed + ")";
    }

    public static double Uniform(double x1) {
        double ans = TRandom.Rndm();
        return x1 * ans;
    }

    public static double Uniform(double x1, double x2) {
        double ans = TRandom.Rndm();
        return x1 + (x2 - x1) * ans;
    }
}

