/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.functions.Function;
import de.gsi.math.utils.UpdateListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFunction
implements Function {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFunction.class);
    private static final List<Function> fallFunctions = new ArrayList<Function>();
    private String funcName = "none";
    private int fnbOfParameter = -1;
    protected double[] fparameter;
    protected double[] fparameterMin;
    protected double[] fparameterMax;
    protected double[] fparameterCopy;
    protected boolean[] fparameterFixed;
    protected String[] fparameterName;
    protected boolean fitterMode;
    private final List<UpdateListener> flistener = new ArrayList<UpdateListener>();
    private final long fcreationTime = System.currentTimeMillis();

    public AbstractFunction(String name, double ... parameter) {
        this(name, parameter, new String[parameter.length]);
    }

    public AbstractFunction(String name, double[] parameters, String ... parameterNames) {
        if (name == null) {
            throw new InvalidParameterException("AbstractFunction(String, double[], double[]) - function name is null");
        }
        if (parameters == null) {
            throw new InvalidParameterException("AbstractFunction(" + name + ", double[], String[]) - parameter array is null");
        }
        if (parameterNames.length != parameters.length) {
            throw new InvalidParameterException("AbstractFunction(" + name + ", double[], String[]) - parameter vs. name array dimension mismatch ( " + parameters.length + " vs. " + (this.fparameterName == null ? 0 : this.fparameterName.length) + ")");
        }
        this.fnbOfParameter = parameters.length;
        this.funcName = name;
        this.reinitialise();
        this.fparameter = Arrays.copyOf(parameters, parameters.length);
        this.fparameterName = Arrays.copyOf(parameterNames, parameterNames.length);
        this.addFunction(this);
    }

    public AbstractFunction(String name, int nparm) {
        this(name, new double[nparm], new String[nparm]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(Function object) {
        List<Function> list = fallFunctions;
        synchronized (list) {
            if (!fallFunctions.contains(object)) {
                fallFunctions.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UpdateListener object) {
        List<UpdateListener> list = this.flistener;
        synchronized (list) {
            if (!this.flistener.contains(object)) {
                this.flistener.add(object);
            }
        }
    }

    @Override
    public void clearParameterValues() {
        for (int i = 0; i < this.fparameter.length; ++i) {
            if (this.isParameterFixed(i)) continue;
            this.fparameter[i] = 0.0;
        }
    }

    @Override
    public void fixParameter(int id, boolean state) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            this.fparameterFixed[id] = state;
            return;
        }
        throw new InvalidParameterException(this.exceptionForIdString("fixParameter", id, new String[0]));
    }

    @Override
    public int getFreeParameterCount() {
        int nDim = 0;
        for (int i = 0; i < this.fnbOfParameter; ++i) {
            if (this.isParameterFixed(i)) continue;
            ++nDim;
        }
        return nDim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function[] getFunctions() {
        List<Function> list = fallFunctions;
        synchronized (list) {
            if (!fallFunctions.isEmpty()) {
                return fallFunctions.toArray(new Function[0]);
            }
        }
        return new Function[0];
    }

    @Override
    public String getID() {
        return this.getName() + this.fcreationTime;
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    @Override
    public int getParameterCount() {
        return this.fnbOfParameter;
    }

    @Override
    public String getParameterName(int id) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            return this.fparameterName[id];
        }
        throw new InvalidParameterException(this.exceptionForIdString("getParameterName", id, new String[0]));
    }

    @Override
    public double getParameterRangeMaximum(int id) {
        if (id < 0 || id >= this.fnbOfParameter) {
            throw new InvalidParameterException(this.exceptionForIdString("getParameterRangeMaximum", id, new String[0]));
        }
        return this.fparameterMax[id];
    }

    private String exceptionForIdString(String functionName, int id, String ... parameter) {
        return functionName + "(" + id + (String)(parameter.length > 0 ? ", " + parameter[0] : "") + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}";
    }

    @Override
    public double getParameterRangeMinimum(int id) {
        if (id < 0 || id >= this.fnbOfParameter) {
            throw new InvalidParameterException(this.exceptionForIdString("getParameterRangeMinimum", id, new String[0]));
        }
        return this.fparameterMin[id];
    }

    @Override
    public double getParameterValue(int id) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            return this.fparameter[id];
        }
        throw new InvalidParameterException(this.exceptionForIdString("getParameterValue", id, new String[0]));
    }

    public double[] getParameterValues() {
        return this.fparameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeListener() {
        List<UpdateListener> list = this.flistener;
        synchronized (list) {
            for (UpdateListener updateListener : this.flistener) {
                updateListener.Update(this);
            }
        }
    }

    @Override
    public boolean isFitterMode() {
        return this.fitterMode;
    }

    @Override
    public boolean isParameterFixed(int id) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            return this.fparameterFixed[id];
        }
        throw new InvalidParameterException(this.exceptionForIdString("isParameterFixed", id, new String[0]));
    }

    public void printParameters() {
        this.printParameters(false);
    }

    public void printParameters(boolean fullDebug) {
        LOGGER.atInfo().log(String.format("AbstractFunction - function name: %s", this.getName()));
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (fullDebug) {
                LOGGER.atInfo().log(String.format("Parameter %2d: %-20s = %f \t [%f, %f]", i, this.getParameterName(i), this.getParameterValue(i), this.getParameterRangeMinimum(i), this.getParameterRangeMaximum(i)));
                continue;
            }
            LOGGER.atInfo().log(String.format("Parameter %2d: %-20s = %f", i, this.getParameterName(i), this.getParameterValue(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(Function object) {
        List<Function> list = fallFunctions;
        synchronized (list) {
            if (fallFunctions.contains(object)) {
                fallFunctions.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateListener object) {
        List<UpdateListener> list = this.flistener;
        synchronized (list) {
            if (this.flistener.contains(object)) {
                this.flistener.remove(object);
            }
        }
    }

    @Override
    public void setFitterMode(boolean state) {
        if (this.fitterMode == state) {
            throw new InvalidParameterException("setFitterMode(" + state + ") - funciton is already in this mode");
        }
        this.fitterMode = state;
        if (this.fitterMode) {
            this.fparameterCopy = Arrays.copyOf(this.fparameter, this.fparameter.length);
        } else {
            this.fparameter = Arrays.copyOf(this.fparameterCopy, this.fparameterCopy.length);
        }
    }

    @Override
    public void setParameterCount(int count) {
        if (this.fnbOfParameter == count || count < 0) {
            return;
        }
        this.fnbOfParameter = count;
        this.reinitialise();
    }

    @Override
    public void setParameterName(int id, String paramName) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            this.fparameterName[id] = paramName;
            return;
        }
        throw new InvalidParameterException(this.exceptionForIdString("setParameterName", id, paramName));
    }

    @Override
    public void setParameterRange(int id, double minRange, double maxRange) {
        if (id < 0 || id >= this.fnbOfParameter) {
            throw new InvalidParameterException("setParameterRangeMaximum(" + id + "," + minRange + "," + maxRange + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        this.fparameterMin[id] = minRange;
        this.fparameterMax[id] = maxRange;
    }

    @Override
    public void setParameterValue(int id, double value) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            this.fparameter[id] = value;
            return;
        }
        throw new InvalidParameterException(this.exceptionForIdString("setParameterValue", id, Double.toString(value)));
    }

    @Override
    public void setParameterValues(double[] value) {
        if (value.length <= this.fnbOfParameter) {
            System.arraycopy(value, 0, this.fparameter, 0, value.length);
            return;
        }
        throw new InvalidParameterException("setParameterValue(" + value.length + "," + Arrays.toString(value) + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
    }

    private void reinitialise() {
        if (this.fparameter != null && this.fnbOfParameter == this.fparameter.length) {
            return;
        }
        if (this.fparameter == null) {
            this.fparameter = new double[this.fnbOfParameter];
            this.fparameterMin = new double[this.fnbOfParameter];
            this.fparameterMax = new double[this.fnbOfParameter];
            this.fparameterCopy = new double[this.fnbOfParameter];
            this.fparameterName = new String[this.fnbOfParameter];
            this.fparameterFixed = new boolean[this.fnbOfParameter];
            for (int i = 0; i < this.fnbOfParameter; ++i) {
                this.fparameterName[i] = "arg" + i;
            }
            return;
        }
        this.fparameter = Arrays.copyOf(this.fparameter, this.fnbOfParameter);
        this.fparameterMin = Arrays.copyOf(this.fparameterMin, this.fnbOfParameter);
        this.fparameterMax = Arrays.copyOf(this.fparameterMax, this.fnbOfParameter);
        this.fparameterCopy = Arrays.copyOf(this.fparameterCopy, this.fnbOfParameter);
        this.fparameterFixed = Arrays.copyOf(this.fparameterFixed, this.fnbOfParameter);
        String[] oldParmeterNames = this.fparameterName;
        this.fparameterName = new String[this.fnbOfParameter];
        for (int i = 0; i < this.fnbOfParameter; ++i) {
            this.fparameterName[i] = i < oldParmeterNames.length ? oldParmeterNames[i] : "arg" + i;
        }
    }
}

