/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.wavelet;

import de.gsi.math.spectra.wavelet.WaveletCoefficients;

public class WaveletTransform
extends WaveletCoefficients {
    private final WaveletCoefficients.Wavelet fwavelet = WaveletCoefficients.Wavelet.Daubechies2;
    protected final double sqrt_3 = Math.sqrt(3.0);
    protected final double denom = 4.0 * Math.sqrt(2.0);
    protected final double h0 = (1.0 + this.sqrt_3) / this.denom;
    protected final double h1 = (3.0 + this.sqrt_3) / this.denom;
    protected final double h2 = (3.0 - this.sqrt_3) / this.denom;
    protected final double h3;
    protected final double g0 = this.h3 = (1.0 - this.sqrt_3) / this.denom;
    protected final double g1 = -this.h2;
    protected final double g2 = this.h1;
    protected final double g3 = -this.h0;
    protected final double Ih0 = this.h2;
    protected final double Ih1 = this.g2;
    protected final double Ih2 = this.h0;
    protected final double Ih3 = this.g0;
    protected final double Ig0 = this.h3;
    protected final double Ig1 = this.g3;
    protected final double Ig2 = this.h1;
    protected final double Ig3 = this.g1;

    int allocating_downsampling_convolution(double[] input, int N, double[] filter, int F, double[] output, int step, WaveletCoefficients.MODE mode) {
        int i;
        int j;
        int stop;
        double[] buffer;
        int N_extended_right_start;
        int N_extended_len;
        int index = 0;
        int F_minus_1 = F - 1;
        int start = F_minus_1 + step - 1;
        if (mode != WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            N_extended_len = N + 2 * F_minus_1;
            N_extended_right_start = N + F_minus_1;
            buffer = new double[N_extended_len];
            System.arraycopy(input, F_minus_1, buffer, 0, N);
            stop = N_extended_len;
        } else {
            N_extended_len = N + F - 1;
            N_extended_right_start = N - 1 + F / 2;
            buffer = new double[N_extended_len];
            System.arraycopy(input, F / 2 - 1, buffer, 0, N);
            --start;
            stop = step == 1 ? N_extended_len - 1 : N_extended_len;
        }
        switch (mode) {
            case MODE_PERIODIZATION: {
                if (N % 2 > 0) {
                    buffer[N_extended_right_start] = input[N - 1];
                    for (j = 1; j < F / 2; ++j) {
                        buffer[N_extended_right_start + j] = buffer[F / 2 - 2 + j];
                    }
                    for (j = 0; j < F / 2 - 1; ++j) {
                        buffer[F / 2 - 2 - j] = buffer[N_extended_right_start - j];
                    }
                } else {
                    for (j = 0; j < F / 2; ++j) {
                        buffer[N_extended_right_start + j] = input[j % N];
                    }
                    for (j = 0; j < F / 2 - 1; ++j) {
                        buffer[F / 2 - 2 - j] = buffer[N_extended_right_start - 1 - j];
                    }
                }
                break;
            }
            case MODE_SYMMETRIC: {
                for (j = 0; j < N; ++j) {
                    buffer[F_minus_1 - 1 - j] = input[j % N];
                    buffer[N_extended_right_start + j] = input[N - 1 - j % N];
                }
                i = j;
                while (j < F_minus_1) {
                    buffer[F_minus_1 - 1 - j] = buffer[N_extended_right_start - 1 + i - j];
                    buffer[N_extended_right_start + j] = buffer[F_minus_1 + j - i];
                    ++j;
                }
                break;
            }
            case MODE_ASYMMETRIC: {
                for (j = 0; j < N; ++j) {
                    buffer[F_minus_1 - 1 - j] = input[0] - input[j % N];
                    buffer[N_extended_right_start + j] = input[N - 1] - input[N - 1 - j % N];
                }
                i = j;
                while (j < F_minus_1) {
                    buffer[F_minus_1 - 1 - j] = buffer[N_extended_right_start - 1 + i - j];
                    buffer[N_extended_right_start + j] = buffer[F_minus_1 + j - i];
                    ++j;
                }
                break;
            }
            case MODE_SMOOTH: {
                if (N > 1) {
                    double tmp = input[0] - input[1];
                    for (j = 0; j < F_minus_1; ++j) {
                        buffer[j] = input[0] + tmp * (double)(F_minus_1 - j);
                    }
                    tmp = input[N - 1] - input[N - 2];
                    for (j = 0; j < F_minus_1; ++j) {
                        buffer[N_extended_right_start + j] = input[N - 1] + tmp * (double)j;
                    }
                    break;
                }
            }
            case MODE_CONSTANT_EDGE: {
                for (j = 0; j < F_minus_1; ++j) {
                    buffer[j] = input[0];
                    buffer[N_extended_right_start + j] = input[N - 1];
                }
                break;
            }
            case MODE_PERIODIC: {
                for (j = 0; j < F_minus_1; ++j) {
                    buffer[N_extended_right_start + j] = input[j % N];
                }
                for (j = 0; j < F_minus_1; ++j) {
                    buffer[F_minus_1 - 1 - j] = buffer[N_extended_right_start - 1 - j];
                }
                break;
            }
        }
        for (i = start; i < stop; i += step) {
            double sum = 0.0;
            for (j = 0; j < F; ++j) {
                sum += buffer[i - j] * filter[j];
            }
            output[index++] = sum;
        }
        return 0;
    }

    int d_dec_a(double[] input, int input_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len, WaveletCoefficients.MODE mode) {
        if (output_len != this.dwt_buffer_length(input_len, wavelet.getDecompHP().length, mode)) {
            return -1;
        }
        return this.downsampling_convolution(input, input_len, wavelet.getDecompLP(), wavelet.getDecompLP().length, output, 2, mode);
    }

    int d_dec_d(double[] input, int input_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len, WaveletCoefficients.MODE mode) {
        if (output_len != this.dwt_buffer_length(input_len, wavelet.getDecompHP().length, mode)) {
            return -1;
        }
        return this.downsampling_convolution(input, input_len, wavelet.getDecompHP(), wavelet.getDecompHP().length, output, 2, mode);
    }

    int d_idwt(double[] coeffs_a, int coeffs_a_len, double[] coeffs_d, int coeffs_d_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len, WaveletCoefficients.MODE mode, int fix_size_diff) {
        int input_len;
        if (coeffs_a != null && coeffs_d != null) {
            if (fix_size_diff > 0) {
                if ((coeffs_a_len > coeffs_d_len ? coeffs_a_len - coeffs_d_len : coeffs_d_len - coeffs_a_len) > 1) {
                    return -1;
                }
                input_len = coeffs_a_len > coeffs_d_len ? coeffs_d_len : coeffs_a_len;
            } else {
                if (coeffs_a_len != coeffs_d_len) {
                    return -1;
                }
                input_len = coeffs_a_len;
            }
        } else if (coeffs_a != null) {
            input_len = coeffs_a_len;
        } else if (coeffs_d != null) {
            input_len = coeffs_d_len;
        } else {
            return -1;
        }
        if (output_len != this.idwt_buffer_length(input_len, wavelet.getReconLP().length, mode)) {
            return -1;
        }
        if (coeffs_a != null && this.upsampling_convolution_valid_sf(coeffs_a, input_len, wavelet.getReconLP(), wavelet.getReconLP().length, output, output_len, mode) < 0) {
            return -1;
        }
        if (coeffs_d != null && this.upsampling_convolution_valid_sf(coeffs_d, input_len, wavelet.getReconHP(), wavelet.getReconHP().length, output, output_len, mode) < 0) {
            return -1;
        }
        return 0;
    }

    int d_rec_a(double[] coeffs_a, int coeffs_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len) {
        if (output_len != this.reconstruction_buffer_length(coeffs_len, wavelet.getReconLP().length)) {
            return -1;
        }
        return this.upsampling_convolution_full(coeffs_a, coeffs_len, wavelet.getReconLP(), wavelet.getReconLP().length, output, output_len);
    }

    int d_rec_d(double[] coeffs_d, int coeffs_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len) {
        if (output_len != this.reconstruction_buffer_length(coeffs_len, wavelet.getReconHP().length)) {
            return -1;
        }
        return this.upsampling_convolution_full(coeffs_d, coeffs_len, wavelet.getReconHP(), wavelet.getReconHP().length, output, output_len);
    }

    int d_swt_(double[] input, int input_len, double[] filter, int filter_len, double[] output, int output_len, int level) {
        if (level < 1) {
            return -1;
        }
        if (level > this.swt_max_level(input_len)) {
            return -2;
        }
        if (output_len != this.swt_buffer_length(input_len)) {
            return -1;
        }
        if (level > 1) {
            int i;
            int e_filter_len = filter_len << level - 1;
            if (e_filter_len <= 0) {
                return -1;
            }
            double[] e_filter = new double[e_filter_len];
            for (i = 0; i < filter_len; ++i) {
                e_filter[i << level - 1] = filter[i];
            }
            i = this.downsampling_convolution(input, input_len, e_filter, e_filter_len, output, 1, WaveletCoefficients.MODE.MODE_PERIODIZATION);
            return i;
        }
        return this.downsampling_convolution(input, input_len, filter, filter_len, output, 1, WaveletCoefficients.MODE.MODE_PERIODIZATION);
    }

    int d_swt_a(double[] input, int input_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len, int level) {
        return this.d_swt_(input, input_len, wavelet.getDecompLP(), wavelet.getDecompLP().length, output, output_len, level);
    }

    int d_swt_d(double[] input, int input_len, WaveletCoefficients.Wavelet wavelet, double[] output, int output_len, int level) {
        return this.d_swt_(input, input_len, wavelet.getDecompHP(), wavelet.getDecompHP().length, output, output_len, level);
    }

    public void daubTrans(double[] s) {
        int N;
        for (int n = N = s.length; n >= this.fwavelet.getLength(); n >>= 1) {
            this.transform(s, n);
        }
    }

    int downsampling_convolution(double[] input, int N, double[] filter, int F, double[] output, int step, WaveletCoefficients.MODE mode) {
        int start;
        int index = 0;
        int i = start = step - 1;
        if (F <= N) {
            double tmp;
            int k;
            int j;
            double sum;
            switch (mode) {
                case MODE_SYMMETRIC: {
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j <= i; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        k = i + 1;
                        for (j = i + 1; j < F; ++j) {
                            sum += filter[j] * input[j - k];
                        }
                        output[index++] = sum;
                    }
                    break;
                }
                case MODE_ASYMMETRIC: {
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j <= i; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        k = i + 1;
                        for (j = i + 1; j < F; ++j) {
                            sum += filter[j] * (input[0] - input[j - k]);
                        }
                        output[index++] = sum;
                    }
                    break;
                }
                case MODE_CONSTANT_EDGE: {
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j <= i; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        for (j = i + 1; j < F; ++j) {
                            sum += filter[j] * input[0];
                        }
                        output[index++] = sum;
                    }
                    break;
                }
                case MODE_SMOOTH: {
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j <= i; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        tmp = input[0] - input[1];
                        for (j = i + 1; j < F; ++j) {
                            sum += filter[j] * (input[0] + tmp * (double)(j - i));
                        }
                        output[index++] = sum;
                    }
                    break;
                }
                case MODE_PERIODIC: {
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j <= i; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        k = N + i;
                        for (j = i + 1; j < F; ++j) {
                            sum += filter[j] * input[k - j];
                        }
                        output[index++] = sum;
                    }
                    break;
                }
                case MODE_PERIODIZATION: {
                    start = F / 2;
                    int F_2 = F / 2;
                    int corr = 0;
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j < i + 1 - corr; ++j) {
                            sum += filter[j] * input[i - j - corr];
                        }
                        if (N % 2 > 0) {
                            if (F - j > 0) {
                                sum += filter[j] * input[N - 1];
                                if (F - j > 0) {
                                    for (k = 2 - corr; k <= F - j; ++k) {
                                        sum += filter[j - 1 + k] * input[N - k + 1];
                                    }
                                }
                            }
                        } else {
                            for (k = 1; k <= F - j; ++k) {
                                sum += filter[j - 1 + k] * input[N - k];
                            }
                        }
                        output[index++] = sum;
                    }
                    break;
                }
                default: {
                    for (i = start; i < F; i += step) {
                        sum = 0.0;
                        for (j = 0; j <= i; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        output[index++] = sum;
                    }
                }
            }
            while (i < N) {
                sum = 0.0;
                for (j = 0; j < F; ++j) {
                    sum += input[i - j] * filter[j];
                }
                output[index++] = sum;
                i += step;
            }
            switch (mode) {
                case MODE_SYMMETRIC: {
                    while (i < N + F - 1) {
                        sum = 0.0;
                        for (j = k = i - N + 1; j < F; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        for (j = 0; j < k; ++j) {
                            sum += filter[j] * input[N - k + j];
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break;
                }
                case MODE_ASYMMETRIC: {
                    while (i < N + F - 1) {
                        sum = 0.0;
                        for (j = k = i - N + 1; j < F; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        for (j = 0; j < k; ++j) {
                            sum += filter[j] * (input[N - 1] - input[N - k - 1 + j]);
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break;
                }
                case MODE_CONSTANT_EDGE: {
                    while (i < N + F - 1) {
                        sum = 0.0;
                        for (j = k = i - N + 1; j < F; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        for (j = 0; j < k; ++j) {
                            sum += filter[j] * input[N - 1];
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break;
                }
                case MODE_SMOOTH: {
                    while (i < N + F - 1) {
                        sum = 0.0;
                        for (j = k = i - N + 1; j < F; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        tmp = input[N - 1] - input[N - 2];
                        for (j = 0; j < k; ++j) {
                            sum += filter[j] * (input[N - 1] + tmp * (double)(k - j));
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break;
                }
                case MODE_PERIODIC: {
                    while (i < N + F - 1) {
                        sum = 0.0;
                        for (j = k = i - N + 1; j < F; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        for (j = 0; j < k; ++j) {
                            sum += filter[j] * input[k - 1 - j];
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break;
                }
                case MODE_PERIODIZATION: {
                    while (i < N - step + F / 2 + 1 + N % 2) {
                        sum = 0.0;
                        for (j = k = i - N + 1; j < F; ++j) {
                            sum += filter[j] * input[i - j];
                        }
                        if (N % 2 == 0) {
                            for (j = 0; j < k; ++j) {
                                sum += filter[j] * input[k - 1 - j];
                            }
                        } else {
                            for (j = 0; j < k - 1; ++j) {
                                sum += filter[j] * input[k - 2 - j];
                            }
                            sum += filter[k - 1] * input[N - 1];
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break;
                }
                default: {
                    while (i < N + F - 1) {
                        sum = 0.0;
                        for (j = i - (N - 1); j < F; ++j) {
                            sum += input[i - j] * filter[j];
                        }
                        output[index++] = sum;
                        i += step;
                    }
                    break block8;
                }
            }
            return 0;
        }
        return this.allocating_downsampling_convolution(input, N, filter, F, output, step, mode);
    }

    int dwt_buffer_length(int input_len, int filter_len, WaveletCoefficients.MODE mode) {
        if (input_len < 1 || filter_len < 1) {
            return 0;
        }
        if (mode == WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            return (int)Math.ceil((double)input_len / 2.0);
        }
        return (int)Math.floor((double)(input_len + filter_len - 1) / 2.0);
    }

    int dwt_max_level(int input_len, int filter_len) {
        if (input_len < 1 || filter_len < 2) {
            return 0;
        }
        return (int)Math.floor(Math.log((double)input_len / (double)(filter_len - 1)) / Math.log(2.0));
    }

    int idwt_buffer_length(int coeffs_len, int filter_len, WaveletCoefficients.MODE mode) {
        if (coeffs_len < 0 || filter_len < 0) {
            return 0;
        }
        if (mode == WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            return 2 * coeffs_len;
        }
        return 2 * coeffs_len - filter_len + 2;
    }

    public void invDaubTrans(double[] coef) {
        int N = coef.length;
        for (int n = this.fwavelet.getLength(); n <= N; n <<= 1) {
            this.invTransform(coef, n);
        }
    }

    public double[] invoke(double[] input) {
        int nfilter = this.fwavelet.getLength();
        double[] h = this.fwavelet.getDecompHP();
        double[] g = this.fwavelet.getDecompLP();
        double[] output = new double[input.length];
        int length = input.length >> 1;
        while (true) {
            for (int i = 0; i < length - nfilter; ++i) {
                double sum = 0.0;
                double diff = 0.0;
                int i2 = i * 2;
                for (int k = 0; k < nfilter; ++k) {
                    sum += input[i2 + k] * g[k];
                    diff += input[i2 + k] * h[k];
                }
                output[i] = sum;
                output[length + i] = diff;
            }
            if (length == 1) {
                return output;
            }
            System.arraycopy(output, 0, input, 0, length << 1);
            length >>= 1;
        }
    }

    protected void invTransform(double[] a, int n) {
        if (n >= 4) {
            int i;
            int half = n >> 1;
            int halfPls1 = half + 1;
            double[] tmp = new double[n];
            tmp[0] = a[half - 1] * this.Ih0 + a[n - 1] * this.Ih1 + a[0] * this.Ih2 + a[half] * this.Ih3;
            tmp[1] = a[half - 1] * this.Ig0 + a[n - 1] * this.Ig1 + a[0] * this.Ig2 + a[half] * this.Ig3;
            int j = 2;
            for (i = 0; i < half - 1; ++i) {
                tmp[j++] = a[i] * this.Ih0 + a[i + half] * this.Ih1 + a[i + 1] * this.Ih2 + a[i + halfPls1] * this.Ih3;
                tmp[j++] = a[i] * this.Ig0 + a[i + half] * this.Ig1 + a[i + 1] * this.Ig2 + a[i + halfPls1] * this.Ig3;
            }
            for (i = 0; i < n; ++i) {
                a[i] = tmp[i];
            }
        }
    }

    int reconstruction_buffer_length(int coeffs_len, int filter_len) {
        if (coeffs_len < 1 || filter_len < 1) {
            return 0;
        }
        return 2 * coeffs_len + filter_len - 2;
    }

    int swt_buffer_length(int input_len) {
        if (input_len < 0) {
            return 0;
        }
        return input_len;
    }

    int swt_max_level(int input_len) {
        int i = (int)Math.floor(Math.log(input_len) / Math.log(2.0));
        for (int j = 0; j <= i; ++j) {
            if ((input_len & 1) == 1) {
                return j;
            }
            input_len >>= 1;
        }
        return i;
    }

    protected void transform(double[] a, int n) {
        int nfilter = this.fwavelet.getLength();
        double[] h = this.fwavelet.getDecompHP();
        double[] g = this.fwavelet.getDecompLP();
        System.err.printf("dim %d %d\n", h.length, g.length);
        System.err.printf("A h0 = %f h1 = %f h2 = %f h3= %f\n", this.h0, this.h1, this.h2, this.h3);
        System.err.printf("B h0 = %f h1 = %f h2 = %f h3= %f\n", h[0], h[1], h[2], h[3]);
        if (n >= nfilter) {
            int half = n >> 1;
            double[] tmp = new double[n];
            int i = 0;
            for (int j = 0; j < n - nfilter - 1; j += 2) {
                tmp[i] = 0.0;
                tmp[i + half] = 0.0;
                for (int k = 0; k < nfilter; ++k) {
                    int n2 = i;
                    tmp[n2] = tmp[n2] + a[j + k] * h[k];
                    tmp[i + half] = a[j + k] * g[k];
                }
                ++i;
            }
            tmp[i] = a[n - 2] * h[0] + a[n - 1] * h[1] + a[0] * h[2] + a[1] * h[3];
            tmp[i + half] = a[n - 2] * g[0] + a[n - 1] * g[1] + a[0] * g[2] + a[1] * g[3];
            for (i = 0; i < n; ++i) {
                a[i] = tmp[i];
            }
        }
    }

    int upsampled_filter_convolution(double[] input, int N, double[] filter, int F, double[] output, int step, WaveletCoefficients.MODE mode) {
        return -1;
    }

    int upsampling_convolution_full(double[] input, int N, double[] filter, int F, double[] output, int O) {
        if (F < 2) {
            return -1;
        }
        int offset = N - 1 << 1;
        for (int i = N - 1; i >= 0; --i) {
            for (int j = 0; j < F; ++j) {
                int n = j + offset;
                output[n] = output[n] + input[i] * filter[j];
            }
            offset -= 2;
        }
        return 0;
    }

    int upsampling_convolution_valid_sf(double[] input, int N, double[] filter, int F, double[] output, int O, WaveletCoefficients.MODE mode) {
        double[] periodization_buf = null;
        int N_p = 0;
        int F_2 = F / 2;
        if (F % 2 > 0) {
            return -3;
        }
        if (N < F_2) {
            int k;
            int i;
            if (mode != WaveletCoefficients.MODE.MODE_PERIODIZATION) {
                return -2;
            }
            N_p = F_2 - 1 + N;
            periodization_buf = new double[N_p];
            for (i = k = (F_2 - 1) / 2; i < k + N; ++i) {
                periodization_buf[i] = input[(i - k) % N];
            }
            int buf_rear = i - 1;
            int j = i - k;
            while (i < N_p) {
                periodization_buf[i] = periodization_buf[i - j];
                ++i;
            }
            j = 0;
            for (i = k - 1; i >= 0; --i) {
                periodization_buf[i] = periodization_buf[buf_rear + j];
                --j;
            }
            if (F_2 % 2 > 0) {
                this.upsampling_convolution_valid_sf(periodization_buf, N_p, filter, F, output, O, WaveletCoefficients.MODE.MODE_ZEROPAD);
            } else {
                double[] ptr_out = new double[this.idwt_buffer_length(N, F, WaveletCoefficients.MODE.MODE_PERIODIZATION)];
                this.upsampling_convolution_valid_sf(periodization_buf, N_p, filter, F, ptr_out, O, WaveletCoefficients.MODE.MODE_ZEROPAD);
                for (i = 2 * N - 1; i > 0; --i) {
                    int n = i;
                    output[n] = output[n] + ptr_out[i - 1];
                }
                output[0] = output[0] + ptr_out[2 * N - 1];
            }
            return 0;
        }
        double[] filter_even = new double[F_2];
        double[] filter_odd = new double[F_2];
        for (int i = 0; i < F_2; ++i) {
            filter_even[i] = filter[i << 1];
            filter_odd[i] = filter[(i << 1) + 1];
        }
        if (mode == WaveletCoefficients.MODE.MODE_PERIODIZATION) {
            int k = F_2 - 1;
            N_p = F_2 - 1 + (int)Math.ceil((double)k / 2.0);
        }
        return 0;
    }
}

