/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES3;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLBuffers;
import com.jogamp.opengl.util.GLPixelBuffer;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;

public class GLReadBufferUtil {
    protected final GLPixelBuffer.GLPixelBufferProvider pixelBufferProvider;
    protected final Texture readTexture;
    protected final GLPixelStorageModes psm;
    protected final boolean alphaRequested;
    protected boolean hasAlpha;
    protected GLPixelBuffer readPixelBuffer = null;
    protected TextureData readTextureData = null;

    public GLReadBufferUtil(boolean bl, boolean bl2) {
        this(GLPixelBuffer.defaultProviderNoRowStride, bl, bl2);
    }

    public GLReadBufferUtil(GLPixelBuffer.GLPixelBufferProvider gLPixelBufferProvider, boolean bl, boolean bl2) {
        this.pixelBufferProvider = gLPixelBufferProvider;
        this.readTexture = bl2 ? new Texture(3553) : null;
        this.psm = new GLPixelStorageModes();
        this.alphaRequested = bl;
        this.hasAlpha = bl;
    }

    public GLPixelBuffer.GLPixelBufferProvider getPixelBufferProvider() {
        return this.pixelBufferProvider;
    }

    public boolean isValid() {
        return null != this.readTextureData && null != this.readPixelBuffer && this.readPixelBuffer.isValid();
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public GLPixelStorageModes getGLPixelStorageModes() {
        return this.psm;
    }

    public GLPixelBuffer getPixelBuffer() {
        return this.readPixelBuffer;
    }

    public void rewindPixelBuffer() {
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.rewind();
        }
    }

    public TextureData getTextureData() {
        return this.readTextureData;
    }

    public Texture getTexture() {
        return this.readTexture;
    }

    public void write(File file) {
        try {
            TextureIO.write(this.readTextureData, file);
            this.rewindPixelBuffer();
        }
        catch (IOException iOException) {
            throw new RuntimeException("can not write to file: " + file.getAbsolutePath(), iOException);
        }
    }

    public boolean readPixels(GL gL, boolean bl) {
        return this.readPixels(gL, 0, 0, 0, 0, bl);
    }

    public boolean readPixels(GL gL, int n, int n2, int n3, int n4, boolean bl) {
        GLDrawable gLDrawable = gL.getContext().getGLReadDrawable();
        int n5 = 0 >= n3 || gLDrawable.getSurfaceWidth() < n3 ? gLDrawable.getSurfaceWidth() : n3;
        int n6 = 0 >= n4 || gLDrawable.getSurfaceHeight() < n4 ? gLDrawable.getSurfaceHeight() : n4;
        return this.readPixelsImpl(gLDrawable, gL, n, n2, n5, n6, bl);
    }

    protected boolean readPixelsImpl(GLDrawable gLDrawable, GL gL, int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        int n5;
        int n6;
        int n7 = gL.glGetError();
        if (0 != n7) {
            System.err.println("Info: GLReadBufferUtil.readPixels: pre-exisiting GL error 0x" + Integer.toHexString(n7));
        }
        int n8 = this.alphaRequested ? 4 : 3;
        PixelFormat.Composition composition = this.pixelBufferProvider.getHostPixelComp(gL.getGLProfile(), n8);
        GLPixelBuffer.GLPixelAttributes gLPixelAttributes = this.pixelBufferProvider.getAttributes(gL, n8, true);
        int n9 = gLPixelAttributes.pfmt.comp.componentCount();
        boolean bl3 = this.hasAlpha = 0 <= gLPixelAttributes.pfmt.comp.find(PixelFormat.CType.A);
        if (4 == n9) {
            n6 = 4;
            n5 = 6408;
        } else {
            n6 = 1;
            n5 = 6407;
        }
        boolean bl4 = gLDrawable.isGLOriented() ? bl : !bl;
        int[] nArray = new int[1];
        int n10 = GLBuffers.sizeof(gL, nArray, gLPixelAttributes.pfmt.comp.bytesPerPixel(), n3, n4, 1, true);
        boolean bl5 = false;
        if (null == this.readPixelBuffer || this.readPixelBuffer.requiresNewBuffer(gL, n3, n4, n10)) {
            this.readPixelBuffer = this.pixelBufferProvider.allocate(gL, composition, gLPixelAttributes, true, n3, n4, 1, n10);
            Buffers.rangeCheckBytes(this.readPixelBuffer.buffer, n10);
            try {
                this.readTextureData = new TextureData(gL.getGLProfile(), n5, n3, n4, 0, gLPixelAttributes, false, false, bl4, this.readPixelBuffer.buffer, null);
                bl5 = true;
            }
            catch (Exception exception) {
                this.readTextureData = null;
                this.readPixelBuffer = null;
                throw new RuntimeException("can not fetch offscreen texture", exception);
            }
        } else {
            this.readTextureData.setInternalFormat(n5);
            this.readTextureData.setWidth(n3);
            this.readTextureData.setHeight(n4);
            this.readTextureData.setPixelAttributes(gLPixelAttributes);
        }
        boolean bl6 = bl2 = null != this.readPixelBuffer && this.readPixelBuffer.isValid();
        if (bl2) {
            this.psm.setPackAlignment(gL, n6);
            if (gL.isGL2ES3()) {
                GL2ES3 gL2ES3 = gL.getGL2ES3();
                this.psm.setPackRowLength(gL2ES3, n3);
                gL2ES3.glReadBuffer(gL2ES3.getDefaultReadBuffer());
            }
            this.readPixelBuffer.clear();
            try {
                gL.glReadPixels(n, n2, n3, n4, gLPixelAttributes.format, gLPixelAttributes.type, this.readPixelBuffer.buffer);
            }
            catch (GLException gLException) {
                bl2 = false;
                gLException.printStackTrace();
            }
            this.readPixelBuffer.position(n10);
            this.readPixelBuffer.flip();
            int n11 = gL.glGetError();
            if (0 != n11) {
                System.err.println("GLReadBufferUtil.readPixels: readPixels error 0x" + Integer.toHexString(n11) + " " + n3 + "x" + n4 + ", " + gLPixelAttributes + ", " + this.readPixelBuffer + ", sz " + n10);
                bl2 = false;
            }
            if (bl2 && null != this.readTexture) {
                if (bl5) {
                    this.readTexture.updateImage(gL, this.readTextureData);
                } else {
                    this.readTexture.updateSubImage(gL, this.readTextureData, 0, n, n2, 0, 0, n3, n4);
                }
                this.readPixelBuffer.rewind();
            }
            this.psm.restore(gL);
        }
        return bl2;
    }

    public void dispose(GL gL) {
        if (null != this.readTexture) {
            this.readTexture.destroy(gL);
            this.readTextureData = null;
        }
        if (null != this.readPixelBuffer) {
            this.readPixelBuffer.dispose();
            this.readPixelBuffer = null;
        }
    }
}

