/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import gov.nasa.worldwind.BasicSceneController;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.StereoSceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.render.DrawContext;

public class StereoOptionSceneController
extends BasicSceneController
implements StereoSceneController {
    protected static final double DEFAULT_FOCUS_ANGLE = Configuration.getDoubleValue("gov.nasa.worldwind.StereoFocusAngle", 1.6);
    protected String stereoMode = "gov.nasa.worldwind.avkey.StereoModeNone";
    protected Angle focusAngle = Angle.fromDegrees(DEFAULT_FOCUS_ANGLE);
    protected boolean swapEyes = false;
    protected GLCapabilitiesImmutable capabilities;
    protected boolean hardwareStereo = false;
    protected boolean inStereo = false;

    public StereoOptionSceneController() {
        String string = System.getProperty("gov.nasa.worldwind.stereo.mode");
        if ("redblue".equalsIgnoreCase(string)) {
            this.setStereoMode("gov.nasa.worldwind.avkey.StereoModeRedBlue");
        } else if ("device".equalsIgnoreCase(string)) {
            this.setStereoMode("gov.nasa.worldwind.avkey.StereoModeDevice");
        }
    }

    @Override
    public void setStereoMode(String string) {
        this.stereoMode = string != null ? string : "gov.nasa.worldwind.avkey.StereoModeNone";
        this.inStereo = this.isHardwareStereo() || "gov.nasa.worldwind.avkey.StereoModeRedBlue".equals(this.stereoMode);
    }

    @Override
    public String getStereoMode() {
        return this.stereoMode;
    }

    @Override
    public void setFocusAngle(Angle angle) {
        this.focusAngle = angle != null ? angle : Angle.ZERO;
    }

    @Override
    public Angle getFocusAngle() {
        return this.focusAngle;
    }

    @Override
    public void setSwapEyes(boolean bl) {
        this.swapEyes = bl;
    }

    @Override
    public boolean isSwapEyes() {
        return this.swapEyes;
    }

    @Override
    public boolean isHardwareStereo() {
        return this.hardwareStereo;
    }

    @Override
    public boolean isInStereo() {
        return this.inStereo;
    }

    @Override
    protected void draw(DrawContext drawContext) {
        if (this.capabilities == null) {
            this.capabilities = drawContext.getGLContext().getGLDrawable().getChosenGLCapabilities();
            this.hardwareStereo = this.capabilities.getStereo();
            boolean bl = this.inStereo = this.isHardwareStereo() ? true : this.isInStereo();
        }
        if (!this.isInStereo()) {
            super.draw(drawContext);
            return;
        }
        View view = drawContext.getView();
        Boolean bl = view.getPitch().compareTo(Angle.fromDegrees(50.0)) > 0 && view.getPitch().compareTo(Angle.POS90) < 0;
        if ("gov.nasa.worldwind.avkey.StereoModeDevice".equals(this.stereoMode) && this.isHardwareStereo() && bl.booleanValue()) {
            this.doDrawToStereoDevice(drawContext);
        } else if ("gov.nasa.worldwind.avkey.StereoModeRedBlue".equals(this.stereoMode) && bl.booleanValue()) {
            this.doDrawStereoRedBlue(drawContext);
        } else {
            this.doDrawStereoNone(drawContext);
        }
    }

    protected void doDrawStereoNone(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDrawBuffer(1026);
        gL2.glClear(16640);
        super.draw(drawContext);
        gL2.glDrawBuffer(1027);
        gL2.glClear(16640);
        super.draw(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawStereoRedBlue(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        View view = drawContext.getView();
        if (this.isSwapEyes()) {
            if (this.isHardwareStereo()) {
                gL2.glDrawBuffer(1027);
            }
            gL2.glColorMask(false, true, true, true);
        } else {
            if (this.isHardwareStereo()) {
                gL2.glDrawBuffer(1026);
            }
            gL2.glColorMask(true, false, false, true);
        }
        if (this.isHardwareStereo()) {
            gL2.glClear(16640);
        }
        super.draw(drawContext);
        Angle angle = view.getHeading();
        view.setHeading(view.getHeading().subtract(this.getFocusAngle()));
        view.apply(drawContext);
        try {
            gL2.glClear(256);
            if (this.isSwapEyes()) {
                if (this.isHardwareStereo()) {
                    gL2.glDrawBuffer(1027);
                }
                gL2.glColorMask(true, false, false, true);
            } else {
                if (this.isHardwareStereo()) {
                    gL2.glDrawBuffer(1026);
                }
                gL2.glColorMask(false, true, true, true);
            }
            if (this.isHardwareStereo()) {
                gL2.glClear(16640);
            }
            super.draw(drawContext);
        }
        finally {
            view.setHeading(angle);
            view.apply(drawContext);
            gL2.glColorMask(true, true, true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawToStereoDevice(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        View view = drawContext.getView();
        if (this.isSwapEyes()) {
            gL2.glDrawBuffer(1027);
        } else {
            gL2.glDrawBuffer(1026);
        }
        gL2.glClear(16640);
        super.draw(drawContext);
        Angle angle = view.getHeading();
        view.setHeading(view.getHeading().subtract(this.getFocusAngle()));
        view.apply(drawContext);
        try {
            if (this.isSwapEyes()) {
                gL2.glDrawBuffer(1026);
            } else {
                gL2.glDrawBuffer(1027);
            }
            gL2.glClear(16640);
            super.draw(drawContext);
        }
        finally {
            view.setHeading(angle);
            view.apply(drawContext);
        }
    }
}

