/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.Logging;

public class AnimationSupport {
    public static long getScaledTimeMillisecs(LatLon latLon, LatLon latLon2, long l, long l2) {
        Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
        double d = AnimationSupport.angularRatio(angle, Angle.POS180);
        return (long)AnimationSupport.mixDouble(d, l, l2);
    }

    public static long getScaledTimeMillisecs(Angle angle, Angle angle2, Angle angle3, long l, long l2) {
        Angle angle4 = angle.angularDistanceTo(angle2);
        double d = AnimationSupport.angularRatio(angle4, angle3);
        return (long)AnimationSupport.mixDouble(d, l, l2);
    }

    public static long getScaledTimeMillisecs(double d, double d2, long l, long l2) {
        double d3 = Math.abs(d2 - d) / Math.max(d2, d);
        d3 = AnimationSupport.clampDouble(d3, 0.0, 1.0);
        return (long)AnimationSupport.mixDouble(d3, l, l2);
    }

    public static double angularRatio(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.divide(angle2);
        return AnimationSupport.clampDouble(d, 0.0, 1.0);
    }

    public static double mixDouble(double d, double d2, double d3) {
        if (d < 0.0) {
            return d2;
        }
        if (d > 1.0) {
            return d3;
        }
        return d2 * (1.0 - d) + d3 * d;
    }

    public static double clampDouble(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static double interpolantNormalized(double d, double d2, double d3) {
        if (d < d2) {
            return 0.0;
        }
        if (d > d3) {
            return 1.0;
        }
        if (d3 - d2 == 0.0) {
            return 1.0;
        }
        return (d - d2) / (d3 - d2);
    }

    public static double interpolantSmoothed(double d, int n) {
        double d2 = d;
        for (int i = 0; i < n; ++i) {
            d2 = d2 * d2 * (3.0 - 2.0 * d2);
        }
        return d2;
    }

    public static double basicInterpolant(double d, double d2, double d3, int n) {
        double d4 = AnimationSupport.interpolantNormalized(d, d2, d3);
        return AnimationSupport.interpolantSmoothed(d4, n);
    }
}

