/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.Animator;
import gov.nasa.worldwind.animation.BasicAnimator;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;

public class CompoundAnimator
extends BasicAnimator {
    protected Animator[] animators;

    public CompoundAnimator(Interpolator interpolator) {
        super(interpolator);
        this.animators = null;
    }

    public CompoundAnimator(Interpolator interpolator, Animator ... animatorArray) {
        super(interpolator);
        if (animatorArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = animatorArray.length;
        this.animators = new Animator[n];
        System.arraycopy(animatorArray, 0, this.animators, 0, n);
    }

    public void setAnimators(Animator ... animatorArray) {
        int n = animatorArray.length;
        this.animators = new Animator[n];
        System.arraycopy(animatorArray, 0, this.animators, 0, n);
    }

    public final Iterable<Animator> getAnimators() {
        return Arrays.asList(this.animators);
    }

    @Override
    protected void setImpl(double d) {
        boolean bl = true;
        for (Animator animator : this.animators) {
            if (animator == null || !animator.hasNext()) continue;
            bl = false;
            animator.set(d);
        }
        if (bl) {
            this.stop();
        }
    }
}

