/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.awt.AbstractViewInputHandler;
import gov.nasa.worldwind.awt.KeyEventState;
import gov.nasa.worldwind.awt.ViewInputActionHandler;
import gov.nasa.worldwind.awt.ViewInputAttributes;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.view.ViewUtil;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;

public abstract class BasicViewInputHandler
extends AbstractViewInputHandler {
    protected abstract void onMoveTo(Position var1, ViewInputAttributes.DeviceAttributes var2, ViewInputAttributes.ActionAttributes var3);

    protected abstract void onHorizontalTranslateRel(double var1, double var3, double var5, double var7, ViewInputAttributes.DeviceAttributes var9, ViewInputAttributes.ActionAttributes var10);

    protected abstract void onVerticalTranslate(double var1, double var3, ViewInputAttributes.DeviceAttributes var5, ViewInputAttributes.ActionAttributes var6);

    protected abstract void onRotateView(double var1, double var3, double var5, double var7, ViewInputAttributes.DeviceAttributes var9, ViewInputAttributes.ActionAttributes var10);

    protected abstract void onResetHeading(ViewInputAttributes.ActionAttributes var1);

    protected abstract void onResetHeadingPitchRoll(ViewInputAttributes.ActionAttributes var1);

    public BasicViewInputHandler() {
        RotateActionListener rotateActionListener = new RotateActionListener();
        this.getAttributes().setActionListener("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewRotateKeys", rotateActionListener);
        this.getAttributes().setActionListener("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewRotateSlow", rotateActionListener);
        this.getAttributes().setActionListener("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewRotateKeysShift", rotateActionListener);
        this.getAttributes().setActionListener("gov.nasa.worldwind.DeviceKeyboard", "gov.nasa.worldwind.ViewRotateKeysShiftSlow", rotateActionListener);
        VerticalTransActionListener verticalTransActionListener = new VerticalTransActionListener();
        ViewInputAttributes.ActionAttributes actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewVertTransKeysCTRL");
        actionAttributes.setActionListener(verticalTransActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewVertTransKeysCtrlSlow");
        actionAttributes.setActionListener(verticalTransActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewVertTransKeys");
        actionAttributes.setActionListener(verticalTransActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewVertTransKeysSlow");
        actionAttributes.setActionListener(verticalTransActionListener);
        HorizontalTransActionListener horizontalTransActionListener = new HorizontalTransActionListener();
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewHorizTransKeys");
        actionAttributes.setActionListener(horizontalTransActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewHorizTransSlow");
        actionAttributes.setActionListener(horizontalTransActionListener);
        RotateMouseActionListener rotateMouseActionListener = new RotateMouseActionListener();
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes("gov.nasa.worldwind.ViewRotate");
        actionAttributes.setMouseActionListener(rotateMouseActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes("gov.nasa.worldwind.ViewRotateShift");
        actionAttributes.setMouseActionListener(rotateMouseActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes("gov.nasa.worldwind.ViewHorizTrans");
        actionAttributes.setMouseActionListener(new HorizTransMouseActionListener());
        VertTransMouseActionListener vertTransMouseActionListener = new VertTransMouseActionListener();
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes("gov.nasa.worldwind.ViewVertTrans");
        actionAttributes.setMouseActionListener(vertTransMouseActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes("gov.nasa.worldwind.ViewVertTransCtrl");
        actionAttributes.setMouseActionListener(vertTransMouseActionListener);
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouse").getActionAttributes("gov.nasa.worldwind.ViewMoveTo");
        actionAttributes.setMouseActionListener(new MoveToMouseActionListener());
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewResetHeading");
        actionAttributes.setActionListener(new ResetHeadingActionListener());
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewResetHeadingPitchRoll");
        actionAttributes.setActionListener(new ResetHeadingPitchActionListener());
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceKeyboard").getActionAttributes("gov.nasa.worldwind.ViewStopView");
        actionAttributes.setActionListener(new StopViewActionListener());
        actionAttributes = this.getAttributes().getActionMap("gov.nasa.worldwind.DeviceMouseWheel").getActionAttributes("gov.nasa.worldwind.ViewVertTrans");
        actionAttributes.setMouseActionListener(new VertTransMouseWheelActionListener());
    }

    @Override
    public void apply() {
        super.apply();
    }

    @Override
    protected void handleKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        Integer n = keyEvent.getModifiersEx();
        for (int i = 0; i < 8; ++i) {
            if ((n & this.modifierList[i]) != this.modifierList[i]) continue;
            ViewInputAttributes.ActionAttributesList actionAttributesList = (ViewInputAttributes.ActionAttributesList)this.keyModsActionMap.get(this.modifierList[i]);
            bl = this.callActionListListeners(keyEvent, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_PRESS, actionAttributesList);
        }
        if (!bl) {
            super.handleKeyPressed(keyEvent);
        }
    }

    @Override
    protected void handleMouseClicked(MouseEvent mouseEvent) {
        boolean bl = false;
        Integer n = mouseEvent.getModifiersEx();
        for (int i = 0; i < 8; ++i) {
            if ((n & this.modifierList[i]) != this.modifierList[i]) continue;
            ViewInputAttributes.ActionAttributesList actionAttributesList = (ViewInputAttributes.ActionAttributesList)this.mouseModsActionMap.get(this.modifierList[i]);
            bl = this.callMouseActionListListeners(mouseEvent, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_PRESS, actionAttributesList);
        }
        if (!bl) {
            super.handleMouseClicked(mouseEvent);
        }
    }

    @Override
    protected void handleMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        boolean bl = false;
        Integer n = mouseWheelEvent.getModifiersEx();
        for (int i = 0; i < 8; ++i) {
            if ((n & this.modifierList[i]) != this.modifierList[i]) continue;
            ViewInputAttributes.ActionAttributesList actionAttributesList = (ViewInputAttributes.ActionAttributesList)this.mouseWheelModsActionMap.get(this.modifierList[i]);
            bl = this.callMouseWheelActionListListeners(mouseWheelEvent, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_DRAG, actionAttributesList);
        }
        if (!bl) {
            super.handleMouseWheelMoved(mouseWheelEvent);
        }
    }

    @Override
    protected void handleMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiersEx();
        for (int i = 0; i < 8; ++i) {
            ViewInputAttributes.ActionAttributesList actionAttributesList;
            if ((n & this.modifierList[i]) != this.modifierList[i] || !this.callMouseActionListListeners(mouseEvent, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_DRAG, actionAttributesList = (ViewInputAttributes.ActionAttributesList)this.mouseModsActionMap.get(this.modifierList[i]))) continue;
            return;
        }
    }

    @Override
    protected boolean handlePerFrameKeyState(KeyEventState keyEventState, String string) {
        if (keyEventState.getNumKeysDown() == 0) {
            return false;
        }
        boolean bl = false;
        Integer n = keyEventState.getModifiersEx();
        for (int i = 0; i < 8; ++i) {
            if ((n & this.modifierList[i]) != this.modifierList[i]) continue;
            ViewInputAttributes.ActionAttributesList actionAttributesList = (ViewInputAttributes.ActionAttributesList)this.keyModsActionMap.get(this.modifierList[i]);
            bl = this.callActionListListeners(keyEventState, string, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN, actionAttributesList);
            break;
        }
        return bl;
    }

    @Override
    protected boolean handlePerFrameMouseState(KeyEventState keyEventState, String string) {
        boolean bl = false;
        if (keyEventState.getNumButtonsDown() == 0) {
            return false;
        }
        Integer n = keyEventState.getModifiersEx();
        for (int i = 0; i < 8; ++i) {
            ViewInputAttributes.ActionAttributesList actionAttributesList;
            if ((n & this.modifierList[i]) != this.modifierList[i] || !this.callActionListListeners(keyEventState, string, ViewInputAttributes.ActionAttributes.ActionTrigger.ON_KEY_DOWN, actionAttributesList = (ViewInputAttributes.ActionAttributesList)this.mouseModsActionMap.get(this.modifierList[i]))) continue;
            return true;
        }
        return bl;
    }

    protected boolean callMouseActionListListeners(MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes.ActionTrigger actionTrigger, ViewInputAttributes.ActionAttributesList actionAttributesList) {
        boolean bl = false;
        if (actionAttributesList != null) {
            for (ViewInputAttributes.ActionAttributes actionAttributes : actionAttributesList) {
                if (actionAttributes.getMouseActionListener() == null || actionAttributes.getActionTrigger() != actionTrigger || !actionAttributes.getMouseActionListener().inputActionPerformed((AbstractViewInputHandler)this, mouseEvent, actionAttributes)) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean callMouseWheelActionListListeners(MouseWheelEvent mouseWheelEvent, ViewInputAttributes.ActionAttributes.ActionTrigger actionTrigger, ViewInputAttributes.ActionAttributesList actionAttributesList) {
        boolean bl = false;
        if (actionAttributesList != null) {
            for (ViewInputAttributes.ActionAttributes actionAttributes : actionAttributesList) {
                if (actionAttributes.getMouseActionListener() == null || actionAttributes.getActionTrigger() != actionTrigger || !actionAttributes.getMouseActionListener().inputActionPerformed((AbstractViewInputHandler)this, mouseWheelEvent, actionAttributes)) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean callActionListListeners(KeyEvent keyEvent, ViewInputAttributes.ActionAttributes.ActionTrigger actionTrigger, ViewInputAttributes.ActionAttributesList actionAttributesList) {
        boolean bl = false;
        if (actionAttributesList != null) {
            for (ViewInputAttributes.ActionAttributes actionAttributes : actionAttributesList) {
                if (actionAttributes.getActionListener() == null || actionAttributes.getActionTrigger() != actionTrigger || !actionAttributes.getActionListener().inputActionPerformed(this, keyEvent, actionAttributes)) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean callActionListListeners(KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes.ActionTrigger actionTrigger, ViewInputAttributes.ActionAttributesList actionAttributesList) {
        boolean bl = false;
        if (actionAttributesList != null) {
            for (ViewInputAttributes.ActionAttributes actionAttributes : actionAttributesList) {
                if (actionAttributes.getActionTrigger() != actionTrigger || !this.callActionListener(keyEventState, string, actionAttributes)) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected boolean callActionListener(KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (actionAttributes.getActionListener() != null) {
            return actionAttributes.getActionListener().inputActionPerformed(this, keyEventState, string, actionAttributes);
        }
        if (actionAttributes.getMouseActionListener() != null) {
            return actionAttributes.getMouseActionListener().inputActionPerformed(keyEventState, string, actionAttributes);
        }
        return false;
    }

    @Override
    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.handlePropertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName() == "gov.nasa.worldwind.View.ViewStopped") {
            this.handleViewStopped();
        }
    }

    protected void handleViewStopped() {
    }

    public class RotateActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            List list = actionAttributes.getKeyActions();
            double d = 0.0;
            double d2 = 0.0;
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (!keyEventState.isKeyDown(keyAction.keyCode)) continue;
                if (keyAction.direction == 0) {
                    d += (double)keyAction.sign;
                    continue;
                }
                d2 += (double)keyAction.sign;
            }
            if (d == 0.0 && d2 == 0.0) {
                return false;
            }
            if (string == "GenerateEvents") {
                ViewInputAttributes.DeviceAttributes deviceAttributes = abstractViewInputHandler.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard");
                BasicViewInputHandler.this.onRotateView(d, d2, d, d2, deviceAttributes, actionAttributes);
            }
            return true;
        }
    }

    public class VerticalTransActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            double d = 0.0;
            List list = actionAttributes.getKeyActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (!keyEventState.isKeyDown(keyAction.keyCode)) continue;
                d += (double)keyAction.sign;
            }
            if (d == 0.0) {
                return false;
            }
            if (string == "GenerateEvents") {
                ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard");
                BasicViewInputHandler.this.onVerticalTranslate(d, d, deviceAttributes, actionAttributes);
            }
            return true;
        }
    }

    public class HorizontalTransActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            double d = 0.0;
            double d2 = 0.0;
            List list = actionAttributes.getKeyActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (!keyEventState.isKeyDown(keyAction.keyCode)) continue;
                if (keyAction.direction == 0) {
                    d2 += (double)keyAction.sign;
                    continue;
                }
                d += (double)keyAction.sign;
            }
            if (d == 0.0 && d2 == 0.0) {
                return false;
            }
            if (string == "GenerateEvents") {
                BasicViewInputHandler.this.onHorizontalTranslateRel(d, d2, d, d2, BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceKeyboard"), actionAttributes);
            }
            return true;
        }
    }

    public class RotateMouseActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            Object object;
            Object object22;
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object object22 : list) {
                object = (ViewInputAttributes.ActionAttributes.MouseAction)object22;
                if ((keyEventState.getMouseModifiersEx() & ((ViewInputAttributes.ActionAttributes.MouseAction)object).mouseButton) == 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Point point = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object22 = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getLastMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMouseDownPoint(), BasicViewInputHandler.this.getWorldWindow());
            if (point == null || object22 == null) {
                return false;
            }
            Point point2 = ViewUtil.subtract(point, object22);
            int n = point2.x;
            int n2 = point2.y;
            Point point3 = ViewUtil.subtract(point, (Point)object);
            int n3 = point3.x;
            int n4 = point3.y;
            ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
            BasicViewInputHandler.this.onRotateView(n, n2, n3, n4, deviceAttributes, actionAttributes);
            return true;
        }

        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            Object object;
            Object object22;
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object object22 : list) {
                object = (ViewInputAttributes.ActionAttributes.MouseAction)object22;
                if ((mouseEvent.getModifiersEx() & ((ViewInputAttributes.ActionAttributes.MouseAction)object).mouseButton) == 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Point point = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object22 = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getLastMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMouseDownPoint(), BasicViewInputHandler.this.getWorldWindow());
            if (point == null || object22 == null) {
                return false;
            }
            Point point2 = ViewUtil.subtract(point, object22);
            int n = point2.x;
            int n2 = point2.y;
            if (object == null) {
                object = object22;
            }
            Point point3 = ViewUtil.subtract(point, (Point)object);
            int n3 = point3.x;
            int n4 = point3.y;
            ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
            BasicViewInputHandler.this.onRotateView(n, n2, n3, n4, deviceAttributes, actionAttributes);
            return true;
        }
    }

    public class HorizTransMouseActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            Object object;
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object object2 : list) {
                object = (ViewInputAttributes.ActionAttributes.MouseAction)object2;
                if ((keyEventState.getMouseModifiersEx() & ((ViewInputAttributes.ActionAttributes.MouseAction)object).mouseButton) == 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            if (string == "GenerateEvents") {
                Object object2;
                Point point = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMousePoint(), BasicViewInputHandler.this.getWorldWindow());
                object2 = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getLastMousePoint(), BasicViewInputHandler.this.getWorldWindow());
                object = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMouseDownPoint(), BasicViewInputHandler.this.getWorldWindow());
                Point point2 = ViewUtil.subtract(point, object2);
                if (point == null || object2 == null) {
                    return false;
                }
                int n = point2.y;
                int n2 = -point2.x;
                Point point3 = ViewUtil.subtract(point, (Point)object);
                int n3 = point3.y;
                int n4 = -point3.x;
                ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
                BasicViewInputHandler.this.onHorizontalTranslateRel(n, n2, n3, n4, deviceAttributes, actionAttributes);
            }
            return true;
        }

        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            Object object;
            Object object22;
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object object22 : list) {
                object = (ViewInputAttributes.ActionAttributes.MouseAction)object22;
                if ((mouseEvent.getModifiersEx() & ((ViewInputAttributes.ActionAttributes.MouseAction)object).mouseButton) == 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Point point = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object22 = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getLastMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMouseDownPoint(), BasicViewInputHandler.this.getWorldWindow());
            if (point == null || object22 == null || object == null) {
                return false;
            }
            Point point2 = ViewUtil.subtract(point, object22);
            int n = point2.y;
            int n2 = -point2.x;
            Point point3 = ViewUtil.subtract(point, (Point)object);
            int n3 = point3.y;
            int n4 = -point3.x;
            ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
            BasicViewInputHandler.this.onHorizontalTranslateRel(n, n2, n3, n4, deviceAttributes, actionAttributes);
            return true;
        }
    }

    public class VertTransMouseActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            Object object;
            Object object22;
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object object22 : list) {
                object = (ViewInputAttributes.ActionAttributes.MouseAction)object22;
                if ((mouseEvent.getModifiersEx() & ((ViewInputAttributes.ActionAttributes.MouseAction)object).mouseButton) == 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Point point = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object22 = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getLastMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMouseDownPoint(), BasicViewInputHandler.this.getWorldWindow());
            if (point == null || object22 == null || object == null) {
                return false;
            }
            Point point2 = ViewUtil.subtract(point, object22);
            int n = point2.y;
            Point point3 = ViewUtil.subtract(point, (Point)object);
            int n2 = point3.y;
            ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
            BasicViewInputHandler.this.onVerticalTranslate(n, n2, deviceAttributes, actionAttributes);
            return true;
        }

        @Override
        public boolean inputActionPerformed(KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
            Object object;
            Object object22;
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object object22 : list) {
                object = (ViewInputAttributes.ActionAttributes.MouseAction)object22;
                if ((keyEventState.getMouseModifiersEx() & ((ViewInputAttributes.ActionAttributes.MouseAction)object).mouseButton) == 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Point point = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object22 = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getLastMousePoint(), BasicViewInputHandler.this.getWorldWindow());
            object = AbstractViewInputHandler.constrainToSourceBounds(BasicViewInputHandler.this.getMouseDownPoint(), BasicViewInputHandler.this.getWorldWindow());
            if (point == null || object22 == null) {
                return false;
            }
            Point point2 = ViewUtil.subtract(point, object22);
            int n = point2.y;
            Point point3 = ViewUtil.subtract(point, (Point)object);
            int n2 = point3.y;
            ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse");
            BasicViewInputHandler.this.onVerticalTranslate(n, n2, deviceAttributes, actionAttributes);
            return true;
        }
    }

    public class MoveToMouseActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseEvent mouseEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            boolean bl = false;
            List list = actionAttributes.getMouseActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.MouseAction mouseAction = (ViewInputAttributes.ActionAttributes.MouseAction)e;
                if (mouseEvent.getButton() != mouseAction.mouseButton) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
            Position position = BasicViewInputHandler.this.computeSelectedPosition();
            if (position == null) {
                return false;
            }
            BasicViewInputHandler.this.onMoveTo(position, BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouse"), actionAttributes);
            return true;
        }
    }

    public class ResetHeadingActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEvent keyEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            List list = actionAttributes.getKeyActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (keyEvent.getKeyCode() != keyAction.keyCode) continue;
                BasicViewInputHandler.this.onResetHeading(actionAttributes);
                return true;
            }
            return false;
        }
    }

    public class ResetHeadingPitchActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEvent keyEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            List list = actionAttributes.getKeyActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (keyEvent.getKeyCode() != keyAction.keyCode) continue;
                BasicViewInputHandler.this.onResetHeadingPitchRoll(actionAttributes);
                return true;
            }
            return false;
        }
    }

    public class StopViewActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, KeyEvent keyEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            List list = actionAttributes.getKeyActions();
            for (Object e : list) {
                ViewInputAttributes.ActionAttributes.KeyAction keyAction = (ViewInputAttributes.ActionAttributes.KeyAction)e;
                if (keyEvent.getKeyCode() != keyAction.keyCode) continue;
                BasicViewInputHandler.this.onStopView();
                return true;
            }
            return false;
        }
    }

    public class VertTransMouseWheelActionListener
    extends ViewInputActionHandler {
        @Override
        public boolean inputActionPerformed(AbstractViewInputHandler abstractViewInputHandler, MouseWheelEvent mouseWheelEvent, ViewInputAttributes.ActionAttributes actionAttributes) {
            double d = mouseWheelEvent.getWheelRotation();
            ViewInputAttributes.DeviceAttributes deviceAttributes = BasicViewInputHandler.this.getAttributes().getDeviceAttributes("gov.nasa.worldwind.DeviceMouseWheel");
            BasicViewInputHandler.this.onVerticalTranslate(d, d, deviceAttributes, actionAttributes);
            return true;
        }
    }
}

