/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;

public class KeyEventState
implements KeyListener,
MouseListener {
    protected Map<Object, InputState> keyStateMap = new HashMap<Object, InputState>();
    protected int modifiers;
    protected int modifiersEx;
    protected int mouseModifiers;
    protected int mouseModifiersEx;

    public boolean isKeyDown(int n) {
        InputState inputState = this.getKeyState(n);
        return inputState != null && inputState.getEventType() == 401;
    }

    public int keyState(int n) {
        InputState inputState = this.getKeyState(n);
        return inputState != null && inputState.getEventType() == 401 ? 1 : 0;
    }

    public int getNumKeysDown() {
        if (this.keyStateMap.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (Object object : this.keyStateMap.keySet()) {
            InputState inputState = this.keyStateMap.get(object);
            if (inputState.getEventType() != 401) continue;
            ++n;
        }
        return n;
    }

    public int getNumButtonsDown() {
        if (this.keyStateMap.isEmpty()) {
            return 0;
        }
        int n = 0;
        for (Object object : this.keyStateMap.keySet()) {
            InputState inputState = this.keyStateMap.get(object);
            if (inputState.getEventType() != 501) continue;
            ++n;
        }
        return n;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getModifiersEx() {
        return this.modifiersEx;
    }

    public int getMouseModifiers() {
        return this.mouseModifiers;
    }

    public int getMouseModifiersEx() {
        return this.mouseModifiersEx;
    }

    public void clearKeyState() {
        this.keyStateMap.clear();
        this.modifiers = 0;
        this.modifiersEx = 0;
        this.mouseModifiers = 0;
        this.mouseModifiersEx = 0;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.onKeyEvent(keyEvent, 401);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.removeKeyState(keyEvent);
    }

    protected void onKeyEvent(KeyEvent keyEvent, int n) {
        if (keyEvent == null) {
            return;
        }
        long l = this.getTimeStamp(keyEvent, n, this.keyStateMap.get(keyEvent.getKeyCode()));
        this.setKeyState(keyEvent.getKeyCode(), new InputState(n, keyEvent.getKeyCode(), l));
        this.setModifiers(keyEvent.getModifiers());
        this.setModifiersEx(keyEvent.getModifiersEx());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        long l = this.getTimeStamp(mouseEvent, 501, this.keyStateMap.get(mouseEvent.getModifiersEx()));
        this.setKeyState(mouseEvent.getButton(), new InputState(501, mouseEvent.getButton(), l));
        this.setMouseModifiers(mouseEvent.getModifiers());
        this.setMouseModifiersEx(mouseEvent.getModifiersEx());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.keyStateMap.remove(mouseEvent.getButton());
        this.setMouseModifiers(0);
        this.setMouseModifiersEx(0);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected InputState getKeyState(int n) {
        return this.keyStateMap.get(n);
    }

    protected void setKeyState(int n, InputState inputState) {
        this.keyStateMap.put(n, inputState);
    }

    protected void setModifiers(int n) {
        this.modifiers = n;
    }

    protected void setModifiersEx(int n) {
        this.modifiersEx = n;
    }

    protected void setMouseModifiersEx(int n) {
        this.mouseModifiersEx = n;
    }

    protected void setMouseModifiers(int n) {
        this.mouseModifiers = n;
    }

    protected void removeKeyState(KeyEvent keyEvent) {
        this.keyStateMap.remove(keyEvent.getKeyCode());
        this.setModifiers(keyEvent.getModifiers());
        this.setModifiersEx(keyEvent.getModifiersEx());
    }

    protected long getTimeStamp(InputEvent inputEvent, int n, InputState inputState) {
        if (inputState != null && inputState.getEventType() == n) {
            return inputState.getTimestamp();
        }
        return inputEvent.getWhen();
    }

    protected static class InputState {
        protected int eventType;
        protected int keyOrButtonCode;
        protected long timestamp;

        public InputState(int n, int n2, long l) {
            this.eventType = n;
            this.keyOrButtonCode = n2;
            this.timestamp = l;
        }

        public int getEventType() {
            return this.eventType;
        }

        public int getKeyOrButtonCode() {
            return this.keyOrButtonCode;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

