/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.awt.KeyInputActionHandler;
import gov.nasa.worldwind.awt.MouseInputActionHandler;
import gov.nasa.worldwind.awt.ViewInputActionHandler;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ViewInputAttributes {
    public static final String VIEW_FOCUS = "gov.nasa.worldwind.ViewFocus";
    public static final String VIEW_FOCUS_SLOW = "gov.nasa.worldwind.ViewFocusSlow";
    public static final String VIEW_PAN = "gov.nasa.worldwind.ViewPan";
    public static final String VIEW_PAN_SLOW = "gov.nasa.worldwind.ViewPanSlow";
    public static final String VIEW_ROTATE = "gov.nasa.worldwind.ViewRotate";
    public static final String VIEW_ROTATE_SHIFT = "gov.nasa.worldwind.ViewRotateShift";
    public static final String VIEW_ROTATE_SLOW = "gov.nasa.worldwind.ViewRotateSlow";
    public static final String VIEW_ZOOM = "gov.nasa.worldwind.ViewZoom";
    public static final String VIEW_ZOOM_SLOW = "gov.nasa.worldwind.ViewZoomSlow";
    public static final String DEVICE_KEYBOARD = "gov.nasa.worldwind.DeviceKeyboard";
    public static final String DEVICE_MOUSE = "gov.nasa.worldwind.DeviceMouse";
    public static final String DEVICE_MOUSE_WHEEL = "gov.nasa.worldwind.DeviceMouseWheel";
    public static final String DEVICE_KEYBOARD_MODS = "gov.nasa.worldwind.DeviceKeyboardMods";
    public static final String DEVICE_MOUSE_MODS = "gov.nasa.worldwind.DeviceMouseMods";
    public static final String DEVICE_MOUSE_WHEEL_MODS = "gov.nasa.worldwind.DeviceMouseWheelMods";
    public static final String VIEW_MOVE_TO = "gov.nasa.worldwind.ViewMoveTo";
    public static final String VIEW_MOVE_TO_SLOW = "gov.nasa.worldwind.MoveToSlow";
    public static final String VIEW_HORIZONTAL_TRANSLATE = "gov.nasa.worldwind.ViewHorizTrans";
    public static final String VIEW_HORIZONTAL_TRANSLATE_SLOW = "gov.nasa.worldwind.ViewHorizTransSlow";
    public static final String VIEW_VERTICAL_TRANSLATE = "gov.nasa.worldwind.ViewVertTrans";
    public static final String VIEW_VERTICAL_TRANSLATE_CTRL = "gov.nasa.worldwind.ViewVertTransCtrl";
    public static final String VIEW_VERTICAL_TRANSLATE_SLOW = "gov.nasa.worldwind.ViewVertTransSlow";
    public static final String VIEW_RESET_HEADING = "gov.nasa.worldwind.ViewResetHeading";
    public static final String VIEW_RESET_HEADING_PITCH_ROLL = "gov.nasa.worldwind.ViewResetHeadingPitchRoll";
    public static final String VIEW_STOP_VIEW = "gov.nasa.worldwind.ViewStopView";
    public static final String VIEW_HORIZONTAL_TRANS_KEYS = "gov.nasa.worldwind.ViewHorizTransKeys";
    public static final String VIEW_VERTICAL_TRANS_KEYS_META = "gov.nasa.worldwind.ViewVertTransKeysMeta";
    public static final String VIEW_VERTICAL_TRANS_KEYS_CTRL = "gov.nasa.worldwind.ViewVertTransKeysCTRL";
    public static final String VIEW_VERTICAL_TRANS_KEYS = "gov.nasa.worldwind.ViewVertTransKeys";
    public static final String VIEW_VERTICAL_TRANS_KEYS_SLOW_META = "gov.nasa.worldwind.ViewVertTransKeysMetaSlow";
    public static final String VIEW_VERTICAL_TRANS_KEYS_SLOW_CTRL = "gov.nasa.worldwind.ViewVertTransKeysCtrlSlow";
    public static final String VIEW_VERTICAL_TRANS_KEYS_SLOW = "gov.nasa.worldwind.ViewVertTransKeysSlow";
    public static final String VIEW_ROTATE_KEYS = "gov.nasa.worldwind.ViewRotateKeys";
    public static final String VIEW_ROTATE_KEYS_SHIFT = "gov.nasa.worldwind.ViewRotateKeysShift";
    public static final String VIEW_ROTATE_KEYS_SHIFT_SLOW = "gov.nasa.worldwind.ViewRotateKeysShiftSlow";
    public static final String VIEW_ROLL_KEYS = "gov.nasa.worldwind.ViewRollKeys";
    private static final ActionAttributes.KeyAction DEFAULT_RESET_HEADING_KEY_ACT = new ActionAttributes.KeyAction(78, 0, 1);
    public static final ActionAttributes.KeyAction[] resetHeadingEvents = new ActionAttributes.KeyAction[]{DEFAULT_RESET_HEADING_KEY_ACT};
    private static final ActionAttributes.KeyAction DEFAULT_RESET_HEADING_PITCH_ROLL_KEY_ACT = new ActionAttributes.KeyAction(82, 0, 1);
    public static final ActionAttributes.KeyAction[] resetHeadingPitchRollEvents = new ActionAttributes.KeyAction[]{DEFAULT_RESET_HEADING_PITCH_ROLL_KEY_ACT};
    private static final ActionAttributes.KeyAction DEFAULT_STOP_VIEW_KEY_ACT = new ActionAttributes.KeyAction(32, 0, 1);
    public static final ActionAttributes.KeyAction[] stopViewEvents = new ActionAttributes.KeyAction[]{DEFAULT_STOP_VIEW_KEY_ACT};
    private static final ActionAttributes.MouseAction DEFAULT_MOVETO_MOUSE_MODS = new ActionAttributes.MouseAction(1);
    public static final ActionAttributes.MouseAction[] moveToMouseEvents = new ActionAttributes.MouseAction[]{DEFAULT_MOVETO_MOUSE_MODS};
    private static final ActionAttributes.MouseAction DEFAULT_HORIZONTAL_TRANSLATE_MOUSE_MODS = new ActionAttributes.MouseAction(1024);
    public static final ActionAttributes.MouseAction[] horizontalTransMouseEvents = new ActionAttributes.MouseAction[]{DEFAULT_HORIZONTAL_TRANSLATE_MOUSE_MODS};
    private static final ActionAttributes.KeyAction DEFAULT_HORIZONTAL_TRANSLEFT_KEY_ACT = new ActionAttributes.KeyAction(37, 0, -1);
    private static final ActionAttributes.KeyAction DEFAULT_HORIZONTAL_TRANSRIGHT_KEY_ACT = new ActionAttributes.KeyAction(39, 0, 1);
    private static final ActionAttributes.KeyAction DEFAULT_HORIZONTAL_TRANSUP_KEY_ACT = new ActionAttributes.KeyAction(38, 1, 1);
    private static final ActionAttributes.KeyAction DEFAULT_HORIZONTAL_TRANSDOWN_KEY_ACT = new ActionAttributes.KeyAction(40, 1, -1);
    public static final ActionAttributes.KeyAction[] horizontalTransKeyEvents = new ActionAttributes.KeyAction[]{DEFAULT_HORIZONTAL_TRANSLEFT_KEY_ACT, DEFAULT_HORIZONTAL_TRANSRIGHT_KEY_ACT, DEFAULT_HORIZONTAL_TRANSUP_KEY_ACT, DEFAULT_HORIZONTAL_TRANSDOWN_KEY_ACT};
    private static final ActionAttributes.MouseAction DEFAULT_VERTICAL_TRANSLATE_MOUSE_MODS = new ActionAttributes.MouseAction(2048);
    public static final ActionAttributes.MouseAction[] verticalTransMouseEvents = new ActionAttributes.MouseAction[]{DEFAULT_VERTICAL_TRANSLATE_MOUSE_MODS};
    private static final ActionAttributes.MouseAction DEFAULT_VERTICAL_TRANSLATE_MOUSE_MODS_CTRL = new ActionAttributes.MouseAction(1024);
    public static final ActionAttributes.MouseAction[] verticalTransMouseEventsCtrl = new ActionAttributes.MouseAction[]{DEFAULT_VERTICAL_TRANSLATE_MOUSE_MODS_CTRL};
    private static final ActionAttributes.KeyAction DEFAULT_VERTICAL_TRANSUP_KEY_ACT = new ActionAttributes.KeyAction(38, 2, -1);
    private static final ActionAttributes.KeyAction DEFAULT_VERTICAL_TRANSDOWN_KEY_ACT = new ActionAttributes.KeyAction(40, 2, 1);
    public static final ActionAttributes.KeyAction[] verticalTransKeyEventsCtrl = new ActionAttributes.KeyAction[]{DEFAULT_VERTICAL_TRANSUP_KEY_ACT, DEFAULT_VERTICAL_TRANSDOWN_KEY_ACT};
    private static final ActionAttributes.KeyAction DEFAULT_VERTICAL_TRANSUP_ADDKEY_ACT = new ActionAttributes.KeyAction(107, 2, -1);
    private static final ActionAttributes.KeyAction DEFAULT_VERTICAL_TRANSDOWN_EQUALSKEY_ACT = new ActionAttributes.KeyAction(61, 2, -1);
    private static final ActionAttributes.KeyAction DEFAULT_VERTICAL_TRANSUP_SUBTKEY_ACT = new ActionAttributes.KeyAction(109, 2, 1);
    private static final ActionAttributes.KeyAction DEFAULT_VERTICAL_TRANSDOWN_MINUSKEY_ACT = new ActionAttributes.KeyAction(45, 2, 1);
    public static final ActionAttributes.KeyAction[] verticalTransKeyEvents = new ActionAttributes.KeyAction[]{DEFAULT_VERTICAL_TRANSUP_ADDKEY_ACT, DEFAULT_VERTICAL_TRANSDOWN_EQUALSKEY_ACT, DEFAULT_VERTICAL_TRANSUP_SUBTKEY_ACT, DEFAULT_VERTICAL_TRANSDOWN_MINUSKEY_ACT};
    private static final ActionAttributes.MouseAction DEFAULT_VERTICAL_TRANSLATE_MOUSE_WHEEL_MODS = new ActionAttributes.MouseAction(507);
    public static final ActionAttributes.MouseAction[] verticalTransMouseWheelEvents = new ActionAttributes.MouseAction[]{DEFAULT_VERTICAL_TRANSLATE_MOUSE_WHEEL_MODS};
    private static final ActionAttributes.MouseAction DEFAULT_ROTATE_MOUSE_MODS = new ActionAttributes.MouseAction(4096);
    public static final ActionAttributes.MouseAction[] rotateMouseEvents = new ActionAttributes.MouseAction[]{DEFAULT_ROTATE_MOUSE_MODS};
    private static final ActionAttributes.MouseAction DEFAULT_ROTATE_MOUSE_MODS_SHIFT = new ActionAttributes.MouseAction(1024);
    public static final ActionAttributes.MouseAction[] rotateMouseEventsShift = new ActionAttributes.MouseAction[]{DEFAULT_ROTATE_MOUSE_MODS_SHIFT};
    private static final ActionAttributes.KeyAction DEFAULT_ROTATE_HEADINGLEFT_KEY_ACT = new ActionAttributes.KeyAction(37, 0, -1);
    private static final ActionAttributes.KeyAction DEFAULT_ROTATE_HEADINGRIGHT_KEY_ACT = new ActionAttributes.KeyAction(39, 0, 1);
    private static final ActionAttributes.KeyAction DEFAULT_ROTATE_PITCHUP_KEY_ACT = new ActionAttributes.KeyAction(38, 1, -1);
    private static final ActionAttributes.KeyAction DEFAULT_ROTATE_PITCHDOWN_KEY_ACT = new ActionAttributes.KeyAction(40, 1, 1);
    public static final ActionAttributes.KeyAction[] rotationKeyEvents = new ActionAttributes.KeyAction[]{DEFAULT_ROTATE_HEADINGLEFT_KEY_ACT, DEFAULT_ROTATE_HEADINGRIGHT_KEY_ACT, DEFAULT_ROTATE_PITCHUP_KEY_ACT, DEFAULT_ROTATE_PITCHDOWN_KEY_ACT};
    protected static final ActionAttributes.KeyAction DEFAULT_ROTATE_ROLLUP_KEY_ACT = new ActionAttributes.KeyAction(37, 1, 1);
    protected static final ActionAttributes.KeyAction DEFAULT_ROTATE_ROLLDOWN_KEY_ACT = new ActionAttributes.KeyAction(39, 1, -1);
    public static final ActionAttributes.KeyAction[] rollKeyEvents = new ActionAttributes.KeyAction[]{DEFAULT_ROTATE_ROLLUP_KEY_ACT, DEFAULT_ROTATE_ROLLDOWN_KEY_ACT};
    private static final ActionAttributes.KeyAction DEFAULT_ROTATE_PITCHUP_KEY_PAGE_ACT = new ActionAttributes.KeyAction(33, 1, -1);
    private static final ActionAttributes.KeyAction DEFAULT_ROTATE_PITCHDOWN_KEY_PAGE_ACT = new ActionAttributes.KeyAction(34, 1, 1);
    public static final ActionAttributes.KeyAction[] rotationKeyEventsPage = new ActionAttributes.KeyAction[]{DEFAULT_ROTATE_PITCHUP_KEY_PAGE_ACT, DEFAULT_ROTATE_PITCHDOWN_KEY_PAGE_ACT};
    public static final boolean DEFAULT_MOVE_TO_SMOOTHING_ENABLED = true;
    public static final boolean DEFAULT_HORIZONTAL_TRANSLATE_SMOOTHING_ENABLED = true;
    public static final boolean DEFAULT_VERTICAL_TRANSLATE_SMOOTHING_ENABLED = true;
    public static final double DEFAULT_MOVE_TO_SMOOTHING_VALUE = 0.0;
    public static final double DEFAULT_HORIZONTAL_TRANSLATE_SMOOTHING_VALUE = 0.4;
    public static final double DEFAULT_VERTICAL_TRANSLATE_SMOOTHING_VALUE = 0.85;
    public static final double DEFAULT_KEY_HORIZONTAL_TRANSLATE_MIN_VALUE = 5.0E-6;
    public static final double DEFAULT_KEY_HORIZONTAL_TRANSLATE_MAX_VALUE = 4.0;
    public static final double DEFAULT_KEY_VERTICAL_TRANSLATE_VALUE = 0.06;
    public static final double DEFAULT_MOUSE_MOVE_TO_MIN_VALUE = 0.95;
    public static final double DEFAULT_MOUSE_MOVE_TO_MAX_VALUE = 0.9;
    public static final double DEFAULT_MOUSE_HORIZONTAL_TRANSLATE_MIN_VALUE = 1.0E-5;
    public static final double DEFAULT_MOUSE_HORIZONTAL_TRANSLATE_MAX_VALUE = 0.2;
    public static final double DEFAULT_MOUSE_VERTICAL_TRANSLATE_VALUE = 0.003;
    public static final double DEFAULT_MOUSE_WHEEL_VERTICAL_TRANSLATE_VALUE = 0.1;
    public static final double DEFAULT_MOUSE_WHEEL_VERTICAL_TRANSLATE_VALUE_OSX = 0.01;
    public static final double DEFAULT_KEY_SENSITIVITY = 1.0;
    public static final double DEFAULT_MOUSE_SENSITIVITY = 1.0;
    public static final double DEFAULT_MOUSE_WHEEL_SENSITIVITY = 1.0;
    public static final double DEFAULT_SLOW_VALUE = 0.25;
    public static final boolean DEFAULT_ROTATE_SMOOTHING_ENABLED = true;
    public static final double DEFAULT_ROTATE_SMOOTHING_VALUE = 0.7;
    public static final boolean DEFAULT_ROLL_SMOOTHING_ENABLED = true;
    public static final double DEFAULT_ROLL_SMOOTHING_VALUE = 0.7;
    public static final double DEFAULT_KEY_ROTATE_MIN_VALUE = 2.0;
    public static final double DEFAULT_KEY_ROTATE_MAX_VALUE = 2.2;
    public static final double DEFAULT_KEY_ROLL_MIN_VALUE = 2.0;
    public static final double DEFAULT_KEY_ROLL_MAX_VALUE = 2.2;
    public static final double DEFAULT_MOUSE_ROTATE_MIN_VALUE = 0.14;
    public static final double DEFAULT_MOUSE_ROTATE_MAX_VALUE = 0.18;
    private Map<Object, DeviceAttributes> deviceMap = new HashMap<Object, DeviceAttributes>();
    private Map<Object, ActionAttributesMap> deviceActionMap = new HashMap<Object, ActionAttributesMap>();
    private Map<Object, DeviceModifierMap> deviceModActionMap = new HashMap<Object, DeviceModifierMap>();

    public ViewInputAttributes() {
        this.setDefaultDeviceAttributes();
        this.setDeviceModifierActionMaps();
    }

    public ActionAttributesMap getActionMap(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.deviceActionMap.get(object);
    }

    public void setActionMap(Object object, ActionAttributesMap actionAttributesMap) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (actionAttributesMap == null) {
            String string = Logging.getMessage("nullValue.MapIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.deviceActionMap.put(object, actionAttributesMap);
    }

    public void addModifierAction(Object object, Integer n, ActionAttributes actionAttributes) {
        this.addModifierActionList(object, n);
        DeviceModifierMap deviceModifierMap = this.getModifierActionMap(object);
        ActionAttributesList actionAttributesList = (ActionAttributesList)deviceModifierMap.get(n);
        actionAttributesList.remove(actionAttributes);
        actionAttributesList.add(actionAttributes);
    }

    public void setValues(Object object, Object object2, double d, double d2) {
        ActionAttributes actionAttributes = this.getActionAttributes(object, object2);
        if (actionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        actionAttributes.setValues(d, d2);
    }

    public void setActionTrigger(Object object, Object object2, ActionAttributes.ActionTrigger actionTrigger) {
        ActionAttributes actionAttributes = this.getActionAttributes(object, object2);
        if (actionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        actionAttributes.setActionTrigger(actionTrigger);
    }

    public void addModifierActionList(Object object, Integer n) {
        ArrayList arrayList;
        DeviceModifierMap deviceModifierMap = this.getModifierActionMap(object);
        if (deviceModifierMap == null) {
            deviceModifierMap = new DeviceModifierMap();
            this.setModifierActionMap(object, deviceModifierMap);
        }
        if ((arrayList = (ArrayList)deviceModifierMap.get(n)) == null) {
            deviceModifierMap.put(n, new ActionAttributesList());
        }
    }

    public List getModifierActionList(Object object, Integer n) {
        DeviceModifierMap deviceModifierMap = this.getModifierActionMap(object);
        if (deviceModifierMap == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return (List)deviceModifierMap.get(n);
    }

    public DeviceAttributes getDeviceAttributes(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.deviceMap.get(object);
    }

    public void setDeviceAttributes(Object object, DeviceAttributes deviceAttributes) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (deviceAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.deviceMap.put(object, deviceAttributes);
    }

    public DeviceModifierMap getModifierActionMap(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.deviceModActionMap.get(object);
    }

    public void setModifierActionMap(Object object, DeviceModifierMap deviceModifierMap) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (deviceModifierMap == null) {
            String string = Logging.getMessage("nullValue.MapIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.deviceModActionMap.put(object, deviceModifierMap);
    }

    public ActionAttributes getActionAttributes(Object object, Object object2) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object2 == null) {
            String string = Logging.getMessage("nullValue.ActionKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ActionAttributesMap actionAttributesMap = this.getActionMap(object);
        if (actionAttributesMap == null) {
            return null;
        }
        return actionAttributesMap.getActionAttributes(object2);
    }

    public void addAction(Object object, Integer n, Object object2, ActionAttributes actionAttributes) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object2 == null) {
            String string = Logging.getMessage("nullValue.ActionKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.addModifierAction(object, n, actionAttributes);
        ActionAttributesMap actionAttributesMap = this.getActionMap(object);
        if (actionAttributesMap == null) {
            actionAttributesMap = new ActionAttributesMap();
            this.setActionMap(object, actionAttributesMap);
        }
        actionAttributesMap.setActionAttributes(object2, actionAttributes);
    }

    public void setMouseActionAttributes(String string, int n, ActionAttributes.ActionTrigger actionTrigger, ActionAttributes.MouseAction[] mouseActionArray, double d, double d2, boolean bl, double d3) {
        ActionAttributes actionAttributes = this.getActionAttributes(DEVICE_MOUSE, string);
        if (actionAttributes != null) {
            actionAttributes.setValues(d, d2);
            actionAttributes.setMouseActions(mouseActionArray);
            actionAttributes.setActionTrigger(actionTrigger);
            actionAttributes.setEnableSmoothing(bl);
            actionAttributes.setSmoothingValue(d3);
        } else {
            this.addAction(DEVICE_MOUSE, n, string, new ActionAttributes(mouseActionArray, actionTrigger, d, d2, bl, d3));
        }
    }

    public void setActionListener(Object object, Object object2, ViewInputActionHandler viewInputActionHandler) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DeviceKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object2 == null) {
            String string = Logging.getMessage("nullValue.ActionKeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ActionAttributesMap actionAttributesMap = this.getActionMap(object);
        if (actionAttributesMap == null) {
            String string = Logging.getMessage("nullValue.DeviceNotDefined");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ActionAttributes actionAttributes = actionAttributesMap.getActionAttributes(object2);
        if (actionAttributes == null) {
            String string = Logging.getMessage("nullValue.DeviceActionNotDefined");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (actionAttributes.getMouseActions() != null) {
            actionAttributes.setMouseActionListener(viewInputActionHandler);
        } else if (actionAttributes.getKeyActions() != null) {
            actionAttributes.setActionListener(viewInputActionHandler);
        }
    }

    protected void setDefaultDeviceAttributes() {
        this.setDeviceAttributes(DEVICE_KEYBOARD, new DeviceAttributes(1.0));
        this.setDeviceAttributes(DEVICE_MOUSE, new DeviceAttributes(1.0));
        this.setDeviceAttributes(DEVICE_MOUSE_WHEEL, new DeviceAttributes(1.0));
    }

    protected void setDeviceModifierActionMaps() {
        if (Configuration.isMacOS()) {
            this.addAction(DEVICE_MOUSE_WHEEL, 0, VIEW_VERTICAL_TRANSLATE, new ActionAttributes(verticalTransMouseWheelEvents, ActionAttributes.ActionTrigger.ON_DRAG, 0.01, 0.01, true, 0.85));
        } else {
            this.addAction(DEVICE_MOUSE_WHEEL, 0, VIEW_VERTICAL_TRANSLATE, new ActionAttributes(verticalTransMouseWheelEvents, ActionAttributes.ActionTrigger.ON_DRAG, 0.1, 0.1, true, 0.85));
        }
        this.addAction(DEVICE_MOUSE, 0, VIEW_MOVE_TO, new ActionAttributes(moveToMouseEvents, ActionAttributes.ActionTrigger.ON_PRESS, 0.95, 0.9, true, 0.0));
        this.addAction(DEVICE_MOUSE, 512, VIEW_MOVE_TO_SLOW, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_MOUSE, VIEW_MOVE_TO), 0.25));
        this.addAction(DEVICE_MOUSE, 0, VIEW_ROTATE, new ActionAttributes(rotateMouseEvents, ActionAttributes.ActionTrigger.ON_DRAG, 0.14, 0.18, true, 0.7));
        this.addAction(DEVICE_MOUSE, 64, VIEW_ROTATE_SHIFT, new ActionAttributes(rotateMouseEventsShift, ActionAttributes.ActionTrigger.ON_DRAG, 0.14, 0.18, true, 0.7));
        this.addAction(DEVICE_MOUSE, 0, VIEW_HORIZONTAL_TRANSLATE, new ActionAttributes(horizontalTransMouseEvents, ActionAttributes.ActionTrigger.ON_DRAG, 1.0E-5, 0.2, true, 0.4));
        this.addAction(DEVICE_MOUSE, 0, VIEW_VERTICAL_TRANSLATE, new ActionAttributes(verticalTransMouseEvents, ActionAttributes.ActionTrigger.ON_DRAG, 0.003, 0.003, true, 0.85));
        this.addAction(DEVICE_MOUSE, 128, VIEW_VERTICAL_TRANSLATE_CTRL, new ActionAttributes(verticalTransMouseEventsCtrl, ActionAttributes.ActionTrigger.ON_DRAG, 0.003, 0.003, true, 0.85));
        this.addAction(DEVICE_MOUSE, 256, VIEW_VERTICAL_TRANSLATE_CTRL, new ActionAttributes(verticalTransMouseEventsCtrl, ActionAttributes.ActionTrigger.ON_DRAG, 0.003, 0.003, true, 0.85));
        this.addAction(DEVICE_KEYBOARD, 64, VIEW_ROTATE_KEYS_SHIFT, new ActionAttributes(rotationKeyEvents, ActionAttributes.ActionTrigger.ON_KEY_DOWN, 64, 2.0, 2.2, true, 0.7));
        this.addAction(DEVICE_KEYBOARD, 0, VIEW_ROTATE_KEYS, new ActionAttributes(rotationKeyEventsPage, ActionAttributes.ActionTrigger.ON_KEY_DOWN, 0, 2.0, 2.2, true, 0.7));
        this.addAction(DEVICE_KEYBOARD, 576, VIEW_ROTATE_KEYS_SHIFT_SLOW, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_KEYBOARD, VIEW_ROTATE_KEYS_SHIFT), 0.25));
        this.addAction(DEVICE_KEYBOARD, 512, VIEW_ROTATE_SLOW, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_KEYBOARD, VIEW_ROTATE_KEYS), 0.25));
        this.addAction(DEVICE_KEYBOARD, 128, VIEW_ROLL_KEYS, new ActionAttributes(rollKeyEvents, ActionAttributes.ActionTrigger.ON_KEY_DOWN, 128, 2.0, 2.2, true, 0.7));
        this.addAction(DEVICE_KEYBOARD, 0, VIEW_HORIZONTAL_TRANS_KEYS, new ActionAttributes(horizontalTransKeyEvents, ActionAttributes.ActionTrigger.ON_KEY_DOWN, 0, 5.0E-6, 4.0, true, 0.4));
        this.addAction(DEVICE_KEYBOARD, 512, VIEW_HORIZONTAL_TRANSLATE_SLOW, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_KEYBOARD, VIEW_HORIZONTAL_TRANS_KEYS), 0.25));
        this.addAction(DEVICE_KEYBOARD, 0, VIEW_VERTICAL_TRANS_KEYS, new ActionAttributes(verticalTransKeyEvents, ActionAttributes.ActionTrigger.ON_KEY_DOWN, 0, 0.06, 0.06, true, 0.85));
        this.addAction(DEVICE_KEYBOARD, 512, VIEW_VERTICAL_TRANS_KEYS_SLOW, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_KEYBOARD, VIEW_VERTICAL_TRANS_KEYS), 0.25));
        this.addAction(DEVICE_KEYBOARD, 128, VIEW_VERTICAL_TRANS_KEYS_CTRL, new ActionAttributes(verticalTransKeyEventsCtrl, ActionAttributes.ActionTrigger.ON_KEY_DOWN, 128, 0.06, 0.06, true, 0.85));
        this.addAction(DEVICE_KEYBOARD, 256, VIEW_VERTICAL_TRANS_KEYS_META, this.getActionAttributes(DEVICE_KEYBOARD, VIEW_VERTICAL_TRANS_KEYS));
        this.addAction(DEVICE_KEYBOARD, 640, VIEW_VERTICAL_TRANS_KEYS_SLOW_CTRL, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_KEYBOARD, VIEW_VERTICAL_TRANS_KEYS_CTRL), 0.25));
        this.addAction(DEVICE_KEYBOARD, 640, VIEW_VERTICAL_TRANS_KEYS_SLOW_META, this.makeSlowActionAttributes(this.getActionAttributes(DEVICE_KEYBOARD, VIEW_VERTICAL_TRANS_KEYS_CTRL), 0.25));
        this.addAction(DEVICE_KEYBOARD, 0, VIEW_RESET_HEADING, new ActionAttributes(resetHeadingEvents, ActionAttributes.ActionTrigger.ON_PRESS, 0, 2.0, 2.2, true, 0.7));
        this.addAction(DEVICE_KEYBOARD, 0, VIEW_RESET_HEADING_PITCH_ROLL, new ActionAttributes(resetHeadingPitchRollEvents, ActionAttributes.ActionTrigger.ON_PRESS, 0, 2.0, 2.2, true, 0.7));
        this.addAction(DEVICE_KEYBOARD, 0, VIEW_STOP_VIEW, new ActionAttributes(stopViewEvents, ActionAttributes.ActionTrigger.ON_PRESS, 0, 0.1, 0.1, false, 0.1));
    }

    protected ActionAttributes makeSlowActionAttributes(ActionAttributes actionAttributes, double d) {
        ActionAttributes actionAttributes2 = new ActionAttributes(actionAttributes);
        double[] dArray = actionAttributes.getValues();
        actionAttributes2.setValues(dArray[0] * d, dArray[1] * d);
        actionAttributes2.setEnableSmoothing(actionAttributes.isEnableSmoothing());
        actionAttributes2.setSmoothingValue(actionAttributes.getSmoothingValue());
        actionAttributes2.setKeyCodeModifier(actionAttributes.getKeyCodeModifier());
        actionAttributes2.setKeyActions(actionAttributes.getKeyActions());
        return actionAttributes2;
    }

    public static class ActionAttributesMap {
        private Map<Object, ActionAttributes> actionMap = new HashMap<Object, ActionAttributes>();

        public ActionAttributes getActionAttributes(Object object) {
            if (object == null) {
                String string = Logging.getMessage("nullValue.ActionKeyIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.actionMap.get(object);
        }

        public void setActionAttributes(Object object, ActionAttributes actionAttributes) {
            if (object == null) {
                String string = Logging.getMessage("nullValue.ActionKeyIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (actionAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.actionMap.put(object, actionAttributes);
        }
    }

    public class DeviceModifierMap
    extends HashMap<Object, ArrayList> {
    }

    public class ActionAttributesList
    extends ArrayList<ActionAttributes> {
    }

    public static class ActionAttributes {
        public static final int NO_MODIFIER = 0;
        private double minValue;
        private double maxValue;
        private boolean enableSmoothing;
        private double smoothingValue;
        private int keyCodeModifier;
        private List keyActions;
        private List mouseActions;
        private ActionTrigger actionTrigger;
        private KeyInputActionHandler actionListener;
        private MouseInputActionHandler mouseActionListener;

        public KeyInputActionHandler getActionListener() {
            return this.actionListener;
        }

        public void setActionListener(KeyInputActionHandler keyInputActionHandler) {
            this.actionListener = keyInputActionHandler;
        }

        public MouseInputActionHandler getMouseActionListener() {
            return this.mouseActionListener;
        }

        public void setMouseActionListener(MouseInputActionHandler mouseInputActionHandler) {
            this.mouseActionListener = mouseInputActionHandler;
        }

        public ActionAttributes(KeyAction[] keyActionArray, ActionTrigger actionTrigger, int n, double d, double d2, boolean bl, double d3) {
            this.setValues(d, d2);
            this.setEnableSmoothing(bl);
            this.setSmoothingValue(d3);
            this.setKeyActions(keyActionArray);
            this.setKeyCodeModifier(n);
            this.setActionTrigger(actionTrigger);
            this.mouseActions = null;
        }

        public ActionAttributes(MouseAction[] mouseActionArray, ActionTrigger actionTrigger, double d, double d2, boolean bl, double d3) {
            this.setValues(d, d2);
            this.setEnableSmoothing(bl);
            this.setSmoothingValue(d3);
            this.setMouseActions(mouseActionArray);
            this.setActionTrigger(actionTrigger);
            this.keyActions = null;
        }

        public ActionAttributes(double d, double d2, boolean bl, double d3) {
            this.setValues(d, d2);
            this.setEnableSmoothing(bl);
            this.setSmoothingValue(d3);
        }

        public ActionAttributes(ActionAttributes actionAttributes) {
            if (actionAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.minValue = actionAttributes.minValue;
            this.maxValue = actionAttributes.maxValue;
            this.smoothingValue = actionAttributes.smoothingValue;
            this.setActionListener(actionAttributes.getActionListener());
            this.setKeyActions(actionAttributes.getKeyActions());
            this.setActionTrigger(actionAttributes.getActionTrigger());
        }

        public double[] getValues() {
            return new double[]{this.minValue, this.maxValue};
        }

        public void setValues(double d, double d2) {
            if (d <= 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "minValue <= 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (d2 <= 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxValue <= 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.minValue = d;
            this.maxValue = d2;
        }

        public void setValue(double d) {
            this.setValues(d, d);
        }

        public boolean isEnableSmoothing() {
            return this.enableSmoothing;
        }

        public void setEnableSmoothing(boolean bl) {
            this.enableSmoothing = bl;
        }

        public double getSmoothingValue() {
            return this.smoothingValue;
        }

        public void setSmoothingValue(double d) {
            if (d < 0.0 || d >= 1.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "smoothingValue < 0 || smoothingValue >= 1");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.smoothingValue = d;
        }

        public void setKeyCodeModifier(int n) {
            this.keyCodeModifier = n;
        }

        public int getKeyCodeModifier() {
            return this.keyCodeModifier;
        }

        public List getKeyActions() {
            return this.keyActions;
        }

        public void setKeyActions(KeyAction[] keyActionArray) {
            this.keyActions = Arrays.asList(keyActionArray);
        }

        public void setKeyActions(List list) {
            this.keyActions = list;
        }

        public List getMouseActions() {
            return this.mouseActions;
        }

        public void setMouseActions(MouseAction[] mouseActionArray) {
            this.mouseActions = Arrays.asList(mouseActionArray);
        }

        public void setMouseActions(List list) {
            this.mouseActions = list;
        }

        public ActionTrigger getActionTrigger() {
            return this.actionTrigger;
        }

        public void setActionTrigger(ActionTrigger actionTrigger) {
            this.actionTrigger = actionTrigger;
        }

        public static MouseAction createMouseActionAttribute(int n) {
            MouseAction mouseAction = new MouseAction(n);
            return mouseAction;
        }

        public static class KeyAction {
            public static final int KA_DIR_X = 0;
            public static final int KA_DIR_Y = 1;
            public static final int KA_DIR_Z = 2;
            public int keyCode;
            public int sign;
            public int direction;

            public KeyAction(int n, int n2, int n3) {
                this.keyCode = n;
                this.sign = n3;
                this.direction = n2;
            }
        }

        public static enum ActionTrigger {
            ON_PRESS,
            ON_DRAG,
            ON_KEY_DOWN,
            ON_RELEASE;

        }

        public static class MouseAction {
            public int mouseButton;

            public MouseAction(int n) {
                this.mouseButton = n;
            }
        }
    }

    public static class DeviceAttributes {
        private double sensitivity;

        public DeviceAttributes(double d) {
            this.setSensitivity(d);
        }

        public DeviceAttributes(DeviceAttributes deviceAttributes) {
            if (deviceAttributes == null) {
                String string = Logging.getMessage("nullValue.AttributesIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.sensitivity = deviceAttributes.sensitivity;
        }

        public double getSensitivity() {
            return this.sensitivity;
        }

        public void setSensitivity(double d) {
            if (d <= 0.0) {
                String string = Logging.getMessage("generic.ArgumentOutOfRange", "sensitivity <= 0");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.sensitivity = d;
        }
    }
}

