/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.cache.FileStoreFilter;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractFileStore
extends WWObjectImpl
implements FileStore {
    protected final List<StoreLocation> readLocations = new CopyOnWriteArrayList<StoreLocation>();
    protected StoreLocation writeLocation = null;
    private final Object fileLock = new Object();

    protected void initialize(InputStream inputStream) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.buildWritePaths(document);
            this.buildReadPaths(document);
            if (this.writeLocation == null) {
                Logging.logger().warning("FileStore.NoWriteLocation");
            }
            if (this.readLocations.size() == 0) {
                String string = Logging.getMessage("FileStore.NoReadLocations");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, iOException);
        }
    }

    protected void buildReadPaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileStore/readLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = xPath.evaluate("@isInstall", node2);
                String string5 = xPath.evaluate("@isMarkWhenUsed", node2);
                String string6 = AbstractFileStore.buildLocationPath(string, string3, string2);
                if (string6 == null) {
                    Logging.logger().log(Level.WARNING, "FileStore.LocationInvalid", string != null ? string : Logging.getMessage("generic.Unknown"));
                    continue;
                }
                StoreLocation storeLocation = this.storeLocationFor(string6);
                if (storeLocation != null) continue;
                File file = new File(string6);
                if (file.exists() && !file.isDirectory()) {
                    Logging.logger().log(Level.WARNING, "FileStore.LocationIsFile", file.getPath());
                }
                boolean bl = string4 != null && (string4.contains("t") || string4.contains("T"));
                StoreLocation storeLocation2 = new StoreLocation(file, bl);
                if (string5 != null && string5.length() > 0) {
                    storeLocation2.setMarkWhenUsed(string5.toLowerCase().contains("t"));
                }
                this.readLocations.add(storeLocation2);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, xPathExpressionException);
        }
    }

    protected void buildWritePaths(Node node) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.evaluate("/dataFileStore/writeLocations/location", node.getFirstChild(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                String string = xPath.evaluate("@property", node2);
                String string2 = xPath.evaluate("@wwDir", node2);
                String string3 = xPath.evaluate("@append", node2);
                String string4 = xPath.evaluate("@create", node2);
                String string5 = AbstractFileStore.buildLocationPath(string, string3, string2);
                if (string5 == null) {
                    Logging.logger().log(Level.WARNING, "FileStore.LocationInvalid", string != null ? string : Logging.getMessage("generic.Unknown"));
                    continue;
                }
                Logging.logger().log(Level.FINER, "FileStore.AttemptingWriteDir", string5);
                File file = new File(string5);
                if (!file.exists() && string4 != null && (string4.contains("t") || string4.contains("T"))) {
                    Logging.logger().log(Level.FINER, "FileStore.MakingDirsFor", string5);
                    file.mkdirs();
                }
                if (!file.isDirectory() || !file.canWrite() || !file.canRead()) continue;
                Logging.logger().log(Level.FINER, "FileStore.WriteLocationSuccessful", string5);
                this.writeLocation = new StoreLocation(file);
                StoreLocation storeLocation = this.storeLocationFor(string5);
                if (storeLocation != null) {
                    this.readLocations.remove(storeLocation);
                }
                this.readLocations.add(0, this.writeLocation);
                break;
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("FileStore.ExceptionReadingConfigurationFile");
            Logging.logger().severe(string);
            throw new IllegalStateException(string, xPathExpressionException);
        }
    }

    protected static String buildLocationPath(String string, String string2, String string3) {
        String string4 = AbstractFileStore.propertyToPath(string);
        if (string2 != null && string2.length() != 0) {
            string4 = WWIO.appendPathPart(string4, string2.trim());
        }
        if (string3 != null && string3.length() != 0) {
            string4 = WWIO.appendPathPart(string4, string3.trim());
        }
        return string4;
    }

    protected static String propertyToPath(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.alluser.store")) {
            return AbstractFileStore.determineAllUserLocation();
        }
        if (string.equalsIgnoreCase("gov.nasa.worldwind.platform.user.store")) {
            return AbstractFileStore.determineSingleUserLocation();
        }
        return null;
    }

    protected static String determineAllUserLocation() {
        if (Configuration.isMacOS()) {
            return "/Library/Caches";
        }
        if (Configuration.isWindowsOS()) {
            String string = System.getenv("ALLUSERSPROFILE");
            if (string == null) {
                Logging.logger().severe("generic.AllUsersWindowsProfileNotKnown");
                return null;
            }
            return string + (Configuration.isWindows7OS() ? "" : "\\Application Data");
        }
        if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            return "/var/cache/";
        }
        Logging.logger().warning("generic.UnknownOperatingSystem");
        return null;
    }

    protected static String determineSingleUserLocation() {
        String string = AbstractFileStore.getUserHomeDir();
        if (string == null) {
            Logging.logger().warning("generic.UsersHomeDirectoryNotKnown");
            return null;
        }
        String string2 = null;
        if (Configuration.isMacOS()) {
            string2 = "/Library/Caches";
        } else if (Configuration.isWindowsOS()) {
            string2 = "\\Application Data";
        } else if (Configuration.isLinuxOS() || Configuration.isUnixOS() || Configuration.isSolarisOS()) {
            string2 = "/var/cache/";
        } else {
            Logging.logger().fine("generic.UnknownOperatingSystem");
        }
        if (string2 == null) {
            return null;
        }
        return string + string2;
    }

    protected static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    @Override
    public List<? extends File> getLocations() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (StoreLocation storeLocation : this.readLocations) {
            arrayList.add(storeLocation.getFile());
        }
        return arrayList;
    }

    @Override
    public File getWriteLocation() {
        return this.writeLocation != null ? this.writeLocation.getFile() : null;
    }

    @Override
    public void addLocation(String string, boolean bl) {
        this.addLocation(this.readLocations.size(), string, bl);
    }

    @Override
    public void addLocation(int n, String string, boolean bl) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n < 0) {
            String string3 = Logging.getMessage("generic.InvalidIndex", n);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        StoreLocation storeLocation = this.storeLocationFor(string);
        if (storeLocation != null) {
            this.readLocations.remove(storeLocation);
        }
        if (n > 0 && n > this.readLocations.size()) {
            n = this.readLocations.size();
        }
        File file = new File(string);
        StoreLocation storeLocation2 = new StoreLocation(file, bl);
        this.readLocations.add(n, storeLocation2);
    }

    @Override
    public void removeLocation(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            return;
        }
        StoreLocation storeLocation = this.storeLocationFor(string);
        if (storeLocation == null) {
            return;
        }
        if (storeLocation.equals(this.writeLocation)) {
            String string3 = Logging.getMessage("FileStore.CannotRemoveWriteLocation", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.readLocations.remove(storeLocation);
    }

    @Override
    public boolean isInstallLocation(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FileStorePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StoreLocation storeLocation = this.storeLocationFor(string);
        return storeLocation != null && storeLocation.isInstall();
    }

    protected StoreLocation storeLocationFor(String string) {
        File file = new File(string);
        for (StoreLocation storeLocation : this.readLocations) {
            if (!file.equals(storeLocation.getFile())) continue;
            return storeLocation;
        }
        return null;
    }

    @Override
    public boolean containsFile(String string) {
        if (string == null) {
            return false;
        }
        for (StoreLocation storeLocation : this.readLocations) {
            File file = storeLocation.getFile();
            File file2 = string.startsWith(file.getAbsolutePath()) ? new File(string) : AbstractFileStore.makeAbsoluteFile(file, string);
            if (!file2.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public URL findFile(String string, boolean bl) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bl) {
            Object object = this.getClass().getClassLoader().getResource(string);
            if (object != null) {
                return object;
            }
            ClassLoader object2 = Thread.currentThread().getContextClassLoader();
            if (object2 != null && (object = object2.getResource(string)) != null) {
                return object;
            }
        }
        for (StoreLocation storeLocation : this.readLocations) {
            File file;
            File file2 = storeLocation.getFile();
            if (!file2.exists() || !(file = new File(AbstractFileStore.makeAbsolutePath(file2, string))).exists()) continue;
            try {
                if (storeLocation.isMarkWhenUsed()) {
                    AbstractFileStore.markFileUsed(file);
                } else {
                    AbstractFileStore.markFileUsed(file.getParentFile());
                }
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("FileStore.ExceptionCreatingURLForFile", file.getPath()), malformedURLException);
            }
        }
        return null;
    }

    protected static void markFileUsed(File file) {
        if (file == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (file.canWrite()) {
            file.setLastModified(l);
        }
        if (file.isDirectory()) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 != null && file2.canWrite()) {
            file2.setLastModified(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File newFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.writeLocation != null) {
            String string3 = AbstractFileStore.makeAbsolutePath(this.writeLocation.getFile(), string);
            File file = new File(string3);
            boolean bl = false;
            Object object = this.fileLock;
            synchronized (object) {
                if (file.getParentFile().exists()) {
                    bl = true;
                } else if (file.getParentFile().mkdirs()) {
                    bl = true;
                }
            }
            if (bl) {
                return file;
            }
            object = Logging.getMessage("generic.CannotCreateFile", string3);
            Logging.logger().severe((String)object);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            File file = new File(uRL.toURI());
            Object object = this.fileLock;
            synchronized (object) {
                if (file.exists()) {
                    String string = file.getParent();
                    if (!string.startsWith(this.getWriteLocation().getPath()) && !string.startsWith(Configuration.getSystemTempDirectory())) {
                        return;
                    }
                    file.delete();
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("FileStore.ExceptionRemovingFile", uRL.toString()), uRISyntaxException);
        }
    }

    protected static File makeAbsoluteFile(File file, String string) {
        return new File(file.getAbsolutePath() + "/" + string);
    }

    protected static String makeAbsolutePath(File file, String string) {
        return file.getAbsolutePath() + "/" + string;
    }

    protected static String normalizeFileStoreName(String string) {
        String string2 = string.replaceAll("\\\\", "/");
        string2 = WWIO.stripLeadingSeparator(string2);
        string2 = WWIO.stripTrailingSeparator(string2);
        return string2;
    }

    protected static String storePathForFile(StoreLocation storeLocation, File file) {
        String string;
        String string2 = file.getPath();
        if (storeLocation != null && string2.startsWith(string = storeLocation.getFile().getPath())) {
            string2 = string2.substring(string.length(), string2.length());
        }
        return string2;
    }

    @Override
    public String[] listFileNames(String string, FileStoreFilter fileStoreFilter) {
        if (fileStoreFilter == null) {
            String string2 = Logging.getMessage("nullValue.FilterIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.doListFileNames(string, fileStoreFilter, false, false);
    }

    @Override
    public String[] listAllFileNames(String string, FileStoreFilter fileStoreFilter) {
        if (fileStoreFilter == null) {
            String string2 = Logging.getMessage("nullValue.FilterIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.doListFileNames(string, fileStoreFilter, true, false);
    }

    @Override
    public String[] listTopFileNames(String string, FileStoreFilter fileStoreFilter) {
        if (fileStoreFilter == null) {
            String string2 = Logging.getMessage("nullValue.FilterIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.doListFileNames(string, fileStoreFilter, true, true);
    }

    protected String[] doListFileNames(String string, FileStoreFilter fileStoreFilter, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = null;
        for (StoreLocation storeLocation : this.readLocations) {
            File file = storeLocation.getFile();
            if (string != null) {
                file = new File(AbstractFileStore.makeAbsolutePath(file, string));
            }
            if (!file.exists()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            this.doListFileNames(storeLocation, file, fileStoreFilter, bl, bl2, arrayList);
        }
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected void doListFileNames(StoreLocation storeLocation, File file, FileStoreFilter fileStoreFilter, boolean bl, boolean bl2, Collection<String> collection) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (file2 == null) continue;
            if (file2.isDirectory()) {
                arrayList.add(file2);
                continue;
            }
            if (!this.listFile(storeLocation, file2, fileStoreFilter, collection) || !bl2) continue;
            return;
        }
        if (!bl) {
            return;
        }
        for (File file3 : arrayList) {
            this.doListFileNames(storeLocation, file3, fileStoreFilter, bl, bl2, collection);
        }
    }

    protected boolean listFile(StoreLocation storeLocation, File file, FileStoreFilter fileStoreFilter, Collection<String> collection) {
        String string = AbstractFileStore.storePathForFile(storeLocation, file);
        if (string == null) {
            return false;
        }
        String string2 = AbstractFileStore.normalizeFileStoreName(string);
        return this.listFileName(storeLocation, string2, fileStoreFilter, collection);
    }

    protected boolean listFileName(StoreLocation storeLocation, String string, FileStoreFilter fileStoreFilter, Collection<String> collection) {
        if (!fileStoreFilter.accept(this, string)) {
            return false;
        }
        collection.add(string);
        return true;
    }

    protected static class StoreLocation
    extends AVListImpl {
        protected boolean markWhenUsed = false;

        public StoreLocation(File file, boolean bl) {
            this.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", file);
            this.setValue("gov.nasa.worldwind.avkey.Installed", bl);
        }

        public StoreLocation(File file) {
            this(file, false);
        }

        public File getFile() {
            Object object = this.getValue("gov.nasa.worldwind.avkey.FileStoreLocation");
            return object != null && object instanceof File ? (File)object : null;
        }

        public void setFile(File file) {
            this.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", file);
        }

        public boolean isInstall() {
            Object object = this.getValue("gov.nasa.worldwind.avkey.Installed");
            return object != null && object instanceof Boolean ? (Boolean)object : false;
        }

        public void setInstall(boolean bl) {
            this.setValue("gov.nasa.worldwind.avkey.Installed", bl);
        }

        public boolean isMarkWhenUsed() {
            return this.markWhenUsed;
        }

        public void setMarkWhenUsed(boolean bl) {
            this.markWhenUsed = bl;
        }
    }
}

