/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.AbstractFileStore;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class BasicDataFileStore
extends AbstractFileStore {
    protected static final long TIMEOUT = 5000L;
    protected static final List<String> DEFAULT_CACHE_CONTENT_TYPES = Arrays.asList("application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kmz", "model/collada+xml", "image/dds", "image/gif", "image/jpeg", "image/jpg", "image/png");
    protected BasicMemoryCache db = new BasicMemoryCache(300000L, 500000L);
    protected AbsentResourceList absentResources = new AbsentResourceList(2000, 3, 500, 60000);
    protected List<String> cacheContentTypes = new ArrayList<String>(DEFAULT_CACHE_CONTENT_TYPES);

    public BasicDataFileStore() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.DataFileStoreConfigurationFileName");
        if (string == null) {
            String string2 = Logging.getMessage("FileStore.NoConfiguration");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        InputStream inputStream = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string3 = Logging.getMessage("FileStore.LocalConfigFileNotFound", string);
                Logging.logger().finest(string3);
            }
        }
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            String string4 = Logging.getMessage("FileStore.ConfigurationNotFound", string);
            Logging.logger().severe(string4);
            throw new IllegalStateException(string4);
        }
        this.initialize(inputStream);
    }

    public BasicDataFileStore(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\"?>");
        stringBuilder.append("<dataFileStore><writeLocations><location wwDir=\"");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append("\" create=\"true\"/></writeLocations></dataFileStore>");
        this.initialize(WWIO.getInputStreamFromString(stringBuilder.toString()));
    }

    @Override
    protected void initialize(InputStream inputStream) {
        super.initialize(inputStream);
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.CacheContentTypes");
        if (string != null) {
            String[] stringArray;
            this.cacheContentTypes.clear();
            for (String string2 : stringArray = string.split(",")) {
                if (WWUtil.isEmpty(string2 = string2.trim())) continue;
                this.cacheContentTypes.add(string2);
            }
        }
    }

    protected AbsentResourceList getAbsentResourceList() {
        return this.absentResources;
    }

    protected List<String> getCacheContentTypes() {
        return this.cacheContentTypes;
    }

    @Override
    public String getContentType(String string) {
        if (string == null) {
            return null;
        }
        DBEntry dBEntry = (DBEntry)this.db.getObject(string);
        return dBEntry != null ? dBEntry.contentType : null;
    }

    @Override
    public long getExpirationTime(String string) {
        if (string == null) {
            return 0L;
        }
        DBEntry dBEntry = (DBEntry)this.db.getObject(string);
        return dBEntry != null ? dBEntry.expiration : 0L;
    }

    @Override
    public synchronized void removeFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AddressIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        DBEntry dBEntry = (DBEntry)this.db.getObject(string);
        if (dBEntry == null) {
            return;
        }
        this.removeFile(dBEntry.localUrl);
        this.db.remove(string);
    }

    @Override
    public synchronized URL requestFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AddressIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        return this.requestFile(string, true);
    }

    @Override
    public synchronized URL requestFile(String string, boolean bl) {
        URL uRL;
        URL uRL2;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AddressIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        if (this.getAbsentResourceList().isResourceAbsent(string)) {
            return null;
        }
        DBEntry dBEntry = (DBEntry)this.db.getObject(string);
        if (dBEntry != null) {
            boolean bl2;
            long l = System.currentTimeMillis();
            boolean bl3 = bl2 = dBEntry.expiration != 0L && l > dBEntry.expiration;
            if (dBEntry.state == 2 && !bl2) {
                return dBEntry.localUrl;
            }
            if (dBEntry.state == 1 && l - dBEntry.lastUpdateTime <= 5000L) {
                return null;
            }
        }
        if ((uRL2 = (uRL = WWIO.makeURL(string)) != null && "file".equalsIgnoreCase(uRL.getProtocol()) ? uRL : this.getLocalFileUrl(string, uRL, bl)) != null) {
            return uRL2;
        }
        if (uRL != null && !this.getAbsentResourceList().isResourceAbsent(string)) {
            this.makeLocal(string, uRL, bl);
        } else if (uRL == null) {
            this.getAbsentResourceList().markResourceAbsent(string);
        }
        return null;
    }

    protected synchronized URL getLocalFileUrl(String string, URL uRL, boolean bl) {
        Object object;
        Object object2;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object3 = null;
        if (string.trim().startsWith("jar:") && WWIO.isLocalJarAddress((URL)(object2 = WWIO.makeURL(string)))) {
            if (this.getJarLength((URL)object2) > 0) {
                object3 = object2;
            } else {
                this.getAbsentResourceList().markResourceAbsent(string);
                return null;
            }
        }
        Object object4 = object2 = uRL != null ? uRL.getProtocol() : null;
        if (object3 == null && (object2 == null || ((String)object2).equals("file")) && ((File)(object = new File(string))).exists()) {
            try {
                object3 = ((File)object).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (object3 == null && (object2 == null || ((String)object2).equals("file"))) {
            object3 = WorldWind.getDataFileStore().findFile(string, true);
        }
        if (object3 == null && uRL != null && bl) {
            object = this.makeCachePath(uRL, null);
            object3 = WorldWind.getDataFileStore().findFile((String)object, true);
            String string3 = WWIO.getSuffix((String)object);
            if (object3 == null && (string3 == null || string3.length() > 4)) {
                for (String string4 : this.getCacheContentTypes()) {
                    String string5 = (String)object + WWIO.makeSuffixForMimeType(string4);
                    object3 = WorldWind.getDataFileStore().findFile(string5, true);
                    if (object3 == null) continue;
                    break;
                }
            }
        }
        if (object3 != null) {
            object = new DBEntry(string);
            ((DBEntry)object).localUrl = object3;
            ((DBEntry)object).state = 2;
            ((DBEntry)object).contentType = WWIO.makeMimeTypeForSuffix(WWIO.getSuffix(((URL)object3).getPath()));
            this.db.add(string, (Cacheable)object);
            this.getAbsentResourceList().unmarkResourceAbsent(string);
            return object3;
        }
        return null;
    }

    protected int getJarLength(URL uRL) {
        try {
            return uRL.openConnection().getContentLength();
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.JarOpenFailed", uRL.toString());
            Logging.logger().log(Level.WARNING, string, iOException);
            return -1;
        }
    }

    protected synchronized void makeLocal(String string, URL uRL, boolean bl) {
        if (WorldWind.getNetworkStatus().isHostUnavailable(uRL) || !WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        DBEntry dBEntry = new DBEntry(string);
        this.db.add(string, dBEntry);
        dBEntry.state = 1;
        URLRetriever uRLRetriever = URLRetriever.createRetriever(uRL, new PostProcessor(string, uRL, bl));
        if (uRLRetriever != null && !WorldWind.getRetrievalService().contains(uRLRetriever)) {
            WorldWind.getRetrievalService().runRetriever(uRLRetriever);
        }
    }

    protected synchronized void updateEntry(String string, URL uRL, long l) {
        DBEntry dBEntry = (DBEntry)this.db.getObject(string);
        if (dBEntry == null) {
            return;
        }
        dBEntry.state = 2;
        dBEntry.localUrl = uRL;
        dBEntry.contentType = WWIO.makeMimeTypeForSuffix(WWIO.getSuffix(uRL.getPath()));
        dBEntry.expiration = l;
        dBEntry.lastUpdateTime = System.currentTimeMillis();
    }

    protected String makeCachePath(URL uRL, String string) {
        if ("jar".equals(uRL.getProtocol())) {
            return this.makeJarURLCachePath(uRL, string);
        }
        return this.makeGenericURLCachePath(uRL, string);
    }

    protected String makeGenericURLCachePath(URL uRL, String string) {
        String string2;
        String string3 = WWIO.replaceIllegalFileNameCharacters(uRL.getHost());
        String string4 = WWIO.replaceIllegalFileNameCharacters(uRL.getPath());
        Object object = string4;
        if (!WWUtil.isEmpty(uRL.getQuery())) {
            string2 = this.removePrivateQueryParameters(uRL.getQuery());
            if (!WWUtil.isEmpty(string2 = WWIO.replaceIllegalFileNameCharacters(string2))) {
                object = string4 + "_" + string2;
            }
        }
        if ((string2 = String.valueOf(Math.abs(((String)object).hashCode()))).length() > 4) {
            string2 = string2.substring(0, 4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        stringBuilder.append(File.separator);
        stringBuilder.append((String)object);
        String string5 = this.makeSuffix((String)object, string);
        if (string5 != null) {
            stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    protected String makeJarURLCachePath(URL uRL, String string) {
        String string2 = uRL.getPath();
        URL uRL2 = WWIO.makeURL(string2);
        String string3 = WWIO.replaceIllegalFileNameCharacters(uRL2.getHost());
        String string4 = WWIO.replaceIllegalFileNameCharacters(uRL2.getPath().replace("!/", "#"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append(File.separator);
        stringBuilder.append(string4);
        String string5 = this.makeSuffix(string4, string);
        if (string5 != null) {
            stringBuilder.append(string5);
        }
        return stringBuilder.toString();
    }

    protected File makeTempFile(URL uRL, String string) {
        Object object = this.makeSuffix(uRL.toString(), string);
        if (object == null) {
            object = WWIO.getSuffix(uRL.toString());
        }
        if (!((String)object).startsWith(".")) {
            object = "." + (String)object;
        }
        try {
            File file = File.createTempFile("wwfs", (String)object);
            file.deleteOnExit();
            return file;
        }
        catch (IOException iOException) {
            String string2 = Logging.getMessage("generic.CannotCreateTempFile");
            Logging.logger().fine(string2);
            return null;
        }
    }

    protected String makeSuffix(String string, String string2) {
        String string3 = string2 != null ? WWIO.makeSuffixForMimeType(string2) : null;
        String string4 = WWIO.getSuffix(string);
        if (string4 != null && string4.equalsIgnoreCase("jpeg")) {
            string4 = "jpg";
        }
        if (!(string3 == null || string4 != null && string4.equalsIgnoreCase(string3.substring(1)))) {
            return string3;
        }
        return null;
    }

    protected String removePrivateQueryParameters(String string) {
        if (WWUtil.isEmpty(string)) {
            return string;
        }
        String string2 = string.replaceAll("(?i)\\Qconnectid\\E\\=[^&]*\\&?", "");
        if (string2.endsWith("&")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    protected static class DBEntry
    implements Cacheable {
        protected static final int NONE = 0;
        protected static final int PENDING = 1;
        protected static final int LOCAL = 2;
        protected String name;
        protected String contentType;
        protected long expiration;
        protected URL localUrl;
        protected long lastUpdateTime;
        protected int state;

        public DBEntry(String string) {
            this.name = string;
            this.state = 0;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        @Override
        public long getSizeInBytes() {
            return 40 + (this.name != null ? 2 * this.name.length() : 0);
        }
    }

    protected class PostProcessor
    extends AbstractRetrievalPostProcessor {
        protected String address;
        protected URL retrievalUrl;
        protected URL localFileUrl = null;
        protected File outputFile = null;
        protected boolean saveInLocalCache;

        public PostProcessor(String string, URL uRL, boolean bl) {
            this.address = string;
            this.retrievalUrl = uRL;
            this.saveInLocalCache = bl;
        }

        @Override
        protected boolean overwriteExistingFile() {
            return true;
        }

        @Override
        protected File doGetOutputFile() {
            if (this.outputFile == null) {
                this.outputFile = this.makeOutputFile();
            }
            return this.outputFile;
        }

        protected File makeOutputFile() {
            String string = BasicDataFileStore.this.makeCachePath(this.retrievalUrl, this.getRetriever().getContentType());
            File file = this.saveInLocalCache && string.length() <= 255 ? WorldWind.getDataFileStore().newFile(string) : BasicDataFileStore.this.makeTempFile(this.retrievalUrl, this.getRetriever().getContentType());
            if (file == null) {
                return null;
            }
            try {
                this.localFileUrl = file.toURI().toURL();
                return file;
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = Logging.getMessage("generic.MalformedURL", file.toURI());
                Logging.logger().finest(string2);
                return null;
            }
        }

        @Override
        protected boolean saveBuffer() throws IOException {
            boolean bl = super.saveBuffer();
            BasicDataFileStore.this.updateEntry(this.address, this.localFileUrl, this.getRetriever().getExpirationTime());
            return bl;
        }

        @Override
        protected ByteBuffer handleSuccessfulRetrieval() {
            ByteBuffer byteBuffer = super.handleSuccessfulRetrieval();
            BasicDataFileStore.this.firePropertyChange(new PropertyChangeEvent(BasicDataFileStore.this, "gov.nasa.worldwind.avkey.RetrievalStateSuccessful", this.retrievalUrl, this.localFileUrl));
            return byteBuffer;
        }

        @Override
        protected void markResourceAbsent() {
            BasicDataFileStore.this.getAbsentResourceList().markResourceAbsent(this.address);
        }

        @Override
        protected ByteBuffer handleTextContent() throws IOException {
            this.saveBuffer();
            return this.getRetriever().getBuffer();
        }
    }
}

