/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.util.Logging;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class BasicMemoryCache
implements MemoryCache {
    protected ConcurrentHashMap<Object, CacheEntry> entries;
    protected CopyOnWriteArrayList<MemoryCache.CacheListener> listeners;
    protected AtomicLong capacity = new AtomicLong();
    protected AtomicLong currentUsedCapacity = new AtomicLong();
    protected Long lowWater;
    protected String name = "";
    protected final Object lock = new Object();

    public BasicMemoryCache(long l, long l2) {
        this.entries = new ConcurrentHashMap();
        this.listeners = new CopyOnWriteArrayList();
        this.capacity.set(l2);
        this.lowWater = l;
        this.currentUsedCapacity.set(0L);
    }

    @Override
    public int getNumObjects() {
        return this.entries.size();
    }

    @Override
    public long getCapacity() {
        return this.capacity.get();
    }

    @Override
    public long getUsedCapacity() {
        return this.currentUsedCapacity.get();
    }

    @Override
    public long getFreeCapacity() {
        return Math.max(this.capacity.get() - this.currentUsedCapacity.get(), 0L);
    }

    @Override
    public void setName(String string) {
        this.name = string != null ? string : "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addCacheListener(MemoryCache.CacheListener cacheListener) {
        if (cacheListener == null) {
            String string = Logging.getMessage("BasicMemoryCache.nullListenerAdded");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.listeners.add(cacheListener);
    }

    @Override
    public void removeCacheListener(MemoryCache.CacheListener cacheListener) {
        if (cacheListener == null) {
            String string = Logging.getMessage("BasicMemoryCache.nullListenerRemoved");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.listeners.remove(cacheListener);
    }

    @Override
    public void setCapacity(long l) {
        this.capacity.set(l);
    }

    @Override
    public void setLowWater(long l) {
        if (l < this.capacity.get() && l >= 0L) {
            this.lowWater = l;
        }
    }

    @Override
    public long getLowWater() {
        return this.lowWater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            return this.entries.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object object, Object object2, long l) {
        long l2 = this.capacity.get();
        if (object == null || object2 == null || l <= 0L || l > l2) {
            Object object3 = Logging.getMessage("BasicMemoryCache.CacheItemNotAdded");
            if (l > l2) {
                object3 = (String)object3 + " - " + Logging.getMessage("BasicMemoryCache.ItemTooLargeForCache");
            }
            Logging.logger().warning((String)object3);
            return false;
        }
        CacheEntry cacheEntry = new CacheEntry(object, object2, l);
        Object object4 = this.lock;
        synchronized (object4) {
            CacheEntry cacheEntry2 = this.entries.get(object);
            if (cacheEntry2 != null) {
                this.removeEntry(cacheEntry2);
            }
            if (this.currentUsedCapacity.get() + l > l2) {
                this.makeSpace(l);
            }
            this.currentUsedCapacity.addAndGet(l);
            this.entries.putIfAbsent(cacheEntry.key, cacheEntry);
        }
        return true;
    }

    @Override
    public boolean add(Object object, Cacheable cacheable) {
        return this.add(object, cacheable, cacheable.getSizeInBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object object) {
        if (object == null) {
            Logging.logger().finer("nullValue.KeyIsNull");
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            CacheEntry cacheEntry = this.entries.get(object);
            if (cacheEntry != null) {
                this.removeEntry(cacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Object object) {
        CacheEntry cacheEntry;
        if (object == null) {
            Logging.logger().finer("nullValue.KeyIsNull");
            return null;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            cacheEntry = this.entries.get(object);
            if (cacheEntry == null) {
                return null;
            }
            cacheEntry.lastUsed = System.nanoTime();
        }
        return cacheEntry.clientObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (CacheEntry cacheEntry : this.entries.values()) {
                this.removeEntry(cacheEntry);
            }
        }
    }

    protected void removeEntry(CacheEntry cacheEntry) {
        if (this.entries.remove(cacheEntry.key) != null) {
            this.currentUsedCapacity.addAndGet(-cacheEntry.clientObjectSize);
            for (MemoryCache.CacheListener cacheListener : this.listeners) {
                try {
                    cacheListener.entryRemoved(cacheEntry.key, cacheEntry.clientObject);
                }
                catch (Exception exception) {
                    cacheListener.removalException(exception, cacheEntry.key, cacheEntry.clientObject);
                }
            }
        }
    }

    private void makeSpace(long l) {
        if (l > this.capacity.get() || l < 0L) {
            return;
        }
        CacheEntry[] cacheEntryArray = new CacheEntry[this.entries.size()];
        Arrays.sort(this.entries.values().toArray(cacheEntryArray));
        int n = 0;
        while (this.getFreeCapacity() < l || this.getUsedCapacity() > this.lowWater) {
            if (n >= cacheEntryArray.length) continue;
            this.removeEntry(cacheEntryArray[n++]);
        }
    }

    public String toString() {
        return "MemoryCache " + this.name + " max size = " + this.getCapacity() + " current size = " + this.currentUsedCapacity.get() + " number of items: " + this.getNumObjects();
    }

    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    protected static class CacheEntry
    implements Comparable<CacheEntry> {
        Object key;
        Object clientObject;
        protected long lastUsed;
        protected long clientObjectSize;

        CacheEntry(Object object, Object object2, long l) {
            this.key = object;
            this.clientObject = object2;
            this.lastUsed = System.nanoTime();
            this.clientObjectSize = l;
        }

        @Override
        public int compareTo(CacheEntry cacheEntry) {
            if (cacheEntry == null) {
                String string = Logging.getMessage("nullValue.CacheEntryIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.lastUsed < cacheEntry.lastUsed ? -1 : (this.lastUsed == cacheEntry.lastUsed ? 0 : 1);
        }

        public String toString() {
            return this.key.toString() + " " + this.clientObject.toString() + " " + this.lastUsed + " " + this.clientObjectSize;
        }
    }
}

