/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.cache;

import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;

public class FileStoreSource {
    private Object lock = new Object();
    protected FileStore fileStore;
    protected String fName;

    public FileStoreSource(FileStore fileStore, String string) {
        this.fileStore = fileStore;
        this.fName = string;
    }

    public boolean exists() {
        return this.fileStore.containsFile(this.fName);
    }

    public String getFileName() {
        return this.fName;
    }

    public File getFile() {
        URL uRL = this.fileStore.findFile(this.fName, false);
        if (uRL != null) {
            try {
                return new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                Logging.logger().warning("invalid filesystem URI: " + uRL);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFileContentsAsBytes() {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getFile();
            if (file != null) {
                try {
                    return Files.readAllBytes(file.toPath());
                }
                catch (IOException iOException) {
                    Logging.logger().warning("error reading cached file: " + iOException);
                }
            }
        }
        return null;
    }

    public ByteBuffer getFileContentsAsByteBuffer() {
        byte[] byArray = this.getFileContentsAsBytes();
        if (byArray != null) {
            return ByteBuffer.wrap(byArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFileContents(ByteBuffer byteBuffer) {
        try {
            Object object = this.lock;
            synchronized (object) {
                File file = this.fileStore.newFile(this.fName);
                FileChannel fileChannel = new FileOutputStream(file, false).getChannel();
                fileChannel.write(byteBuffer);
                fileChannel.close();
            }
        }
        catch (IOException iOException) {
            Logging.logger().warning("error writing cached file: " + iOException);
        }
    }

    public String toString() {
        return "FileStoreSource(" + this.fName + ")";
    }
}

