/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractDataRasterReader
extends AVListImpl
implements DataRasterReader {
    protected final String description;
    protected final String[] mimeTypes;
    protected final String[] suffixes;

    protected abstract boolean doCanRead(Object var1, AVList var2);

    protected abstract DataRaster[] doRead(Object var1, AVList var2) throws IOException;

    protected abstract void doReadMetadata(Object var1, AVList var2) throws IOException;

    public AbstractDataRasterReader(String string, String[] stringArray, String[] stringArray2) {
        this.description = string;
        this.mimeTypes = Arrays.copyOf(stringArray, stringArray.length);
        this.suffixes = Arrays.copyOf(stringArray2, stringArray2.length);
        this.setValue("gov.nasa.worldwind.avkey.ServiceName", "Offline");
    }

    public AbstractDataRasterReader(String[] stringArray, String[] stringArray2) {
        this(AbstractDataRasterReader.descriptionFromSuffixes(stringArray2), stringArray, stringArray2);
    }

    protected AbstractDataRasterReader(String string) {
        this(string, new String[0], new String[0]);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getMimeTypes() {
        String[] stringArray = new String[this.mimeTypes.length];
        System.arraycopy(this.mimeTypes, 0, stringArray, 0, this.mimeTypes.length);
        return stringArray;
    }

    @Override
    public String[] getSuffixes() {
        String[] stringArray = new String[this.suffixes.length];
        System.arraycopy(this.suffixes, 0, stringArray, 0, this.suffixes.length);
        return stringArray;
    }

    @Override
    public boolean canRead(Object object, AVList aVList) {
        if (object == null) {
            return false;
        }
        if (!this.canReadSuffix(object)) {
            return false;
        }
        return this.doCanRead(object, aVList);
    }

    protected boolean canReadSuffix(Object object) {
        String string = WWIO.getSourcePath(object);
        if (string == null) {
            return true;
        }
        String string2 = WWIO.getSuffix(string);
        boolean bl = false;
        for (String string3 : this.suffixes) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public DataRaster[] read(Object object, AVList aVList) throws IOException {
        if (!this.canRead(object, aVList)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        return this.doRead(object, aVList);
    }

    @Override
    public AVList readMetadata(Object object, AVList aVList) throws IOException {
        if (!this.canRead(object, aVList)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        this.doReadMetadata(object, aVList);
        String string = this.validateMetadata(object, aVList);
        if (string != null) {
            throw new IOException(string);
        }
        return aVList;
    }

    protected String validateMetadata(Object object, AVList aVList) {
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        Object object3 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avkey.Width") : null;
        if (object2 == null || !(object2 instanceof Integer)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSizeSpecified", object));
        }
        Object object4 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avkey.Height") : null;
        if (object2 == null || !(object2 instanceof Integer)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSizeSpecified", object));
        }
        Object object5 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avKey.Sector") : null;
        if (object2 == null || !(object2 instanceof Sector)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSectorSpecified", object));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isImageryRaster(Object object, AVList aVList) {
        if (aVList != null && "gov.nasa.worldwind.avkey.Image".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            return true;
        }
        try {
            AVList aVList2 = this.readMetadata(object, aVList);
            return aVList2 != null && "gov.nasa.worldwind.avkey.Image".equals(aVList2.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean isElevationsRaster(Object object, AVList aVList) {
        if (aVList != null && "gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            return true;
        }
        try {
            AVList aVList2 = this.readMetadata(object, aVList);
            return aVList2 != null && "gov.nasa.worldwind.avkey.Elevation".equals(aVList2.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"));
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static String descriptionFromSuffixes(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.").append(string.toLowerCase());
        }
        return stringBuilder.toString();
    }
}

