/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class CachedDataRaster
extends AVListImpl
implements DataRaster {
    protected Object dataSource = null;
    protected DataRasterReader dataReader = null;
    protected MemoryCache rasterCache = null;
    protected MemoryCache.CacheListener cacheListener = null;
    protected final Object rasterUsageLock = new Object();
    protected final Object rasterRetrievalLock = new Object();
    protected String[] requiredKeys = new String[]{"gov.nasa.worldwind.avKey.Sector", "gov.nasa.worldwind.avkey.PixelFormat"};

    public CachedDataRaster(Object object, AVList aVList, DataRasterReader dataRasterReader, MemoryCache memoryCache) throws IOException, IllegalArgumentException {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRasterReader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        aVList = null == aVList ? new AVListImpl() : aVList;
        this.assembleMetadata(object, aVList, dataRasterReader);
        this.dataSource = object;
        this.dataReader = dataRasterReader;
        this.setValues(aVList.copy());
        this.rasterCache = memoryCache;
        if (this.rasterCache != null) {
            this.cacheListener = new CacheListener(this.dataSource);
            this.rasterCache.addCacheListener(this.cacheListener);
        }
    }

    protected void assembleMetadata(Object object, AVList aVList, DataRasterReader dataRasterReader) throws IOException, IllegalArgumentException {
        if (!this.hasRequiredMetadata(aVList, ErrorHandlerMode.DISABLE_EXCEPTIONS)) {
            if (!dataRasterReader.canRead(object, aVList)) {
                String string = Logging.getMessage("DataRaster.CannotRead", object);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            if (!this.hasRequiredMetadata(aVList, ErrorHandlerMode.DISABLE_EXCEPTIONS)) {
                dataRasterReader.readMetadata(object, aVList);
                this.hasRequiredMetadata(aVList, ErrorHandlerMode.ALLOW_EXCEPTIONS);
            }
        }
    }

    protected String[] getRequiredKeysList() {
        return this.requiredKeys;
    }

    protected boolean hasRequiredMetadata(AVList aVList, ErrorHandlerMode errorHandlerMode) throws IllegalArgumentException {
        String[] stringArray = this.getRequiredKeysList();
        if (null == aVList || aVList.getEntries().size() == 0) {
            return null == stringArray || stringArray.length == 0;
        }
        if (null != stringArray && stringArray.length > 0) {
            for (String string : stringArray) {
                Object object = aVList.getValue(string);
                if (!WWUtil.isEmpty(object)) continue;
                if (errorHandlerMode == ErrorHandlerMode.ALLOW_EXCEPTIONS) {
                    String string2 = Logging.getMessage("generic.MissingRequiredParameter", string);
                    Logging.logger().finest(string2);
                    throw new IllegalArgumentException(string2);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public int getWidth() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.Width");
        if (null != object && object instanceof Integer) {
            return (Integer)object;
        }
        throw new WWRuntimeException(Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Width"));
    }

    @Override
    public int getHeight() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.Height");
        if (null != object && object instanceof Integer) {
            return (Integer)object;
        }
        throw new WWRuntimeException(Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Height"));
    }

    @Override
    public Sector getSector() {
        Object object = this.getValue("gov.nasa.worldwind.avKey.Sector");
        if (null != object && object instanceof Sector) {
            return (Sector)object;
        }
        throw new WWRuntimeException(Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avKey.Sector"));
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public AVList getParams() {
        return this.getMetadata();
    }

    public AVList getMetadata() {
        return this.copy();
    }

    public DataRasterReader getDataRasterReader() {
        return this.dataReader;
    }

    @Override
    public void dispose() {
        String string = Logging.getMessage("generic.ExceptionWhileDisposing", this.dataSource);
        Logging.logger().severe(string);
        throw new IllegalStateException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataRaster[] getDataRasters() throws IOException, WWRuntimeException {
        Object object = this.rasterRetrievalLock;
        synchronized (object) {
            DataRaster[] dataRasterArray;
            block15: {
                DataRaster[] dataRasterArray2 = dataRasterArray = this.rasterCache != null ? (DataRaster[])this.rasterCache.getObject(this.dataSource) : null;
                if (null != dataRasterArray) {
                    return dataRasterArray;
                }
                if (this.rasterCache == null || !this.rasterCache.contains(this.dataSource)) {
                    long l;
                    long l2 = 0L;
                    try {
                        AVList aVList = this.copy();
                        try {
                            long l3 = CachedDataRaster.getTotalUsedMemory();
                            dataRasterArray = this.dataReader.read(this.getDataSource(), aVList);
                            l2 = CachedDataRaster.getTotalUsedMemory() - l3;
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            Logging.logger().finest(this.composeExceptionReason(outOfMemoryError));
                            this.releaseMemory();
                            long l4 = CachedDataRaster.getTotalUsedMemory();
                            dataRasterArray = this.dataReader.read(this.getDataSource(), aVList);
                            l2 = CachedDataRaster.getTotalUsedMemory() - l4;
                        }
                        if (this.rasterCache == null) break block15;
                        l = this.getSizeInBytes(dataRasterArray);
                        long l5 = l = l2 > l ? l2 : l;
                    }
                    catch (Throwable throwable) {
                        try {
                            CachedDataRaster.disposeRasters(dataRasterArray);
                            dataRasterArray = null;
                            String string = Logging.getMessage("DataRaster.CannotRead", this.composeExceptionReason(throwable));
                            Logging.logger().severe(string);
                            throw new WWRuntimeException(string);
                        }
                        catch (Throwable throwable2) {
                            if (this.rasterCache != null) {
                                long l6 = this.getSizeInBytes(dataRasterArray);
                                long l7 = l6 = l2 > l6 ? l2 : l6;
                                if (l6 > 0L) {
                                    this.rasterCache.add(this.dataSource, dataRasterArray, l6);
                                }
                            }
                            throw throwable2;
                        }
                    }
                    if (l > 0L) {
                        this.rasterCache.add(this.dataSource, dataRasterArray, l);
                    }
                }
            }
            if (null == dataRasterArray || dataRasterArray.length == 0) {
                String string = Logging.getMessage("generic.CannotCreateRaster", this.getDataSource());
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            return dataRasterArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOnTo(DataRaster dataRaster) {
        Object object = this.rasterUsageLock;
        synchronized (object) {
            try {
                try {
                    DataRaster[] dataRasterArray;
                    for (DataRaster dataRaster2 : dataRasterArray = this.getDataRasters()) {
                        dataRaster2.drawOnTo(dataRaster);
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    DataRaster[] dataRasterArray;
                    Logging.logger().finest(this.composeExceptionReason(outOfMemoryError));
                    this.releaseMemory();
                    for (DataRaster dataRaster3 : dataRasterArray = this.getDataRasters()) {
                        dataRaster3.drawOnTo(dataRaster);
                    }
                }
            }
            catch (Throwable throwable) {
                String string = this.composeExceptionReason(throwable);
                Logging.logger().log(Level.SEVERE, string, throwable);
            }
        }
    }

    @Override
    public DataRaster getSubRaster(AVList aVList) {
        Object object = this.rasterUsageLock;
        synchronized (object) {
            try {
                try {
                    DataRaster[] dataRasterArray = this.getDataRasters();
                    return dataRasterArray[0].getSubRaster(aVList);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Logging.logger().finest(this.composeExceptionReason(outOfMemoryError));
                    this.releaseMemory();
                    DataRaster[] dataRasterArray = this.getDataRasters();
                    return dataRasterArray[0].getSubRaster(aVList);
                }
            }
            catch (Throwable throwable) {
                String string = this.composeExceptionReason(throwable);
                Logging.logger().log(Level.SEVERE, string, throwable);
                String string2 = Logging.getMessage("generic.CannotCreateRaster", this.getDataSource());
                Logging.logger().severe(string2);
                throw new WWRuntimeException(string2);
            }
        }
    }

    @Override
    public DataRaster getSubRaster(int n, int n2, Sector sector, AVList aVList) {
        if (null == aVList) {
            aVList = new AVListImpl();
        }
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        return this.getSubRaster(aVList);
    }

    protected void releaseMemory() {
        if (this.rasterCache != null) {
            this.rasterCache.clear();
        }
        System.runFinalization();
        System.gc();
        Thread.yield();
    }

    protected String composeExceptionReason(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != this.dataSource) {
            stringBuffer.append(this.dataSource).append(" : ");
        }
        stringBuffer.append(WWUtil.extractExceptionReason(throwable));
        return stringBuffer.toString();
    }

    protected long getSizeInBytes(DataRaster[] dataRasterArray) {
        long l = 0L;
        if (dataRasterArray != null) {
            for (DataRaster dataRaster : dataRasterArray) {
                if (dataRaster == null || !(dataRaster instanceof Cacheable)) continue;
                l += ((Cacheable)((Object)dataRaster)).getSizeInBytes();
            }
        }
        return l;
    }

    protected static void disposeRasters(DataRaster[] dataRasterArray) {
        if (dataRasterArray != null) {
            for (DataRaster dataRaster : dataRasterArray) {
                dataRaster.dispose();
            }
        }
    }

    protected static long getTotalUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    private static class CacheListener
    implements MemoryCache.CacheListener {
        private Object key;

        private CacheListener(Object object) {
            this.key = object;
        }

        @Override
        public void entryRemoved(Object object, Object object2) {
            if (object != this.key) {
                return;
            }
            if (object2 == null || !(object2 instanceof DataRaster[])) {
                String string = MessageFormat.format("Cannot dispose {0}", object2);
                Logging.logger().warning(string);
                return;
            }
            try {
                CachedDataRaster.disposeRasters((DataRaster[])object2);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileDisposing", object2);
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }

        @Override
        public void removalException(Throwable throwable, Object object, Object object2) {
            String string = throwable.getMessage();
            string = WWUtil.isEmpty(string) && null != throwable.getCause() ? throwable.getCause().getMessage() : string;
            String string2 = Logging.getMessage("BasicMemoryCache.ExceptionFromRemovalListener", string);
            Logging.logger().info(string2);
        }
    }

    protected static enum ErrorHandlerMode {
        ALLOW_EXCEPTIONS,
        DISABLE_EXCEPTIONS;

    }
}

