/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.drag;

import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class DragContext {
    protected Point point;
    protected Point previousPoint;
    protected Point initialPoint;
    protected SceneController sceneController;
    protected Globe globe;
    protected View view;
    protected String dragState;

    public Point getPoint() {
        return this.point;
    }

    public void setPoint(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.point = point;
    }

    public Point getPreviousPoint() {
        return this.previousPoint;
    }

    public void setPreviousPoint(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.previousPoint = point;
    }

    public Point getInitialPoint() {
        return this.initialPoint;
    }

    public void setInitialPoint(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.initialPoint = point;
    }

    public SceneController getSceneController() {
        return this.sceneController;
    }

    public void setSceneController(SceneController sceneController) {
        if (sceneController == null) {
            String string = Logging.getMessage("nullValue.SceneControllerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sceneController = sceneController;
    }

    public Globe getGlobe() {
        return this.globe;
    }

    public void setGlobe(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.globe = globe;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.view = view;
    }

    public String getDragState() {
        return this.dragState;
    }

    public void setDragState(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DragStateIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!(string.equals("gov.nasa.worldwind.avkey.DragBegin") || string.equals("gov.nasa.worldwind.avkey.DragChange") || string.equals("gov.nasa.worldwind.avkey.DragEnded"))) {
            String string3 = Logging.getMessage("generic.UnknownDragState", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.dragState = string;
    }
}

