/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.json;

import gov.nasa.worldwind.formats.json.BasicJSONEvent;
import gov.nasa.worldwind.formats.json.BasicJSONEventParser;
import gov.nasa.worldwind.formats.json.JSONEvent;
import gov.nasa.worldwind.formats.json.JSONEventParser;
import gov.nasa.worldwind.formats.json.JSONEventParserContext;
import gov.nasa.worldwind.formats.json.NumericValueJSONEvent;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class BasicJSONEventParserContext
implements JSONEventParserContext {
    protected JsonParser parser;
    protected boolean hasNext;
    protected JSONEvent nextEvent;
    protected Deque<String> fieldNameStack = new ArrayDeque<String>();
    protected Map<String, JSONEventParser> parsers = new HashMap<String, JSONEventParser>();

    public BasicJSONEventParserContext(JsonParser jsonParser) throws IOException {
        if (jsonParser == null) {
            String string = Logging.getMessage("nullValue.ParserIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.parser = jsonParser;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public JSONEvent nextEvent() throws IOException {
        JSONEvent jSONEvent = this.nextEvent;
        this.advance();
        return jSONEvent;
    }

    @Override
    public JSONEvent peek() {
        return this.nextEvent;
    }

    @Override
    public String getCurrentFieldName() {
        return this.fieldNameStack.peek();
    }

    @Override
    public void pushFieldName(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.fieldNameStack.push(string);
    }

    @Override
    public void popFieldName() {
        this.fieldNameStack.pop();
    }

    @Override
    public JSONEventParser allocate(JSONEvent jSONEvent) {
        return this.parsers.get(this.getCurrentFieldName());
    }

    @Override
    public JSONEventParser getUnrecognizedParser() {
        return new BasicJSONEventParser();
    }

    @Override
    public void registerParser(String string, BasicJSONEventParser basicJSONEventParser) {
        this.parsers.put(string, basicJSONEventParser);
    }

    protected void advance() throws IOException {
        this.parser.nextToken();
        if (!this.parser.hasCurrentToken()) {
            this.hasNext = false;
            this.nextEvent = null;
        } else {
            this.hasNext = true;
            this.nextEvent = this.createEvent(this.parser.getCurrentToken());
        }
    }

    protected JSONEvent createEvent(JsonToken jsonToken) throws IOException {
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return new NumericValueJSONEvent(this.parser.getCurrentName(), this.parser.getDoubleValue());
        }
        return new BasicJSONEvent(this.parser, jsonToken, this.parser.getCurrentName());
    }
}

