/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nmea;

import gov.nasa.worldwind.formats.nmea.NmeaTrackPoint;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class NmeaWriter {
    private final PrintStream printStream;
    private final String encoding;
    private int sentenceNumber = 0;
    private static final String DEFAULT_ENCODING = "US-ASCII";

    public NmeaWriter(String string) throws IOException {
        this(string, DEFAULT_ENCODING);
    }

    public NmeaWriter(String string, String string2) throws IOException {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.encoding = string2;
        this.printStream = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(string)), false, this.encoding);
    }

    public NmeaWriter(OutputStream outputStream) throws IOException {
        this(outputStream, DEFAULT_ENCODING);
    }

    public NmeaWriter(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            String string2 = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.encoding = string;
        this.printStream = new PrintStream((OutputStream)new BufferedOutputStream(outputStream), false, this.encoding);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public void writeTrack(Track track) {
        if (track == null) {
            String string = Logging.getMessage("nullValue.TrackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doWriteTrack(track, this.printStream);
        this.doFlush();
    }

    public void close() {
        this.doFlush();
        this.printStream.close();
    }

    private void doWriteTrack(Track track, PrintStream printStream) {
        if (track != null && track.getSegments() != null) {
            for (TrackSegment trackSegment : track.getSegments()) {
                this.doWriteTrackSegment(trackSegment, printStream);
            }
        }
    }

    private void doWriteTrackSegment(TrackSegment trackSegment, PrintStream printStream) {
        if (trackSegment != null && trackSegment.getPoints() != null) {
            for (TrackPoint trackPoint : trackSegment.getPoints()) {
                if (trackPoint instanceof NmeaTrackPoint) {
                    this.doWriteNmeaTrackPoint((NmeaTrackPoint)trackPoint, printStream);
                    continue;
                }
                this.doWriteTrackPoint(trackPoint, printStream);
            }
        }
    }

    private void doWriteTrackPoint(TrackPoint trackPoint, PrintStream printStream) {
        if (trackPoint != null) {
            this.writeGGASentence(trackPoint.getTime(), trackPoint.getLatitude(), trackPoint.getLongitude(), trackPoint.getElevation(), 0.0, printStream);
        }
    }

    private void doWriteNmeaTrackPoint(NmeaTrackPoint nmeaTrackPoint, PrintStream printStream) {
        if (nmeaTrackPoint != null) {
            this.writeGGASentence(nmeaTrackPoint.getTime(), nmeaTrackPoint.getLatitude(), nmeaTrackPoint.getLongitude(), nmeaTrackPoint.getElevation(), 0.0, printStream);
        }
    }

    private void writeGGASentence(String string, double d, double d2, double d3, double d4, PrintStream printStream) {
        ++this.sentenceNumber;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GP");
        stringBuilder.append("GGA");
        stringBuilder.append(",");
        stringBuilder.append(this.formatTime(string));
        stringBuilder.append(",");
        stringBuilder.append(this.formatLatitude(d));
        stringBuilder.append(",");
        stringBuilder.append(this.formatLongitude(d2));
        stringBuilder.append(",");
        stringBuilder.append("");
        stringBuilder.append(",");
        stringBuilder.append("");
        stringBuilder.append(",");
        stringBuilder.append("");
        stringBuilder.append(",");
        stringBuilder.append(this.formatElevation(d3));
        stringBuilder.append(",");
        stringBuilder.append(this.formatElevation(d4));
        stringBuilder.append(",");
        stringBuilder.append("");
        stringBuilder.append(",");
        stringBuilder.append("");
        stringBuilder.append(",");
        int n = this.computeChecksum(stringBuilder, 0, stringBuilder.length());
        stringBuilder.append("*");
        stringBuilder.append(this.formatChecksum(n));
        printStream.print("$");
        printStream.print(stringBuilder);
        printStream.print("\r\n");
        this.doFlush();
    }

    private String formatTime(String string) {
        return string != null ? string : "";
    }

    private String formatLatitude(double d) {
        int n = (int)Math.floor(Math.abs(d));
        double d2 = 60.0 * (Math.abs(d) - (double)n);
        return String.format("%02d%06.3f,%s", n, d2, d < 0.0 ? "S" : "N");
    }

    private String formatLongitude(double d) {
        int n = (int)Math.floor(Math.abs(d));
        double d2 = 60.0 * (Math.abs(d) - (double)n);
        return String.format("%03d%06.3f,%s", n, d2, d < 0.0 ? "W" : "E");
    }

    private String formatElevation(double d) {
        return String.format("%.1f,M", d);
    }

    private String formatChecksum(int n) {
        return Integer.toHexString(n);
    }

    private int computeChecksum(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            int n4 = 0xFF & charSequence.charAt(i);
            n3 ^= n4;
        }
        return n3;
    }

    private void doFlush() {
        this.printStream.flush();
    }
}

