/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import gov.nasa.worldwind.formats.rpf.RPFColorMap;
import gov.nasa.worldwind.formats.rpf.RPFLocationSection;
import gov.nasa.worldwind.geom.LatLon;
import java.nio.ByteBuffer;

public class RPFFrameFileComponents {
    public static final String DATA_TAG = "RPFIMG";
    public RPFLocationSection componentLocationTable;
    public LatLon nwUpperLeft;
    public LatLon swLowerleft;
    public LatLon neUpperRight;
    public LatLon seLowerRight;
    public double verticalResolutionNorthSouth;
    public double horizontalResolutionEastWest;
    public double verticalIntervalLatitude;
    public double horizontalIntervalLongitude;
    public RPFColorMap[] rpfColorMaps;
    public short numOfColorGrayscaleOffsetRecords;
    public short numOfColorConverterOffsetRecords;
    public String externalColorGrayscaleFilename;
    public long colormapOffsetTableOffset;
    public int colormapGrayscaleOffsetRecordLength;
    public int numOfSpectralGroups;
    public int numOfSubframeTables;
    public int numOfSpectralBandTables;
    public int numOfSpectralBandLinesPerImageRow;
    public int numOfSubframesInEastWestDirection;
    public int numOfSubframesInNorthSouthDirection;
    public long numOfOutputColumnsPerSubframe;
    public long numOfOutputRowsPerSubframe;
    public long subframeMaskTableOffset;
    public long transparencyMaskTableOffset;
    public RelatedImagesSection relatedImagesSection = null;

    public RPFFrameFileComponents(ByteBuffer byteBuffer) {
        this.componentLocationTable = new RPFLocationSection(byteBuffer);
        if (0 < this.componentLocationTable.getCoverageSectionSubheaderLength()) {
            this.parseRPFCoverageSection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getColorGrayscaleSectionSubheaderLength()) {
            this.parseColorGrayscaleSection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getColormapSubsectionLength()) {
            this.parseColormapSubSection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getColorConverterSubsectionLength()) {
            this.parseColorConverterSubsection(byteBuffer);
        }
        if (0 < this.componentLocationTable.getImageDescriptionSubheaderLength()) {
            byteBuffer.position(this.componentLocationTable.getImageDescriptionSubheaderLocation());
            this.parseImageDescriptionSubheader(byteBuffer);
        }
        if (0 < this.componentLocationTable.getRelatedImagesSectionSubheaderLength()) {
            byteBuffer.position(this.componentLocationTable.getRelatedImagesSectionSubheaderLocation());
            this.relatedImagesSection = new RelatedImagesSection(byteBuffer);
        }
    }

    private void parseImageDescriptionSubheader(ByteBuffer byteBuffer) {
        this.numOfSpectralGroups = NITFSUtil.getUShort(byteBuffer);
        this.numOfSubframeTables = NITFSUtil.getUShort(byteBuffer);
        this.numOfSpectralBandTables = NITFSUtil.getUShort(byteBuffer);
        this.numOfSpectralBandLinesPerImageRow = NITFSUtil.getUShort(byteBuffer);
        this.numOfSubframesInEastWestDirection = NITFSUtil.getUShort(byteBuffer);
        this.numOfSubframesInNorthSouthDirection = NITFSUtil.getUShort(byteBuffer);
        this.numOfOutputColumnsPerSubframe = NITFSUtil.getUInt(byteBuffer);
        this.numOfOutputRowsPerSubframe = NITFSUtil.getUInt(byteBuffer);
        this.subframeMaskTableOffset = NITFSUtil.getUInt(byteBuffer);
        this.transparencyMaskTableOffset = NITFSUtil.getUInt(byteBuffer);
    }

    private void parseColorConverterSubsection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getColorConverterSubsectionLocation());
    }

    private void parseColormapSubSection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getColormapSubsectionLocation());
        this.colormapOffsetTableOffset = NITFSUtil.getUInt(byteBuffer);
        this.colormapGrayscaleOffsetRecordLength = NITFSUtil.getUShort(byteBuffer);
        if (0 < this.numOfColorGrayscaleOffsetRecords) {
            this.rpfColorMaps = new RPFColorMap[this.numOfColorGrayscaleOffsetRecords];
            for (int i = 0; i < this.numOfColorGrayscaleOffsetRecords; ++i) {
                this.rpfColorMaps[i] = new RPFColorMap(byteBuffer, this.componentLocationTable.getColormapSubsectionLocation());
            }
        } else {
            throw new NITFSRuntimeException("NITFSReader.InvalidNumberOfRPFColorGrayscaleRecords");
        }
    }

    private void parseColorGrayscaleSection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getColorGrayscaleSectionSubheaderLocation());
        this.numOfColorGrayscaleOffsetRecords = NITFSUtil.getByteAsShort(byteBuffer);
        this.numOfColorConverterOffsetRecords = NITFSUtil.getByteAsShort(byteBuffer);
        this.externalColorGrayscaleFilename = NITFSUtil.getString(byteBuffer, 12);
    }

    private void parseRPFCoverageSection(ByteBuffer byteBuffer) {
        byteBuffer.position(this.componentLocationTable.getCoverageSectionSubheaderLocation());
        this.nwUpperLeft = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.swLowerleft = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.neUpperRight = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.seLowerRight = LatLon.fromDegrees(byteBuffer.getDouble(), byteBuffer.getDouble());
        this.verticalResolutionNorthSouth = byteBuffer.getDouble();
        this.horizontalResolutionEastWest = byteBuffer.getDouble();
        this.verticalIntervalLatitude = byteBuffer.getDouble();
        this.horizontalIntervalLongitude = byteBuffer.getDouble();
    }

    public class RelatedImagesSection {
        public long relatedImageDescriptionTableOffset;
        public int numOfRelatedImageDescriptionRecords;
        public int relatedImageDescriptionRecordLength;

        public RelatedImagesSection(ByteBuffer byteBuffer) {
            this.relatedImageDescriptionTableOffset = NITFSUtil.getUInt(byteBuffer);
            this.numOfRelatedImageDescriptionRecords = NITFSUtil.getUShort(byteBuffer);
            this.relatedImageDescriptionRecordLength = NITFSUtil.getUShort(byteBuffer);
        }
    }
}

