/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.formats.shapefile.DBaseField;
import gov.nasa.worldwind.formats.shapefile.DBaseFile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordMultiPoint;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordNull;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPoint;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPolygon;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPolyline;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import gov.nasa.worldwind.util.VecBufferBlocks;
import gov.nasa.worldwind.util.VecBufferSequence;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Shapefile
extends AVListImpl
implements Closeable,
Exportable {
    protected static final int FILE_CODE = 9994;
    protected static final int HEADER_LENGTH = 100;
    protected static final String SHAPE_FILE_SUFFIX = ".shp";
    protected static final String INDEX_FILE_SUFFIX = ".shx";
    protected static final String ATTRIBUTE_FILE_SUFFIX = ".dbf";
    protected static final String PROJECTION_FILE_SUFFIX = ".prj";
    protected static final String[] SHAPE_CONTENT_TYPES = new String[]{"application/shp", "application/octet-stream"};
    protected static final String[] INDEX_CONTENT_TYPES = new String[]{"application/shx", "application/octet-stream"};
    protected static final String[] PROJECTION_CONTENT_TYPES = new String[]{"application/prj", "application/octet-stream", "text/plain"};
    public static final String SHAPE_NULL = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeNull";
    public static final String SHAPE_POINT = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePoint";
    public static final String SHAPE_MULTI_POINT = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPoint";
    public static final String SHAPE_POLYLINE = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolyline";
    public static final String SHAPE_POLYGON = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygon";
    public static final String SHAPE_POINT_M = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointM";
    public static final String SHAPE_MULTI_POINT_M = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointM";
    public static final String SHAPE_POLYLINE_M = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineM";
    public static final String SHAPE_POLYGON_M = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonM";
    public static final String SHAPE_POINT_Z = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointZ";
    public static final String SHAPE_MULTI_POINT_Z = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointZ";
    public static final String SHAPE_POLYLINE_Z = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineZ";
    public static final String SHAPE_POLYGON_Z = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonZ";
    public static final String SHAPE_MULTI_PATCH = "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPatch";
    protected static List<String> measureTypes = new ArrayList<String>(Arrays.asList("gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonM", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonZ"));
    protected static List<String> zTypes = new ArrayList<String>(Arrays.asList("gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePointZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapeMultiPointZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolylineZ", "gov.nasa.worldwind.formats.shapefile.Shapefile.ShapePolygonZ"));
    protected Header header;
    protected int[] index;
    protected CompoundVecBuffer pointBuffer;
    protected ReadableByteChannel shpChannel;
    protected ReadableByteChannel shxChannel;
    protected ReadableByteChannel prjChannel;
    protected DBaseFile attributeFile;
    protected boolean open;
    protected boolean normalizePoints;
    protected int numRecordsRead;
    protected int numBytesRead;
    protected ByteBuffer recordHeaderBuffer;
    protected ByteBuffer recordContentBuffer;
    protected MappedByteBuffer mappedShpBuffer;

    public Shapefile(Object object, AVList aVList) {
        block7: {
            if (object == null || WWUtil.isEmpty(object)) {
                String string = Logging.getMessage("nullValue.SourceIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            try {
                this.setValue("gov.nasa.worldwind.avkey.DisplayName", object.toString());
                if (object instanceof File) {
                    this.initializeFromFile((File)object, aVList);
                    break block7;
                }
                if (object instanceof URL) {
                    this.initializeFromURL((URL)object, aVList);
                    break block7;
                }
                if (object instanceof InputStream) {
                    this.initializeFromStreams((InputStream)object, null, null, null, aVList);
                    break block7;
                }
                if (object instanceof String) {
                    this.initializeFromPath((String)object, aVList);
                    break block7;
                }
                String string = Logging.getMessage("generic.UnrecognizedSourceType", object);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("SHP.ExceptionAttemptingToReadShapefile", this.getValue("gov.nasa.worldwind.avkey.DisplayName"));
                Logging.logger().log(Level.SEVERE, string, exception);
                throw new WWRuntimeException(string, exception);
            }
        }
    }

    public Shapefile(Object object) {
        this(object, null);
    }

    public Shapefile(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, InputStream inputStream4, AVList aVList) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", inputStream.toString());
            this.initializeFromStreams(inputStream, inputStream2, inputStream3, inputStream4, aVList);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("SHP.ExceptionAttemptingToReadShapefile", inputStream);
            Logging.logger().log(Level.SEVERE, string, exception);
            throw new WWRuntimeException(string, exception);
        }
    }

    public Shapefile(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, InputStream inputStream4) {
        this(inputStream, inputStream2, inputStream3, inputStream4, null);
    }

    public Shapefile(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, AVList aVList) {
        this(inputStream, inputStream2, inputStream3, null, aVList);
    }

    public Shapefile(InputStream inputStream, InputStream inputStream2, InputStream inputStream3) {
        this(inputStream, inputStream2, inputStream3, null, null);
    }

    public int getVersion() {
        return this.header != null ? this.header.version : -1;
    }

    public int getLength() {
        return this.header != null ? this.header.fileLength : -1;
    }

    public String getShapeType() {
        return this.header != null ? this.header.shapeType : null;
    }

    public double[] getBoundingRectangle() {
        return this.header != null ? this.header.boundingRectangle : null;
    }

    public int getNumberOfRecords() {
        return this.index != null ? this.index.length / 2 : -1;
    }

    public CompoundVecBuffer getPointBuffer() {
        return this.pointBuffer;
    }

    public Set<String> getAttributeNames() {
        if (this.attributeFile == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (DBaseField dBaseField : this.attributeFile.getFields()) {
            hashSet.add(dBaseField.getName());
        }
        return hashSet;
    }

    public boolean hasNext() {
        if (!this.open || this.header == null) {
            return false;
        }
        int n = this.header.fileLength - 100;
        return this.numBytesRead < n;
    }

    public ShapefileRecord nextRecord() {
        ShapefileRecord shapefileRecord;
        if (!this.open) {
            String string = Logging.getMessage("SHP.ShapefileClosed", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.header == null) {
            String string = Logging.getMessage("SHP.HeaderIsNull", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int n = this.header.fileLength - 100;
        if (n <= 0 || this.numBytesRead >= n) {
            String string = Logging.getMessage("SHP.NoRecords", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            shapefileRecord = this.readNextRecord();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("SHP.ExceptionAttemptingToReadShapefileRecord", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName"));
            Logging.logger().log(Level.SEVERE, string, exception);
            throw new WWRuntimeException(string, exception);
        }
        ++this.numRecordsRead;
        return shapefileRecord;
    }

    @Override
    public void close() {
        if (this.shpChannel != null) {
            WWIO.closeStream(this.shpChannel, null);
            this.shpChannel = null;
        }
        if (this.shxChannel != null) {
            WWIO.closeStream(this.shxChannel, null);
            this.shxChannel = null;
        }
        if (this.prjChannel != null) {
            WWIO.closeStream(this.prjChannel, null);
            this.prjChannel = null;
        }
        if (this.attributeFile != null) {
            this.attributeFile.close();
            this.attributeFile = null;
        }
        this.recordHeaderBuffer = null;
        this.recordContentBuffer = null;
        this.mappedShpBuffer = null;
        this.open = false;
    }

    protected boolean isNormalizePoints() {
        return this.normalizePoints;
    }

    protected void setNormalizePoints(boolean bl) {
        this.normalizePoints = bl;
    }

    protected void initializeFromFile(File file, AVList aVList) throws IOException {
        InputStream inputStream;
        InputStream inputStream2;
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        if (file.canRead() && file.canWrite()) {
            try {
                this.mappedShpBuffer = WWIO.mapFile(file, FileChannel.MapMode.PRIVATE);
                Logging.logger().finer(Logging.getMessage("SHP.MemoryMappingEnabled", file.getPath()));
            }
            catch (IOException iOException) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("SHP.ExceptionAttemptingToMemoryMap", file.getPath()), iOException);
            }
        }
        if (this.mappedShpBuffer == null) {
            this.shpChannel = Channels.newChannel(new BufferedInputStream(new FileInputStream(file)));
        }
        if ((inputStream2 = this.getFileStream(WWIO.replaceSuffix(file.getPath(), INDEX_FILE_SUFFIX))) != null) {
            this.shxChannel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream2));
        }
        if ((inputStream = this.getFileStream(WWIO.replaceSuffix(file.getPath(), PROJECTION_FILE_SUFFIX))) != null) {
            this.prjChannel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream));
        }
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", file.getPath());
        this.initialize(aVList);
        File file2 = new File(WWIO.replaceSuffix(file.getPath(), ATTRIBUTE_FILE_SUFFIX));
        if (file2.exists()) {
            try {
                this.attributeFile = new DBaseFile(file2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void initializeFromURL(URL uRL, AVList aVList) throws IOException {
        Object object;
        Object object2;
        URLConnection uRLConnection = uRL.openConnection();
        String string = this.validateURLConnection(uRLConnection, SHAPE_CONTENT_TYPES);
        if (string != null) {
            throw new IOException(string);
        }
        this.shpChannel = Channels.newChannel(WWIO.getBufferedInputStream(uRLConnection.getInputStream()));
        URLConnection uRLConnection2 = this.getURLConnection(WWIO.replaceSuffix(uRL.toString(), INDEX_FILE_SUFFIX));
        if (uRLConnection2 != null) {
            string = this.validateURLConnection(uRLConnection2, INDEX_CONTENT_TYPES);
            if (string != null) {
                Logging.logger().warning(string);
            } else {
                object2 = this.getURLStream(uRLConnection2);
                if (object2 != null) {
                    this.shxChannel = Channels.newChannel(WWIO.getBufferedInputStream((InputStream)object2));
                }
            }
        }
        if ((object2 = this.getURLConnection(WWIO.replaceSuffix(uRL.toString(), PROJECTION_FILE_SUFFIX))) != null) {
            string = this.validateURLConnection((URLConnection)object2, PROJECTION_CONTENT_TYPES);
            if (string != null) {
                Logging.logger().warning(string);
            } else {
                object = this.getURLStream((URLConnection)object2);
                if (object != null) {
                    this.prjChannel = Channels.newChannel(WWIO.getBufferedInputStream((InputStream)object));
                }
            }
        }
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", uRL.toString());
        this.initialize(aVList);
        object = WWIO.makeURL(WWIO.replaceSuffix(uRL.toString(), ATTRIBUTE_FILE_SUFFIX));
        if (object != null) {
            try {
                this.attributeFile = new DBaseFile(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void initializeFromStreams(InputStream inputStream, InputStream inputStream2, InputStream inputStream3, InputStream inputStream4, AVList aVList) throws IOException {
        if (inputStream != null) {
            this.shpChannel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream));
        }
        if (inputStream2 != null) {
            this.shxChannel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream2));
        }
        if (inputStream4 != null) {
            this.prjChannel = Channels.newChannel(WWIO.getBufferedInputStream(inputStream4));
        }
        this.initialize(aVList);
        if (inputStream3 != null) {
            try {
                this.attributeFile = new DBaseFile(inputStream3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void initializeFromPath(String string, AVList aVList) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            this.initializeFromFile(file, aVList);
            return;
        }
        URL uRL = WWIO.makeURL(string);
        if (uRL != null) {
            this.initializeFromURL(uRL, aVList);
            return;
        }
        String string2 = Logging.getMessage("generic.UnrecognizedSourceType", string);
        Logging.logger().severe(string2);
        throw new IllegalArgumentException(string2);
    }

    protected void initialize(AVList aVList) throws IOException {
        Object object;
        try {
            object = this.readCoordinateSystem();
            if (object != null) {
                this.setValues((AVList)object);
            }
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("SHP.ExceptionAttemptingToReadProjection", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName")), iOException);
        }
        if (aVList != null) {
            this.setValues(aVList);
        }
        if ((object = this.validateCoordinateSystem(this)) != null) {
            throw new WWRuntimeException((String)object);
        }
        try {
            this.index = this.readIndex();
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("SHP.ExceptionAttemptingToReadIndex", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName")), iOException);
        }
        this.header = this.readHeader();
        this.open = true;
        this.setNormalizePoints(this.header.normalizePoints);
    }

    protected InputStream getFileStream(String string) {
        try {
            return new FileInputStream(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected URLConnection getURLConnection(String string) {
        try {
            URL uRL = new URL(string);
            return uRL.openConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected InputStream getURLStream(URLConnection uRLConnection) {
        try {
            return uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String validateURLConnection(URLConnection uRLConnection, String[] stringArray) {
        try {
            if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)uRLConnection).getResponseCode() != 200) {
                return Logging.getMessage("HTTP.ResponseCode", ((HttpURLConnection)uRLConnection).getResponseCode(), uRLConnection.getURL());
            }
        }
        catch (Exception exception) {
            return Logging.getMessage("URLRetriever.ErrorOpeningConnection", uRLConnection.getURL());
        }
        String string = uRLConnection.getContentType();
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        for (String string2 : stringArray) {
            if (!string.trim().toLowerCase().startsWith(string2)) continue;
            return null;
        }
        return Logging.getMessage("HTTP.UnexpectedContentType", string, Arrays.toString(stringArray));
    }

    protected Header readHeader() throws IOException {
        ByteBuffer byteBuffer;
        if (this.mappedShpBuffer != null) {
            byteBuffer = this.mappedShpBuffer;
        } else {
            byteBuffer = ByteBuffer.allocate(100);
            WWIO.readChannelToBuffer(this.shpChannel, byteBuffer);
        }
        if (byteBuffer.remaining() < 100) {
            throw new WWRuntimeException(Logging.getMessage("generic.InvalidFileLength", byteBuffer.remaining()));
        }
        return this.readHeaderFromBuffer(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Header readHeaderFromBuffer(ByteBuffer byteBuffer) throws IOException {
        Header header = null;
        int n = byteBuffer.position();
        try {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            int n2 = byteBuffer.getInt();
            if (n2 != 9994) {
                throw new WWUnrecognizedException(Logging.getMessage("SHP.UnrecognizedShapefile", n2));
            }
            byteBuffer.position(byteBuffer.position() + 20);
            int n3 = byteBuffer.getInt();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            BoundingRectangle boundingRectangle = this.readBoundingRectangle(byteBuffer);
            String string = this.getShapeType(n5);
            if (string == null) {
                throw new WWRuntimeException(Logging.getMessage("SHP.UnsupportedShapeType", n5));
            }
            header = new Header();
            header.fileLength = n3 * 2;
            header.version = n4;
            header.shapeType = string;
            header.boundingRectangle = boundingRectangle.coords;
            header.normalizePoints = boundingRectangle.isNormalized;
        }
        finally {
            byteBuffer.position(n + 100);
        }
        return header;
    }

    protected int[] readIndex() throws IOException {
        int[] nArray;
        if (this.shxChannel == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(100);
        WWIO.readChannelToBuffer(this.shxChannel, byteBuffer);
        if (byteBuffer.remaining() < 100) {
            return null;
        }
        Header header = this.readHeaderFromBuffer(byteBuffer);
        int n = (header.fileLength - 100) / 8;
        int n2 = 2 * n;
        int n3 = 8 * n;
        try {
            byteBuffer = ByteBuffer.allocate(n3);
            nArray = new int[n2];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("SHP.OutOfMemoryAllocatingIndex", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName")), outOfMemoryError);
            return null;
        }
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        WWIO.readChannelToBuffer(this.shxChannel, byteBuffer);
        byteBuffer.asIntBuffer().get(nArray);
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n4++;
            nArray[n5] = nArray[n5] * 2;
        }
        return nArray;
    }

    protected AVList readCoordinateSystem() throws IOException {
        if (this.prjChannel == null) {
            return null;
        }
        String string = WWIO.readChannelToString(this.prjChannel, null);
        if (WWUtil.isEmpty(string)) {
            return null;
        }
        return WorldFile.decodeOGCCoordinateSystemWKT(string, null);
    }

    protected String validateCoordinateSystem(AVList aVList) {
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (!this.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            Logging.logger().warning(Logging.getMessage("generic.UnspecifiedCoordinateSystem", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName")));
            return null;
        }
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(object)) {
            return null;
        }
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(object)) {
            return this.validateProjection(aVList);
        }
        return Logging.getMessage("generic.UnsupportedCoordinateSystem", object);
    }

    protected String validateProjection(AVList aVList) {
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.Projection.Name");
        if ("gov.nasa.worldwind.avkey.Projection.UTM".equals(object)) {
            StringBuilder stringBuilder = new StringBuilder();
            Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.Projection.Zone");
            if (object2 == null) {
                stringBuilder.append(Logging.getMessage("generic.ZoneIsMissing"));
            } else if (!(object2 instanceof Integer) || (Integer)object2 < 1 || (Integer)object2 > 60) {
                stringBuilder.append(Logging.getMessage("generic.ZoneIsInvalid", object2));
            }
            object2 = aVList.getValue("gov.nasa.worldwind.avkey.Projection.Hemisphere");
            if (object2 == null) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("generic.HemisphereIsMissing"));
            } else if (!object2.equals("gov.nasa.worldwind.avkey.North") && !object2.equals("gov.nasa.worldwdind.avkey.South")) {
                stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("generic.HemisphereIsInvalid", object2));
            }
            return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
        }
        return Logging.getMessage("generic.UnsupportedProjection", object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ShapefileRecord readNextRecord() throws IOException {
        ShapefileRecord shapefileRecord;
        ByteBuffer byteBuffer;
        int n;
        if (this.mappedShpBuffer != null) {
            n = this.mappedShpBuffer.position();
            this.mappedShpBuffer.order(ByteOrder.BIG_ENDIAN);
            int n2 = this.mappedShpBuffer.getInt(n + 4) * 2;
            int n3 = 8 + n2;
            this.mappedShpBuffer.position(n);
            this.mappedShpBuffer.limit(n + n3);
            this.numBytesRead += n3;
            byteBuffer = this.mappedShpBuffer;
        } else {
            if (this.recordHeaderBuffer == null) {
                this.recordHeaderBuffer = ByteBuffer.allocate(8);
            }
            this.recordHeaderBuffer.clear();
            this.recordHeaderBuffer.order(ByteOrder.BIG_ENDIAN);
            WWIO.readChannelToBuffer(this.shpChannel, this.recordHeaderBuffer);
            n = this.recordHeaderBuffer.getInt(4) * 2;
            int n4 = 8 + n;
            if (this.recordContentBuffer == null || this.recordContentBuffer.capacity() < n4) {
                this.recordContentBuffer = ByteBuffer.allocate(n4);
            }
            this.recordContentBuffer.limit(n4);
            this.recordContentBuffer.rewind();
            this.recordContentBuffer.put(this.recordHeaderBuffer);
            WWIO.readChannelToBuffer(this.shpChannel, this.recordContentBuffer);
            this.numBytesRead += n4;
            byteBuffer = this.recordContentBuffer;
        }
        try {
            shapefileRecord = this.readRecordFromBuffer(byteBuffer);
        }
        finally {
            if (this.mappedShpBuffer != null) {
                this.mappedShpBuffer.limit(this.mappedShpBuffer.capacity());
            }
        }
        return shapefileRecord;
    }

    protected ShapefileRecord readRecordFromBuffer(ByteBuffer byteBuffer) {
        ShapefileRecord shapefileRecord = this.createRecord(byteBuffer);
        if (shapefileRecord != null && this.attributeFile != null && this.attributeFile.hasNext()) {
            shapefileRecord.setAttributes(this.attributeFile.nextRecord());
        }
        return shapefileRecord;
    }

    protected ShapefileRecord createRecord(ByteBuffer byteBuffer) {
        String string = this.readRecordShapeType(byteBuffer);
        if (Shapefile.isPointType(string)) {
            return this.createPoint(byteBuffer);
        }
        if (Shapefile.isMultiPointType(string)) {
            return this.createMultiPoint(byteBuffer);
        }
        if (Shapefile.isPolylineType(string)) {
            return this.createPolyline(byteBuffer);
        }
        if (Shapefile.isPolygonType(string)) {
            return this.createPolygon(byteBuffer);
        }
        if (Shapefile.isNullType(string)) {
            return this.createNull(byteBuffer);
        }
        return null;
    }

    protected ShapefileRecord createNull(ByteBuffer byteBuffer) {
        return new ShapefileRecordNull(this, byteBuffer);
    }

    protected ShapefileRecord createPoint(ByteBuffer byteBuffer) {
        return new ShapefileRecordPoint(this, byteBuffer);
    }

    protected ShapefileRecord createMultiPoint(ByteBuffer byteBuffer) {
        return new ShapefileRecordMultiPoint(this, byteBuffer);
    }

    protected ShapefileRecord createPolyline(ByteBuffer byteBuffer) {
        return new ShapefileRecordPolyline(this, byteBuffer);
    }

    protected ShapefileRecord createPolygon(ByteBuffer byteBuffer) {
        return new ShapefileRecordPolygon(this, byteBuffer);
    }

    protected String readRecordShapeType(ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.getInt(byteBuffer.position() + 8);
        String string = this.getShapeType(n);
        if (string == null) {
            throw new WWRuntimeException(Logging.getMessage("SHP.UnsupportedShapeType", n));
        }
        return string;
    }

    protected String getShapeType(int n) {
        switch (n) {
            case 0: {
                return SHAPE_NULL;
            }
            case 1: {
                return SHAPE_POINT;
            }
            case 3: {
                return SHAPE_POLYLINE;
            }
            case 5: {
                return SHAPE_POLYGON;
            }
            case 8: {
                return SHAPE_MULTI_POINT;
            }
            case 11: {
                return SHAPE_POINT_Z;
            }
            case 13: {
                return SHAPE_POLYLINE_Z;
            }
            case 15: {
                return SHAPE_POLYGON_Z;
            }
            case 18: {
                return SHAPE_MULTI_POINT_Z;
            }
            case 21: {
                return SHAPE_POINT_M;
            }
            case 23: {
                return SHAPE_POLYLINE_M;
            }
            case 25: {
                return SHAPE_POLYGON_M;
            }
            case 28: {
                return SHAPE_MULTI_POINT_M;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addPoints(ShapefileRecord shapefileRecord, ByteBuffer byteBuffer, int n) {
        DoubleBuffer doubleBuffer;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.position() + 16 * n;
        try {
            byteBuffer.limit(n3);
            doubleBuffer = this.readPoints(shapefileRecord, byteBuffer);
        }
        finally {
            byteBuffer.clear();
            byteBuffer.position(n3);
        }
        if (this.mappedShpBuffer != null) {
            if (this.pointBuffer == null) {
                ByteBuffer byteBuffer2 = this.mappedShpBuffer.duplicate();
                byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer2.clear();
                this.pointBuffer = new VecBufferBlocks(2, "gov.nasa.worldwind.avkey.Float64", byteBuffer2);
            }
            return ((VecBufferBlocks)this.pointBuffer).addBlock(n2, n3 - 1);
        }
        if (this.pointBuffer == null) {
            DoubleBuffer doubleBuffer2;
            int n4 = this.computeNumberOfPointsEstimate();
            try {
                doubleBuffer2 = Buffers.newDirectDoubleBuffer(2 * n4);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new WWRuntimeException(Logging.getMessage("SHP.OutOfMemoryAllocatingPointBuffer", this.getStringValue("gov.nasa.worldwind.avkey.DisplayName")), outOfMemoryError);
            }
            this.pointBuffer = new VecBufferSequence(new VecBuffer(2, new BufferWrapper.DoubleBufferWrapper(doubleBuffer2)));
        }
        VecBuffer vecBuffer = new VecBuffer(2, new BufferWrapper.DoubleBufferWrapper(doubleBuffer));
        return ((VecBufferSequence)this.pointBuffer).append(vecBuffer);
    }

    protected int computeNumberOfPointsEstimate() {
        int n = this.getNumberOfRecords();
        if (n < 0) {
            return (this.getLength() - 100) / 16;
        }
        int n2 = 100 + n * 12;
        String string = this.getShapeType();
        if (string == SHAPE_POINT || string == SHAPE_POINT_M) {
            return (this.getLength() - n2) / 16;
        }
        if (string == SHAPE_MULTI_POINT || string == SHAPE_MULTI_POINT_M) {
            return (this.getLength() - (n2 + n * 36)) / 16;
        }
        if (string == SHAPE_POLYLINE || string == SHAPE_POLYGON || string == SHAPE_POLYLINE_M || string == SHAPE_POLYGON_M) {
            return (this.getLength() - (n2 + n * 40)) / 16;
        }
        if (string == SHAPE_POINT_Z) {
            return (this.getLength() - n2) / 24;
        }
        if (string == SHAPE_MULTI_POINT_Z) {
            return (this.getLength() - (n2 + n * 52)) / 24;
        }
        if (string == SHAPE_POLYLINE_Z || string == SHAPE_POLYGON_Z) {
            return (this.getLength() - (n2 + n * 56)) / 24;
        }
        throw new WWRuntimeException(Logging.getMessage("SHP.UnsupportedShapeType", string));
    }

    protected DoubleBuffer readPoints(ShapefileRecord shapefileRecord, ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        Object object = this.getValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (!this.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            return this.readUnspecifiedPoints(shapefileRecord, byteBuffer);
        }
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(object)) {
            return this.readGeographicPoints(shapefileRecord, byteBuffer);
        }
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(object)) {
            return this.readProjectedPoints(shapefileRecord, byteBuffer);
        }
        throw new WWRuntimeException(Logging.getMessage("generic.UnsupportedCoordinateSystem", object));
    }

    protected DoubleBuffer readUnspecifiedPoints(ShapefileRecord shapefileRecord, ByteBuffer byteBuffer) {
        return byteBuffer.asDoubleBuffer();
    }

    protected DoubleBuffer readGeographicPoints(ShapefileRecord shapefileRecord, ByteBuffer byteBuffer) {
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        if (shapefileRecord != null && shapefileRecord.isNormalizePoints()) {
            WWUtil.normalizeGeographicCoordinates(doubleBuffer);
            doubleBuffer.rewind();
        }
        return doubleBuffer;
    }

    protected DoubleBuffer readProjectedPoints(ShapefileRecord shapefileRecord, ByteBuffer byteBuffer) {
        Object object = this.getValue("gov.nasa.worldwind.avkey.Projection.Name");
        if ("gov.nasa.worldwind.avkey.Projection.UTM".equals(object)) {
            Integer n = (Integer)this.getValue("gov.nasa.worldwind.avkey.Projection.Zone");
            String string = (String)this.getValue("gov.nasa.worldwind.avkey.Projection.Hemisphere");
            DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
            WWUtil.convertUTMCoordinatesToGeographic(n, string, doubleBuffer);
            doubleBuffer.rewind();
            return doubleBuffer;
        }
        throw new WWRuntimeException(Logging.getMessage("generic.UnsupportedProjection", object));
    }

    protected BoundingRectangle readBoundingRectangle(ByteBuffer byteBuffer) {
        Object object = this.getValue("gov.nasa.worldwind.avkey.CoordinateSystem");
        if (!this.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem")) {
            return this.readUnspecifiedBoundingRectangle(byteBuffer);
        }
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Geographic".equals(object)) {
            return this.readGeographicBoundingRectangle(byteBuffer);
        }
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(object)) {
            return this.readProjectedBoundingRectangle(byteBuffer);
        }
        throw new WWRuntimeException(Logging.getMessage("generic.UnsupportedCoordinateSystem", object));
    }

    protected BoundingRectangle readUnspecifiedBoundingRectangle(ByteBuffer byteBuffer) {
        BoundingRectangle boundingRectangle = new BoundingRectangle();
        boundingRectangle.coords = this.readBoundingRectangleCoordinates(byteBuffer);
        return boundingRectangle;
    }

    protected BoundingRectangle readGeographicBoundingRectangle(ByteBuffer byteBuffer) {
        double d;
        BoundingRectangle boundingRectangle = new BoundingRectangle();
        boundingRectangle.coords = this.readBoundingRectangleCoordinates(byteBuffer);
        if (boundingRectangle.coords[0] < -90.0) {
            d = Angle.normalizedLatitude((Angle)Angle.fromDegrees((double)boundingRectangle.coords[0])).degrees;
            boundingRectangle.coords[0] = -90.0;
            boundingRectangle.isNormalized = true;
            if (boundingRectangle.coords[1] < d) {
                boundingRectangle.coords[1] = d;
            }
        }
        if (boundingRectangle.coords[1] > 90.0) {
            d = Angle.normalizedLatitude((Angle)Angle.fromDegrees((double)boundingRectangle.coords[1])).degrees;
            boundingRectangle.coords[1] = 90.0;
            boundingRectangle.isNormalized = true;
            if (boundingRectangle.coords[0] > d) {
                boundingRectangle.coords[0] = d;
            }
        }
        if (boundingRectangle.coords[2] < -180.0 || boundingRectangle.coords[3] > 180.0) {
            boundingRectangle.coords[2] = -180.0;
            boundingRectangle.coords[3] = 180.0;
            boundingRectangle.isNormalized = true;
        }
        return boundingRectangle;
    }

    protected BoundingRectangle readProjectedBoundingRectangle(ByteBuffer byteBuffer) {
        Object object = this.getValue("gov.nasa.worldwind.avkey.Projection.Name");
        if ("gov.nasa.worldwind.avkey.Projection.UTM".equals(object)) {
            double[] dArray = ShapefileUtils.readDoubleArray(byteBuffer, 4);
            Integer n = (Integer)this.getValue("gov.nasa.worldwind.avkey.Projection.Zone");
            String string = (String)this.getValue("gov.nasa.worldwind.avkey.Projection.Hemisphere");
            Sector sector = Sector.fromUTMRectangle(n, string, dArray[0], dArray[2], dArray[1], dArray[3]);
            BoundingRectangle boundingRectangle = new BoundingRectangle();
            boundingRectangle.coords = sector.toArrayDegrees();
            return boundingRectangle;
        }
        throw new WWRuntimeException(Logging.getMessage("generic.UnsupportedProjection", object));
    }

    protected double[] readBoundingRectangleCoordinates(ByteBuffer byteBuffer) {
        double d = byteBuffer.getDouble();
        double d2 = byteBuffer.getDouble();
        double d3 = byteBuffer.getDouble();
        double d4 = byteBuffer.getDouble();
        return new double[]{d2, d4, d, d3};
    }

    public static boolean isMeasureType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return measureTypes.contains(string);
    }

    public static boolean isZType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return zTypes.contains(string);
    }

    public static boolean isNullType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.equals(SHAPE_NULL);
    }

    public static boolean isPointType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.equals(SHAPE_POINT) || string.equals(SHAPE_POINT_Z) || string.equals(SHAPE_POINT_M);
    }

    public static boolean isMultiPointType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.equals(SHAPE_MULTI_POINT) || string.equals(SHAPE_MULTI_POINT_Z) || string.equals(SHAPE_MULTI_POINT_M);
    }

    public static boolean isPolylineType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.equals(SHAPE_POLYLINE) || string.equals(SHAPE_POLYLINE_Z) || string.equals(SHAPE_POLYLINE_M);
    }

    public static boolean isPolygonType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ShapeType");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.equals(SHAPE_POLYGON) || string.equals(SHAPE_POLYGON_Z) || string.equals(SHAPE_POLYGON_M);
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return Arrays.binarySearch(SHAPE_CONTENT_TYPES, string) >= 0 ? "Export.FormatSupported" : "Export.FormatNotSupported";
    }

    @Override
    public void export(String string, Object object) throws IOException, UnsupportedOperationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            this.doExport(string, object);
        }
        catch (XMLStreamException xMLStreamException) {
            Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
            throw new IOException(xMLStreamException);
        }
    }

    protected void doExport(String string, Object object) throws IOException, XMLStreamException {
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        if ("application/vnd.google-earth.kml+xml".equals(string)) {
            this.exportAsKML(xMLStreamWriter);
        } else {
            this.exportAsXML(xMLStreamWriter);
        }
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }

    protected void exportAsXML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartElement("Shapefile");
        xMLStreamWriter.writeCharacters("\n");
        while (this.hasNext()) {
            try {
                ShapefileRecord shapefileRecord = this.nextRecord();
                if (shapefileRecord == null) continue;
                shapefileRecord.exportAsXML(xMLStreamWriter);
                xMLStreamWriter.writeCharacters("\n");
            }
            catch (Exception exception) {
                String string = Logging.getMessage("Export.Exception.ShapefileRecord");
                Logging.logger().log(Level.WARNING, string, exception);
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    protected void exportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        while (this.hasNext()) {
            try {
                ShapefileRecord shapefileRecord = this.nextRecord();
                if (shapefileRecord == null) continue;
                shapefileRecord.exportAsKML(xMLStreamWriter);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("Export.Exception.ShapefileRecord");
                Logging.logger().log(Level.WARNING, string, exception);
            }
        }
    }

    public void printInfo(boolean bl) {
        while (this.hasNext()) {
            this.nextRecord().printInfo(bl);
        }
    }

    protected static class Header {
        public int fileCode = 9994;
        public int fileLength;
        public int version;
        public String shapeType;
        public double[] boundingRectangle;
        public boolean normalizePoints;

        protected Header() {
        }
    }

    protected static class BoundingRectangle {
        public double[] coords;
        public boolean isNormalized;

        protected BoundingRectangle() {
        }
    }
}

