/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.cache.ShapeDataCache;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRenderable;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PolygonTessellator;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Range;
import gov.nasa.worldwind.util.VecBuffer;
import java.awt.Color;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class ShapefileExtrudedPolygons
extends ShapefileRenderable
implements OrderedRenderable {
    protected double defaultHeight;
    protected double defaultBaseDepth;
    protected double maxHeight;
    protected Tile rootTile;
    protected int tileMaxLevel = 3;
    protected int tileMaxCapacity = 10000;
    protected ArrayList<Tile> currentTiles = new ArrayList();
    protected PolygonTessellator tess = new PolygonTessellator();
    protected byte[] colorByteArray = new byte[6];
    protected float[] colorFloatArray = new float[3];
    protected double[] matrixArray = new double[16];
    protected Layer pickLayer;
    protected PickSupport pickSupport = new PickSupport();
    protected ByteBuffer pickColors;
    protected Object pickColorsVboKey = new Object();

    public ShapefileExtrudedPolygons(Shapefile shapefile) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(shapefile, null, null, null);
    }

    public ShapefileExtrudedPolygons(Shapefile shapefile, ShapeAttributes shapeAttributes, ShapeAttributes shapeAttributes2, ShapefileRenderable.AttributeDelegate attributeDelegate) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(shapefile, shapeAttributes, shapeAttributes2, attributeDelegate);
    }

    @Override
    protected void assembleRecords(Shapefile shapefile) {
        this.rootTile = new Tile(this.sector, 0);
        super.assembleRecords(shapefile);
        if (this.mustSplitTile(this.rootTile)) {
            this.splitTile(this.rootTile);
        }
        this.rootTile.records.trimToSize();
    }

    @Override
    protected boolean mustAssembleRecord(ShapefileRecord shapefileRecord) {
        return super.mustAssembleRecord(shapefileRecord) && (shapefileRecord.isPolylineRecord() || shapefileRecord.isPolygonRecord());
    }

    @Override
    protected void assembleRecord(ShapefileRecord shapefileRecord) {
        Record record = this.createRecord(shapefileRecord);
        this.addRecord(shapefileRecord, record);
        if (record.height != null && this.maxHeight < record.height) {
            this.maxHeight = record.height;
        }
        this.rootTile.records.add(record);
        record.tile = this.rootTile;
    }

    protected Record createRecord(ShapefileRecord shapefileRecord) {
        return new Record(this, shapefileRecord);
    }

    protected boolean mustSplitTile(Tile tile) {
        return tile.level < this.tileMaxLevel && tile.records.size() > this.tileMaxCapacity;
    }

    protected void splitTile(Tile tile) {
        Sector[] sectorArray = tile.sector.subdivide();
        tile.children = new Tile[4];
        tile.children[0] = new Tile(sectorArray[0], tile.level + 1);
        tile.children[1] = new Tile(sectorArray[1], tile.level + 1);
        tile.children[2] = new Tile(sectorArray[2], tile.level + 1);
        tile.children[3] = new Tile(sectorArray[3], tile.level + 1);
        Iterator<Record> iterator = tile.records.iterator();
        block0: while (iterator.hasNext()) {
            Record record = iterator.next();
            for (int i = 0; i < 4; ++i) {
                if (!tile.children[i].sector.contains(record.sector)) continue;
                tile.children[i].records.add(record);
                record.tile = tile.children[i];
                iterator.remove();
                continue block0;
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (this.mustSplitTile(tile.children[i])) {
                this.splitTile(tile.children[i]);
            }
            tile.children[i].records.trimToSize();
        }
    }

    @Override
    protected void recordDidChange(ShapefileRenderable.Record record) {
        Tile tile = ((Record)record).tile;
        if (tile != null) {
            this.invalidateTileAttributeGroups(tile);
        }
    }

    public double getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(double d) {
        this.defaultHeight = d;
        this.invalidateAllTileGeometry();
    }

    public double getDefaultBaseDepth() {
        return this.defaultBaseDepth;
    }

    public void setDefaultBaseDepth(double d) {
        this.defaultBaseDepth = d;
        this.invalidateAllTileGeometry();
    }

    @Override
    public double getDistanceFromEye() {
        return 0.0;
    }

    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.rootTile == null) {
            return;
        }
        this.pickOrderedSurfaceRenderable(drawContext, point);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.rootTile == null) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedSurfaceRenderable(drawContext);
        } else {
            this.makeOrderedSurfaceRenderable(drawContext);
        }
    }

    protected void makeOrderedSurfaceRenderable(DrawContext drawContext) {
        this.assembleTiles(drawContext);
        if (this.currentTiles.isEmpty()) {
            return;
        }
        this.pickLayer = drawContext.getCurrentLayer();
        drawContext.addOrderedSurfaceRenderable(this);
    }

    protected void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        this.addTileOrDescendants(drawContext, this.rootTile);
    }

    protected void addTileOrDescendants(DrawContext drawContext, Tile tile) {
        tile.currentData = (ShapeData)tile.dataCache.getEntry(drawContext.getGlobe());
        if (tile.currentData == null) {
            tile.currentData = new ShapeData(drawContext, 3000L, 9000L);
            tile.dataCache.addEntry(tile.currentData);
        }
        if (!this.isTileVisible(drawContext, tile)) {
            return;
        }
        if (tile.records.size() > 0) {
            this.adjustTileExpiration(drawContext, tile);
            if (this.mustRegenerateTileGeometry(drawContext, tile)) {
                this.regenerateTileGeometry(drawContext, tile);
            }
            if (this.mustAssembleTileAttributeGroups(tile)) {
                this.assembleTileAttributeGroups(tile);
            }
            this.currentTiles.add(tile);
        }
        if (tile.children != null) {
            for (Tile tile2 : tile.children) {
                this.addTileOrDescendants(drawContext, tile2);
            }
        }
    }

    protected boolean isTileVisible(DrawContext drawContext, Tile tile) {
        Extent extent = this.makeTileExtent(drawContext.getTerrain(), tile);
        if (drawContext.isSmall(extent, 1)) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(extent);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(extent);
    }

    protected boolean mustRegenerateTileGeometry(DrawContext drawContext, Tile tile) {
        return tile.currentData.isExpired(drawContext) || !tile.currentData.isValid(drawContext);
    }

    protected void adjustTileExpiration(DrawContext drawContext, Tile tile) {
        if (tile.currentData.referencePoint != null) {
            double d = drawContext.getView().getEyePoint().distanceTo3(tile.currentData.referencePoint);
            tile.currentData.adjustTimer(drawContext, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateTileGeometry(Tile tile) {
        tile.dataCache.setAllExpired(true);
        Tile tile2 = tile;
        synchronized (tile2) {
            tile.intersectionData.invalidate();
        }
    }

    protected void invalidateAllTileGeometry() {
        ArrayDeque<Tile> arrayDeque = new ArrayDeque<Tile>();
        arrayDeque.add(this.rootTile);
        while (!arrayDeque.isEmpty()) {
            Tile tile = (Tile)arrayDeque.poll();
            this.invalidateTileGeometry(tile);
            if (tile.children == null) continue;
            arrayDeque.addAll(Arrays.asList(tile.children));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void regenerateTileGeometry(DrawContext drawContext, Tile tile) {
        ShapeData shapeData = tile.currentData;
        ShapefileExtrudedPolygons shapefileExtrudedPolygons = this;
        synchronized (shapefileExtrudedPolygons) {
            this.tessellateTile(drawContext.getTerrain(), tile, shapeData);
        }
        shapeData.setEyeDistance(drawContext.getView().getEyePoint().distanceTo3(shapeData.referencePoint));
        shapeData.setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
        shapeData.setVerticalExaggeration(drawContext.getVerticalExaggeration());
        shapeData.restartTimer(drawContext);
    }

    protected Extent makeTileExtent(Terrain terrain, Tile tile) {
        double[] dArray = terrain.getGlobe().getMinAndMaxElevations(tile.sector);
        double d = dArray[0] - this.defaultBaseDepth;
        double d2 = dArray[1] + Math.max(this.maxHeight, this.defaultHeight);
        return Sector.computeBoundingBox(terrain.getGlobe(), terrain.getVerticalExaggeration(), tile.sector, d, d2);
    }

    /*
     * WARNING - void declaration
     */
    protected void tessellateTile(Terrain terrain, Tile tile, ShapeData shapeData) {
        void var8_11;
        int n = 3;
        FloatBuffer floatBuffer = shapeData.vertices;
        if (floatBuffer == null) {
            int n2 = 0;
            for (Record object2 : tile.records) {
                n2 += object2.numberOfPoints;
            }
            floatBuffer = Buffers.newDirectFloatBuffer(2 * n * n2);
        }
        double[] dArray = new double[2];
        Object object3 = new float[6];
        Object var8_10 = null;
        for (Record record : tile.records) {
            double d = record.height != null ? record.height : this.defaultHeight;
            double d2 = this.defaultBaseDepth;
            double d3 = 0.0;
            Vec4 vec4 = null;
            this.tess.setEnabled(record.interiorIndices == null);
            this.tess.reset();
            this.tess.setPolygonNormal(0.0, 0.0, 1.0);
            this.tess.beginPolygon();
            for (int i = 0; i < record.getBoundaryCount(); ++i) {
                this.tess.beginContour();
                VecBuffer vecBuffer = record.getBoundaryPoints(i);
                for (int j = 0; j < vecBuffer.getSize(); ++j) {
                    vecBuffer.get(j, dArray);
                    Vec4 vec42 = terrain.getSurfacePoint(Angle.fromDegrees(dArray[1]), Angle.fromDegrees(dArray[0]), 0.0);
                    int n2 = floatBuffer.position() / n;
                    this.tess.addVertex(dArray[0], dArray[1], 0.0, n2);
                    if (var8_11 == null) {
                        Vec4 vec43 = vec42;
                    }
                    if (vec4 == null) {
                        vec4 = terrain.getGlobe().computeSurfaceNormalAtPoint(vec42);
                        d3 = vec42.x * vec4.x + vec42.y * vec4.y + vec42.z * vec4.z;
                    }
                    double d4 = d + d3 - (vec42.x * vec4.x + vec42.y * vec4.y + vec42.z * vec4.z);
                    double d5 = -d2;
                    object3[0] = (float)(vec42.x + vec4.x * d4 - var8_11.x);
                    object3[1] = (float)(vec42.y + vec4.y * d4 - var8_11.y);
                    object3[2] = (float)(vec42.z + vec4.z * d4 - var8_11.z);
                    object3[3] = (float)(vec42.x + vec4.x * d5 - var8_11.x);
                    object3[4] = (float)(vec42.y + vec4.y * d5 - var8_11.y);
                    object3[5] = (float)(vec42.z + vec4.z * d5 - var8_11.z);
                    floatBuffer.put((float[])object3);
                }
                this.tess.endContour();
            }
            this.tess.endPolygon();
            this.assembleRecordIndices(this.tess, record);
        }
        shapeData.vertices = floatBuffer.rewind();
        shapeData.referencePoint = var8_11;
        shapeData.transformMatrix = Matrix.fromTranslation(var8_11.x, var8_11.y, var8_11.z);
        shapeData.vboExpired = true;
    }

    protected void assembleRecordIndices(PolygonTessellator polygonTessellator, Record record) {
        if (!polygonTessellator.isEnabled()) {
            return;
        }
        IntBuffer intBuffer = polygonTessellator.getInteriorIndices().flip();
        IntBuffer intBuffer2 = polygonTessellator.getBoundaryIndices().flip();
        IntBuffer intBuffer3 = IntBuffer.allocate(intBuffer.remaining() + 3 * intBuffer2.remaining());
        IntBuffer intBuffer4 = IntBuffer.allocate(2 * intBuffer2.remaining());
        intBuffer3.put(intBuffer);
        for (int i = intBuffer2.position(); i < intBuffer2.limit(); i += 2) {
            int n = intBuffer2.get(i);
            int n2 = intBuffer2.get(i + 1);
            int n3 = n + 1;
            int n4 = n2 + 1;
            intBuffer3.put(n);
            intBuffer3.put(n3);
            intBuffer3.put(n2);
            intBuffer3.put(n2);
            intBuffer3.put(n3);
            intBuffer3.put(n4);
            intBuffer4.put(n);
            intBuffer4.put(n2);
            intBuffer4.put(n);
            intBuffer4.put(n3);
        }
        record.interiorIndices = intBuffer3.rewind();
        record.outlineIndices = intBuffer4.rewind();
    }

    protected boolean mustAssembleTileAttributeGroups(Tile tile) {
        return tile.attributeGroups.isEmpty();
    }

    protected void invalidateTileAttributeGroups(Tile tile) {
        tile.attributeGroups.clear();
    }

    protected void assembleTileAttributeGroups(Tile tile) {
        Object object;
        tile.attributeGroups.clear();
        IdentityHashMap<ShapeAttributes, Object> identityHashMap = new IdentityHashMap<ShapeAttributes, Object>();
        for (Record object2 : tile.records) {
            if (!object2.isVisible()) continue;
            ShapeAttributes shapeAttributes = this.determineActiveAttributes(object2);
            object = (RecordGroup)identityHashMap.get(shapeAttributes);
            if (object == null) {
                object = new RecordGroup(shapeAttributes);
                identityHashMap.put(shapeAttributes, object);
                tile.attributeGroups.add((RecordGroup)object);
            }
            ((RecordGroup)object).records.add(object2);
            ((RecordGroup)object).interiorIndexRange.length += object2.interiorIndices.remaining();
            ((RecordGroup)object).outlineIndexRange.length += object2.outlineIndices.remaining();
        }
        for (RecordGroup recordGroup : tile.attributeGroups) {
            int n = recordGroup.interiorIndexRange.length + recordGroup.outlineIndexRange.length;
            object = Buffers.newDirectIntBuffer(n);
            recordGroup.interiorIndexRange.location = ((Buffer)object).position();
            for (Record record : recordGroup.records) {
                ((IntBuffer)object).put(record.interiorIndices);
                record.interiorIndices.rewind();
            }
            recordGroup.outlineIndexRange.location = ((Buffer)object).position();
            for (Record record : recordGroup.records) {
                ((IntBuffer)object).put(record.outlineIndices);
                record.outlineIndices.rewind();
            }
            recordGroup.indices = ((IntBuffer)object).rewind();
            recordGroup.records.clear();
            recordGroup.records.trimToSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pickOrderedSurfaceRenderable(DrawContext drawContext, Point point) {
        try {
            this.pickSupport.clearPickList();
            this.pickSupport.beginPicking(drawContext);
            this.beginDrawing(drawContext);
            for (Tile tile : this.currentTiles) {
                Color color = drawContext.getUniquePickColor();
                drawContext.getGL().getGL2().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                this.pickSupport.addPickableObject(color.getRGB(), tile);
                this.drawTile(drawContext, tile);
            }
            PickedObject pickedObject = this.pickSupport.getTopObject(drawContext, point);
            if (pickedObject != null) {
                this.pickSupport.clearPickList();
                this.drawTileInUniqueColors(drawContext, (Tile)pickedObject.getObject());
                this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
            }
        }
        finally {
            this.endDrawing(drawContext);
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.clearPickList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedSurfaceRenderable(DrawContext drawContext) {
        try {
            this.beginDrawing(drawContext);
            for (Tile tile : this.currentTiles) {
                if (drawContext.isPickingMode()) {
                    Color color = drawContext.getUniquePickColor();
                    drawContext.getGL().getGL2().glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    this.pickSupport.addPickableObject(color.getRGB(), tile);
                }
                this.drawTile(drawContext, tile);
            }
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnable(2884);
        gL2.glEnableClientState(32884);
        gL2.glDepthFunc(515);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            gL2.glEnable(2848);
            gL2.glBlendFunc(770, 771);
            gL2.glHint(3154, 4353);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDisable(2884);
        gL2.glDisableClientState(32884);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL2.glDepthFunc(513);
        gL2.glLineWidth(1.0f);
        gL2.glPopMatrix();
        if (!drawContext.isPickingMode()) {
            gL2.glDisable(3042);
            gL2.glDisable(2848);
            gL2.glBlendFunc(1, 0);
            gL2.glHint(3154, 4352);
        }
        if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject()) {
            gL2.glBindBuffer(34962, 0);
            gL2.glBindBuffer(34963, 0);
        }
    }

    protected void drawTile(DrawContext drawContext, Tile tile) {
        GL2 gL2 = drawContext.getGL().getGL2();
        ShapeData shapeData = tile.currentData;
        int[] nArray = null;
        boolean bl = drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
        if (bl && (nArray = (int[])drawContext.getGpuResourceCache().get(shapeData.vboKey)) == null) {
            long l = 4 * shapeData.vertices.remaining();
            nArray = new int[1];
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, l, shapeData.vertices, 35044);
            gL2.glVertexPointer(3, 5126, 0, 0L);
            drawContext.getGpuResourceCache().put(shapeData.vboKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", l);
        } else if (bl) {
            gL2.glBindBuffer(34962, (int)nArray[0]);
            if (shapeData.vboExpired) {
                gL2.glBufferSubData(34962, 0L, 4 * shapeData.vertices.remaining(), shapeData.vertices);
                shapeData.vboExpired = false;
            }
            gL2.glVertexPointer(3, 5126, 0, 0L);
        } else {
            gL2.glVertexPointer(3, 5126, 0, shapeData.vertices);
        }
        Matrix matrix = drawContext.getView().getModelviewMatrix().multiply(shapeData.transformMatrix);
        matrix.toArray(this.matrixArray, 0, false);
        gL2.glLoadMatrixd(this.matrixArray, 0);
        for (RecordGroup recordGroup : tile.attributeGroups) {
            this.drawTileAttributeGroup(drawContext, recordGroup);
        }
    }

    protected void drawTileAttributeGroup(DrawContext drawContext, RecordGroup recordGroup) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int[] nArray = null;
        boolean bl = drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
        if (bl && (nArray = (int[])drawContext.getGpuResourceCache().get(recordGroup.vboKey)) == null) {
            long l = 4 * recordGroup.indices.remaining();
            nArray = new int[1];
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34963, nArray[0]);
            gL2.glBufferData(34963, l, recordGroup.indices, 35044);
            drawContext.getGpuResourceCache().put(recordGroup.vboKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", l);
        } else if (bl) {
            gL2.glBindBuffer(34963, (int)nArray[0]);
        }
        if (recordGroup.attributes.isDrawInterior()) {
            if (!drawContext.isPickingMode()) {
                float[] fArray = this.colorFloatArray;
                recordGroup.attributes.getInteriorMaterial().getDiffuse().getRGBColorComponents(fArray);
                gL2.glColor3f(fArray[0], fArray[1], fArray[2]);
            }
            if (bl) {
                gL2.glDrawElements(4, recordGroup.interiorIndexRange.length, 5125, 4 * recordGroup.interiorIndexRange.location);
            } else {
                gL2.glDrawElements(4, recordGroup.interiorIndexRange.length, 5125, recordGroup.indices.position(recordGroup.interiorIndexRange.location));
                recordGroup.indices.rewind();
            }
        }
        if (recordGroup.attributes.isDrawOutline()) {
            gL2.glLineWidth((float)recordGroup.attributes.getOutlineWidth());
            if (!drawContext.isPickingMode()) {
                float[] fArray = this.colorFloatArray;
                recordGroup.attributes.getOutlineMaterial().getDiffuse().getRGBColorComponents(fArray);
                gL2.glColor3f(fArray[0], fArray[1], fArray[2]);
            }
            if (bl) {
                gL2.glDrawElements(1, recordGroup.outlineIndexRange.length, 5125, 4 * recordGroup.outlineIndexRange.location);
            } else {
                gL2.glDrawElements(1, recordGroup.outlineIndexRange.length, 5125, recordGroup.indices.position(recordGroup.outlineIndexRange.location));
                recordGroup.indices.rewind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTileInUniqueColors(DrawContext drawContext, Tile tile) {
        ByteBuffer byteBuffer;
        GL2 gL2 = drawContext.getGL().getGL2();
        ShapeData shapeData = tile.currentData;
        int n = shapeData.vertices.remaining();
        if (this.pickColors == null || this.pickColors.capacity() < n) {
            this.pickColors = Buffers.newDirectByteBuffer(n);
            drawContext.getGpuResourceCache().remove(this.pickColorsVboKey);
        }
        this.pickColors.clear();
        int[] nArray = null;
        boolean bl = drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
        if (bl && (nArray = (int[])drawContext.getGpuResourceCache().get(this.pickColorsVboKey)) == null) {
            nArray = new int[1];
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, this.pickColors.remaining(), this.pickColors, 35048);
            drawContext.getGpuResourceCache().put(this.pickColorsVboKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", this.pickColors.remaining());
            byteBuffer = gL2.glMapBuffer(34962, 35001);
        } else if (bl) {
            gL2.glBindBuffer(34962, (int)nArray[0]);
            byteBuffer = gL2.glMapBuffer(34962, 35001);
        } else {
            byteBuffer = this.pickColors;
        }
        byte[] byArray = this.colorByteArray;
        for (Record record : tile.records) {
            Color color = drawContext.getUniquePickColor();
            this.pickSupport.addPickableObject(color.getRGB(), record);
            byArray[0] = (byte)color.getRed();
            byArray[1] = (byte)color.getGreen();
            byArray[2] = (byte)color.getBlue();
            byArray[3] = byArray[0];
            byArray[4] = byArray[1];
            byArray[5] = byArray[2];
            for (int i = 0; i < record.numberOfPoints; ++i) {
                byteBuffer.put(byArray);
            }
        }
        byteBuffer.flip();
        try {
            gL2.glEnableClientState(32886);
            if (bl) {
                gL2.glUnmapBuffer(34962);
                gL2.glColorPointer(3, 5121, 0, 0L);
            } else {
                gL2.glColorPointer(3, 5121, 0, byteBuffer);
            }
            this.drawTile(drawContext, tile);
        }
        finally {
            gL2.glDisableClientState(32886);
        }
    }

    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (terrain == null) {
            String string = Logging.getMessage("nullValue.TerrainIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        this.intersectTileOrDescendants(line, terrain, this.rootTile, arrayList);
        return arrayList.size() > 0 ? arrayList : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void intersectTileOrDescendants(Line line, Terrain terrain, Tile tileArray, List<Intersection> list) {
        Tile[] object = tileArray;
        synchronized (tileArray) {
            ShapeData shapeData = this.prepareTileIntersectionData(line, terrain, (Tile)tileArray);
            // ** MonitorExit[object] (shouldn't be in output)
            if (shapeData == null) {
                return;
            }
            if (tileArray.records.size() > 0) {
                Line line2 = new Line(line.getOrigin().subtract3(shapeData.referencePoint), line.getDirection());
                for (Record record : tileArray.records) {
                    if (!record.isVisible()) continue;
                    this.intersectRecordInterior(line2, terrain, record, shapeData, list);
                }
            }
            if (tileArray.children != null) {
                for (Tile tile : tileArray.children) {
                    this.intersectTileOrDescendants(line, terrain, tile, list);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void intersectTileRecord(Line line, Terrain terrain, Record record, List<Intersection> list) {
        ShapeData shapeData;
        Object object = record.tile;
        synchronized (object) {
            shapeData = this.prepareTileIntersectionData(line, terrain, record.tile);
        }
        if (shapeData == null) {
            return;
        }
        object = new Line(line.getOrigin().subtract3(shapeData.referencePoint), line.getDirection());
        this.intersectRecordInterior((Line)object, terrain, record, shapeData, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ShapeData prepareTileIntersectionData(Line line, Terrain terrain, Tile tile) {
        IntersectionData intersectionData = tile.intersectionData;
        if (!intersectionData.isValid(terrain)) {
            intersectionData.setExtent(this.makeTileExtent(terrain, tile));
            intersectionData.setTessellationValid(false);
            intersectionData.setTerrain(terrain);
            intersectionData.setGlobeStateKey(terrain.getGlobe().getGlobeStateKey());
            intersectionData.setVerticalExaggeration(terrain.getVerticalExaggeration());
        }
        if (!intersectionData.getExtent().intersects(line)) {
            return null;
        }
        if (tile.records.size() > 0 && !intersectionData.isTessellationValid()) {
            ShapefileExtrudedPolygons shapefileExtrudedPolygons = this;
            synchronized (shapefileExtrudedPolygons) {
                this.tessellateTile(terrain, tile, intersectionData);
            }
            intersectionData.setTessellationValid(true);
        }
        return intersectionData;
    }

    protected void intersectRecordInterior(Line line, Terrain terrain, Record record, ShapeData shapeData, List<Intersection> list) {
        FloatBuffer floatBuffer = shapeData.vertices;
        IntBuffer intBuffer = record.interiorIndices;
        List<Intersection> list2 = Triangle.intersectTriangles(line, floatBuffer, intBuffer);
        if (list2 != null) {
            for (Intersection intersection : list2) {
                Vec4 vec4 = intersection.getIntersectionPoint().add3(shapeData.referencePoint);
                intersection.setIntersectionPoint(vec4);
                Position position = terrain.getGlobe().computePositionFromPoint(vec4);
                Vec4 vec42 = terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0);
                double d = Math.sqrt(vec4.dotSelf3()) - Math.sqrt(vec42.dotSelf3());
                intersection.setIntersectionPosition(new Position(position, d));
                intersection.setObject(record);
                list.add(intersection);
            }
        }
    }

    protected static class Tile {
        public final Sector sector;
        public final int level;
        public ArrayList<Record> records = new ArrayList();
        public ArrayList<RecordGroup> attributeGroups = new ArrayList();
        public Tile[] children;
        public ShapeDataCache dataCache = new ShapeDataCache(60000L);
        public ShapeData currentData;
        public IntersectionData intersectionData = new IntersectionData();

        public Tile(Sector sector, int n) {
            this.sector = sector;
            this.level = n;
        }
    }

    public static class Record
    extends ShapefileRenderable.Record {
        protected Double height;
        protected Tile tile;
        protected IntBuffer interiorIndices;
        protected IntBuffer outlineIndices;

        public Record(ShapefileRenderable shapefileRenderable, ShapefileRecord shapefileRecord) {
            super(shapefileRenderable, shapefileRecord);
            this.height = ShapefileUtils.extractHeightAttribute(shapefileRecord);
        }

        public Double getHeight() {
            return this.height;
        }

        public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
            if (line == null) {
                String string = Logging.getMessage("nullValue.LineIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (terrain == null) {
                String string = Logging.getMessage("nullValue.TerrainIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (!this.visible) {
                return null;
            }
            ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
            ((ShapefileExtrudedPolygons)this.shapefileRenderable).intersectTileRecord(line, terrain, this, arrayList);
            return arrayList.size() > 0 ? arrayList : null;
        }
    }

    protected static class ShapeData
    extends ShapeDataCache.ShapeDataCacheEntry {
        public FloatBuffer vertices;
        public Vec4 referencePoint;
        public Matrix transformMatrix;
        public Object vboKey = new Object();
        public boolean vboExpired;

        public ShapeData(DrawContext drawContext, long l, long l2) {
            super(drawContext, l, l2);
        }
    }

    protected static class IntersectionData
    extends ShapeData {
        protected Terrain terrain;
        protected boolean tessellationValid;

        public IntersectionData() {
            super(null, 0L, 0L);
        }

        public boolean isValid(Terrain terrain) {
            return this.terrain == terrain && this.verticalExaggeration == terrain.getVerticalExaggeration() && this.globeStateKey != null && this.globeStateKey.equals(terrain.getGlobe().getGlobeStateKey());
        }

        public void invalidate() {
            this.terrain = null;
            this.verticalExaggeration = 1.0;
            this.globeStateKey = null;
            this.tessellationValid = false;
        }

        public Terrain getTerrain() {
            return this.terrain;
        }

        public void setTerrain(Terrain terrain) {
            this.terrain = terrain;
        }

        public boolean isTessellationValid() {
            return this.tessellationValid;
        }

        public void setTessellationValid(boolean bl) {
            this.tessellationValid = bl;
        }
    }

    protected static class RecordGroup {
        public final ShapeAttributes attributes;
        public ArrayList<Record> records = new ArrayList();
        public IntBuffer indices;
        public Range interiorIndexRange = new Range(0, 0);
        public Range outlineIndexRange = new Range(0, 0);
        public Object vboKey = new Object();

        public RecordGroup(ShapeAttributes shapeAttributes) {
            this.attributes = shapeAttributes;
        }
    }
}

