/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.shapefile.DBaseRecord;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileExtrudedPolygons;
import gov.nasa.worldwind.formats.shapefile.ShapefilePolygons;
import gov.nasa.worldwind.formats.shapefile.ShapefilePolylines;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordMultiPoint;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecordPoint;
import gov.nasa.worldwind.formats.shapefile.ShapefileRenderable;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.awt.Color;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShapefileLayerFactory
implements Factory,
ShapefileRenderable.AttributeDelegate {
    protected AVList dBaseMappings;
    protected ShapeAttributes normalShapeAttributes;
    protected ShapeAttributes highlightShapeAttributes;
    protected PointPlacemarkAttributes normalPointAttributes;
    protected PointPlacemarkAttributes highlightPointAttributes;
    protected ShapefileRenderable.AttributeDelegate attributeDelegate;

    public AVList getDBaseMappings() {
        return this.dBaseMappings;
    }

    public void setDBaseMappings(AVList aVList) {
        this.dBaseMappings = aVList;
    }

    public ShapeAttributes getNormalShapeAttributes() {
        return this.normalShapeAttributes;
    }

    public void setNormalShapeAttributes(ShapeAttributes shapeAttributes) {
        this.normalShapeAttributes = shapeAttributes;
    }

    public ShapeAttributes getHighlightShapeAttributes() {
        return this.highlightShapeAttributes;
    }

    public void setHighlightShapeAttributes(ShapeAttributes shapeAttributes) {
        this.highlightShapeAttributes = shapeAttributes;
    }

    public PointPlacemarkAttributes getNormalPointAttributes() {
        return this.normalPointAttributes;
    }

    public void setNormalPointAttributes(PointPlacemarkAttributes pointPlacemarkAttributes) {
        this.normalPointAttributes = pointPlacemarkAttributes;
    }

    public PointPlacemarkAttributes getHighlightPointAttributes() {
        return this.highlightPointAttributes;
    }

    public void setHighlightPointAttributes(PointPlacemarkAttributes pointPlacemarkAttributes) {
        this.highlightPointAttributes = pointPlacemarkAttributes;
    }

    public ShapefileRenderable.AttributeDelegate getAttributeDelegate() {
        return this.attributeDelegate;
    }

    public void setAttributeDelegate(ShapefileRenderable.AttributeDelegate attributeDelegate) {
        this.attributeDelegate = attributeDelegate;
    }

    @Override
    public void assignAttributes(ShapefileRecord shapefileRecord, ShapefileRenderable.Record record) {
        AVList aVList;
        if (this.dBaseMappings != null && (aVList = this.applyMappings(shapefileRecord.getAttributes(), this.dBaseMappings)) != null) {
            record.setValues(aVList);
        }
        if (this.attributeDelegate != null) {
            this.attributeDelegate.assignAttributes(shapefileRecord, record);
        }
    }

    @Override
    public Object createFromConfigSource(Object object, AVList aVList) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("generic.ConfigurationSourceIsInvalid", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.createFromConfigSource(object, aVList, null);
    }

    public Object createFromConfigSource(Object object, AVList aVList, CompletionCallback completionCallback) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("generic.ConfigurationSourceIsInvalid", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object2 = null;
        try {
            if (object instanceof Element) {
                object2 = this.doCreateFromElement((Element)object, aVList, completionCallback);
            } else {
                Document document = WWXML.openDocument(object);
                if (document != null) {
                    object2 = this.doCreateFromElement(document.getDocumentElement(), aVList, completionCallback);
                }
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.CreationFromConfigurationFileFailed", object);
            throw new WWRuntimeException(string, exception);
        }
        return object2;
    }

    public Object createFromShapefileSource(Object object) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("generic.ShapefileSourceIsInvalid", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.createFromShapefileSource(object, null);
    }

    public Object createFromShapefileSource(Object object, CompletionCallback completionCallback) {
        Object object2;
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("generic.ShapefileSourceIsInvalid", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            object2 = this.doCreateFromShapefile(object, completionCallback);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.CreationFromShapefileSourceFailed", object);
            throw new WWRuntimeException(string, exception);
        }
        return object2;
    }

    protected Object doCreateFromElement(Element element, AVList aVList, CompletionCallback completionCallback) throws Exception {
        Boolean bl;
        String string = WWXML.getText(element, "ShapefileLocation");
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("SHP.ShapefileLocationUnspecified");
            throw new WWRuntimeException(string2);
        }
        RenderableLayer renderableLayer = new RenderableLayer();
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        AbstractLayer.getLayerConfigParams(element, aVList);
        renderableLayer.setValues(aVList);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        this.setDBaseMappings(this.collectDBaseMappings(element, xPath));
        Element element2 = WWXML.getElement(element, "NormalShapeAttributes", xPath);
        this.setNormalShapeAttributes(element2 != null ? this.collectShapeAttributes(element2) : null);
        element2 = WWXML.getElement(element, "HighlightShapeAttributes", xPath);
        this.setHighlightShapeAttributes(element2 != null ? this.collectShapeAttributes(element2) : null);
        element2 = WWXML.getElement(element, "NormalPointAttributes", xPath);
        this.setNormalPointAttributes(element2 != null ? this.collectPointAttributes(element2) : null);
        element2 = WWXML.getElement(element, "HighlightPointAttributes", xPath);
        this.setHighlightPointAttributes(element2 != null ? this.collectPointAttributes(element2) : null);
        Double d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.Opacity");
        if (d != null) {
            renderableLayer.setOpacity(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MaxActiveAltitude")) != null) {
            renderableLayer.setMaxActiveAltitude(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MinActiveAltitude")) != null) {
            renderableLayer.setMinActiveAltitude(d);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.PickEnabled")) != null) {
            renderableLayer.setPickEnabled(bl);
        }
        this.createShapefileLayer(string, renderableLayer, completionCallback);
        return renderableLayer;
    }

    protected Object doCreateFromShapefile(Object object, CompletionCallback completionCallback) throws Exception {
        RenderableLayer renderableLayer = new RenderableLayer();
        this.createShapefileLayer(object, renderableLayer, completionCallback);
        return renderableLayer;
    }

    protected void createShapefileLayer(final Object object, final RenderableLayer renderableLayer, final CompletionCallback completionCallback) {
        WorldWind.getScheduledTaskService().addTask(new Runnable(){

            @Override
            public void run() {
                Shapefile shapefile = null;
                try {
                    shapefile = ShapefileLayerFactory.this.loadShapefile(object);
                    ShapefileLayerFactory.this.assembleShapefileLayer(shapefile, renderableLayer);
                }
                catch (Exception exception) {
                    if (completionCallback != null) {
                        completionCallback.exception(exception);
                    }
                }
                finally {
                    if (completionCallback != null) {
                        completionCallback.completion(renderableLayer);
                    }
                    if (object != shapefile) {
                        WWIO.closeStream(shapefile, object.toString());
                    }
                }
            }
        });
    }

    protected Shapefile loadShapefile(Object object) {
        return object instanceof Shapefile ? (Shapefile)object : new Shapefile(object);
    }

    protected void assembleShapefileLayer(Shapefile shapefile, RenderableLayer renderableLayer) {
        this.addRenderablesForShapefile(shapefile, renderableLayer);
        this.addPropertiesForShapefile(shapefile, renderableLayer);
    }

    protected AVList collectDBaseMappings(Element element, XPath xPath) {
        try {
            Element[] elementArray = WWXML.getElements(element, "AttributeMapping", xPath);
            if (elementArray == null || elementArray.length == 0) {
                return null;
            }
            AVListImpl aVListImpl = new AVListImpl();
            for (Element element2 : elementArray) {
                String string = xPath.evaluate("@attributeName", element2);
                String string2 = xPath.evaluate("@mapToKey", element2);
                if (WWUtil.isEmpty(string) || WWUtil.isEmpty(string2)) continue;
                aVListImpl.setValue(string, string2);
            }
            return aVListImpl;
        }
        catch (XPathExpressionException xPathExpressionException) {
            String string = Logging.getMessage("XML.InvalidXPathExpression", "internal expression");
            Logging.logger().log(Level.WARNING, string, xPathExpressionException);
            return null;
        }
    }

    protected PointPlacemarkAttributes collectPointAttributes(Element element) {
        Boolean bl;
        Color color;
        Color color2;
        Double d;
        Double d2;
        Color color3;
        Double d3;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        PointPlacemarkAttributes pointPlacemarkAttributes = new PointPlacemarkAttributes();
        String string = WWXML.getText(element, "ImageAddress", xPath);
        if (!WWUtil.isEmpty(string)) {
            pointPlacemarkAttributes.setImageAddress(string);
        }
        if ((d3 = WWXML.getDouble(element, "Scale", xPath)) != null) {
            pointPlacemarkAttributes.setScale(d3);
        }
        if ((color3 = WWXML.getColor(element, "ImageColor", xPath)) != null) {
            pointPlacemarkAttributes.setImageColor(color3);
        }
        if ((d2 = WWXML.getDouble(element, "LineWidth", xPath)) != null) {
            pointPlacemarkAttributes.setLineWidth(d2);
        }
        if ((d = WWXML.getDouble(element, "LabelScale", xPath)) != null) {
            pointPlacemarkAttributes.setLabelScale(d);
        }
        if ((color2 = WWXML.getColor(element, "LabelColor", xPath)) != null) {
            pointPlacemarkAttributes.setLabelMaterial(new Material(color2));
        }
        if ((color = WWXML.getColor(element, "LineColor", xPath)) != null) {
            pointPlacemarkAttributes.setLabelMaterial(new Material(color));
        }
        if ((bl = WWXML.getBoolean(element, "UsePointAsDefaultImage", xPath)) != null) {
            pointPlacemarkAttributes.setUsePointAsDefaultImage(bl);
        }
        return pointPlacemarkAttributes;
    }

    protected ShapeAttributes collectShapeAttributes(Element element) {
        Color color;
        Double d;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        Boolean bl = WWXML.getBoolean(element, "DrawInterior", xPath);
        if (bl != null) {
            basicShapeAttributes.setDrawInterior(bl);
        }
        if ((bl = WWXML.getBoolean(element, "DrawOutline", xPath)) != null) {
            basicShapeAttributes.setDrawOutline(bl);
        }
        if ((d = WWXML.getDouble(element, "InteriorOpacity", xPath)) != null) {
            basicShapeAttributes.setInteriorOpacity(d);
        }
        if ((d = WWXML.getDouble(element, "OutlineOpacity", xPath)) != null) {
            basicShapeAttributes.setOutlineOpacity(d);
        }
        Double d2 = WWXML.getDouble(element, "OutlineWidth", xPath);
        if (d != null) {
            basicShapeAttributes.setOutlineWidth(d2);
        }
        if ((color = WWXML.getColor(element, "InteriorColor", xPath)) != null) {
            basicShapeAttributes.setInteriorMaterial(new Material(color));
        }
        if ((color = WWXML.getColor(element, "OutlineColor", xPath)) != null) {
            basicShapeAttributes.setOutlineMaterial(new Material(color));
        }
        return basicShapeAttributes;
    }

    protected void addRenderablesForShapefile(Shapefile shapefile, RenderableLayer renderableLayer) {
        if (Shapefile.isPointType(shapefile.getShapeType())) {
            this.addRenderablesForPoints(shapefile, renderableLayer);
        } else if (Shapefile.isMultiPointType(shapefile.getShapeType())) {
            this.addRenderablesForMultiPoints(shapefile, renderableLayer);
        } else if (Shapefile.isPolylineType(shapefile.getShapeType())) {
            this.addRenderablesForPolylines(shapefile, renderableLayer);
        } else if (Shapefile.isPolygonType(shapefile.getShapeType())) {
            this.addRenderablesForPolygons(shapefile, renderableLayer);
        } else {
            String string = Logging.getMessage("generic.UnrecognizedShapeType", shapefile.getShapeType());
            throw new WWRuntimeException(string);
        }
    }

    protected void addRenderablesForPoints(Shapefile shapefile, RenderableLayer renderableLayer) {
        while (shapefile.hasNext()) {
            ShapefileRecord shapefileRecord = shapefile.nextRecord();
            if (!Shapefile.isPointType(shapefileRecord.getShapeType())) continue;
            AVList aVList = this.applyMappings(shapefileRecord.getAttributes(), this.dBaseMappings);
            double[] dArray = ((ShapefileRecordPoint)shapefileRecord).getPoint();
            renderableLayer.addRenderable(this.createPoint(shapefileRecord, dArray[1], dArray[0], aVList));
        }
    }

    protected void addRenderablesForMultiPoints(Shapefile shapefile, RenderableLayer renderableLayer) {
        while (shapefile.hasNext()) {
            ShapefileRecord shapefileRecord = shapefile.nextRecord();
            if (!Shapefile.isMultiPointType(shapefileRecord.getShapeType())) continue;
            AVList aVList = this.applyMappings(shapefileRecord.getAttributes(), this.dBaseMappings);
            Iterable<double[]> iterable = ((ShapefileRecordMultiPoint)shapefileRecord).getPoints(0);
            for (double[] dArray : iterable) {
                renderableLayer.addRenderable(this.createPoint(shapefileRecord, dArray[1], dArray[0], aVList));
            }
        }
    }

    protected Renderable createPoint(ShapefileRecord shapefileRecord, double d, double d2, AVList aVList) {
        PointPlacemark pointPlacemark = new PointPlacemark(Position.fromDegrees(d, d2, 0.0));
        pointPlacemark.setAltitudeMode(1);
        if (this.normalPointAttributes != null) {
            pointPlacemark.setAttributes(this.normalPointAttributes);
        }
        if (this.highlightPointAttributes != null) {
            pointPlacemark.setHighlightAttributes(this.highlightPointAttributes);
        }
        if (aVList != null) {
            pointPlacemark.setValues(aVList);
        }
        return pointPlacemark;
    }

    protected void addRenderablesForPolylines(Shapefile shapefile, RenderableLayer renderableLayer) {
        ShapefilePolylines shapefilePolylines = new ShapefilePolylines(shapefile, this.normalShapeAttributes, this.highlightShapeAttributes, this);
        renderableLayer.addRenderable(shapefilePolylines);
    }

    protected void addRenderablesForPolygons(Shapefile shapefile, RenderableLayer renderableLayer) {
        if (ShapefileUtils.hasHeightAttribute(shapefile)) {
            this.addRenderablesForExtrudedPolygons(shapefile, renderableLayer);
        } else {
            this.addRenderablesForSurfacePolygons(shapefile, renderableLayer);
        }
    }

    protected void addRenderablesForSurfacePolygons(Shapefile shapefile, RenderableLayer renderableLayer) {
        ShapefilePolygons shapefilePolygons = new ShapefilePolygons(shapefile, this.normalShapeAttributes, this.highlightShapeAttributes, this);
        renderableLayer.addRenderable(shapefilePolygons);
    }

    protected void addRenderablesForExtrudedPolygons(Shapefile shapefile, RenderableLayer renderableLayer) {
        ShapefileExtrudedPolygons shapefileExtrudedPolygons = new ShapefileExtrudedPolygons(shapefile, this.normalShapeAttributes, this.highlightShapeAttributes, this);
        renderableLayer.addRenderable(shapefileExtrudedPolygons);
    }

    protected AVList applyMappings(DBaseRecord dBaseRecord, AVList aVList) {
        if (dBaseRecord == null || aVList == null) {
            return null;
        }
        AVListImpl aVListImpl = new AVListImpl();
        for (Map.Entry<String, Object> entry : aVList.getEntries()) {
            Object object = dBaseRecord.getValue(entry.getKey());
            if (object == null) continue;
            aVListImpl.setValue((String)entry.getValue(), object);
        }
        return aVListImpl.getEntries().size() > 0 ? aVListImpl : null;
    }

    protected void addPropertiesForShapefile(Shapefile shapefile, RenderableLayer renderableLayer) {
        if (renderableLayer.getValue("gov.nasa.worldwind.avkey.DisplayName") == null) {
            renderableLayer.setValue("gov.nasa.worldwind.avkey.DisplayName", shapefile.getValue("gov.nasa.worldwind.avkey.DisplayName"));
        }
        if (shapefile.getBoundingRectangle() != null) {
            renderableLayer.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(shapefile.getBoundingRectangle()));
        }
    }

    public static interface CompletionCallback {
        public void completion(Object var1);

        public void exception(Exception var1);
    }
}

