/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileRenderable;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PolylineTessellator;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceObjectTileBuilder;
import gov.nasa.worldwind.render.SurfaceRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Range;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.VecBuffer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ShapefilePolylines
extends ShapefileRenderable
implements OrderedRenderable,
PreRenderable {
    protected static final int DEFAULT_OUTLINE_PICK_WIDTH = 10;
    protected Tile rootTile;
    protected int tileMaxLevel = 3;
    protected int tileMaxCapacity = 10000;
    protected ArrayList<Tile> currentTiles = new ArrayList();
    protected PolylineTessellator tess = new PolylineTessellator();
    protected byte[] colorByteArray = new byte[3];
    protected float[] colorFloatArray = new float[4];
    protected double[] matrixArray = new double[16];
    protected int outlinePickWidth = 10;
    protected Layer pickLayer;
    protected PickSupport pickSupport = new PickSupport();
    protected SurfaceObjectTileBuilder pickTileBuilder = new SurfaceObjectTileBuilder(new Dimension(512, 512), 32856, false, false);
    protected ByteBuffer pickColors;
    protected Object pickColorsVboKey = new Object();

    public ShapefilePolylines(Shapefile shapefile) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(shapefile, null, null, null);
    }

    public ShapefilePolylines(Shapefile shapefile, ShapeAttributes shapeAttributes, ShapeAttributes shapeAttributes2, ShapefileRenderable.AttributeDelegate attributeDelegate) {
        if (shapefile == null) {
            String string = Logging.getMessage("nullValue.ShapefileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.init(shapefile, shapeAttributes, shapeAttributes2, attributeDelegate);
    }

    public int getOutlinePickWidth() {
        return this.outlinePickWidth;
    }

    public void setOutlinePickWidth(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlinePickWidth = n;
    }

    @Override
    public double getDistanceFromEye() {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRender(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.getRecordCount() == 0) {
            return;
        }
        this.assembleTiles(drawContext);
        for (Tile tile : this.currentTiles) {
            drawContext.addOrderedSurfaceRenderable(tile);
        }
        if (drawContext.getCurrentLayer().isPickEnabled()) {
            try {
                drawContext.enablePickingMode();
                this.assembleTiles(drawContext);
                this.pickSupport.clearPickList();
                this.pickTileBuilder.setForceTileUpdates(true);
                this.pickTileBuilder.buildTiles(drawContext, this.currentTiles);
            }
            finally {
                drawContext.disablePickingMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        int n = this.getRecordCount();
        if (n == 0) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        try {
            this.pickSupport.beginPicking(drawContext);
            gL2.glEnable(2884);
            drawContext.getGeographicSurfaceTileRenderer().setUseImageTilePickColors(true);
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.pickTileBuilder.getTiles(drawContext));
        }
        finally {
            drawContext.getGeographicSurfaceTileRenderer().setUseImageTilePickColors(false);
            gL2.glDisable(2884);
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
            this.pickTileBuilder.clearTiles(drawContext);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.visible) {
            return;
        }
        if (this.getRecordCount() == 0) {
            return;
        }
        if (drawContext.isPickingMode() && this.pickTileBuilder.getTileCount(drawContext) > 0) {
            this.pickLayer = drawContext.getCurrentLayer();
            drawContext.addOrderedSurfaceRenderable(this);
        }
    }

    @Override
    protected void assembleRecords(Shapefile shapefile) {
        this.rootTile = new Tile(this, this.sector, 0);
        super.assembleRecords(shapefile);
        if (this.mustSplitTile(this.rootTile)) {
            this.splitTile(this.rootTile);
        }
        this.rootTile.records.trimToSize();
    }

    @Override
    protected boolean mustAssembleRecord(ShapefileRecord shapefileRecord) {
        return super.mustAssembleRecord(shapefileRecord) && (shapefileRecord.isPolylineRecord() || shapefileRecord.isPolygonRecord());
    }

    @Override
    protected void assembleRecord(ShapefileRecord shapefileRecord) {
        Record record = this.createRecord(shapefileRecord);
        this.addRecord(shapefileRecord, record);
        this.rootTile.records.add(record);
        record.tile = this.rootTile;
    }

    protected Record createRecord(ShapefileRecord shapefileRecord) {
        return new Record(this, shapefileRecord);
    }

    @Override
    protected void recordDidChange(ShapefileRenderable.Record record) {
        Tile tile = ((Record)record).tile;
        if (tile != null) {
            this.invalidateTileAttributeGroups(tile);
        }
    }

    protected boolean mustSplitTile(Tile tile) {
        return tile.level < this.tileMaxLevel && tile.records.size() > this.tileMaxCapacity;
    }

    protected void splitTile(Tile tile) {
        Sector[] sectorArray = tile.sector.subdivide();
        tile.children = new Tile[4];
        tile.children[0] = new Tile(this, sectorArray[0], tile.level + 1);
        tile.children[1] = new Tile(this, sectorArray[1], tile.level + 1);
        tile.children[2] = new Tile(this, sectorArray[2], tile.level + 1);
        tile.children[3] = new Tile(this, sectorArray[3], tile.level + 1);
        Iterator<Record> iterator = tile.records.iterator();
        block0: while (iterator.hasNext()) {
            Record record = iterator.next();
            for (int i = 0; i < 4; ++i) {
                if (!tile.children[i].sector.contains(record.sector)) continue;
                tile.children[i].records.add(record);
                record.tile = tile.children[i];
                iterator.remove();
                continue block0;
            }
        }
        for (int i = 0; i < 4; ++i) {
            if (this.mustSplitTile(tile.children[i])) {
                this.splitTile(tile.children[i]);
            }
            tile.children[i].records.trimToSize();
        }
    }

    protected void assembleTiles(DrawContext drawContext) {
        this.currentTiles.clear();
        this.addTileOrDescendants(drawContext, this.rootTile);
    }

    protected void addTileOrDescendants(DrawContext drawContext, Tile tile) {
        if (!this.isTileVisible(drawContext, tile)) {
            return;
        }
        if (tile.records.size() > 0) {
            if (this.mustRegenerateTileGeometry(tile)) {
                this.regenerateTileGeometry(tile);
            }
            if (this.mustAssembleTileAttributeGroups(tile)) {
                this.assembleTileAttributeGroups(tile);
            }
            this.currentTiles.add(tile);
        }
        if (tile.children != null) {
            for (Tile tile2 : tile.children) {
                this.addTileOrDescendants(drawContext, tile2);
            }
        }
    }

    protected boolean isTileVisible(DrawContext drawContext, Tile tile) {
        Box box = Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), tile.sector);
        if (drawContext.isSmall(box, 1)) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(box);
        }
        return drawContext.getView().getFrustumInModelCoordinates().intersects(box);
    }

    protected boolean mustRegenerateTileGeometry(Tile tile) {
        return tile.vertices == null;
    }

    protected void regenerateTileGeometry(Tile tile) {
        this.tessellateTile(tile);
    }

    protected void tessellateTile(Tile tile) {
        int n = 0;
        for (Record object2 : tile.records) {
            n += object2.numberOfPoints;
        }
        int n2 = 2;
        FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer(n2 * n);
        double[] dArray = new double[2];
        float[] fArray = new float[2];
        Vec4 vec4 = null;
        for (Record record : tile.records) {
            this.tess.reset();
            for (int i = 0; i < record.getBoundaryCount(); ++i) {
                this.tess.beginPolyline();
                VecBuffer vecBuffer = record.getBoundaryPoints(i);
                for (int j = 0; j < vecBuffer.getSize(); ++j) {
                    vecBuffer.get(j, dArray);
                    double d = dArray[0];
                    double d2 = dArray[1];
                    int n3 = floatBuffer.position() / n2;
                    this.tess.addVertex(d, d2, 0.0, n3);
                    if (vec4 == null) {
                        vec4 = new Vec4(d, d2, 0.0);
                    }
                    fArray[0] = (float)(d - vec4.x);
                    fArray[1] = (float)(d2 - vec4.y);
                    floatBuffer.put(fArray);
                }
                this.tess.endPolyline();
            }
            this.assembleRecordIndices(this.tess, record);
        }
        tile.vertices = floatBuffer.rewind();
        tile.vertexStride = n2;
        tile.referencePoint = vec4;
        tile.transformMatrix = Matrix.fromTranslation(vec4.x, vec4.y, vec4.z);
    }

    protected void assembleRecordIndices(PolylineTessellator polylineTessellator, Record record) {
        IntBuffer intBuffer = polylineTessellator.getIndices().flip();
        IntBuffer intBuffer2 = IntBuffer.allocate(intBuffer.remaining());
        intBuffer2.put(intBuffer);
        record.outlineIndices = intBuffer2.rewind();
    }

    protected void invalidateTileAttributeGroups(Tile tile) {
        tile.attributeGroups.clear();
    }

    protected boolean mustAssembleTileAttributeGroups(Tile tile) {
        return tile.attributeGroups.isEmpty();
    }

    protected void assembleTileAttributeGroups(Tile tile) {
        Object object;
        tile.attributeGroups.clear();
        ++tile.attributeStateID;
        HashMap<ShapeAttributes, Object> hashMap = new HashMap<ShapeAttributes, Object>();
        for (Record object2 : tile.records) {
            if (!object2.isVisible()) continue;
            ShapeAttributes shapeAttributes = this.determineActiveAttributes(object2);
            object = (RecordGroup)hashMap.get(shapeAttributes);
            if (object == null) {
                object = new RecordGroup(shapeAttributes);
                hashMap.put(shapeAttributes, object);
                tile.attributeGroups.add((RecordGroup)object);
            }
            ((RecordGroup)object).records.add(object2);
            ((RecordGroup)object).outlineIndexRange.length += object2.outlineIndices.remaining();
        }
        for (RecordGroup recordGroup : tile.attributeGroups) {
            int n = recordGroup.outlineIndexRange.length;
            object = Buffers.newDirectIntBuffer(n);
            recordGroup.outlineIndexRange.location = ((Buffer)object).position();
            for (Record record : recordGroup.records) {
                ((IntBuffer)object).put(record.outlineIndices);
                record.outlineIndices.rewind();
            }
            recordGroup.indices = ((IntBuffer)object).rewind();
            recordGroup.records.clear();
            recordGroup.records.trimToSize();
        }
    }

    protected void renderTile(DrawContext drawContext, Tile tile) {
        this.beginDrawing(drawContext);
        try {
            if (drawContext.isPickingMode()) {
                this.drawTileInUniqueColors(drawContext, tile);
            } else {
                this.drawTile(drawContext, tile);
            }
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glDisable(2929);
        gL2.glEnableClientState(32884);
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        if (!drawContext.isPickingMode()) {
            gL2.glEnable(3042);
            gL2.glEnable(2848);
            gL2.glBlendFunc(770, 771);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glEnable(2929);
        gL2.glDisableClientState(32884);
        gL2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gL2.glLineWidth(1.0f);
        gL2.glPopMatrix();
        if (!drawContext.isPickingMode()) {
            gL2.glDisable(3042);
            gL2.glDisable(2848);
            gL2.glBlendFunc(1, 0);
        }
        if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject()) {
            gL2.glBindBuffer(34962, 0);
            gL2.glBindBuffer(34963, 0);
        }
    }

    protected void drawTile(DrawContext drawContext, Tile tile) {
        GL2 gL2 = drawContext.getGL().getGL2();
        int[] nArray = null;
        boolean bl = drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
        if (bl && (nArray = (int[])drawContext.getGpuResourceCache().get(tile.vboKey)) == null) {
            long l = 4 * tile.vertices.remaining();
            nArray = new int[1];
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, l, tile.vertices, 35044);
            gL2.glVertexPointer(tile.vertexStride, 5126, 0, 0L);
            drawContext.getGpuResourceCache().put(tile.vboKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", l);
        } else if (bl) {
            gL2.glBindBuffer(34962, (int)nArray[0]);
            gL2.glVertexPointer(tile.vertexStride, 5126, 0, 0L);
        } else {
            gL2.glVertexPointer(tile.vertexStride, 5126, 0, tile.vertices);
        }
        SurfaceTileDrawContext surfaceTileDrawContext = (SurfaceTileDrawContext)drawContext.getValue("gov.nasa.worldwind.avkey.SurfaceTileDrawContext");
        Matrix matrix = surfaceTileDrawContext.getModelviewMatrix().multiply(tile.transformMatrix);
        matrix.toArray(this.matrixArray, 0, false);
        gL2.glLoadMatrixd(this.matrixArray, 0);
        for (RecordGroup recordGroup : tile.attributeGroups) {
            this.drawTileAttributeGroup(drawContext, recordGroup);
        }
    }

    protected void drawTileAttributeGroup(DrawContext drawContext, RecordGroup recordGroup) {
        GL2 gL2 = drawContext.getGL().getGL2();
        ShapeAttributes shapeAttributes = recordGroup.attributes;
        if (!shapeAttributes.isDrawOutline()) {
            return;
        }
        int[] nArray = null;
        boolean bl = drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
        if (bl && (nArray = (int[])drawContext.getGpuResourceCache().get(recordGroup.vboKey)) == null) {
            long l = 4 * recordGroup.indices.remaining();
            nArray = new int[1];
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34963, nArray[0]);
            gL2.glBufferData(34963, l, recordGroup.indices, 35044);
            drawContext.getGpuResourceCache().put(recordGroup.vboKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", l);
        } else if (bl) {
            gL2.glBindBuffer(34963, (int)nArray[0]);
        }
        if (!drawContext.isPickingMode()) {
            float[] fArray = this.colorFloatArray;
            shapeAttributes.getOutlineMaterial().getDiffuse().getRGBComponents(fArray);
            gL2.glColor4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        if (drawContext.isPickingMode() && shapeAttributes.getOutlineWidth() < (double)this.getOutlinePickWidth()) {
            gL2.glLineWidth(this.getOutlinePickWidth());
        } else {
            gL2.glLineWidth((float)shapeAttributes.getOutlineWidth());
        }
        if (bl) {
            gL2.glDrawElements(1, recordGroup.indices.remaining(), 5125, 0L);
        } else {
            gL2.glDrawElements(1, recordGroup.indices.remaining(), 5125, recordGroup.indices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTileInUniqueColors(DrawContext drawContext, Tile tile) {
        ByteBuffer byteBuffer;
        GL2 gL2 = drawContext.getGL().getGL2();
        int n = 3 * (tile.vertices.remaining() / tile.vertexStride);
        if (this.pickColors == null || this.pickColors.capacity() < n) {
            this.pickColors = Buffers.newDirectByteBuffer(n);
            drawContext.getGpuResourceCache().remove(this.pickColorsVboKey);
        }
        this.pickColors.clear();
        int[] nArray = null;
        boolean bl = drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject();
        if (bl && (nArray = (int[])drawContext.getGpuResourceCache().get(this.pickColorsVboKey)) == null) {
            nArray = new int[1];
            gL2.glGenBuffers(1, nArray, 0);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, this.pickColors.remaining(), this.pickColors, 35048);
            drawContext.getGpuResourceCache().put(this.pickColorsVboKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", this.pickColors.remaining());
            byteBuffer = gL2.glMapBuffer(34962, 35001);
        } else if (bl) {
            gL2.glBindBuffer(34962, (int)nArray[0]);
            byteBuffer = gL2.glMapBuffer(34962, 35001);
        } else {
            byteBuffer = this.pickColors;
        }
        byte[] byArray = this.colorByteArray;
        for (Record record : tile.records) {
            Color color = drawContext.getUniquePickColor();
            this.pickSupport.addPickableObject(color.getRGB(), record);
            byArray[0] = (byte)color.getRed();
            byArray[1] = (byte)color.getGreen();
            byArray[2] = (byte)color.getBlue();
            for (int i = 0; i < record.numberOfPoints; ++i) {
                byteBuffer.put(byArray, 0, 3);
            }
        }
        byteBuffer.flip();
        try {
            this.pickSupport.beginPicking(drawContext);
            gL2.glEnableClientState(32886);
            if (bl) {
                gL2.glUnmapBuffer(34962);
                gL2.glColorPointer(3, 5121, 0, 0L);
            } else {
                gL2.glColorPointer(3, 5121, 0, byteBuffer);
            }
            this.drawTile(drawContext, tile);
        }
        finally {
            gL2.glDisableClientState(32886);
            this.pickSupport.endPicking(drawContext);
        }
    }

    protected static class Tile
    implements OrderedRenderable,
    SurfaceRenderable {
        public ShapefileRenderable shapefileRenderable;
        public final Sector sector;
        public final int level;
        public ArrayList<Record> records = new ArrayList();
        public ArrayList<RecordGroup> attributeGroups = new ArrayList();
        public long attributeStateID;
        public Tile[] children;
        public FloatBuffer vertices;
        public int vertexStride;
        public Vec4 referencePoint;
        public Matrix transformMatrix;
        public Object vboKey = new Object();

        public Tile(ShapefileRenderable shapefileRenderable, Sector sector, int n) {
            this.shapefileRenderable = shapefileRenderable;
            this.sector = sector;
            this.level = n;
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public List<Sector> getSectors(DrawContext drawContext) {
            return Arrays.asList(this.sector);
        }

        @Override
        public Object getStateKey(DrawContext drawContext) {
            return new TileStateKey(this);
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        @Override
        public void render(DrawContext drawContext) {
            ((ShapefilePolylines)this.shapefileRenderable).renderTile(drawContext, this);
        }
    }

    public static class Record
    extends ShapefileRenderable.Record {
        protected Tile tile;
        protected IntBuffer outlineIndices;

        public Record(ShapefileRenderable shapefileRenderable, ShapefileRecord shapefileRecord) {
            super(shapefileRenderable, shapefileRecord);
        }
    }

    protected static class RecordGroup {
        public final ShapeAttributes attributes;
        public ArrayList<Record> records = new ArrayList();
        public IntBuffer indices;
        public Range outlineIndexRange = new Range(0, 0);
        public Object vboKey = new Object();

        public RecordGroup(ShapeAttributes shapeAttributes) {
            this.attributes = shapeAttributes;
        }
    }

    protected static class TileStateKey {
        protected Tile tile;
        protected long attributeStateID;
        protected ShapeAttributes[] attributeGroups;

        public TileStateKey(Tile tile) {
            this.tile = tile;
            this.attributeStateID = tile.attributeStateID;
            this.attributeGroups = new ShapeAttributes[tile.attributeGroups.size()];
            for (int i = 0; i < this.attributeGroups.length; ++i) {
                this.attributeGroups[i] = tile.attributeGroups.get((int)i).attributes.copy();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TileStateKey tileStateKey = (TileStateKey)object;
            return this.tile.equals(tileStateKey.tile) && this.attributeStateID == tileStateKey.attributeStateID && Arrays.equals(this.attributeGroups, tileStateKey.attributeGroups);
        }

        public int hashCode() {
            int n = this.tile.hashCode();
            n = 31 * n + (int)(this.attributeStateID ^ this.attributeStateID >>> 32);
            n = 31 * n + Arrays.hashCode(this.attributeGroups);
            return n;
        }
    }
}

