/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.util.VecBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ShapefileRecordPoint
extends ShapefileRecord {
    protected Double z;
    protected Double m;

    public ShapefileRecordPoint(Shapefile shapefile, ByteBuffer byteBuffer) {
        super(shapefile, byteBuffer);
    }

    @Override
    public boolean isPointRecord() {
        return true;
    }

    public double[] getPoint() {
        VecBuffer vecBuffer = this.getPointBuffer(0);
        return vecBuffer.get(0, new double[vecBuffer.getCoordsPerVec()]);
    }

    public Double getZ() {
        return this.z;
    }

    public Double getM() {
        return this.m;
    }

    @Override
    public double[] getBoundingRectangle() {
        return null;
    }

    @Override
    protected void doReadFromBuffer(Shapefile shapefile, ByteBuffer byteBuffer) {
        if (shapefile.isNormalizePoints()) {
            this.setNormalizePoints(true);
        }
        this.numberOfParts = 1;
        this.numberOfPoints = 1;
        this.firstPartNumber = shapefile.addPoints(this, byteBuffer, 1);
        if (this.isZType()) {
            this.readZ(byteBuffer);
        }
        if (this.isMeasureType()) {
            this.readOptionalMeasure(byteBuffer);
        }
    }

    protected void readZ(ByteBuffer byteBuffer) {
        double[] dArray = ShapefileUtils.readDoubleArray(byteBuffer, 1);
        this.z = dArray[0];
    }

    protected void readOptionalMeasure(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining() && byteBuffer.limit() - byteBuffer.position() >= 8) {
            double[] dArray = ShapefileUtils.readDoubleArray(byteBuffer, 1);
            this.m = dArray[0];
        }
    }

    @Override
    public void exportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartElement("Placemark");
        xMLStreamWriter.writeStartElement("name");
        xMLStreamWriter.writeCharacters(Integer.toString(this.getRecordNumber()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("Point");
        String string = "absolute";
        double[] dArray = this.getPoint();
        Double d = this.getZ();
        if (d == null) {
            d = 0.0;
            string = "clampToGround";
        }
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        String string2 = String.format("%f,%f,%f", dArray[0], dArray[1], d);
        xMLStreamWriter.writeStartElement("coordinates");
        xMLStreamWriter.writeCharacters(string2);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
    }
}

