/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.formats.shapefile.ShapefileUtils;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.util.VecBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ShapefileRecordPolyline
extends ShapefileRecord {
    protected double[] boundingRectangle;
    protected double[] zRange;
    protected double[] zValues;
    protected double[] mRange;
    protected double[] mValues;

    public ShapefileRecordPolyline(Shapefile shapefile, ByteBuffer byteBuffer) {
        super(shapefile, byteBuffer);
    }

    @Override
    public boolean isPolylineRecord() {
        return true;
    }

    public Iterable<double[]> getPoints(int n) {
        return this.getPointBuffer(n).getCoords();
    }

    public double[] getZRange() {
        return this.zRange;
    }

    public double[] getZValues() {
        return this.zValues;
    }

    public double[] getMRange() {
        return this.mRange;
    }

    public double[] getMValues() {
        return this.mValues;
    }

    @Override
    public double[] getBoundingRectangle() {
        return this.boundingRectangle != null ? this.boundingRectangle : null;
    }

    @Override
    protected void doReadFromBuffer(Shapefile shapefile, ByteBuffer byteBuffer) {
        Shapefile.BoundingRectangle boundingRectangle = shapefile.readBoundingRectangle(byteBuffer);
        this.boundingRectangle = boundingRectangle.coords;
        if (boundingRectangle.isNormalized) {
            this.setNormalizePoints(true);
        }
        this.numberOfParts = byteBuffer.getInt();
        this.numberOfPoints = byteBuffer.getInt();
        this.firstPartNumber = -1;
        if (this.numberOfParts > 0 && this.numberOfPoints > 0) {
            int[] nArray = ShapefileUtils.readIntArray(byteBuffer, this.numberOfParts);
            for (int i = 0; i < this.numberOfParts; ++i) {
                int n = i == this.numberOfParts - 1 ? this.numberOfPoints - nArray[i] : nArray[i + 1] - nArray[i];
                int n2 = shapefile.addPoints(this, byteBuffer, n);
                if (this.firstPartNumber >= 0) continue;
                this.firstPartNumber = n2;
            }
        }
        if (this.isZType()) {
            this.readZ(byteBuffer);
        }
        if (this.isMeasureType()) {
            this.readOptionalMeasures(byteBuffer);
        }
    }

    protected void readZ(ByteBuffer byteBuffer) {
        this.zRange = ShapefileUtils.readDoubleArray(byteBuffer, 2);
        this.zValues = ShapefileUtils.readDoubleArray(byteBuffer, this.getNumberOfPoints());
    }

    protected void readOptionalMeasures(ByteBuffer byteBuffer) {
        if (byteBuffer.hasRemaining() && byteBuffer.limit() - byteBuffer.position() >= this.getNumberOfPoints() * 8) {
            this.mRange = ShapefileUtils.readDoubleArray(byteBuffer, 2);
            this.mValues = ShapefileUtils.readDoubleArray(byteBuffer, this.getNumberOfPoints());
        }
    }

    @Override
    public void exportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        for (int i = 0; i < this.getNumberOfParts(); ++i) {
            xMLStreamWriter.writeStartElement("Placemark");
            xMLStreamWriter.writeStartElement("name");
            xMLStreamWriter.writeCharacters(Integer.toString(this.getRecordNumber()));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("LineString");
            String string = this.isZType() ? "absolute" : "clampToGround";
            xMLStreamWriter.writeStartElement("altitudeMode");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("coordinates");
            double[] dArray = this.getZValues();
            int n = 0;
            VecBuffer vecBuffer = this.getPointBuffer(i);
            for (LatLon latLon : vecBuffer.getLocations()) {
                double d = 0.0;
                if (dArray != null && n < dArray.length) {
                    d = dArray[n];
                }
                xMLStreamWriter.writeCharacters(String.format(Locale.US, "%f,%f,%f ", latLon.getLongitude().getDegrees(), latLon.getLatitude().getDegrees(), d));
                ++n;
            }
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
    }
}

