/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.shapefile.Shapefile;
import gov.nasa.worldwind.formats.shapefile.ShapefileRecord;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Highlightable;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.VecBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class ShapefileRenderable
extends WWObjectImpl
implements Renderable,
Iterable<Record> {
    protected Sector sector;
    protected ArrayList<Record> records;
    protected boolean visible = true;
    protected ShapeAttributes initNormalAttrs;
    protected ShapeAttributes initHighlightAttrs;
    protected AttributeDelegate initAttributeDelegate;
    protected static ShapeAttributes defaultAttributes = new BasicShapeAttributes();
    protected static ShapeAttributes defaultHighlightAttributes;

    protected void init(Shapefile shapefile, ShapeAttributes shapeAttributes, ShapeAttributes shapeAttributes2, AttributeDelegate attributeDelegate) {
        double[] dArray = shapefile.getBoundingRectangle();
        if (dArray == null) {
            return;
        }
        this.sector = Sector.fromDegrees(dArray);
        this.initNormalAttrs = shapeAttributes;
        this.initHighlightAttrs = shapeAttributes2;
        this.initAttributeDelegate = attributeDelegate;
        this.assembleRecords(shapefile);
    }

    protected void assembleRecords(Shapefile shapefile) {
        this.records = new ArrayList();
        while (shapefile.hasNext()) {
            ShapefileRecord shapefileRecord = shapefile.nextRecord();
            if (!this.mustAssembleRecord(shapefileRecord)) continue;
            this.assembleRecord(shapefileRecord);
        }
        this.records.trimToSize();
    }

    protected boolean mustAssembleRecord(ShapefileRecord shapefileRecord) {
        return shapefileRecord.getNumberOfParts() > 0 && shapefileRecord.getNumberOfPoints() > 0 && !shapefileRecord.isNullRecord();
    }

    protected void assembleRecord(ShapefileRecord shapefileRecord) {
        Record record = new Record(this, shapefileRecord);
        this.addRecord(shapefileRecord, record);
    }

    protected void addRecord(ShapefileRecord shapefileRecord, Record record) {
        record.setAttributes(this.initNormalAttrs);
        record.setHighlightAttributes(this.initHighlightAttrs);
        record.ordinal = this.records.size();
        this.records.add(record);
        if (this.initAttributeDelegate != null) {
            this.initAttributeDelegate.assignAttributes(shapefileRecord, record);
        }
    }

    public Sector getSector() {
        return this.sector;
    }

    public int getRecordCount() {
        if (this.records == null) {
            return 0;
        }
        return this.records.size();
    }

    public Record getRecord(int n) {
        if (this.records == null || n < 0 || n >= this.records.size()) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.records.get(n);
    }

    @Override
    public Iterator<Record> iterator() {
        if (this.records == null) {
            return Collections.emptyList().iterator();
        }
        return this.records.iterator();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    protected void recordDidChange(Record record) {
    }

    protected ShapeAttributes determineActiveAttributes(Record record) {
        if (record.highlighted) {
            return record.highlightAttrs != null ? record.highlightAttrs : defaultHighlightAttributes;
        }
        if (record.normalAttrs != null) {
            return record.normalAttrs;
        }
        return defaultAttributes;
    }

    static {
        defaultAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
        defaultAttributes.setOutlineMaterial(Material.DARK_GRAY);
        defaultHighlightAttributes = new BasicShapeAttributes();
        defaultHighlightAttributes.setInteriorMaterial(Material.WHITE);
        defaultHighlightAttributes.setOutlineMaterial(Material.DARK_GRAY);
    }

    public static interface AttributeDelegate {
        public void assignAttributes(ShapefileRecord var1, Record var2);
    }

    public static class Record
    extends AVListImpl
    implements Highlightable {
        protected ShapefileRenderable shapefileRenderable;
        protected Sector sector;
        protected int ordinal;
        protected boolean visible = true;
        protected boolean highlighted;
        protected ShapeAttributes normalAttrs;
        protected ShapeAttributes highlightAttrs;
        protected final CompoundVecBuffer pointBuffer;
        protected int firstPartNumber;
        protected int numberOfParts;
        protected int numberOfPoints;

        public Record(ShapefileRenderable shapefileRenderable, ShapefileRecord shapefileRecord) {
            if (shapefileRenderable == null) {
                String string = Logging.getMessage("nullValue.RenderableIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (shapefileRecord == null) {
                String string = Logging.getMessage("nullValue.RecordIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.shapefileRenderable = shapefileRenderable;
            this.sector = shapefileRecord.getBoundingRectangle() != null ? Sector.fromDegrees(shapefileRecord.getBoundingRectangle()) : null;
            this.pointBuffer = shapefileRecord.getShapeFile().getPointBuffer();
            this.firstPartNumber = shapefileRecord.getFirstPartNumber();
            this.numberOfParts = shapefileRecord.getNumberOfParts();
            this.numberOfPoints = shapefileRecord.getNumberOfPoints();
        }

        public ShapefileRenderable getShapefileRenderable() {
            return this.shapefileRenderable;
        }

        public Sector getSector() {
            return this.sector;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            if (this.visible != bl) {
                this.visible = bl;
                this.shapefileRenderable.recordDidChange(this);
            }
        }

        @Override
        public boolean isHighlighted() {
            return this.highlighted;
        }

        @Override
        public void setHighlighted(boolean bl) {
            if (this.highlighted != bl) {
                this.highlighted = bl;
                this.shapefileRenderable.recordDidChange(this);
            }
        }

        public ShapeAttributes getAttributes() {
            return this.normalAttrs;
        }

        public void setAttributes(ShapeAttributes shapeAttributes) {
            if (this.normalAttrs != shapeAttributes) {
                this.normalAttrs = shapeAttributes;
                this.shapefileRenderable.recordDidChange(this);
            }
        }

        public ShapeAttributes getHighlightAttributes() {
            return this.highlightAttrs;
        }

        public void setHighlightAttributes(ShapeAttributes shapeAttributes) {
            if (this.highlightAttrs != shapeAttributes) {
                this.highlightAttrs = shapeAttributes;
                this.shapefileRenderable.recordDidChange(this);
            }
        }

        public int getBoundaryCount() {
            return this.numberOfParts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VecBuffer getBoundaryPoints(int n) {
            if (n < 0 || n >= this.numberOfParts) {
                String string = Logging.getMessage("generic.indexOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            CompoundVecBuffer compoundVecBuffer = this.pointBuffer;
            synchronized (compoundVecBuffer) {
                return this.pointBuffer.subBuffer(this.firstPartNumber + n);
            }
        }

        public Iterable<Position> getBoundaryPositions(int n) {
            if (n < 0 || n >= this.numberOfParts) {
                String string = Logging.getMessage("generic.indexOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            VecBuffer vecBuffer = this.getBoundaryPoints(n);
            return vecBuffer.getPositions();
        }
    }
}

