/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.util.Logging;
import java.util.HashMap;
import java.util.Vector;

class GeoCodec {
    private HashMap<Integer, GeoKeyEntry> geoKeys = null;
    private Vector<ModelTiePoint> tiePoints = new Vector(1);
    private double xScale;
    private double yScale;
    private double zScale;
    private Matrix modelTransform;
    private short[] shortParams;
    private double[] doubleParams;
    private byte[] asciiParams;

    public void addModelTiePoints(double[] dArray) throws IllegalArgumentException {
        if (dArray == null || dArray.length == 0 || dArray.length % 6 != 0) {
            String string = Logging.getMessage("GeoCodec.BadTiePoints");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        for (int i = 0; i < dArray.length; i += 6) {
            this.addModelTiePoint(dArray[i], dArray[i + 1], dArray[i + 2], dArray[i + 3], dArray[i + 4], dArray[i + 5]);
        }
    }

    public void addModelTiePoint(double d, double d2, double d3, double d4, double d5, double d6) {
        ModelTiePoint modelTiePoint = new ModelTiePoint(d, d2, d3, d4, d5, d6);
        this.tiePoints.add(modelTiePoint);
    }

    public ModelTiePoint[] getTiePoints() {
        ModelTiePoint[] modelTiePointArray = new ModelTiePoint[this.tiePoints.size()];
        return this.tiePoints.toArray(modelTiePointArray);
    }

    public void setModelPixelScale(double[] dArray) {
        if (dArray == null || dArray.length != 3) {
            String string = Logging.getMessage("GeoCodec.BadPixelValues");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        this.setModelPixelScale(dArray[0], dArray[1], dArray[2]);
    }

    public void setModelPixelScale(double d, double d2, double d3) {
        this.xScale = d;
        this.yScale = d2;
        this.zScale = d3;
    }

    public double getModelPixelScaleX() {
        return this.xScale;
    }

    public double getModelPixelScaleY() {
        return this.yScale;
    }

    public void setModelTransformation(double[] dArray) throws IllegalArgumentException {
        if (dArray == null || dArray.length != 16) {
            String string = Logging.getMessage("GeoCodec.BadMatrix");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        this.setModelTransformation(Matrix.fromArray(dArray, 0, true));
    }

    public void setModelTransformation(Matrix matrix) {
        this.modelTransform = matrix;
        Matrix matrix2 = this.modelTransform.multiply(Matrix.fromTranslation(0.0, 0.0, 0.0));
        this.addModelTiePoint(0.0, 0.0, 0.0, matrix2.m14, matrix2.m24, matrix2.m34);
        this.setModelPixelScale(matrix.m11, matrix.m22, 0.0);
    }

    public double[] getBoundingBox(int n, int n2) throws UnsupportedOperationException {
        double[] dArray = new double[4];
        double[] dArray2 = this.getXYAtPixel(0, 0);
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray2 = this.getXYAtPixel(n2, n);
        dArray[2] = dArray2[0];
        dArray[3] = dArray2[1];
        return dArray;
    }

    public double[] getXYAtPixel(int n, int n2) throws UnsupportedOperationException {
        if (this.tiePoints.size() == 0) {
            String string = Logging.getMessage("GeotiffReader.NotSimpleGeotiff");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        double[] dArray = new double[2];
        ModelTiePoint modelTiePoint = this.tiePoints.get(0);
        dArray[0] = modelTiePoint.x + (double)n2 * this.xScale;
        dArray[1] = modelTiePoint.y - (double)n * this.yScale;
        return dArray;
    }

    public int[] getGeoKeyAsInts(int n) throws IllegalArgumentException {
        GeoKeyEntry geoKeyEntry;
        int[] nArray = null;
        if (this.geoKeys != null && (geoKeyEntry = this.geoKeys.get(n)) != null) {
            if (geoKeyEntry.array != this.shortParams) {
                String string = Logging.getMessage("GeoCodec.NotIntegerKey", n);
                Logging.logger().severe(string);
                throw new UnsupportedOperationException(string);
            }
            nArray = new int[geoKeyEntry.count];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0xFFFF & this.shortParams[geoKeyEntry.offset + i];
            }
        }
        return nArray;
    }

    public boolean hasGeoKey(int n) {
        return this.geoKeys != null && this.geoKeys.get(n) != null;
    }

    void setGeokeys(short[] sArray) {
        if (sArray != null && sArray.length > 4) {
            this.shortParams = new short[sArray.length];
            System.arraycopy(sArray, 0, this.shortParams, 0, sArray.length);
            int n = sArray[3];
            this.geoKeys = new HashMap();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = 0xFFFF & sArray[n2 += 4];
                int n4 = 0xFFFF & sArray[n2 + 1];
                if (n4 == 0) {
                    this.geoKeys.put(n3, new GeoKeyEntry(n3, 1, n2 + 3, this.shortParams));
                    continue;
                }
                Object[] objectArray = null;
                if (n4 == 34735) {
                    objectArray = this.shortParams;
                } else if (n4 == 34736) {
                    objectArray = this.doubleParams;
                } else if (n4 == 34737) {
                    objectArray = this.asciiParams;
                }
                if (objectArray == null) continue;
                this.geoKeys.put(n3, new GeoKeyEntry(n3, 0xFFFF & sArray[n2 + 2], 0xFFFF & sArray[n2 + 3], objectArray));
            }
        }
    }

    void setDoubleParams(double[] dArray) {
        this.doubleParams = new double[dArray.length];
        System.arraycopy(dArray, 0, this.doubleParams, 0, dArray.length);
    }

    void setAsciiParams(byte[] byArray) {
        this.asciiParams = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.asciiParams, 0, byArray.length);
    }

    public class ModelTiePoint {
        public double i;
        public double j;
        public double k;
        public double x;
        public double y;
        public double z;

        public ModelTiePoint(double d, double d2, double d3, double d4, double d5, double d6) {
            this.i = d;
            this.j = d2;
            this.k = d3;
            this.x = d4;
            this.y = d5;
            this.z = d6;
        }

        public double getRow() {
            return this.j;
        }

        public double getColumn() {
            return this.i;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    private class GeoKeyEntry {
        int tag;
        int count;
        int offset;
        Object array;

        GeoKeyEntry(int n, int n2, int n3, Object object) {
            this.tag = n;
            this.count = n2;
            this.offset = n3;
            this.array = object;
        }
    }
}

