/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.formats.tiff.BaselineTiff;
import gov.nasa.worldwind.formats.tiff.GeoCodec;
import gov.nasa.worldwind.formats.tiff.TIFFIFDFactory;
import gov.nasa.worldwind.formats.tiff.TIFFReader;
import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ElevationsUtil;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;

public class GeotiffReader
implements Disposable {
    private TIFFReader tiffReader = null;
    private String sourceFilename;
    private RandomAccessFile sourceFile;
    private FileChannel theChannel;
    private GeoCodec gc = new GeoCodec();
    private ArrayList<TiffIFDEntry[]> tiffIFDs = null;
    private ArrayList<AVList> metadata = null;

    public GeotiffReader(String string) throws IOException {
        this.sourceFilename = string;
        this.sourceFile = new RandomAccessFile(string, "r");
        this.theChannel = this.sourceFile.getChannel();
        this.tiffReader = new TIFFReader(this.theChannel);
        this.readTiffHeaders();
    }

    public GeotiffReader(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    protected AVList getMetadata(int n) throws IOException {
        this.checkImageIndex(n);
        AVList aVList = this.metadata.get(n);
        return null != aVList ? aVList.copy() : null;
    }

    public AVList copyMetadataTo(int n, AVList aVList) throws IOException {
        AVList aVList2 = this.getMetadata(n);
        if (null != aVList) {
            aVList.setValues(aVList2);
        } else {
            aVList = aVList2;
        }
        return aVList;
    }

    public AVList copyMetadataTo(AVList aVList) throws IOException {
        return this.copyMetadataTo(0, aVList);
    }

    public void close() {
        try {
            this.sourceFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumImages() throws IOException {
        return this.tiffIFDs != null ? this.tiffIFDs.size() : 0;
    }

    public int getWidth(int n) throws IOException {
        this.checkImageIndex(n);
        AVList aVList = this.metadata.get(n);
        return aVList.hasKey("gov.nasa.worldwind.avkey.Width") ? (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width") : 0;
    }

    public int getHeight(int n) throws IOException {
        this.checkImageIndex(n);
        AVList aVList = this.metadata.get(n);
        return aVList.hasKey("gov.nasa.worldwind.avkey.Height") ? (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height") : 0;
    }

    public DataRaster[] readDataRaster() throws IOException {
        int n = this.getNumImages();
        if (n <= 0) {
            return null;
        }
        DataRaster[] dataRasterArray = new DataRaster[n];
        for (int i = 0; i < n; ++i) {
            dataRasterArray[i] = this.doRead(i);
        }
        return dataRasterArray;
    }

    public DataRaster readDataRaster(int n) throws IOException {
        this.checkImageIndex(n);
        return this.doRead(n);
    }

    public BufferedImage read() throws IOException {
        return this.read(0);
    }

    public BufferedImage read(int n) throws IOException {
        DataRaster dataRaster = this.doRead(n);
        if (null == dataRaster) {
            return null;
        }
        if (dataRaster instanceof BufferedImageRaster) {
            return ((BufferedImageRaster)dataRaster).getBufferedImage();
        }
        String string = Logging.getMessage("Geotiff.IsNotAnImage");
        Logging.logger().severe(string);
        throw new IOException(string);
    }

    public boolean isGeotiff(int n) throws IOException {
        AVList aVList = this.metadata.get(n);
        return null != aVList && aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem");
    }

    public DataRaster doRead(int n) throws IOException {
        Object object;
        this.checkImageIndex(n);
        AVList aVList = this.metadata.get(n);
        long[] lArray = null;
        byte[][] byArray = null;
        long[] lArray2 = null;
        boolean bl = false;
        TiffIFDEntry[] tiffIFDEntryArray = this.tiffIFDs.get(n);
        BaselineTiff baselineTiff = BaselineTiff.extract(tiffIFDEntryArray, this.tiffReader);
        if (null == baselineTiff) {
            String string = Logging.getMessage("GeotiffReader.BadGeotiff");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (baselineTiff.width <= 0) {
            String string = Logging.getMessage("GeotiffReader.InvalidIFDEntryValue", baselineTiff.width, "width", 256);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (baselineTiff.height <= 0) {
            String string = Logging.getMessage("GeotiffReader.InvalidIFDEntryValue", baselineTiff.height, "height", 257);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (baselineTiff.samplesPerPixel <= 0) {
            String string = Logging.getMessage("GeotiffReader.InvalidIFDEntryValue", baselineTiff.samplesPerPixel, "samplesPerPixel", 277);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (baselineTiff.photometric <= -1 || baselineTiff.photometric > 6) {
            String string = Logging.getMessage("GeotiffReader.InvalidIFDEntryValue", baselineTiff.photometric, "PhotoInterpretation", 262);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (baselineTiff.rowsPerStrip <= 0) {
            object = Logging.getMessage("GeotiffReader.InvalidIFDEntryValue", baselineTiff.rowsPerStrip, "RowsPerStrip", 278);
            Logging.logger().fine((String)object);
            baselineTiff.rowsPerStrip = Integer.MAX_VALUE;
        }
        if (baselineTiff.planarConfig != 2 && baselineTiff.planarConfig != 1) {
            object = Logging.getMessage("GeotiffReader.InvalidIFDEntryValue", baselineTiff.planarConfig, "PhotoInterpretation", 262);
            Logging.logger().severe((String)object);
            throw new IOException((String)object);
        }
        for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray) {
            try {
                switch (tiffIFDEntry.tag) {
                    case 273: {
                        lArray = tiffIFDEntry.getAsLongs();
                        break;
                    }
                    case 279: {
                        lArray2 = tiffIFDEntry.getAsLongs();
                        break;
                    }
                    case 320: {
                        byArray = this.tiffReader.readColorMap(tiffIFDEntry);
                    }
                }
            }
            catch (IOException iOException) {
                Logging.logger().finest(iOException.toString());
            }
        }
        if (null == lArray || 0 == lArray.length) {
            object = Logging.getMessage("GeotiffReader.MissingRequiredTag", "StripOffsets");
            Logging.logger().severe((String)object);
            throw new IOException((String)object);
        }
        if (null == lArray2 || 0 == lArray2.length) {
            object = Logging.getMessage("GeotiffReader.MissingRequiredTag", "StripCounts");
            Logging.logger().severe((String)object);
            throw new IOException((String)object);
        }
        object = this.getByTag(tiffIFDEntryArray, 259);
        int n2 = 0;
        if (object != null && ((TiffIFDEntry)object).asLong() == 5L) {
            n2 = 1;
            TiffIFDEntry tiffIFDEntry = this.getByTag(tiffIFDEntryArray, 317);
            if (tiffIFDEntry != null && tiffIFDEntry.asLong() != 0L) {
                bl = true;
            }
        } else if (object != null && ((TiffIFDEntry)object).asLong() != 1L) {
            String string = Logging.getMessage("GeotiffReader.CompressionFormatNotSupported");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        object = this.getByTag(tiffIFDEntryArray, 322);
        if (object != null) {
            String string = Logging.getMessage("GeotiffReader.NoTiled");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        long l = lArray[0];
        if (aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") == "gov.nasa.worldwind.avkey.Elevation") {
            ByteBufferRaster byteBufferRaster = new ByteBufferRaster(baselineTiff.width, baselineTiff.height, (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector"), aVList);
            if (byteBufferRaster.getValue("gov.nasa.worldwind.avkey.DataType") == "gov.nasa.worldwind.avkey.Int8") {
                byte[][] byArray2 = this.tiffReader.readPlanar8(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
                int n3 = 0;
                for (int i = 0; i < baselineTiff.height; ++i) {
                    for (int j = 0; j < baselineTiff.width; ++j) {
                        byteBufferRaster.setDoubleAtPosition(i, j, byArray2[0][n3++]);
                    }
                }
            } else if (byteBufferRaster.getValue("gov.nasa.worldwind.avkey.DataType") == "gov.nasa.worldwind.avkey.Int16") {
                short[][] sArray = this.tiffReader.readPlanar16(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
                int n4 = 0;
                for (int i = 0; i < baselineTiff.height; ++i) {
                    for (int j = 0; j < baselineTiff.width; ++j) {
                        byteBufferRaster.setDoubleAtPosition(i, j, sArray[0][n4++]);
                    }
                }
            } else if (byteBufferRaster.getValue("gov.nasa.worldwind.avkey.DataType") == "gov.nasa.worldwind.avkey.Float32") {
                float[][] fArray = this.tiffReader.readPlanarFloat32(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
                int n5 = 0;
                for (int i = 0; i < baselineTiff.height; ++i) {
                    for (int j = 0; j < baselineTiff.width; ++j) {
                        byteBufferRaster.setDoubleAtPosition(i, j, fArray[0][n5++]);
                    }
                }
            } else {
                String string = Logging.getMessage("Geotiff.UnsupportedDataTypeRaster", baselineTiff.toString());
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            ElevationsUtil.rectify(byteBufferRaster);
            return byteBufferRaster;
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") == "gov.nasa.worldwind.avkey.Image" && aVList.getValue("gov.nasa.worldwind.avkey.ImageColorFormat") == "gov.nasa.worldwind.avkey.Grayscale") {
            Object object2;
            BufferedImage bufferedImage = null;
            if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == "gov.nasa.worldwind.avkey.Int8") {
                object2 = this.tiffReader.readPlanar8(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
                bufferedImage = new BufferedImage(baselineTiff.width, baselineTiff.height, 10);
                WritableRaster writableRaster = bufferedImage.getRaster();
                int n6 = 0;
                for (int i = 0; i < baselineTiff.height; ++i) {
                    for (int j = 0; j < baselineTiff.width; ++j) {
                        writableRaster.setSample(j, i, 0, 0xFF & object2[0][n6++]);
                    }
                }
            } else if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == "gov.nasa.worldwind.avkey.Int16" && baselineTiff.samplesPerPixel == 1) {
                object2 = this.tiffReader.readPlanar16(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
                bufferedImage = new BufferedImage(baselineTiff.width, baselineTiff.height, 11);
                WritableRaster writableRaster = bufferedImage.getRaster();
                int n7 = 0;
                for (int i = 0; i < baselineTiff.height; ++i) {
                    for (int j = 0; j < baselineTiff.width; ++j) {
                        writableRaster.setSample(j, i, 0, 0xFFFF & object2[0][n7++]);
                    }
                }
            } else if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == "gov.nasa.worldwind.avkey.Int16" && baselineTiff.samplesPerPixel > 1) {
                object2 = this.tiffReader.read16bitPixelInterleavedImage(n, baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
                bufferedImage = new BufferedImage(baselineTiff.width, baselineTiff.height, 11);
                WritableRaster writableRaster = bufferedImage.getRaster();
                int n8 = 0;
                for (int i = 0; i < baselineTiff.height; ++i) {
                    for (int j = 0; j < baselineTiff.width; ++j) {
                        writableRaster.setSample(j, i, 0, 0xFFFF & object2[n8++]);
                    }
                }
            }
            if (null == bufferedImage) {
                object2 = Logging.getMessage("Geotiff.UnsupportedDataTypeRaster", baselineTiff.toString());
                Logging.logger().severe((String)object2);
                throw new IOException((String)object2);
            }
            bufferedImage = ImageUtil.toCompatibleImage(bufferedImage);
            return BufferedImageRaster.wrap(bufferedImage, aVList);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") == "gov.nasa.worldwind.avkey.Image" && aVList.getValue("gov.nasa.worldwind.avkey.ImageColorFormat") == "gov.nasa.worldwind.avkey.Color") {
            byte[][] byArray3;
            ComponentSampleModel componentSampleModel;
            int n9;
            ColorModel colorModel = null;
            int[] nArray = baselineTiff.bitsPerSample;
            int n10 = nArray.length;
            for (n9 = 0; n9 < n10; ++n9) {
                int n11 = nArray[n9];
                if (n11 == 8) continue;
                String string = Logging.getMessage("GeotiffReader.Not8bit", n11);
                Logging.logger().warning(string);
                throw new IOException(string);
            }
            if (baselineTiff.photometric == 2) {
                int n12 = 1;
                n10 = 0;
                if (baselineTiff.samplesPerPixel == 3) {
                    n12 = 1;
                    n10 = 0;
                } else if (baselineTiff.samplesPerPixel == 4) {
                    n12 = 3;
                    n10 = 1;
                }
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), baselineTiff.bitsPerSample, n10 != 0, false, n12, 0);
            } else if (baselineTiff.photometric == 3) {
                colorModel = new IndexColorModel(baselineTiff.bitsPerSample[0], byArray[0].length, byArray[0], byArray[1], byArray[2]);
            } else if (baselineTiff.photometric == 5) {
                // empty if block
            }
            int[] nArray2 = new int[baselineTiff.samplesPerPixel];
            for (n10 = 0; n10 < baselineTiff.samplesPerPixel; ++n10) {
                nArray2[n10] = n10;
            }
            int[] nArray3 = new int[baselineTiff.planarConfig == 1 ? 1 : baselineTiff.samplesPerPixel];
            for (n9 = 0; n9 < nArray3.length; ++n9) {
                nArray3[n9] = 0;
            }
            if (baselineTiff.samplesPerPixel == 1) {
                componentSampleModel = new ComponentSampleModel(0, baselineTiff.width, baselineTiff.height, 1, baselineTiff.width, nArray2);
            } else {
                ComponentSampleModel componentSampleModel2 = componentSampleModel = baselineTiff.planarConfig == 1 ? new PixelInterleavedSampleModel(0, baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, baselineTiff.width * baselineTiff.samplesPerPixel, nArray2) : new BandedSampleModel(0, baselineTiff.width, baselineTiff.height, baselineTiff.width, nArray2, nArray3);
            }
            if (baselineTiff.planarConfig == 1) {
                if (n2 != 0 && baselineTiff.samplesPerPixel > 2) {
                    byArray3 = new byte[1][baselineTiff.width * baselineTiff.height * baselineTiff.samplesPerPixel];
                    byArray3[0] = this.tiffReader.readLZWCompressed(baselineTiff.width, baselineTiff.height, l, baselineTiff.samplesPerPixel, bl, lArray, lArray2);
                } else {
                    byArray3 = this.tiffReader.readPixelInterleaved8(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2);
                }
            } else {
                byArray3 = this.tiffReader.readPlanar8(baselineTiff.width, baselineTiff.height, baselineTiff.samplesPerPixel, lArray, lArray2, baselineTiff.rowsPerStrip);
            }
            DataBufferByte dataBufferByte = new DataBufferByte(byArray3, baselineTiff.width * baselineTiff.height, nArray3);
            WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            if (null == bufferedImage) {
                String string = Logging.getMessage("Geotiff.UnsupportedDataTypeRaster", baselineTiff.toString());
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            bufferedImage = ImageUtil.toCompatibleImage(bufferedImage);
            return BufferedImageRaster.wrap(bufferedImage, aVList);
        }
        String string = Logging.getMessage("Geotiff.UnsupportedDataTypeRaster", baselineTiff.toString());
        Logging.logger().severe(string);
        throw new IOException(string);
    }

    private void repackageGeoReferencingTags() throws IOException {
        for (int i = 0; i < this.getNumImages(); ++i) {
            int n;
            TiffIFDEntry[] tiffIFDEntryArray = this.tiffIFDs.get(i);
            AVList aVList = this.metadata.get(i);
            aVList.setValue("gov.nasa.worldwind.avkey.FileName", this.sourceFilename);
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
            BaselineTiff baselineTiff = BaselineTiff.extract(tiffIFDEntryArray, this.tiffReader);
            if (null == baselineTiff) {
                String string = Logging.getMessage("GeotiffReader.BadGeotiff");
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            if (baselineTiff.width == 0) {
                String string = Logging.getMessage("generic.InvalidWidth", baselineTiff.width);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            aVList.setValue("gov.nasa.worldwind.avkey.Width", baselineTiff.width);
            if (baselineTiff.height == 0) {
                String string = Logging.getMessage("generic.InvalidHeight", baselineTiff.height);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            aVList.setValue("gov.nasa.worldwind.avkey.Height", baselineTiff.height);
            int n2 = null != baselineTiff.sampleFormat ? baselineTiff.sampleFormat[0] : 0;
            int n3 = n = null != baselineTiff.bitsPerSample ? baselineTiff.bitsPerSample[0] : 0;
            if (null != baselineTiff.displayName) {
                aVList.setValue("gov.nasa.worldwind.avkey.DisplayName", baselineTiff.displayName);
            }
            if (null != baselineTiff.imageDescription) {
                aVList.setValue("gov.nasa.worldwind.avkey.Description", baselineTiff.imageDescription);
            }
            if (null != baselineTiff.softwareVersion) {
                aVList.setValue("gov.nasa.worldwind.avkey.Version", baselineTiff.softwareVersion);
            }
            if (null != baselineTiff.dateTime) {
                aVList.setValue("gov.nasa.worldwind.avkey.DateTime", baselineTiff.dateTime);
            }
            if (baselineTiff.photometric == 2) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", "gov.nasa.worldwind.avkey.Color");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int8");
            } else if (baselineTiff.photometric == 5) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", "gov.nasa.worldwind.avkey.Color");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int8");
            } else if (baselineTiff.photometric == 3) {
                aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", "gov.nasa.worldwind.avkey.Color");
                aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int8");
            } else if (baselineTiff.samplesPerPixel == 1) {
                if (n2 == 2) {
                    aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
                    if (n == 16) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
                    } else if (n == 8) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int8");
                    } else if (n == 32) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int32");
                    }
                } else if (n2 == 3) {
                    aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
                    if (n == 32) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Float32");
                    }
                } else if (n2 == 1) {
                    aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
                    aVList.setValue("gov.nasa.worldwind.avkey.ImageColorFormat", "gov.nasa.worldwind.avkey.Grayscale");
                    if (n == 16) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
                    } else if (n == 8) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int8");
                    } else if (n == 32) {
                        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int32");
                    }
                }
            }
            if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat") || !aVList.hasKey("gov.nasa.worldwind.avkey.DataType")) {
                TiffIFDEntry[] tiffIFDEntryArray2 = Logging.getMessage("Geotiff.UnsupportedDataTypeRaster", baselineTiff.toString());
                Logging.logger().severe((String)tiffIFDEntryArray2);
            }
            for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray) {
                try {
                    switch (tiffIFDEntry.tag) {
                        case 42113: {
                            Double d = Double.parseDouble(this.tiffReader.readString(tiffIFDEntry));
                            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", d);
                            break;
                        }
                        case 280: {
                            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", tiffIFDEntry.getAsDouble());
                            break;
                        }
                        case 281: {
                            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", tiffIFDEntry.getAsDouble());
                            break;
                        }
                        case 33550: {
                            this.gc.setModelPixelScale(tiffIFDEntry.getDoubles());
                            break;
                        }
                        case 33922: {
                            this.gc.addModelTiePoints(tiffIFDEntry.getDoubles());
                            break;
                        }
                        case 34264: {
                            this.gc.setModelTransformation(tiffIFDEntry.getDoubles());
                            break;
                        }
                        case 34735: {
                            this.gc.setGeokeys(tiffIFDEntry.getShorts());
                            break;
                        }
                        case 34736: {
                            this.gc.setDoubleParams(tiffIFDEntry.getDoubles());
                            break;
                        }
                        case 34737: {
                            this.gc.setAsciiParams(this.tiffReader.readBytes(tiffIFDEntry));
                        }
                    }
                }
                catch (Exception exception) {
                    Logging.logger().finest(exception.toString());
                }
            }
            this.processGeoKeys(i);
        }
    }

    private void readTiffHeaders() throws IOException {
        ByteOrder byteOrder;
        if (this.tiffIFDs != null) {
            return;
        }
        if (this.theChannel == null) {
            String string = Logging.getMessage("GeotiffReader.NullInputFile", this.sourceFilename);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN);
        this.theChannel.read(byteBuffer);
        byte by = byArray[0];
        byte by2 = byArray[1];
        ByteOrder byteOrder2 = by == 77 && by2 == 77 ? ByteOrder.BIG_ENDIAN : (byteOrder = by == 73 && by2 == 73 ? ByteOrder.LITTLE_ENDIAN : null);
        if (null == byteOrder) {
            String string = Logging.getMessage("GeotiffReader.BadTiffSig");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        this.tiffReader.setByteOrder(byteOrder);
        byteBuffer = ByteBuffer.wrap(byArray).order(byteOrder);
        byteBuffer.position(4);
        long l = TIFFReader.getUnsignedInt(byteBuffer);
        this.theChannel.position(l);
        byteBuffer.clear().limit(2);
        this.theChannel.read(byteBuffer);
        byteBuffer.flip();
        this.readIFD(byteBuffer.getShort());
        this.repackageGeoReferencingTags();
    }

    private void processGeoKeys(int n) throws IOException {
        int[] nArray;
        int n2;
        int[] nArray2;
        this.checkImageIndex(n);
        AVList aVList = this.metadata.get(n);
        if (!(null != aVList && null != this.gc && this.gc.hasGeoKey(1024) && aVList.hasKey("gov.nasa.worldwind.avkey.Width") && aVList.hasKey("gov.nasa.worldwind.avkey.Height"))) {
            return;
        }
        int n3 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        int n4 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (this.gc.hasGeoKey(4096)) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
        }
        if (this.gc.hasGeoKey(4099)) {
            nArray2 = this.gc.getGeoKeyAsInts(4099);
            int n5 = n2 = null != nArray2 && nArray2.length > 0 ? nArray2[0] : 0;
            if (n2 == 9001) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationUnit", "gov.nasa.worldwind.avkey.Unit.Meter");
            } else if (n2 == 9002) {
                aVList.setValue("gov.nasa.worldwind.avkey.ElevationUnit", "gov.nasa.worldwind.avkey.Unit.Foot");
            }
        }
        if (this.gc.hasGeoKey(1025)) {
            nArray2 = this.gc.getGeoKeyAsInts(1025);
            int n6 = n2 = null != nArray2 && nArray2.length > 0 ? nArray2[0] : 0;
            if (n2 == 1) {
                aVList.setValue("gov.nasa.worldwind.avkey.RasterPixel", "gov.nasa.worldwind.avkey.RasterPixelIsArea");
            } else if (n2 == 2) {
                aVList.setValue("gov.nasa.worldwind.avkey.RasterPixel", "gov.nasa.worldwind.avkey.RasterPixelIsPoint");
            }
        }
        if (this.gc.hasGeoKey(2054)) {
            // empty if block
        }
        int n7 = 0;
        if (this.gc.hasGeoKey(1024) && null != (nArray = this.gc.getGeoKeyAsInts(1024)) && nArray.length > 0) {
            n7 = nArray[0];
        }
        if (n7 == 2) {
            Object[] objectArray;
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
            int n8 = 0;
            if (this.gc.hasGeoKey(2048) && null != (objectArray = this.gc.getGeoKeyAsInts(2048)) && objectArray.length > 0) {
                n8 = objectArray[0];
            }
            if (n8 != 0) {
                aVList.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", n8);
            }
            objectArray = this.gc.getBoundingBox(n3, n4);
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", Sector.fromDegrees(objectArray[3], objectArray[1], objectArray[0], objectArray[2]));
            aVList.setValue("gov.nasa.worldwind.avkey.Origin", LatLon.fromDegrees(objectArray[1], objectArray[0]));
        } else if (n7 == 1) {
            int n9;
            String string;
            aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Projected");
            int n10 = 0;
            int[] nArray3 = null;
            if (this.gc.hasGeoKey(3074)) {
                nArray3 = this.gc.getGeoKeyAsInts(3074);
            } else if (this.gc.hasGeoKey(3072)) {
                nArray3 = this.gc.getGeoKeyAsInts(3072);
            }
            if (null != nArray3 && nArray3.length > 0) {
                n10 = nArray3[0];
            }
            if (n10 != 0) {
                aVList.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", n10);
            }
            if (n10 >= 16100 && n10 <= 16199) {
                string = "gov.nasa.worldwdind.avkey.South";
                n9 = n10 - 16100;
            } else if (n10 >= 16000 && n10 <= 16099) {
                string = "gov.nasa.worldwind.avkey.North";
                n9 = n10 - 16000;
            } else if (n10 >= 26900 && n10 <= 26999) {
                string = "gov.nasa.worldwind.avkey.North";
                n9 = n10 - 26900;
            } else if (n10 >= 32201 && n10 <= 32260) {
                string = "gov.nasa.worldwind.avkey.North";
                n9 = n10 - 32200;
            } else if (n10 >= 32301 && n10 <= 32360) {
                string = "gov.nasa.worldwdind.avkey.South";
                n9 = n10 - 32300;
            } else if (n10 >= 32401 && n10 <= 32460) {
                string = "gov.nasa.worldwind.avkey.North";
                n9 = n10 - 32400;
            } else if (n10 >= 32501 && n10 <= 32560) {
                string = "gov.nasa.worldwdind.avkey.South";
                n9 = n10 - 32500;
            } else if (n10 >= 32601 && n10 <= 32660) {
                string = "gov.nasa.worldwind.avkey.North";
                n9 = n10 - 32600;
            } else if (n10 >= 32701 && n10 <= 32760) {
                string = "gov.nasa.worldwdind.avkey.South";
                n9 = n10 - 32700;
            } else {
                String string2 = Logging.getMessage("generic.UnknownProjection", n10);
                Logging.logger().severe(string2);
                return;
            }
            double d = this.gc.getModelPixelScaleX();
            double d2 = Math.abs(this.gc.getModelPixelScaleY());
            aVList.setValue("gov.nasa.worldwind.avkey.Projection.Hemisphere", string);
            aVList.setValue("gov.nasa.worldwind.avkey.Projection.Zone", n9);
            aVList.setValue("gov.nasa.worldwind.worldFile.XPixelSize", d);
            aVList.setValue("gov.nasa.worldwind.worldFile.YPixelSize", -d2);
            GeoCodec.ModelTiePoint[] modelTiePointArray = this.gc.getTiePoints();
            if (null != modelTiePointArray && modelTiePointArray.length > n) {
                GeoCodec.ModelTiePoint modelTiePoint = modelTiePointArray[n];
                double d3 = modelTiePoint.getX() + d / 2.0;
                double d4 = modelTiePoint.getY() - d2 / 2.0;
                aVList.setValue("gov.nasa.worldwind.worldFile.XLocation", d3);
                aVList.setValue("gov.nasa.worldwind.worldFile.YLocation", d4);
            }
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", ImageUtil.calcBoundingBoxForUTM(aVList));
        } else {
            String string = Logging.getMessage("Geotiff.UnknownGeoKeyValue", n7, 1024);
            Logging.logger().severe(string);
        }
    }

    private void readIFD(int n) throws IOException {
        try {
            if (null == this.tiffIFDs) {
                this.tiffIFDs = new ArrayList();
            }
            ArrayList<TiffIFDEntry> arrayList = new ArrayList<TiffIFDEntry>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(TIFFIFDFactory.create(this.theChannel, this.tiffReader.getByteOrder()));
            }
            TiffIFDEntry[] tiffIFDEntryArray = arrayList.toArray(new TiffIFDEntry[arrayList.size()]);
            this.tiffIFDs.add(tiffIFDEntryArray);
            if (null == this.metadata) {
                this.metadata = new ArrayList();
            }
            this.metadata.add(new AVListImpl());
            ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this.tiffReader.getByteOrder());
            this.theChannel.read(byteBuffer);
            byteBuffer.flip();
            long l = TIFFReader.getUnsignedInt(byteBuffer);
            if (l > 0L) {
                this.theChannel.position(l);
                byteBuffer.clear().limit(2);
                this.theChannel.read(byteBuffer);
                byteBuffer.flip();
                this.readIFD(byteBuffer.getShort());
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("GeotiffReader.BadIFD", exception.getMessage());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
    }

    private TiffIFDEntry getByTag(TiffIFDEntry[] tiffIFDEntryArray, int n) {
        for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray) {
            if (tiffIFDEntry.tag != n) continue;
            return tiffIFDEntry;
        }
        return null;
    }

    private void checkImageIndex(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages()) {
            String string = Logging.getMessage("GeotiffReader.BadImageIndex", n, 0, this.getNumImages());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public void dispose() {
        try {
            WWIO.closeStream(this.theChannel, this.sourceFilename);
            WWIO.closeStream(this.sourceFile, this.sourceFilename);
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            string = WWUtil.isEmpty(string) ? throwable.getCause().getMessage() : string;
            Logging.logger().log(Level.FINEST, string, throwable);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

