/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.GeoSymTable;
import gov.nasa.worldwind.formats.vpf.GeoSymTableReader;
import gov.nasa.worldwind.util.Logging;
import java.util.HashMap;
import java.util.Map;

public class GeoSymAssignment {
    protected String filePath;
    protected Map<String, GeoSymTable> tableMap = new HashMap<String, GeoSymTable>();
    protected static String[] tableNames = new String[]{"attexp.txt", "code.txt", "color.txt", "fullsym.txt", "simpsym.txt", "textchar.txt", "textjoin.txt", "textloc.txt"};

    public static GeoSymAssignment fromFile(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        GeoSymAssignment geoSymAssignment = new GeoSymAssignment();
        geoSymAssignment.filePath = string;
        GeoSymTableReader geoSymTableReader = new GeoSymTableReader();
        for (String string3 : tableNames) {
            GeoSymTable geoSymTable = geoSymTableReader.read(GeoSymAssignment.getTablePath(string, string3));
            if (geoSymTable == null) continue;
            geoSymAssignment.putTable(string3, geoSymTable);
        }
        return geoSymAssignment;
    }

    public static boolean isGeoSymAssignment(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        GeoSymTableReader geoSymTableReader = new GeoSymTableReader();
        for (String string3 : tableNames) {
            if (geoSymTableReader.canRead(GeoSymAssignment.getTablePath(string, string3))) continue;
            return false;
        }
        return true;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public GeoSymTable getTable(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.tableMap.get(string);
    }

    public void putTable(String string, GeoSymTable geoSymTable) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.tableMap.put(string, geoSymTable);
    }

    protected static String getTablePath(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("/");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

