/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.vpf.GeoSymAttributeExpression;
import gov.nasa.worldwind.formats.vpf.GeoSymTable;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;

public class GeoSymAttributeExpressionProvider {
    protected Map<Integer, GeoSymAttributeExpression> expressionMap = new HashMap<Integer, GeoSymAttributeExpression>();

    public GeoSymAttributeExpressionProvider(GeoSymTable geoSymTable) {
        this.loadExpressions(geoSymTable);
    }

    public GeoSymAttributeExpression getAttributeExpression(int n) {
        return this.expressionMap.get(n);
    }

    protected void loadExpressions(GeoSymTable geoSymTable) {
        this.expressionMap.clear();
        HashMap<Object, TreeSet<AVList>> hashMap = new HashMap<Object, TreeSet<AVList>>();
        for (AVList object : geoSymTable.getRecords()) {
            Set<AVList> set;
            Object object2 = AVListImpl.getIntegerValue(object, "cond_index");
            Integer n = AVListImpl.getIntegerValue(object, "seq");
            if (object2 == null || n == null) {
                set = Logging.getMessage("VPF.GeoSymInvalidAttributeExpression", object);
                Logging.logger().warning((String)((Object)set));
                continue;
            }
            set = (Set)hashMap.get(object2);
            if (set == null) {
                set = new TreeSet<AVList>(new Comparator<AVList>(){

                    @Override
                    public int compare(AVList aVList, AVList aVList2) {
                        Integer n = AVListImpl.getIntegerValue(aVList, "seq");
                        Integer n2 = AVListImpl.getIntegerValue(aVList2, "seq");
                        return n < n2 ? -1 : (n > n2 ? 1 : 0);
                    }
                });
                hashMap.put(object2, (TreeSet<AVList>)set);
            }
            set.add(object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (Object object2 : (Set)entry.getValue()) {
                int n = AVListImpl.getIntegerValue((AVList)object2, "connector", 0);
                linkedList.add(new Comparison((AVList)object2));
                linkedList.add((Object)LogicalOperator.values()[n]);
            }
            Expression expression = this.parseExpression(linkedList);
            if (expression == null) continue;
            this.expressionMap.put((Integer)entry.getKey(), expression);
        }
    }

    protected Expression parseExpression(Queue<?> queue) {
        if (queue.isEmpty()) {
            return null;
        }
        ComparisonParser comparisonParser = new ComparisonParser(queue);
        LogicalExpressionParser logicalExpressionParser = new LogicalExpressionParser(queue, comparisonParser, EnumSet.of(LogicalOperator.AND_LEVEL1, LogicalOperator.OR_LEVEL1));
        LogicalExpressionParser logicalExpressionParser2 = new LogicalExpressionParser(queue, logicalExpressionParser, EnumSet.of(LogicalOperator.AND_LEVEL2, LogicalOperator.OR_LEVEL2));
        return logicalExpressionParser2.parse();
    }

    protected static class Comparison
    implements Expression {
        protected String attributeName;
        protected ComparisonOperator operator;
        protected String value;

        public Comparison(String string, ComparisonOperator comparisonOperator, String string2) {
            this.attributeName = string;
            this.operator = comparisonOperator;
            this.value = string2;
        }

        public Comparison(AVList aVList) {
            this.attributeName = aVList.getStringValue("att");
            this.value = aVList.getStringValue("value");
            Integer n = AVListImpl.getIntegerValue(aVList, "oper");
            if (n != null) {
                this.operator = ComparisonOperator.values()[n];
            }
        }

        @Override
        public boolean evaluate(AVList aVList) {
            return this.operator.evaluate(aVList, this.attributeName, this.value);
        }
    }

    protected static enum LogicalOperator {
        NONE{

            @Override
            public boolean evaluate(AVList aVList, Iterable<? extends Expression> iterable) {
                return false;
            }
        }
        ,
        OR_LEVEL1{

            @Override
            public boolean evaluate(AVList aVList, Iterable<? extends Expression> iterable) {
                for (Expression expression : iterable) {
                    if (!expression.evaluate(aVList)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        AND_LEVEL2{

            @Override
            public boolean evaluate(AVList aVList, Iterable<? extends Expression> iterable) {
                return AND_LEVEL1.evaluate(aVList, iterable);
            }
        }
        ,
        AND_LEVEL1{

            @Override
            public boolean evaluate(AVList aVList, Iterable<? extends Expression> iterable) {
                for (Expression expression : iterable) {
                    if (expression.evaluate(aVList)) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        OR_LEVEL2{

            @Override
            public boolean evaluate(AVList aVList, Iterable<? extends Expression> iterable) {
                return OR_LEVEL1.evaluate(aVList, iterable);
            }
        };


        public abstract boolean evaluate(AVList var1, Iterable<? extends Expression> var2);
    }

    protected static interface Expression
    extends GeoSymAttributeExpression {
        @Override
        public boolean evaluate(AVList var1);
    }

    protected static class ComparisonParser
    implements ExpressionParser {
        protected Queue<?> queue;

        public ComparisonParser(Queue<?> queue) {
            this.queue = queue;
        }

        @Override
        public Expression parse() {
            return this.queue.peek() instanceof Comparison ? (Comparison)this.queue.poll() : null;
        }
    }

    protected static class LogicalExpressionParser
    implements ExpressionParser {
        protected Queue<?> queue;
        protected ExpressionParser delegateParser;
        protected EnumSet<LogicalOperator> operatorSet;

        public LogicalExpressionParser(Queue<?> queue, ExpressionParser expressionParser, EnumSet<LogicalOperator> enumSet) {
            this.queue = queue;
            this.delegateParser = expressionParser;
            this.operatorSet = enumSet;
        }

        @Override
        public Expression parse() {
            LogicalOperator logicalOperator;
            Expression expression = this.delegateParser.parse();
            if (expression == null) {
                return null;
            }
            LogicalExpression logicalExpression = null;
            while ((logicalOperator = this.peekOperator()) != null && this.operatorSet.contains((Object)logicalOperator)) {
                if (logicalExpression == null || !logicalExpression.logicalOperator.equals((Object)logicalOperator)) {
                    logicalExpression = new LogicalExpression(logicalOperator);
                    logicalExpression.add(expression);
                    expression = logicalExpression;
                }
                this.queue.poll();
                logicalExpression.add(this.delegateParser.parse());
            }
            return expression;
        }

        protected LogicalOperator peekOperator() {
            return this.queue.peek() instanceof LogicalOperator ? (LogicalOperator)((Object)this.queue.peek()) : null;
        }
    }

    protected static interface ExpressionParser {
        public Expression parse();
    }

    protected static enum ComparisonOperator {
        NONE{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return false;
            }
        }
        ,
        EQUAL{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return ComparisonOperator.compare(aVList, string, string2) == 0;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return !EQUAL.evaluate(aVList, string, string2);
            }
        }
        ,
        LESS_THAN{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return ComparisonOperator.compare(aVList, string, string2) < 0;
            }
        }
        ,
        GREATER_THAN{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return ComparisonOperator.compare(aVList, string, string2) > 0;
            }
        }
        ,
        LESS_THAN_OR_EQUAL_TO{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return ComparisonOperator.compare(aVList, string, string2) <= 0;
            }
        }
        ,
        GREATER_THAN_OR_EQUAL_TO{

            @Override
            public boolean evaluate(AVList aVList, String string, String string2) {
                return ComparisonOperator.compare(aVList, string, string2) >= 0;
            }
        };


        public abstract boolean evaluate(AVList var1, String var2, String var3);

        private static int compare(AVList aVList, String string, String string2) {
            Object object = aVList.getValue(string);
            boolean bl = string2.equalsIgnoreCase("NULL");
            if (bl || object == null) {
                return bl ? (object != null ? -1 : 0) : 1;
            }
            if (string2.startsWith("\"") && string2.endsWith("\"")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return String.CASE_INSENSITIVE_ORDER.compare(object.toString(), string2);
        }
    }

    protected static class LogicalExpression
    extends ArrayList<Expression>
    implements Expression {
        protected LogicalOperator logicalOperator;

        public LogicalExpression(LogicalOperator logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public boolean evaluate(AVList aVList) {
            return this.logicalOperator.evaluate(aVList, this);
        }
    }
}

