/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFDataBuffer;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.util.Logging;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VPFBufferedRecordData
implements Iterable<VPFRecord> {
    private int numRecords;
    private Map<String, RecordData> dataMap = new HashMap<String, RecordData>();

    public int getNumRecords() {
        return this.numRecords;
    }

    public void setNumRecords(int n) {
        this.numRecords = n;
    }

    public Iterable<String> getRecordParameterNames() {
        return Collections.unmodifiableSet(this.dataMap.keySet());
    }

    public VPFDataBuffer getRecordData(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        RecordData recordData = this.dataMap.get(string);
        return recordData != null ? recordData.dataBuffer : null;
    }

    public void setRecordData(String string, VPFDataBuffer vPFDataBuffer) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (vPFDataBuffer != null) {
            this.dataMap.put(string, new RecordData(vPFDataBuffer));
        } else {
            this.dataMap.remove(string);
        }
    }

    public VPFRecord getRecord(int n) {
        if (n < 1 || n > this.numRecords) {
            String string = Logging.getMessage("generic.indexOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new RecordImpl(n);
    }

    public VPFRecord getRecord(String string, Object object) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        RecordData recordData = this.dataMap.get(string);
        if (recordData == null) {
            return null;
        }
        int n = recordData.indexOf(object, 1, this.numRecords);
        return n > 0 ? new RecordImpl(n) : null;
    }

    @Override
    public Iterator<VPFRecord> iterator() {
        return new Iterator<VPFRecord>(){
            private int id = 0;
            private int maxId = VPFBufferedRecordData.access$000(VPFBufferedRecordData.this);

            @Override
            public boolean hasNext() {
                return this.id < this.maxId;
            }

            @Override
            public VPFRecord next() {
                return new RecordImpl(++this.id);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean buildRecordIndex(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ParameterNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        RecordData recordData = this.dataMap.get(string);
        return recordData != null && recordData.updateIndex(1, this.numRecords);
    }

    public static int indexFromId(int n) {
        return n - 1;
    }

    static /* synthetic */ int access$000(VPFBufferedRecordData vPFBufferedRecordData) {
        return vPFBufferedRecordData.numRecords;
    }

    protected static class RecordData {
        public VPFDataBuffer dataBuffer;
        protected Map<Object, Integer> recordIndex;

        public RecordData(VPFDataBuffer vPFDataBuffer) {
            this.dataBuffer = vPFDataBuffer;
        }

        public boolean hasIndex() {
            return this.recordIndex != null;
        }

        public int indexOf(Object object, int n, int n2) {
            int n3;
            block2: {
                block1: {
                    n3 = -1;
                    if (this.recordIndex == null) break block1;
                    Integer n4 = this.recordIndex.get(object);
                    if (n4 == null) break block2;
                    n3 = n4;
                    break block2;
                }
                for (int i = n; i <= n2; ++i) {
                    Object object2 = this.dataBuffer.get(i);
                    if (!(object2 != null ? object2.equals(object) : object == null)) continue;
                    n3 = i;
                    break;
                }
            }
            return n3;
        }

        public boolean updateIndex(int n, int n2) {
            if (this.recordIndex == null) {
                this.recordIndex = new HashMap<Object, Integer>();
            }
            this.recordIndex.clear();
            for (int i = n; i <= n2; ++i) {
                Object object = this.dataBuffer.get(i);
                this.recordIndex.put(object, i);
            }
            return true;
        }
    }

    protected class RecordImpl
    implements VPFRecord {
        protected final int id;

        public RecordImpl(int n) {
            this.id = n;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public boolean hasValue(String string) {
            VPFDataBuffer vPFDataBuffer = VPFBufferedRecordData.this.getRecordData(string);
            return vPFDataBuffer != null && vPFDataBuffer.hasValue(this.id);
        }

        @Override
        public Object getValue(String string) {
            VPFDataBuffer vPFDataBuffer = VPFBufferedRecordData.this.getRecordData(string);
            return vPFDataBuffer != null ? vPFDataBuffer.get(this.id) : null;
        }
    }
}

