/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClassSchema;
import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.formats.vpf.VPFLibrary;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.formats.vpf.VPFRelation;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class VPFCoverage
extends AVListImpl {
    private VPFLibrary library;
    private boolean tiled;
    private VPFBufferedRecordData featureClassSchemaTable;
    private VPFBufferedRecordData featureClassAttributeTable;
    private VPFBufferedRecordData characterValueDescriptionTable;
    private VPFBufferedRecordData integerValueDescriptionTable;
    private VPFBufferedRecordData symbolRelatedAttributeTable;

    protected VPFCoverage(VPFLibrary vPFLibrary) {
        if (vPFLibrary == null) {
            String string = Logging.getMessage("nullValue.LibraryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.library = vPFLibrary;
    }

    public static VPFCoverage fromFile(VPFLibrary vPFLibrary, String string) {
        if (vPFLibrary == null) {
            String string2 = Logging.getMessage("nullValue.LibraryIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(string)) {
            String string3 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        File file = new File(vPFLibrary.getFilePath(), string);
        if (!file.exists()) {
            String string4 = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string4);
            throw new WWRuntimeException(string4);
        }
        VPFBufferedRecordData vPFBufferedRecordData = VPFUtils.readTable(new File(file, "fcs"));
        if (vPFBufferedRecordData == null) {
            String string5 = Logging.getMessage("VPF.FeatureClassSchemaTableMissing");
            throw new WWRuntimeException(string5);
        }
        VPFBufferedRecordData vPFBufferedRecordData2 = VPFUtils.readTable(new File(file, "fca"));
        VPFBufferedRecordData vPFBufferedRecordData3 = VPFUtils.readTable(new File(file, "char.vdt"));
        VPFBufferedRecordData vPFBufferedRecordData4 = VPFUtils.readTable(new File(file, "int.vdt"));
        VPFBufferedRecordData vPFBufferedRecordData5 = VPFUtils.readTable(new File(file, "symbol.rat"));
        VPFCoverage vPFCoverage = new VPFCoverage(vPFLibrary);
        vPFCoverage.setFeatureClassSchemaTable(vPFBufferedRecordData);
        vPFCoverage.setFeatureClassAttributeTable(vPFBufferedRecordData2);
        vPFCoverage.setCharacterValueDescriptionTable(vPFBufferedRecordData3);
        vPFCoverage.setIntegerValueDescriptionTable(vPFBufferedRecordData4);
        vPFCoverage.setSymbolRelatedAttributeTable(vPFBufferedRecordData5);
        VPFRecord vPFRecord = vPFLibrary.getCoverageAttributeTable().getRecord("coverage_name", string);
        if (vPFRecord != null) {
            VPFUtils.checkAndSetValue(vPFRecord, "coverage_name", "gov.nasa.worldwind.avkey.DisplayName", vPFCoverage);
            VPFUtils.checkAndSetValue(vPFRecord, "description", "gov.nasa.worldwind.avkey.Description", vPFCoverage);
        }
        return vPFCoverage;
    }

    public VPFLibrary getLibrary() {
        return this.library;
    }

    public String getName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public String getDescription() {
        return this.getStringValue("gov.nasa.worldwind.avkey.Description");
    }

    public String getFilePath() {
        StringBuilder stringBuilder = new StringBuilder(this.library.getFilePath());
        stringBuilder.append(File.separator);
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public boolean isReferenceCoverage() {
        String string = this.getName();
        return string.equalsIgnoreCase("dq") || string.equalsIgnoreCase("libref") || string.equalsIgnoreCase("gazette") || string.equalsIgnoreCase("tileref");
    }

    public boolean isTiled() {
        return this.tiled;
    }

    public void setTiled(boolean bl) {
        this.tiled = bl;
    }

    public VPFFeatureClassSchema[] getFeatureClasses(FileFilter fileFilter) {
        if (fileFilter == null) {
            String string = Logging.getMessage("nullValue.FilterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = WWIO.listChildFilenames(new File(this.getFilePath()), fileFilter);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        VPFFeatureClassSchema[] vPFFeatureClassSchemaArray = new VPFFeatureClassSchema[n];
        for (int i = 0; i < n; ++i) {
            VPFRecord vPFRecord;
            String string = stringArray[i];
            String string2 = WWIO.replaceSuffix(string, "");
            String string3 = null;
            if (this.featureClassAttributeTable != null && (vPFRecord = this.featureClassAttributeTable.getRecord("fclass", string2)) != null) {
                string3 = (String)vPFRecord.getValue("type");
            }
            if (string3 == null) {
                string3 = VPFUtils.getFeatureTypeName(string);
            }
            vPFFeatureClassSchemaArray[i] = new VPFFeatureClassSchema(string2, VPFFeatureType.fromTypeName(string3), string);
        }
        return vPFFeatureClassSchemaArray;
    }

    public VPFRelation[] getFeatureClassRelations(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ClassNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        ArrayList<VPFRelation> arrayList = new ArrayList<VPFRelation>();
        for (VPFRecord vPFRecord : this.featureClassSchemaTable) {
            Object object = vPFRecord.getValue("feature_class");
            if (object == null || !(object instanceof String) || !string.equalsIgnoreCase((String)object)) continue;
            arrayList.add(new VPFRelation((String)vPFRecord.getValue("table1"), (String)vPFRecord.getValue("table1_key"), (String)vPFRecord.getValue("table2"), (String)vPFRecord.getValue("table2_key")));
        }
        VPFRelation[] vPFRelationArray = new VPFRelation[arrayList.size()];
        arrayList.toArray(vPFRelationArray);
        return vPFRelationArray;
    }

    public VPFBufferedRecordData getFeatureClassSchemaTable() {
        return this.featureClassSchemaTable;
    }

    public void setFeatureClassSchemaTable(VPFBufferedRecordData vPFBufferedRecordData) {
        this.featureClassSchemaTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getFeatureClassAttributeTable() {
        return this.featureClassAttributeTable;
    }

    public void setFeatureClassAttributeTable(VPFBufferedRecordData vPFBufferedRecordData) {
        this.featureClassAttributeTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getCharacterValueDescriptionTable() {
        return this.characterValueDescriptionTable;
    }

    public void setCharacterValueDescriptionTable(VPFBufferedRecordData vPFBufferedRecordData) {
        this.characterValueDescriptionTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getIntegerValueDescriptionTable() {
        return this.integerValueDescriptionTable;
    }

    public void setIntegerValueDescriptionTable(VPFBufferedRecordData vPFBufferedRecordData) {
        this.integerValueDescriptionTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getSymbolRelatedAttributeTable() {
        return this.symbolRelatedAttributeTable;
    }

    public void setSymbolRelatedAttributeTable(VPFBufferedRecordData vPFBufferedRecordData) {
        this.symbolRelatedAttributeTable = vPFBufferedRecordData;
    }
}

