/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFLibrary;
import gov.nasa.worldwind.formats.vpf.VPFRecord;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VPFDatabase
extends AVListImpl {
    private String filePath;
    private Map<String, VPFLibrary> libraryMap = new HashMap<String, VPFLibrary>();
    private VPFBufferedRecordData databaseHeaderTable;
    private VPFBufferedRecordData libraryAttributeTable;

    protected VPFDatabase(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.filePath = string;
    }

    public static VPFDatabase fromFile(String string) {
        Collection<VPFLibrary> collection;
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
        VPFBufferedRecordData vPFBufferedRecordData = VPFUtils.readTable(file);
        if (vPFBufferedRecordData == null) {
            String string4 = Logging.getMessage("VPF.DatabaseHeaderTableMissing");
            throw new WWRuntimeException(string4);
        }
        VPFBufferedRecordData vPFBufferedRecordData2 = VPFUtils.readTable(new File(file.getParent(), "lat"));
        if (vPFBufferedRecordData2 == null) {
            String string5 = Logging.getMessage("VPF.LibraryAttributeTableMissing");
            throw new WWRuntimeException(string5);
        }
        VPFDatabase vPFDatabase = new VPFDatabase(file.getParent());
        vPFDatabase.setDatabaseHeaderTable(vPFBufferedRecordData);
        vPFDatabase.setLibraryAttributeTable(vPFBufferedRecordData2);
        VPFRecord vPFRecord = vPFBufferedRecordData.getRecord(1);
        if (vPFRecord != null) {
            VPFUtils.checkAndSetValue(vPFRecord, "database_name", "gov.nasa.worldwind.avkey.DisplayName", vPFDatabase);
            VPFUtils.checkAndSetValue(vPFRecord, "database_desc", "gov.nasa.worldwind.avkey.Description", vPFDatabase);
        }
        if ((collection = VPFDatabase.createLibraries(vPFDatabase, vPFBufferedRecordData2)) != null) {
            vPFDatabase.setLibraries(collection);
        }
        return vPFDatabase;
    }

    public static boolean isDatabase(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        VPFBufferedRecordData vPFBufferedRecordData = VPFUtils.readTable(file);
        if (vPFBufferedRecordData == null) {
            return false;
        }
        if (!(file = new File(file.getParent(), "lat")).exists()) {
            return false;
        }
        vPFBufferedRecordData = VPFUtils.readTable(file);
        return vPFBufferedRecordData != null;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getName() {
        return this.getStringValue("gov.nasa.worldwind.avkey.DisplayName");
    }

    public String getDescription() {
        return this.getStringValue("gov.nasa.worldwind.avkey.Description");
    }

    public int getNumLibraries() {
        return this.libraryMap.size();
    }

    public boolean containsLibrary(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.libraryMap.containsKey(string);
    }

    public VPFLibrary getLibrary(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.libraryMap.get(string);
    }

    public Set<String> getLibraryNames() {
        return Collections.unmodifiableSet(this.libraryMap.keySet());
    }

    public Collection<VPFLibrary> getLibraries() {
        return Collections.unmodifiableCollection(this.libraryMap.values());
    }

    public void setLibraries(Collection<? extends VPFLibrary> collection) {
        this.removeAllLibraries();
        if (collection != null) {
            this.addAllLibraries(collection);
        }
    }

    public void addLibrary(VPFLibrary vPFLibrary) {
        if (vPFLibrary == null) {
            String string = Logging.getMessage("nullValue.LibraryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.libraryMap.put(vPFLibrary.getName(), vPFLibrary);
    }

    public void addAllLibraries(Collection<? extends VPFLibrary> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.CollectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (VPFLibrary vPFLibrary : collection) {
            this.addLibrary(vPFLibrary);
        }
    }

    public void removeLibrary(VPFLibrary vPFLibrary) {
        if (vPFLibrary == null) {
            String string = Logging.getMessage("nullValue.LibraryIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.libraryMap.remove(vPFLibrary.getName());
    }

    public void removeAllLibraries() {
        this.libraryMap.clear();
    }

    public VPFBufferedRecordData getDatabaseHeaderTable() {
        return this.databaseHeaderTable;
    }

    public void setDatabaseHeaderTable(VPFBufferedRecordData vPFBufferedRecordData) {
        if (vPFBufferedRecordData == null) {
            String string = Logging.getMessage("nullValue.TableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.databaseHeaderTable = vPFBufferedRecordData;
    }

    public VPFBufferedRecordData getLibraryAttributeTable() {
        return this.libraryAttributeTable;
    }

    public void setLibraryAttributeTable(VPFBufferedRecordData vPFBufferedRecordData) {
        if (vPFBufferedRecordData == null) {
            String string = Logging.getMessage("nullValue.TableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.libraryAttributeTable = vPFBufferedRecordData;
    }

    protected static Collection<VPFLibrary> createLibraries(VPFDatabase vPFDatabase, VPFBufferedRecordData vPFBufferedRecordData) {
        ArrayList<VPFLibrary> arrayList = new ArrayList<VPFLibrary>();
        for (VPFRecord vPFRecord : vPFBufferedRecordData) {
            VPFLibrary vPFLibrary;
            String string = (String)vPFRecord.getValue("library_name");
            if (string == null || (vPFLibrary = VPFUtils.readLibrary(vPFDatabase, string)) == null) continue;
            arrayList.add(vPFLibrary);
        }
        return arrayList;
    }
}

