/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.util.Logging;

public class VPFFeature
extends AVListImpl {
    protected VPFFeatureClass featureClass;
    protected int id;
    protected VPFBoundingBox bounds;
    private int[] primitiveIds;

    public VPFFeature(VPFFeatureClass vPFFeatureClass, int n, VPFBoundingBox vPFBoundingBox, int[] nArray) {
        if (vPFFeatureClass == null) {
            String string = Logging.getMessage("nullValue.FeatureClassIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vPFBoundingBox == null) {
            String string = Logging.getMessage("nullValue.BoundingBoxIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.featureClass = vPFFeatureClass;
        this.id = n;
        this.bounds = vPFBoundingBox;
        this.primitiveIds = nArray;
    }

    public VPFFeatureClass getFeatureClass() {
        return this.featureClass;
    }

    public VPFFeatureType getType() {
        return this.featureClass.getType();
    }

    public int getId() {
        return this.id;
    }

    public VPFBoundingBox getBounds() {
        return this.bounds;
    }

    public int[] getPrimitiveIds() {
        return this.primitiveIds;
    }
}

