/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.formats.vpf.VPFBasicPrimitiveDataFactory;
import gov.nasa.worldwind.formats.vpf.VPFBasicSymbolFactory;
import gov.nasa.worldwind.formats.vpf.VPFBoundingBox;
import gov.nasa.worldwind.formats.vpf.VPFCoverage;
import gov.nasa.worldwind.formats.vpf.VPFDatabase;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureTableFilter;
import gov.nasa.worldwind.formats.vpf.VPFLibrary;
import gov.nasa.worldwind.formats.vpf.VPFPrimitiveData;
import gov.nasa.worldwind.formats.vpf.VPFSymbol;
import gov.nasa.worldwind.formats.vpf.VPFSymbolComparator;
import gov.nasa.worldwind.formats.vpf.VPFSymbolSupport;
import gov.nasa.worldwind.formats.vpf.VPFTile;
import gov.nasa.worldwind.formats.vpf.VPFUtils;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BoundedHashMap;
import gov.nasa.worldwind.util.Logging;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.PriorityBlockingQueue;

public class VPFLayer
extends AbstractLayer {
    public static final String LIBRARY_CHANGED = "VPFLayer.LibraryChanged";
    public static final String COVERAGE_CHANGED = "VPFLayer.CoverageChanged";
    protected VPFDatabase db;
    protected ArrayList<VPFLibraryRenderable> libraries;
    protected double drawDistance = 1000000.0;
    protected int maxTilesToDraw = 4;
    protected boolean drawTileExtents = false;
    protected ArrayList<VPFSymbol> symbols = new ArrayList();
    protected ArrayList<GeographicText> textObjects = new ArrayList();
    protected ArrayList<Renderable> renderableObjects = new ArrayList();
    protected GeographicTextRenderer textRenderer = new GeographicTextRenderer();
    protected VPFSymbolSupport symbolSupport = new VPFSymbolSupport("geosym", "image/png");
    protected Queue<Runnable> requestQ = new PriorityBlockingQueue<Runnable>(4);
    protected Queue<Disposable> disposalQ = new ConcurrentLinkedQueue<Disposable>();
    protected static final VPFTile NULL_TILE = new VPFTile(-1, "NullTile", new VPFBoundingBox(0.0, 0.0, 0.0, 0.0));

    protected VPFSymbolCollection loadTileSymbols(VPFCoverage vPFCoverage, VPFTile vPFTile) {
        VPFFeatureClass[] vPFFeatureClassArray;
        VPFBasicPrimitiveDataFactory vPFBasicPrimitiveDataFactory = new VPFBasicPrimitiveDataFactory(vPFTile);
        VPFPrimitiveData vPFPrimitiveData = vPFBasicPrimitiveDataFactory.createPrimitiveData(vPFCoverage);
        if (vPFPrimitiveData == null) {
            return VPFSymbolCollection.EMPTY_SYMBOL_COLLECTION;
        }
        VPFBasicSymbolFactory vPFBasicSymbolFactory = new VPFBasicSymbolFactory(vPFTile, vPFPrimitiveData);
        vPFBasicSymbolFactory.setStyleSupport(this.symbolSupport);
        ArrayList<? extends VPFSymbol> arrayList = new ArrayList<VPFSymbol>();
        for (VPFFeatureClass vPFFeatureClass : vPFFeatureClassArray = VPFUtils.readFeatureClasses(vPFCoverage, new VPFFeatureTableFilter())) {
            Collection<? extends VPFSymbol> collection = vPFFeatureClass.createFeatureSymbols(vPFBasicSymbolFactory);
            if (collection == null) continue;
            arrayList.addAll(collection);
        }
        return new VPFSymbolCollection(arrayList);
    }

    public VPFLayer() {
        this(null);
    }

    public VPFLayer(VPFDatabase vPFDatabase) {
        this.setName("VPF Layer");
        this.setPickEnabled(false);
        if (vPFDatabase != null) {
            this.setVPFDatabase(vPFDatabase);
        }
        this.textRenderer.setCullTextEnabled(true);
        this.textRenderer.setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
    }

    public VPFDatabase getVPFDatabase() {
        return this.db;
    }

    public void setVPFDatabase(VPFDatabase vPFDatabase) {
        this.db = vPFDatabase;
        this.initialize();
        this.db.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(VPFLayer.LIBRARY_CHANGED)) {
                    VPFLibrary vPFLibrary = (VPFLibrary)propertyChangeEvent.getSource();
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    VPFLayer.this.setLibraryEnabled(vPFLibrary, bl);
                } else if (propertyChangeEvent.getPropertyName().equals(VPFLayer.COVERAGE_CHANGED)) {
                    VPFCoverage vPFCoverage = (VPFCoverage)propertyChangeEvent.getSource();
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    VPFLayer.this.setCoverageEnabled(vPFCoverage, bl);
                }
            }
        });
    }

    protected void initialize() {
        this.libraries = new ArrayList();
        for (VPFLibrary vPFLibrary : this.db.getLibraries()) {
            this.libraries.add(new VPFLibraryRenderable(this, vPFLibrary));
        }
    }

    public void setCoverageEnabled(VPFCoverage vPFCoverage, boolean bl) {
        for (VPFLibraryRenderable vPFLibraryRenderable : this.libraries) {
            vPFLibraryRenderable.setCoverageEnabled(vPFCoverage, bl);
        }
    }

    @Override
    public void doPreRender(DrawContext drawContext) {
        this.assembleRenderables(drawContext);
        this.handleDisposal();
        for (Renderable renderable : this.renderableObjects) {
            if (!(renderable instanceof PreRenderable)) continue;
            ((PreRenderable)((Object)renderable)).preRender(drawContext);
        }
    }

    @Override
    public void doRender(DrawContext drawContext) {
        for (Renderable object : this.renderableObjects) {
            object.render(drawContext);
        }
        this.textRenderer.render(drawContext, this.textObjects);
        if (this.drawTileExtents) {
            for (VPFLibraryRenderable vPFLibraryRenderable : this.libraries) {
                vPFLibraryRenderable.drawTileExtents(drawContext);
            }
        }
    }

    public void setLibraryEnabled(VPFLibrary vPFLibrary, boolean bl) {
        VPFLibraryRenderable vPFLibraryRenderable = this.getLibraryRenderable(vPFLibrary);
        if (vPFLibraryRenderable != null) {
            vPFLibraryRenderable.enabled = bl;
        }
        this.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
    }

    public VPFLibraryRenderable getLibraryRenderable(VPFLibrary vPFLibrary) {
        for (VPFLibraryRenderable vPFLibraryRenderable : this.libraries) {
            if (!vPFLibraryRenderable.library.getFilePath().equals(vPFLibrary.getFilePath())) continue;
            return vPFLibraryRenderable;
        }
        return null;
    }

    public Iterable<VPFSymbol> getActiveSymbols() {
        return this.symbols;
    }

    protected void assembleRenderables(DrawContext drawContext) {
        this.symbols.clear();
        this.textObjects.clear();
        this.renderableObjects.clear();
        for (VPFLibraryRenderable object : this.libraries) {
            object.assembleSymbols(drawContext, this.drawDistance, this.maxTilesToDraw);
        }
        this.sortSymbols(this.symbols);
        for (VPFSymbol vPFSymbol : this.symbols) {
            if (vPFSymbol.getMapObject() instanceof GeographicText) {
                this.textObjects.add((GeographicText)vPFSymbol.getMapObject());
                continue;
            }
            if (!(vPFSymbol.getMapObject() instanceof Renderable)) continue;
            this.renderableObjects.add((Renderable)vPFSymbol.getMapObject());
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    protected void sortSymbols(List<VPFSymbol> list) {
        Collections.sort(list, new VPFSymbolComparator());
    }

    protected void handleDisposal() {
        Disposable disposable;
        while ((disposable = this.disposalQ.poll()) != null) {
            disposable.dispose();
        }
    }

    protected void sendRequests() {
        Runnable runnable;
        while ((runnable = this.requestQ.poll()) != null) {
            if (WorldWind.getTaskService().isFull()) continue;
            WorldWind.getTaskService().addTask(runnable);
        }
    }

    protected static class VPFSymbolCollection
    implements Disposable {
        public static final VPFSymbolCollection EMPTY_SYMBOL_COLLECTION = new VPFSymbolCollection(null);
        protected final ArrayList<VPFSymbol> symbols = new ArrayList();

        public VPFSymbolCollection(Collection<? extends VPFSymbol> collection) {
            if (collection != null) {
                this.symbols.addAll(collection);
            }
        }

        public Collection<VPFSymbol> getSymbols() {
            return Collections.unmodifiableCollection(this.symbols);
        }

        @Override
        public void dispose() {
            for (VPFSymbol vPFSymbol : this.symbols) {
                if (vPFSymbol == null || !(vPFSymbol.getMapObject() instanceof Disposable)) continue;
                ((Disposable)vPFSymbol.getMapObject()).dispose();
            }
            this.symbols.clear();
        }
    }

    protected static class VPFLibraryRenderable {
        protected boolean enabled = false;
        protected VPFLayer layer;
        protected VPFLibrary library;
        protected VPFCoverageRenderable referenceCoverage;
        protected ArrayList<VPFCoverageRenderable> coverages = new ArrayList();
        protected ArrayList<VPFTile> currentTiles = new ArrayList();

        public VPFLibraryRenderable(VPFLayer vPFLayer, VPFLibrary vPFLibrary) {
            this.layer = vPFLayer;
            this.library = vPFLibrary;
            for (VPFCoverage vPFCoverage : this.library.getCoverages()) {
                if (vPFCoverage.getName().equalsIgnoreCase("libref")) {
                    this.referenceCoverage = new VPFCoverageRenderable(this.layer, vPFCoverage);
                    continue;
                }
                this.coverages.add(new VPFCoverageRenderable(this.layer, vPFCoverage));
            }
            if (this.referenceCoverage != null) {
                this.referenceCoverage.enabled = true;
            }
        }

        public void assembleSymbols(DrawContext drawContext, double d, int n) {
            if (!this.enabled) {
                return;
            }
            this.assembleVisibleTiles(drawContext, d, n);
            if (this.referenceCoverage != null) {
                this.referenceCoverage.assembleSymbols(null);
            }
            for (VPFCoverageRenderable vPFCoverageRenderable : this.coverages) {
                vPFCoverageRenderable.assembleSymbols(vPFCoverageRenderable.coverage.isTiled() ? this.currentTiles : null);
            }
        }

        public void drawTileExtents(DrawContext drawContext) {
            for (VPFTile vPFTile : this.currentTiles) {
                Extent extent = vPFTile.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
                if (!(extent instanceof Renderable)) continue;
                ((Renderable)((Object)extent)).render(drawContext);
            }
        }

        public void setCoverageEnabled(VPFCoverage vPFCoverage, boolean bl) {
            VPFCoverageRenderable vPFCoverageRenderable = this.getCoverageRenderable(vPFCoverage);
            if (vPFCoverageRenderable != null) {
                vPFCoverageRenderable.enabled = bl;
            }
            this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this.layer);
        }

        public VPFCoverageRenderable getCoverageRenderable(VPFCoverage vPFCoverage) {
            for (VPFCoverageRenderable vPFCoverageRenderable : this.coverages) {
                if (!vPFCoverageRenderable.coverage.getFilePath().equals(vPFCoverage.getFilePath())) continue;
                return vPFCoverageRenderable;
            }
            return null;
        }

        protected void assembleVisibleTiles(DrawContext drawContext, double d, int n) {
            double d2;
            Extent extent;
            this.currentTiles.clear();
            if (!this.library.hasTiledCoverages()) {
                return;
            }
            Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
            Vec4 vec4 = drawContext.getView().getEyePoint();
            for (VPFTile vPFTile : this.library.getTiles()) {
                extent = vPFTile.getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
                d2 = extent.getCenter().distanceTo3(vec4) - extent.getRadius();
                if (!(d2 < d) || !frustum.intersects(extent)) continue;
                this.currentTiles.add(vPFTile);
            }
            while (this.currentTiles.size() > n) {
                int n2 = -1;
                double d3 = 0.0;
                for (int i = 0; i < this.currentTiles.size(); ++i) {
                    extent = this.currentTiles.get(i).getExtent(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
                    d2 = drawContext.getView().getEyePoint().distanceTo3(extent.getCenter());
                    if (!(d2 > d3)) continue;
                    d3 = d2;
                    n2 = i;
                }
                this.currentTiles.remove(n2);
            }
        }
    }

    protected static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        protected VPFCoverageRenderable coverageRenderable;
        protected VPFTile tile;

        protected RequestTask(VPFCoverageRenderable vPFCoverageRenderable, VPFTile vPFTile) {
            this.coverageRenderable = vPFCoverageRenderable;
            this.tile = vPFTile;
        }

        @Override
        public void run() {
            VPFSymbolCollection vPFSymbolCollection = this.coverageRenderable.layer.loadTileSymbols(this.coverageRenderable.coverage, this.tile != NULL_TILE ? this.tile : null);
            this.coverageRenderable.tileCache.put(this.tile, vPFSymbolCollection);
            this.coverageRenderable.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this.coverageRenderable.layer);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            if (this.coverageRenderable != null ? !this.coverageRenderable.equals(requestTask.coverageRenderable) : requestTask.coverageRenderable != null) {
                return false;
            }
            return !(this.tile != null ? !this.tile.equals(requestTask.tile) : requestTask.tile != null);
        }

        public int hashCode() {
            int n = this.coverageRenderable != null ? this.coverageRenderable.hashCode() : 0;
            n = 31 * n + (this.tile != null ? this.tile.hashCode() : 0);
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("coverageRenderable=").append(this.coverageRenderable.coverage.getName());
            stringBuilder.append(", tile=").append(this.tile);
            return stringBuilder.toString();
        }
    }

    protected static class VPFCoverageRenderable {
        protected boolean enabled = false;
        protected VPFLayer layer;
        protected VPFCoverage coverage;
        protected Map<VPFTile, VPFSymbolCollection> tileCache;

        public VPFCoverageRenderable(VPFLayer vPFLayer, VPFCoverage vPFCoverage) {
            this.layer = vPFLayer;
            this.coverage = vPFCoverage;
            this.tileCache = Collections.synchronizedMap(new BoundedHashMap<VPFTile, VPFSymbolCollection>(6, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<VPFTile, VPFSymbolCollection> entry) {
                    if (!super.removeEldestEntry(entry)) {
                        return false;
                    }
                    this.dispose(entry.getValue());
                    return true;
                }
            });
        }

        public void assembleSymbols(Iterable<? extends VPFTile> iterable) {
            if (!this.enabled) {
                return;
            }
            if (iterable == null) {
                this.doAssembleSymbols(NULL_TILE);
                return;
            }
            for (VPFTile vPFTile : iterable) {
                this.doAssembleSymbols(vPFTile);
            }
        }

        protected void doAssembleSymbols(VPFTile vPFTile) {
            VPFSymbolCollection vPFSymbolCollection = this.tileCache.get(vPFTile);
            if (vPFSymbolCollection != null) {
                this.layer.symbols.addAll(vPFSymbolCollection.getSymbols());
            } else {
                this.layer.requestQ.add(new RequestTask(this, vPFTile));
            }
        }

        protected void dispose(VPFSymbolCollection vPFSymbolCollection) {
            this.layer.disposalQ.add(vPFSymbolCollection);
        }
    }
}

