/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.formats.vpf.GeoSymSupport;
import gov.nasa.worldwind.formats.vpf.VPFBufferedRecordData;
import gov.nasa.worldwind.formats.vpf.VPFFeatureClass;
import gov.nasa.worldwind.formats.vpf.VPFFeatureType;
import gov.nasa.worldwind.formats.vpf.VPFSymbolAttributes;
import gov.nasa.worldwind.formats.vpf.VPFSymbolKey;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;

public class VPFSymbolSupport {
    protected GeoSymSupport geoSymSupport;

    public VPFSymbolSupport(String string, String string2) {
        this.geoSymSupport = new GeoSymSupport(string, string2);
    }

    public Iterable<? extends VPFSymbolKey> getSymbolKeys(VPFFeatureClass vPFFeatureClass, String string, AVList aVList) {
        if (string != null) {
            Iterable<? extends VPFSymbolKey> iterable = this.doGetSymbolKeys(vPFFeatureClass, string, aVList);
            if (iterable != null) {
                return iterable;
            }
            iterable = this.geoSymSupport.getSymbolKeys(vPFFeatureClass, string, aVList);
            if (iterable != null) {
                return iterable;
            }
        }
        return Arrays.asList(VPFSymbolKey.UNKNOWN_SYMBOL_KEY);
    }

    public Iterable<? extends VPFSymbolAttributes> getSymbolAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        Iterable<? extends VPFSymbolAttributes> iterable = this.doGetAttributes(vPFFeatureClass, vPFSymbolKey);
        if (iterable != null) {
            return iterable;
        }
        iterable = this.geoSymSupport.getSymbolAttributes(vPFFeatureClass, vPFSymbolKey);
        if (iterable != null) {
            return iterable;
        }
        if (vPFSymbolKey == VPFSymbolKey.UNKNOWN_SYMBOL_KEY) {
            iterable = this.assembleGenericAttributes(vPFFeatureClass, vPFSymbolKey);
        }
        return iterable;
    }

    public Iterable<? extends VPFSymbolAttributes> getSymbolAttributes(VPFFeatureClass vPFFeatureClass, String string, AVList aVList) {
        Iterable<? extends VPFSymbolKey> iterable = this.getSymbolKeys(vPFFeatureClass, string, aVList);
        if (iterable == null) {
            return null;
        }
        ArrayList<VPFSymbolAttributes> arrayList = new ArrayList<VPFSymbolAttributes>();
        for (VPFSymbolKey vPFSymbolKey : iterable) {
            Iterable<? extends VPFSymbolAttributes> iterable2 = this.getSymbolAttributes(vPFFeatureClass, vPFSymbolKey);
            if (iterable2 == null) continue;
            for (VPFSymbolAttributes vPFSymbolAttributes : iterable2) {
                arrayList.add(vPFSymbolAttributes);
            }
        }
        return arrayList;
    }

    public String getSymbolLabelText(VPFSymbolAttributes.LabelAttributes labelAttributes, AVList aVList) {
        CharSequence charSequence;
        CharSequence charSequence2 = null;
        Object object = aVList.getValue(labelAttributes.getAttributeName());
        if (object instanceof String) {
            charSequence = (String)object;
            if (((String)charSequence).length() > 0 && !((String)charSequence).equalsIgnoreCase("UNK")) {
                charSequence2 = charSequence;
            }
        } else if (object instanceof Number && labelAttributes.getAbbreviationTableId() > 0) {
            charSequence2 = this.geoSymSupport.getAbbreviation(labelAttributes.getAbbreviationTableId(), ((Number)object).intValue());
        }
        if (charSequence2 != null) {
            charSequence = new StringBuilder();
            if (labelAttributes.getPrepend() != null) {
                ((StringBuilder)charSequence).append(labelAttributes.getPrepend());
            }
            ((StringBuilder)charSequence).append((String)charSequence2);
            if (labelAttributes.getAppend() != null) {
                ((StringBuilder)charSequence).append(labelAttributes.getAppend());
            }
            charSequence2 = ((StringBuilder)charSequence).toString();
        }
        return charSequence2;
    }

    protected Iterable<? extends VPFSymbolKey> doGetSymbolKeys(VPFFeatureClass vPFFeatureClass, String string, AVList aVList) {
        Integer n;
        if (vPFFeatureClass.getType() == VPFFeatureType.TEXT && (n = this.getSymbolId(aVList)) != null) {
            return Arrays.asList(new VPFSymbolKey(n));
        }
        return null;
    }

    protected Iterable<? extends VPFSymbolAttributes> doGetAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        if (vPFFeatureClass.getType() == VPFFeatureType.TEXT) {
            return this.assembleTextAttributes(vPFFeatureClass, vPFSymbolKey);
        }
        return null;
    }

    protected Iterable<? extends VPFSymbolAttributes> assembleTextAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        int n;
        Object object;
        Object object22;
        VPFBufferedRecordData vPFBufferedRecordData = vPFFeatureClass.getCoverage().getSymbolRelatedAttributeTable();
        if (vPFBufferedRecordData == null) {
            return null;
        }
        Object object3 = null;
        for (Object object22 : vPFBufferedRecordData) {
            object = object22.getValue("symbol_id");
            if (object == null || !(object instanceof Number) || (n = ((Number)object).intValue()) != vPFSymbolKey.getSymbolCode()) continue;
            object3 = object22;
            break;
        }
        if (object3 == null) {
            return null;
        }
        VPFSymbolAttributes vPFSymbolAttributes = new VPFSymbolAttributes(VPFFeatureType.TEXT, vPFSymbolKey);
        vPFSymbolAttributes.setDrawInterior(false);
        vPFSymbolAttributes.setDrawOutline(false);
        object22 = new VPFSymbolAttributes.LabelAttributes();
        object = null;
        n = (Integer)object3.getValue("fon");
        switch (n) {
            case 1: {
                object = "Arial";
            }
        }
        if (object != null) {
            int n2 = (Integer)object3.getValue("size");
            ((VPFSymbolAttributes.LabelAttributes)object22).setFont(new Font((String)object, 0, n2));
        }
        n = (Integer)object3.getValue("col");
        switch (n) {
            case 1: {
                ((VPFSymbolAttributes.LabelAttributes)object22).setColor(Color.BLACK);
                break;
            }
            case 4: {
                ((VPFSymbolAttributes.LabelAttributes)object22).setColor(Color.BLUE);
                break;
            }
            case 9: {
                ((VPFSymbolAttributes.LabelAttributes)object22).setColor(new Color(0xA62A2A));
                break;
            }
            case 12: {
                ((VPFSymbolAttributes.LabelAttributes)object22).setColor(Color.MAGENTA);
            }
        }
        ((VPFSymbolAttributes.LabelAttributes)object22).setBackgroundColor(WWUtil.computeContrastingColor(((VPFSymbolAttributes.LabelAttributes)object22).getColor()));
        vPFSymbolAttributes.setLabelAttributes(new VPFSymbolAttributes.LabelAttributes[]{object22});
        return Arrays.asList(vPFSymbolAttributes);
    }

    protected Integer getSymbolId(AVList aVList) {
        Object object = aVList.getValue("symbol_id");
        return object != null && object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : null;
    }

    protected Iterable<? extends VPFSymbolAttributes> assembleGenericAttributes(VPFFeatureClass vPFFeatureClass, VPFSymbolKey vPFSymbolKey) {
        VPFSymbolAttributes vPFSymbolAttributes = new VPFSymbolAttributes(vPFFeatureClass.getType(), vPFSymbolKey);
        vPFSymbolAttributes.setDrawInterior(false);
        vPFSymbolAttributes.setDrawOutline(true);
        vPFSymbolAttributes.setOutlineMaterial(Material.GRAY);
        vPFSymbolAttributes.setIconImageSource("images/vpf_unknownsymbol-32x64.png");
        return Arrays.asList(vPFSymbolAttributes);
    }
}

