/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import com.jogamp.opengl.GL2;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.Arrays;

public class Box
implements Extent,
Renderable {
    protected static final int[][] ProjectionHullTable = new int[][]{null, {7, 6, 5, 4}, {0, 1, 2, 3}, null, {3, 2, 6, 7}, {3, 2, 6, 5, 4, 7}, {0, 1, 2, 6, 7, 3}, null, {1, 0, 4, 5}, {1, 0, 4, 7, 6, 5}, {2, 3, 0, 4, 5, 1}, null, null, null, null, null, {2, 1, 5, 6}, {2, 1, 5, 4, 7, 6}, {3, 0, 1, 5, 6, 2}, null, {3, 2, 1, 5, 6, 7}, {3, 2, 1, 5, 4, 7}, {3, 0, 1, 5, 6, 7}, null, {2, 1, 0, 4, 5, 6}, {2, 1, 0, 4, 7, 6}, {2, 3, 0, 4, 5, 6}, null, null, null, null, null, {0, 3, 7, 4}, {0, 3, 7, 6, 5, 4}, {1, 2, 3, 7, 4, 0}, null, {0, 3, 2, 6, 7, 4}, {0, 3, 2, 6, 5, 4}, {0, 1, 2, 6, 7, 4}, null, {1, 0, 3, 7, 4, 5}, {1, 0, 3, 7, 6, 5}, {1, 2, 3, 7, 4, 5}};
    public Vec4 bottomCenter;
    public Vec4 topCenter;
    protected final Vec4 center;
    protected final Vec4 r;
    protected final Vec4 s;
    protected final Vec4 t;
    protected final Vec4 ru;
    protected final Vec4 su;
    protected final Vec4 tu;
    protected final double rLength;
    protected final double sLength;
    protected final double tLength;
    protected final Plane[] planes;

    protected Box(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44, Vec4 vec45, Vec4 vec46, Vec4 vec47, Vec4 vec48, Vec4 vec49, double d, double d2, double d3, Plane[] planeArray) {
        this.bottomCenter = vec4;
        this.topCenter = vec42;
        this.center = vec43;
        this.r = vec44;
        this.s = vec45;
        this.t = vec46;
        this.ru = vec47;
        this.su = vec48;
        this.tu = vec49;
        this.rLength = d;
        this.sLength = d2;
        this.tLength = d3;
        this.planes = planeArray;
    }

    public Box(Vec4[] vec4Array, double d, double d2, double d3, double d4, double d5, double d6) {
        if (vec4Array == null || vec4Array[0] == null || vec4Array[1] == null || vec4Array[2] == null) {
            String string = Logging.getMessage("nullValue.AxesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.ru = vec4Array[0];
        this.su = vec4Array[1];
        this.tu = vec4Array[2];
        this.r = this.ru.multiply3(d2 - d);
        this.s = this.su.multiply3(d4 - d3);
        this.t = this.tu.multiply3(d6 - d5);
        this.rLength = this.r.getLength3();
        this.sLength = this.s.getLength3();
        this.tLength = this.t.getLength3();
        this.planes = new Plane[6];
        this.planes[0] = new Plane(-this.ru.x, -this.ru.y, -this.ru.z, d);
        this.planes[1] = new Plane(this.ru.x, this.ru.y, this.ru.z, -d2);
        this.planes[2] = new Plane(-this.su.x, -this.su.y, -this.su.z, d3);
        this.planes[3] = new Plane(this.su.x, this.su.y, this.su.z, -d4);
        this.planes[4] = new Plane(-this.tu.x, -this.tu.y, -this.tu.z, d5);
        this.planes[5] = new Plane(this.tu.x, this.tu.y, this.tu.z, -d6);
        double d7 = 0.5 * (d + d2);
        double d8 = 0.5 * (d3 + d4);
        double d9 = 0.5 * (d5 + d6);
        this.center = this.ru.multiply3(d7).add3(this.su.multiply3(d8)).add3(this.tu.multiply3(d9));
        Vec4 vec4 = this.r.multiply3(0.5);
        this.topCenter = this.center.add3(vec4);
        this.bottomCenter = this.center.subtract3(vec4);
    }

    public Box(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.ru = new Vec4(1.0, 0.0, 0.0, 1.0);
        this.su = new Vec4(0.0, 1.0, 0.0, 1.0);
        this.tu = new Vec4(0.0, 0.0, 1.0, 1.0);
        this.r = this.ru;
        this.s = this.su;
        this.t = this.tu;
        this.rLength = 1.0;
        this.sLength = 1.0;
        this.tLength = 1.0;
        this.planes = new Plane[6];
        double d = 0.5 * vec4.getLength3();
        this.planes[0] = new Plane(-this.ru.x, -this.ru.y, -this.ru.z, -(d + 0.5));
        this.planes[1] = new Plane(this.ru.x, this.ru.y, this.ru.z, -(d + 0.5));
        this.planes[2] = new Plane(-this.su.x, -this.su.y, -this.su.z, -(d + 0.5));
        this.planes[3] = new Plane(this.su.x, this.su.y, this.su.z, -(d + 0.5));
        this.planes[4] = new Plane(-this.tu.x, -this.tu.y, -this.tu.z, -(d + 0.5));
        this.planes[5] = new Plane(this.tu.x, this.tu.y, this.tu.z, -(d + 0.5));
        this.center = this.ru.add3(this.su).add3(this.tu).multiply3(0.5);
        Vec4 vec42 = this.r.multiply3(0.5);
        this.topCenter = this.center.add3(vec42);
        this.bottomCenter = this.center.subtract3(vec42);
    }

    @Override
    public Vec4 getCenter() {
        return this.center;
    }

    public Vec4 getBottomCenter() {
        return this.bottomCenter;
    }

    public Vec4 getTopCenter() {
        return this.topCenter;
    }

    public Vec4 getRAxis() {
        return this.r;
    }

    public Vec4 getSAxis() {
        return this.s;
    }

    public Vec4 getTAxis() {
        return this.t;
    }

    public Vec4 getUnitRAxis() {
        return this.ru;
    }

    public Vec4 getUnitSAxis() {
        return this.su;
    }

    public Vec4 getUnitTAxis() {
        return this.tu;
    }

    public Vec4[] getCorners() {
        Vec4 vec4 = this.s.add3(this.t).multiply3(-0.5);
        Vec4 vec42 = this.t.subtract3(this.s).multiply3(0.5);
        Vec4 vec43 = this.s.add3(this.t).multiply3(0.5);
        Vec4 vec44 = this.s.subtract3(this.t).multiply3(0.5);
        Vec4[] vec4Array = new Vec4[]{this.bottomCenter.add3(vec4), this.bottomCenter.add3(vec42), this.bottomCenter.add3(vec43), this.bottomCenter.add3(vec44), this.topCenter.add3(vec4), this.topCenter.add3(vec42), this.topCenter.add3(vec43), this.topCenter.add3(vec44)};
        return vec4Array;
    }

    public Plane[] getPlanes() {
        return this.planes;
    }

    public double getRLength() {
        return this.rLength;
    }

    public double getSLength() {
        return this.sLength;
    }

    public double getTLength() {
        return this.tLength;
    }

    @Override
    public double getDiameter() {
        return Math.sqrt(this.rLength * this.rLength + this.sLength * this.sLength + this.tLength * this.tLength);
    }

    @Override
    public double getRadius() {
        return 0.5 * this.getDiameter();
    }

    public Box translate(Vec4 vec4) {
        Vec4 vec42 = this.bottomCenter.add3(vec4);
        Vec4 vec43 = this.topCenter.add3(vec4);
        Vec4 vec44 = this.center.add3(vec4);
        Plane[] planeArray = new Plane[this.planes.length];
        for (int i = 0; i < this.planes.length; ++i) {
            Plane plane = this.planes[i];
            Vec4 vec45 = plane.getNormal();
            planeArray[i] = new Plane(vec45.x, vec45.y, vec45.z, plane.getDistance() - vec45.dot3(vec4));
        }
        return new Box(vec42, vec43, vec44, this.r, this.s, this.t, this.ru, this.su, this.tu, this.rLength, this.sLength, this.tLength, planeArray);
    }

    public static Box computeBoundingBox(Iterable<? extends Vec4> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PointListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = WWMath.computePrincipalAxes(iterable);
        if (vec4Array == null) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = vec4Array[0];
        Vec4 vec42 = vec4Array[1];
        Vec4 vec43 = vec4Array[2];
        double d = Double.MAX_VALUE;
        double d2 = -d;
        double d3 = Double.MAX_VALUE;
        double d4 = -d3;
        double d5 = Double.MAX_VALUE;
        double d6 = -d5;
        for (Vec4 vec44 : iterable) {
            double d7;
            double d8;
            if (vec44 == null) continue;
            double d9 = vec44.dot3(vec4);
            if (d9 < d) {
                d = d9;
            }
            if (d9 > d2) {
                d2 = d9;
            }
            if ((d8 = vec44.dot3(vec42)) < d3) {
                d3 = d8;
            }
            if (d8 > d4) {
                d4 = d8;
            }
            if ((d7 = vec44.dot3(vec43)) < d5) {
                d5 = d7;
            }
            if (!(d7 > d6)) continue;
            d6 = d7;
        }
        if (d2 == d) {
            d2 = d + 1.0;
        }
        if (d4 == d3) {
            d4 = d3 + 1.0;
        }
        if (d6 == d5) {
            d6 = d5 + 1.0;
        }
        return new Box(vec4Array, d, d2, d3, d4, d5, d6);
    }

    public static Box computeBoundingBox(BufferWrapper bufferWrapper, int n) {
        if (bufferWrapper == null) {
            String string = Logging.getMessage("nullValue.CoordinatesAreNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3) {
            String string = Logging.getMessage("generic.StrideIsInvalid", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = WWMath.computePrincipalAxes(bufferWrapper, n);
        if (vec4Array == null) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = vec4Array[0];
        Vec4 vec42 = vec4Array[1];
        Vec4 vec43 = vec4Array[2];
        double d = Double.MAX_VALUE;
        double d2 = -d;
        double d3 = Double.MAX_VALUE;
        double d4 = -d3;
        double d5 = Double.MAX_VALUE;
        double d6 = -d5;
        for (int i = 0; i <= bufferWrapper.length() - n; i += n) {
            double d7;
            double d8;
            double d9;
            double d10;
            double d11 = bufferWrapper.getDouble(i);
            double d12 = d11 * vec4.x + (d10 = bufferWrapper.getDouble(i + 1)) * vec4.y + (d9 = bufferWrapper.getDouble(i + 2)) * vec4.z;
            if (d12 < d) {
                d = d12;
            }
            if (d12 > d2) {
                d2 = d12;
            }
            if ((d8 = d11 * vec42.x + d10 * vec42.y + d9 * vec42.z) < d3) {
                d3 = d8;
            }
            if (d8 > d4) {
                d4 = d8;
            }
            if ((d7 = d11 * vec43.x + d10 * vec43.y + d9 * vec43.z) < d5) {
                d5 = d7;
            }
            if (!(d7 > d6)) continue;
            d6 = d7;
        }
        if (d2 == d) {
            d2 = d + 1.0;
        }
        if (d4 == d3) {
            d4 = d3 + 1.0;
        }
        if (d6 == d5) {
            d6 = d5 + 1.0;
        }
        return new Box(vec4Array, d, d2, d3, d4, d5, d6);
    }

    public static Box union(Iterable<? extends Box> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Box> arrayList = new ArrayList<Box>();
        for (Box object : iterable) {
            if (object == null) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Box)arrayList.get(0);
        }
        ArrayList arrayList2 = new ArrayList(8 * arrayList.size());
        for (Box box : arrayList) {
            arrayList2.addAll(Arrays.asList(box.getCorners()));
        }
        return Box.computeBoundingBox(arrayList2);
    }

    @Override
    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4[] vec4Array = new Vec4[]{this.bottomCenter, this.topCenter};
        double d = this.getEffectiveRadius2(frustum.getNear());
        double d2 = this.intersectsAt(frustum.getNear(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius2(frustum.getFar());
        d2 = this.intersectsAt(frustum.getFar(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius2(frustum.getLeft());
        d2 = this.intersectsAt(frustum.getLeft(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius2(frustum.getRight());
        d2 = this.intersectsAt(frustum.getRight(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius2(frustum.getTop());
        d2 = this.intersectsAt(frustum.getTop(), d, vec4Array);
        if (d2 < 0.0) {
            return false;
        }
        d = this.getEffectiveRadius2(frustum.getBottom());
        d2 = this.intersectsAt(frustum.getBottom(), d, vec4Array);
        return d2 >= 0.0;
    }

    protected double getEffectiveRadius2(Plane plane) {
        if (plane == null) {
            return 0.0;
        }
        Vec4 vec4 = plane.getNormal();
        return 0.5 * (Math.abs(this.s.dot3(vec4)) + Math.abs(this.t.dot3(vec4)));
    }

    @Override
    public double getEffectiveRadius(Plane plane) {
        if (plane == null) {
            return 0.0;
        }
        Vec4 vec4 = plane.getNormal();
        return 0.5 * (Math.abs(this.s.dot3(vec4)) + Math.abs(this.t.dot3(vec4)) + Math.abs(this.r.dot3(vec4)));
    }

    protected double intersectsAt(Plane plane, double d, Vec4[] vec4Array) {
        boolean bl;
        double d2 = plane.dot(vec4Array[0]);
        boolean bl2 = d2 <= -d;
        double d3 = plane.dot(vec4Array[1]);
        boolean bl3 = bl = d3 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return 0.0;
        }
        double d4 = (d + d2) / plane.getNormal().dot3(vec4Array[0].subtract3(vec4Array[1]));
        Vec4 vec4 = vec4Array[0].add3(vec4Array[1].subtract3(vec4Array[0]).multiply3(d4));
        if (bl2) {
            vec4Array[0] = vec4;
        } else {
            vec4Array[1] = vec4;
        }
        return d4;
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.getEffectiveRadius(plane);
        return this.intersects(plane, d) >= 0.0;
    }

    protected double intersects(Plane plane, double d) {
        boolean bl;
        double d2 = plane.dot(this.bottomCenter);
        boolean bl2 = d2 <= -d;
        double d3 = plane.dot(this.topCenter);
        boolean bl3 = bl = d3 <= -d;
        if (bl2 && bl) {
            return -1.0;
        }
        if (bl2 == bl) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public Intersection[] intersect(Line line) {
        return WWMath.polytopeIntersect(line, this.planes);
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWMath.polytopeIntersect(line, this.planes) != null;
    }

    @Override
    public double getProjectedArea(View view) {
        int n;
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = this.computeProjectionHullCode(view);
        if (n2 == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (n2 < 0 || n2 >= ProjectionHullTable.length) {
            return 0.0;
        }
        int[] nArray = ProjectionHullTable[n2];
        if (nArray == null || nArray.length != 4 && nArray.length != 6) {
            return 0.0;
        }
        Vec4[] vec4Array = this.getCorners();
        Vec4[] vec4Array2 = new Vec4[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            Vec4 vec4 = vec4Array[nArray[n]].transformBy4(view.getModelviewMatrix());
            if (!(vec4.z >= 0.0)) continue;
            return Double.POSITIVE_INFINITY;
        }
        for (n = 0; n < nArray.length; ++n) {
            vec4Array2[n] = view.project(vec4Array[nArray[n]]);
        }
        double d = WWMath.computePolygonAreaFromVertices(Arrays.asList(vec4Array2));
        return Math.abs(d);
    }

    protected int computeProjectionHullCode(View view) {
        Vec4 vec4 = view.getEyePoint().subtract3(this.center);
        double d = vec4.dot3(this.ru);
        double d2 = vec4.dot3(this.su);
        double d3 = vec4.dot3(this.tu);
        return (d > this.rLength / 2.0 ? 1 : 0) | (d < -this.rLength / 2.0 ? 1 : 0) << 1 | (d2 > this.sLength / 2.0 ? 1 : 0) << 2 | (d2 < -this.sLength / 2.0 ? 1 : 0) << 3 | (d3 > this.tLength / 2.0 ? 1 : 0) << 4 | (d3 < -this.tLength / 2.0 ? 1 : 0) << 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.isPickingMode()) {
            return;
        }
        Vec4 vec4 = this.s.add3(this.t).multiply3(-0.5);
        Vec4 vec42 = this.s.subtract3(this.t).multiply3(0.5);
        Vec4 vec43 = this.s.add3(this.t).multiply3(0.5);
        Vec4 vec44 = this.t.subtract3(this.s).multiply3(0.5);
        GL2 gL2 = drawContext.getGL().getGL2();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL2, 20741);
        try {
            gL2.glLineWidth(1.0f);
            gL2.glEnable(3042);
            OGLUtil.applyBlending(gL2, false);
            gL2.glEnable(2929);
            gL2.glDepthFunc(515);
            gL2.glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
            this.drawBox(drawContext, vec4, vec42, vec43, vec44);
            gL2.glDepthFunc(516);
            gL2.glColor4f(1.0f, 0.0f, 1.0f, 0.4f);
            this.drawBox(drawContext, vec4, vec42, vec43, vec44);
        }
        finally {
            oGLStackHandler.pop(gL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBox(DrawContext drawContext, Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44) {
        Vec4 vec45 = vec4.add3(this.r);
        Vec4 vec46 = vec44.add3(this.r);
        GL2 gL2 = drawContext.getGL().getGL2();
        drawContext.getView().pushReferenceCenter(drawContext, this.bottomCenter);
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushModelview(gL2);
        try {
            int n = 20;
            Vec4 vec47 = this.r.multiply3(1.0 / (double)n);
            this.drawOutline(drawContext, vec4, vec42, vec43, vec44);
            for (int i = 1; i < n; ++i) {
                gL2.glTranslated(vec47.x, vec47.y, vec47.z);
                this.drawOutline(drawContext, vec4, vec42, vec43, vec44);
            }
            n = 20;
            Vec4 vec48 = this.s.multiply3(1.0 / (double)n);
            gL2.glPopMatrix();
            gL2.glPushMatrix();
            this.drawOutline(drawContext, vec4, vec45, vec46, vec44);
            for (int i = 1; i < n; ++i) {
                gL2.glTranslated(vec48.x, vec48.y, vec48.z);
                this.drawOutline(drawContext, vec4, vec45, vec46, vec44);
            }
        }
        finally {
            oGLStackHandler.pop(gL2);
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    protected void drawOutline(DrawContext drawContext, Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4 vec44) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glBegin(2);
        gL2.glVertex3d(vec4.x, vec4.y, vec4.z);
        gL2.glVertex3d(vec42.x, vec42.y, vec42.z);
        gL2.glVertex3d(vec43.x, vec43.y, vec43.z);
        gL2.glVertex3d(vec44.x, vec44.y, vec44.z);
        gL2.glEnd();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Box)) {
            return false;
        }
        Box box = (Box)object;
        if (this.center != null ? !this.center.equals(box.center) : box.center != null) {
            return false;
        }
        if (this.r != null ? !this.r.equals(box.r) : box.r != null) {
            return false;
        }
        if (this.s != null ? !this.s.equals(box.s) : box.s != null) {
            return false;
        }
        return !(this.t != null ? !this.t.equals(box.t) : box.t != null);
    }

    public int hashCode() {
        int n = this.center != null ? this.center.hashCode() : 0;
        n = 31 * n + (this.r != null ? this.r.hashCode() : 0);
        n = 31 * n + (this.s != null ? this.s.hashCode() : 0);
        n = 31 * n + (this.t != null ? this.t.hashCode() : 0);
        return n;
    }
}

